<?php
/**
 * DomainLogicalInterface
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * DomainLogicalInterface Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class DomainLogicalInterface implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'DomainLogicalInterface';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'description' => 'string',
        'version' => 'int',
        'dateCreated' => '\DateTime',
        'dateModified' => '\DateTime',
        'modifiedBy' => 'string',
        'createdBy' => 'string',
        'state' => 'string',
        'modifiedByApp' => 'string',
        'createdByApp' => 'string',
        'edgeUri' => 'string',
        'edgeAssignedId' => 'string',
        'friendlyName' => 'string',
        'vlanTagId' => 'int',
        'hardwareAddress' => 'string',
        'physicalAdapterId' => 'string',
        'ifStatus' => 'string',
        'interfaceType' => 'string',
        'routes' => '\PureCloudSDK\DomainNetworkRoute[]',
        'addresses' => '\PureCloudSDK\DomainNetworkAddress[]',
        'ipv4Capabilities' => '\PureCloudSDK\DomainCapabilities',
        'ipv6Capabilities' => '\PureCloudSDK\DomainCapabilities',
        'currentState' => 'string',
        'lastModifiedUserId' => 'string',
        'lastModifiedCorrelationId' => 'string',
        'commandResponses' => '\PureCloudSDK\DomainNetworkCommandResponse[]',
        'inheritPhoneTrunkBasesIPv4' => 'bool',
        'inheritPhoneTrunkBasesIPv6' => 'bool',
        'useForInternalEdgeCommunication' => 'bool',
        'externalTrunkBaseAssignments' => '\PureCloudSDK\TrunkBaseAssignment[]',
        'phoneTrunkBaseAssignments' => '\PureCloudSDK\TrunkBaseAssignment[]',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'description' => 'description',
        'version' => 'version',
        'dateCreated' => 'dateCreated',
        'dateModified' => 'dateModified',
        'modifiedBy' => 'modifiedBy',
        'createdBy' => 'createdBy',
        'state' => 'state',
        'modifiedByApp' => 'modifiedByApp',
        'createdByApp' => 'createdByApp',
        'edgeUri' => 'edgeUri',
        'edgeAssignedId' => 'edgeAssignedId',
        'friendlyName' => 'friendlyName',
        'vlanTagId' => 'vlanTagId',
        'hardwareAddress' => 'hardwareAddress',
        'physicalAdapterId' => 'physicalAdapterId',
        'ifStatus' => 'ifStatus',
        'interfaceType' => 'interfaceType',
        'routes' => 'routes',
        'addresses' => 'addresses',
        'ipv4Capabilities' => 'ipv4Capabilities',
        'ipv6Capabilities' => 'ipv6Capabilities',
        'currentState' => 'currentState',
        'lastModifiedUserId' => 'lastModifiedUserId',
        'lastModifiedCorrelationId' => 'lastModifiedCorrelationId',
        'commandResponses' => 'commandResponses',
        'inheritPhoneTrunkBasesIPv4' => 'inheritPhoneTrunkBasesIPv4',
        'inheritPhoneTrunkBasesIPv6' => 'inheritPhoneTrunkBasesIPv6',
        'useForInternalEdgeCommunication' => 'useForInternalEdgeCommunication',
        'externalTrunkBaseAssignments' => 'externalTrunkBaseAssignments',
        'phoneTrunkBaseAssignments' => 'phoneTrunkBaseAssignments',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'description' => 'setDescription',
        'version' => 'setVersion',
        'dateCreated' => 'setDateCreated',
        'dateModified' => 'setDateModified',
        'modifiedBy' => 'setModifiedBy',
        'createdBy' => 'setCreatedBy',
        'state' => 'setState',
        'modifiedByApp' => 'setModifiedByApp',
        'createdByApp' => 'setCreatedByApp',
        'edgeUri' => 'setEdgeUri',
        'edgeAssignedId' => 'setEdgeAssignedId',
        'friendlyName' => 'setFriendlyName',
        'vlanTagId' => 'setVlanTagId',
        'hardwareAddress' => 'setHardwareAddress',
        'physicalAdapterId' => 'setPhysicalAdapterId',
        'ifStatus' => 'setIfStatus',
        'interfaceType' => 'setInterfaceType',
        'routes' => 'setRoutes',
        'addresses' => 'setAddresses',
        'ipv4Capabilities' => 'setIpv4Capabilities',
        'ipv6Capabilities' => 'setIpv6Capabilities',
        'currentState' => 'setCurrentState',
        'lastModifiedUserId' => 'setLastModifiedUserId',
        'lastModifiedCorrelationId' => 'setLastModifiedCorrelationId',
        'commandResponses' => 'setCommandResponses',
        'inheritPhoneTrunkBasesIPv4' => 'setInheritPhoneTrunkBasesIPv4',
        'inheritPhoneTrunkBasesIPv6' => 'setInheritPhoneTrunkBasesIPv6',
        'useForInternalEdgeCommunication' => 'setUseForInternalEdgeCommunication',
        'externalTrunkBaseAssignments' => 'setExternalTrunkBaseAssignments',
        'phoneTrunkBaseAssignments' => 'setPhoneTrunkBaseAssignments',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'description' => 'getDescription',
        'version' => 'getVersion',
        'dateCreated' => 'getDateCreated',
        'dateModified' => 'getDateModified',
        'modifiedBy' => 'getModifiedBy',
        'createdBy' => 'getCreatedBy',
        'state' => 'getState',
        'modifiedByApp' => 'getModifiedByApp',
        'createdByApp' => 'getCreatedByApp',
        'edgeUri' => 'getEdgeUri',
        'edgeAssignedId' => 'getEdgeAssignedId',
        'friendlyName' => 'getFriendlyName',
        'vlanTagId' => 'getVlanTagId',
        'hardwareAddress' => 'getHardwareAddress',
        'physicalAdapterId' => 'getPhysicalAdapterId',
        'ifStatus' => 'getIfStatus',
        'interfaceType' => 'getInterfaceType',
        'routes' => 'getRoutes',
        'addresses' => 'getAddresses',
        'ipv4Capabilities' => 'getIpv4Capabilities',
        'ipv6Capabilities' => 'getIpv6Capabilities',
        'currentState' => 'getCurrentState',
        'lastModifiedUserId' => 'getLastModifiedUserId',
        'lastModifiedCorrelationId' => 'getLastModifiedCorrelationId',
        'commandResponses' => 'getCommandResponses',
        'inheritPhoneTrunkBasesIPv4' => 'getInheritPhoneTrunkBasesIPv4',
        'inheritPhoneTrunkBasesIPv6' => 'getInheritPhoneTrunkBasesIPv6',
        'useForInternalEdgeCommunication' => 'getUseForInternalEdgeCommunication',
        'externalTrunkBaseAssignments' => 'getExternalTrunkBaseAssignments',
        'phoneTrunkBaseAssignments' => 'getPhoneTrunkBaseAssignments',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const STATE_ACTIVE = 'active';
    const STATE_INACTIVE = 'inactive';
    const STATE_DELETED = 'deleted';
    const INTERFACE_TYPE_DIAGNOSTIC = 'DIAGNOSTIC';
    const INTERFACE_TYPE_SYSTEM = 'SYSTEM';
    const CURRENT_STATE_INIT = 'INIT';
    const CURRENT_STATE_CREATING = 'CREATING';
    const CURRENT_STATE_UPDATING = 'UPDATING';
    const CURRENT_STATE_OK = 'OK';
    const CURRENT_STATE_EXCEPTION = 'EXCEPTION';
    const CURRENT_STATE_DELETING = 'DELETING';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_ACTIVE,
            self::STATE_INACTIVE,
            self::STATE_DELETED,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getInterfaceTypeAllowableValues()
    {
        return [
            self::INTERFACE_TYPE_DIAGNOSTIC,
            self::INTERFACE_TYPE_SYSTEM,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getCurrentStateAllowableValues()
    {
        return [
            self::CURRENT_STATE_INIT,
            self::CURRENT_STATE_CREATING,
            self::CURRENT_STATE_UPDATING,
            self::CURRENT_STATE_OK,
            self::CURRENT_STATE_EXCEPTION,
            self::CURRENT_STATE_DELETING,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['version'] = isset($data['version']) ? $data['version'] : null;
        $this->container['dateCreated'] = isset($data['dateCreated']) ? $data['dateCreated'] : null;
        $this->container['dateModified'] = isset($data['dateModified']) ? $data['dateModified'] : null;
        $this->container['modifiedBy'] = isset($data['modifiedBy']) ? $data['modifiedBy'] : null;
        $this->container['createdBy'] = isset($data['createdBy']) ? $data['createdBy'] : null;
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['modifiedByApp'] = isset($data['modifiedByApp']) ? $data['modifiedByApp'] : null;
        $this->container['createdByApp'] = isset($data['createdByApp']) ? $data['createdByApp'] : null;
        $this->container['edgeUri'] = isset($data['edgeUri']) ? $data['edgeUri'] : null;
        $this->container['edgeAssignedId'] = isset($data['edgeAssignedId']) ? $data['edgeAssignedId'] : null;
        $this->container['friendlyName'] = isset($data['friendlyName']) ? $data['friendlyName'] : null;
        $this->container['vlanTagId'] = isset($data['vlanTagId']) ? $data['vlanTagId'] : null;
        $this->container['hardwareAddress'] = isset($data['hardwareAddress']) ? $data['hardwareAddress'] : null;
        $this->container['physicalAdapterId'] = isset($data['physicalAdapterId']) ? $data['physicalAdapterId'] : null;
        $this->container['ifStatus'] = isset($data['ifStatus']) ? $data['ifStatus'] : null;
        $this->container['interfaceType'] = isset($data['interfaceType']) ? $data['interfaceType'] : null;
        $this->container['routes'] = isset($data['routes']) ? $data['routes'] : null;
        $this->container['addresses'] = isset($data['addresses']) ? $data['addresses'] : null;
        $this->container['ipv4Capabilities'] = isset($data['ipv4Capabilities']) ? $data['ipv4Capabilities'] : null;
        $this->container['ipv6Capabilities'] = isset($data['ipv6Capabilities']) ? $data['ipv6Capabilities'] : null;
        $this->container['currentState'] = isset($data['currentState']) ? $data['currentState'] : null;
        $this->container['lastModifiedUserId'] = isset($data['lastModifiedUserId']) ? $data['lastModifiedUserId'] : null;
        $this->container['lastModifiedCorrelationId'] = isset($data['lastModifiedCorrelationId']) ? $data['lastModifiedCorrelationId'] : null;
        $this->container['commandResponses'] = isset($data['commandResponses']) ? $data['commandResponses'] : null;
        $this->container['inheritPhoneTrunkBasesIPv4'] = isset($data['inheritPhoneTrunkBasesIPv4']) ? $data['inheritPhoneTrunkBasesIPv4'] : null;
        $this->container['inheritPhoneTrunkBasesIPv6'] = isset($data['inheritPhoneTrunkBasesIPv6']) ? $data['inheritPhoneTrunkBasesIPv6'] : null;
        $this->container['useForInternalEdgeCommunication'] = isset($data['useForInternalEdgeCommunication']) ? $data['useForInternalEdgeCommunication'] : null;
        $this->container['externalTrunkBaseAssignments'] = isset($data['externalTrunkBaseAssignments']) ? $data['externalTrunkBaseAssignments'] : null;
        $this->container['phoneTrunkBaseAssignments'] = isset($data['phoneTrunkBaseAssignments']) ? $data['phoneTrunkBaseAssignments'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['name'] === null) {
            $invalid_properties[] = "'name' can't be null";
        }
        $allowed_values = array("active", "inactive", "deleted");
        if (!in_array($this->container['state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'state', must be one of #{allowed_values}.";
        }

        if ($this->container['friendlyName'] === null) {
            $invalid_properties[] = "'friendlyName' can't be null";
        }
        if ($this->container['hardwareAddress'] === null) {
            $invalid_properties[] = "'hardwareAddress' can't be null";
        }
        if ($this->container['physicalAdapterId'] === null) {
            $invalid_properties[] = "'physicalAdapterId' can't be null";
        }
        $allowed_values = array("DIAGNOSTIC", "SYSTEM");
        if (!in_array($this->container['interfaceType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'interfaceType', must be one of #{allowed_values}.";
        }

        $allowed_values = array("INIT", "CREATING", "UPDATING", "OK", "EXCEPTION", "DELETING");
        if (!in_array($this->container['currentState'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'currentState', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['name'] === null) {
            return false;
        }
        $allowed_values = array("active", "inactive", "deleted");
        if (!in_array($this->container['state'], $allowed_values)) {
            return false;
        }
        if ($this->container['friendlyName'] === null) {
            return false;
        }
        if ($this->container['hardwareAddress'] === null) {
            return false;
        }
        if ($this->container['physicalAdapterId'] === null) {
            return false;
        }
        $allowed_values = array("DIAGNOSTIC", "SYSTEM");
        if (!in_array($this->container['interfaceType'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("INIT", "CREATING", "UPDATING", "OK", "EXCEPTION", "DELETING");
        if (!in_array($this->container['currentState'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The name of the entity.
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets version
     * @return int
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     * @param int $version
     * @return $this
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets dateCreated
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->container['dateCreated'];
    }

    /**
     * Sets dateCreated
     * @param \DateTime $dateCreated Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCreated($dateCreated)
    {
        $this->container['dateCreated'] = $dateCreated;

        return $this;
    }

    /**
     * Gets dateModified
     * @return \DateTime
     */
    public function getDateModified()
    {
        return $this->container['dateModified'];
    }

    /**
     * Sets dateModified
     * @param \DateTime $dateModified Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateModified($dateModified)
    {
        $this->container['dateModified'] = $dateModified;

        return $this;
    }

    /**
     * Gets modifiedBy
     * @return string
     */
    public function getModifiedBy()
    {
        return $this->container['modifiedBy'];
    }

    /**
     * Sets modifiedBy
     * @param string $modifiedBy
     * @return $this
     */
    public function setModifiedBy($modifiedBy)
    {
        $this->container['modifiedBy'] = $modifiedBy;

        return $this;
    }

    /**
     * Gets createdBy
     * @return string
     */
    public function getCreatedBy()
    {
        return $this->container['createdBy'];
    }

    /**
     * Sets createdBy
     * @param string $createdBy
     * @return $this
     */
    public function setCreatedBy($createdBy)
    {
        $this->container['createdBy'] = $createdBy;

        return $this;
    }

    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state
     * @return $this
     */
    public function setState($state)
    {
        $allowed_values = array('active', 'inactive', 'deleted');
        if (!in_array($state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'state', must be one of 'active', 'inactive', 'deleted'");
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets modifiedByApp
     * @return string
     */
    public function getModifiedByApp()
    {
        return $this->container['modifiedByApp'];
    }

    /**
     * Sets modifiedByApp
     * @param string $modifiedByApp
     * @return $this
     */
    public function setModifiedByApp($modifiedByApp)
    {
        $this->container['modifiedByApp'] = $modifiedByApp;

        return $this;
    }

    /**
     * Gets createdByApp
     * @return string
     */
    public function getCreatedByApp()
    {
        return $this->container['createdByApp'];
    }

    /**
     * Sets createdByApp
     * @param string $createdByApp
     * @return $this
     */
    public function setCreatedByApp($createdByApp)
    {
        $this->container['createdByApp'] = $createdByApp;

        return $this;
    }

    /**
     * Gets edgeUri
     * @return string
     */
    public function getEdgeUri()
    {
        return $this->container['edgeUri'];
    }

    /**
     * Sets edgeUri
     * @param string $edgeUri
     * @return $this
     */
    public function setEdgeUri($edgeUri)
    {
        $this->container['edgeUri'] = $edgeUri;

        return $this;
    }

    /**
     * Gets edgeAssignedId
     * @return string
     */
    public function getEdgeAssignedId()
    {
        return $this->container['edgeAssignedId'];
    }

    /**
     * Sets edgeAssignedId
     * @param string $edgeAssignedId
     * @return $this
     */
    public function setEdgeAssignedId($edgeAssignedId)
    {
        $this->container['edgeAssignedId'] = $edgeAssignedId;

        return $this;
    }

    /**
     * Gets friendlyName
     * @return string
     */
    public function getFriendlyName()
    {
        return $this->container['friendlyName'];
    }

    /**
     * Sets friendlyName
     * @param string $friendlyName Friendly Name
     * @return $this
     */
    public function setFriendlyName($friendlyName)
    {
        $this->container['friendlyName'] = $friendlyName;

        return $this;
    }

    /**
     * Gets vlanTagId
     * @return int
     */
    public function getVlanTagId()
    {
        return $this->container['vlanTagId'];
    }

    /**
     * Sets vlanTagId
     * @param int $vlanTagId
     * @return $this
     */
    public function setVlanTagId($vlanTagId)
    {
        $this->container['vlanTagId'] = $vlanTagId;

        return $this;
    }

    /**
     * Gets hardwareAddress
     * @return string
     */
    public function getHardwareAddress()
    {
        return $this->container['hardwareAddress'];
    }

    /**
     * Sets hardwareAddress
     * @param string $hardwareAddress Hardware Address
     * @return $this
     */
    public function setHardwareAddress($hardwareAddress)
    {
        $this->container['hardwareAddress'] = $hardwareAddress;

        return $this;
    }

    /**
     * Gets physicalAdapterId
     * @return string
     */
    public function getPhysicalAdapterId()
    {
        return $this->container['physicalAdapterId'];
    }

    /**
     * Sets physicalAdapterId
     * @param string $physicalAdapterId Physical Adapter Id
     * @return $this
     */
    public function setPhysicalAdapterId($physicalAdapterId)
    {
        $this->container['physicalAdapterId'] = $physicalAdapterId;

        return $this;
    }

    /**
     * Gets ifStatus
     * @return string
     */
    public function getIfStatus()
    {
        return $this->container['ifStatus'];
    }

    /**
     * Sets ifStatus
     * @param string $ifStatus
     * @return $this
     */
    public function setIfStatus($ifStatus)
    {
        $this->container['ifStatus'] = $ifStatus;

        return $this;
    }

    /**
     * Gets interfaceType
     * @return string
     */
    public function getInterfaceType()
    {
        return $this->container['interfaceType'];
    }

    /**
     * Sets interfaceType
     * @param string $interfaceType The type of this network interface.
     * @return $this
     */
    public function setInterfaceType($interfaceType)
    {
        $allowed_values = array('DIAGNOSTIC', 'SYSTEM');
        if (!in_array($interfaceType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'interfaceType', must be one of 'DIAGNOSTIC', 'SYSTEM'");
        }
        $this->container['interfaceType'] = $interfaceType;

        return $this;
    }

    /**
     * Gets routes
     * @return \PureCloudSDK\DomainNetworkRoute[]
     */
    public function getRoutes()
    {
        return $this->container['routes'];
    }

    /**
     * Sets routes
     * @param \PureCloudSDK\DomainNetworkRoute[] $routes The list of routes assigned to this interface.
     * @return $this
     */
    public function setRoutes($routes)
    {
        $this->container['routes'] = $routes;

        return $this;
    }

    /**
     * Gets addresses
     * @return \PureCloudSDK\DomainNetworkAddress[]
     */
    public function getAddresses()
    {
        return $this->container['addresses'];
    }

    /**
     * Sets addresses
     * @param \PureCloudSDK\DomainNetworkAddress[] $addresses The list of IP addresses on this interface.  Priority of dns addresses are based on order in the list.
     * @return $this
     */
    public function setAddresses($addresses)
    {
        $this->container['addresses'] = $addresses;

        return $this;
    }

    /**
     * Gets ipv4Capabilities
     * @return \PureCloudSDK\DomainCapabilities
     */
    public function getIpv4Capabilities()
    {
        return $this->container['ipv4Capabilities'];
    }

    /**
     * Sets ipv4Capabilities
     * @param \PureCloudSDK\DomainCapabilities $ipv4Capabilities IPv4 interface settings.
     * @return $this
     */
    public function setIpv4Capabilities($ipv4Capabilities)
    {
        $this->container['ipv4Capabilities'] = $ipv4Capabilities;

        return $this;
    }

    /**
     * Gets ipv6Capabilities
     * @return \PureCloudSDK\DomainCapabilities
     */
    public function getIpv6Capabilities()
    {
        return $this->container['ipv6Capabilities'];
    }

    /**
     * Sets ipv6Capabilities
     * @param \PureCloudSDK\DomainCapabilities $ipv6Capabilities IPv6 interface settings.
     * @return $this
     */
    public function setIpv6Capabilities($ipv6Capabilities)
    {
        $this->container['ipv6Capabilities'] = $ipv6Capabilities;

        return $this;
    }

    /**
     * Gets currentState
     * @return string
     */
    public function getCurrentState()
    {
        return $this->container['currentState'];
    }

    /**
     * Sets currentState
     * @param string $currentState
     * @return $this
     */
    public function setCurrentState($currentState)
    {
        $allowed_values = array('INIT', 'CREATING', 'UPDATING', 'OK', 'EXCEPTION', 'DELETING');
        if (!in_array($currentState, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'currentState', must be one of 'INIT', 'CREATING', 'UPDATING', 'OK', 'EXCEPTION', 'DELETING'");
        }
        $this->container['currentState'] = $currentState;

        return $this;
    }

    /**
     * Gets lastModifiedUserId
     * @return string
     */
    public function getLastModifiedUserId()
    {
        return $this->container['lastModifiedUserId'];
    }

    /**
     * Sets lastModifiedUserId
     * @param string $lastModifiedUserId
     * @return $this
     */
    public function setLastModifiedUserId($lastModifiedUserId)
    {
        $this->container['lastModifiedUserId'] = $lastModifiedUserId;

        return $this;
    }

    /**
     * Gets lastModifiedCorrelationId
     * @return string
     */
    public function getLastModifiedCorrelationId()
    {
        return $this->container['lastModifiedCorrelationId'];
    }

    /**
     * Sets lastModifiedCorrelationId
     * @param string $lastModifiedCorrelationId
     * @return $this
     */
    public function setLastModifiedCorrelationId($lastModifiedCorrelationId)
    {
        $this->container['lastModifiedCorrelationId'] = $lastModifiedCorrelationId;

        return $this;
    }

    /**
     * Gets commandResponses
     * @return \PureCloudSDK\DomainNetworkCommandResponse[]
     */
    public function getCommandResponses()
    {
        return $this->container['commandResponses'];
    }

    /**
     * Sets commandResponses
     * @param \PureCloudSDK\DomainNetworkCommandResponse[] $commandResponses
     * @return $this
     */
    public function setCommandResponses($commandResponses)
    {
        $this->container['commandResponses'] = $commandResponses;

        return $this;
    }

    /**
     * Gets inheritPhoneTrunkBasesIPv4
     * @return bool
     */
    public function getInheritPhoneTrunkBasesIPv4()
    {
        return $this->container['inheritPhoneTrunkBasesIPv4'];
    }

    /**
     * Sets inheritPhoneTrunkBasesIPv4
     * @param bool $inheritPhoneTrunkBasesIPv4 The IPv4 phone trunk base assignment will be inherited from the Edge Group.
     * @return $this
     */
    public function setInheritPhoneTrunkBasesIPv4($inheritPhoneTrunkBasesIPv4)
    {
        $this->container['inheritPhoneTrunkBasesIPv4'] = $inheritPhoneTrunkBasesIPv4;

        return $this;
    }

    /**
     * Gets inheritPhoneTrunkBasesIPv6
     * @return bool
     */
    public function getInheritPhoneTrunkBasesIPv6()
    {
        return $this->container['inheritPhoneTrunkBasesIPv6'];
    }

    /**
     * Sets inheritPhoneTrunkBasesIPv6
     * @param bool $inheritPhoneTrunkBasesIPv6 The IPv6 phone trunk base assignment will be inherited from the Edge Group.
     * @return $this
     */
    public function setInheritPhoneTrunkBasesIPv6($inheritPhoneTrunkBasesIPv6)
    {
        $this->container['inheritPhoneTrunkBasesIPv6'] = $inheritPhoneTrunkBasesIPv6;

        return $this;
    }

    /**
     * Gets useForInternalEdgeCommunication
     * @return bool
     */
    public function getUseForInternalEdgeCommunication()
    {
        return $this->container['useForInternalEdgeCommunication'];
    }

    /**
     * Sets useForInternalEdgeCommunication
     * @param bool $useForInternalEdgeCommunication This interface will be used for all internal edge-to-edge communication using settings from the edgeTrunkBaseAssignment on the Edge Group.
     * @return $this
     */
    public function setUseForInternalEdgeCommunication($useForInternalEdgeCommunication)
    {
        $this->container['useForInternalEdgeCommunication'] = $useForInternalEdgeCommunication;

        return $this;
    }

    /**
     * Gets externalTrunkBaseAssignments
     * @return \PureCloudSDK\TrunkBaseAssignment[]
     */
    public function getExternalTrunkBaseAssignments()
    {
        return $this->container['externalTrunkBaseAssignments'];
    }

    /**
     * Sets externalTrunkBaseAssignments
     * @param \PureCloudSDK\TrunkBaseAssignment[] $externalTrunkBaseAssignments External trunk base settings to use for external communication from this interface.
     * @return $this
     */
    public function setExternalTrunkBaseAssignments($externalTrunkBaseAssignments)
    {
        $this->container['externalTrunkBaseAssignments'] = $externalTrunkBaseAssignments;

        return $this;
    }

    /**
     * Gets phoneTrunkBaseAssignments
     * @return \PureCloudSDK\TrunkBaseAssignment[]
     */
    public function getPhoneTrunkBaseAssignments()
    {
        return $this->container['phoneTrunkBaseAssignments'];
    }

    /**
     * Sets phoneTrunkBaseAssignments
     * @param \PureCloudSDK\TrunkBaseAssignment[] $phoneTrunkBaseAssignments Phone trunk base settings to use for phone communication from this interface.  These settings will be ignored when \"inheritPhoneTrunkBases\" is true.
     * @return $this
     */
    public function setPhoneTrunkBaseAssignments($phoneTrunkBaseAssignments)
    {
        $this->container['phoneTrunkBaseAssignments'] = $phoneTrunkBaseAssignments;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


