<?php
/**
 * DomainOrganizationRoleCreate
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * DomainOrganizationRoleCreate Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class DomainOrganizationRoleCreate implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'DomainOrganizationRoleCreate';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'description' => 'string',
        'defaultRoleId' => 'string',
        'permissions' => 'string[]',
        'permissionPolicies' => '\PureCloudSDK\DomainPermissionPolicy[]',
        'userCount' => 'int',
        'roleNeedsUpdate' => 'bool',
        'base' => 'bool',
        'default' => 'bool',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'description' => 'description',
        'defaultRoleId' => 'defaultRoleId',
        'permissions' => 'permissions',
        'permissionPolicies' => 'permissionPolicies',
        'userCount' => 'userCount',
        'roleNeedsUpdate' => 'roleNeedsUpdate',
        'base' => 'base',
        'default' => 'default',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'description' => 'setDescription',
        'defaultRoleId' => 'setDefaultRoleId',
        'permissions' => 'setPermissions',
        'permissionPolicies' => 'setPermissionPolicies',
        'userCount' => 'setUserCount',
        'roleNeedsUpdate' => 'setRoleNeedsUpdate',
        'base' => 'setBase',
        'default' => 'setDefault',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'description' => 'getDescription',
        'defaultRoleId' => 'getDefaultRoleId',
        'permissions' => 'getPermissions',
        'permissionPolicies' => 'getPermissionPolicies',
        'userCount' => 'getUserCount',
        'roleNeedsUpdate' => 'getRoleNeedsUpdate',
        'base' => 'getBase',
        'default' => 'getDefault',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['defaultRoleId'] = isset($data['defaultRoleId']) ? $data['defaultRoleId'] : null;
        $this->container['permissions'] = isset($data['permissions']) ? $data['permissions'] : null;
        $this->container['permissionPolicies'] = isset($data['permissionPolicies']) ? $data['permissionPolicies'] : null;
        $this->container['userCount'] = isset($data['userCount']) ? $data['userCount'] : null;
        $this->container['roleNeedsUpdate'] = isset($data['roleNeedsUpdate']) ? $data['roleNeedsUpdate'] : null;
        $this->container['base'] = isset($data['base']) ? $data['base'] : null;
        $this->container['default'] = isset($data['default']) ? $data['default'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['name'] === null) {
            $invalid_properties[] = "'name' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['name'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The role name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets defaultRoleId
     * @return string
     */
    public function getDefaultRoleId()
    {
        return $this->container['defaultRoleId'];
    }

    /**
     * Sets defaultRoleId
     * @param string $defaultRoleId
     * @return $this
     */
    public function setDefaultRoleId($defaultRoleId)
    {
        $this->container['defaultRoleId'] = $defaultRoleId;

        return $this;
    }

    /**
     * Gets permissions
     * @return string[]
     */
    public function getPermissions()
    {
        return $this->container['permissions'];
    }

    /**
     * Sets permissions
     * @param string[] $permissions
     * @return $this
     */
    public function setPermissions($permissions)
    {
        $this->container['permissions'] = $permissions;

        return $this;
    }

    /**
     * Gets permissionPolicies
     * @return \PureCloudSDK\DomainPermissionPolicy[]
     */
    public function getPermissionPolicies()
    {
        return $this->container['permissionPolicies'];
    }

    /**
     * Sets permissionPolicies
     * @param \PureCloudSDK\DomainPermissionPolicy[] $permissionPolicies
     * @return $this
     */
    public function setPermissionPolicies($permissionPolicies)
    {
        $this->container['permissionPolicies'] = $permissionPolicies;

        return $this;
    }

    /**
     * Gets userCount
     * @return int
     */
    public function getUserCount()
    {
        return $this->container['userCount'];
    }

    /**
     * Sets userCount
     * @param int $userCount
     * @return $this
     */
    public function setUserCount($userCount)
    {
        $this->container['userCount'] = $userCount;

        return $this;
    }

    /**
     * Gets roleNeedsUpdate
     * @return bool
     */
    public function getRoleNeedsUpdate()
    {
        return $this->container['roleNeedsUpdate'];
    }

    /**
     * Sets roleNeedsUpdate
     * @param bool $roleNeedsUpdate Optional unless patch operation.
     * @return $this
     */
    public function setRoleNeedsUpdate($roleNeedsUpdate)
    {
        $this->container['roleNeedsUpdate'] = $roleNeedsUpdate;

        return $this;
    }

    /**
     * Gets base
     * @return bool
     */
    public function getBase()
    {
        return $this->container['base'];
    }

    /**
     * Sets base
     * @param bool $base
     * @return $this
     */
    public function setBase($base)
    {
        $this->container['base'] = $base;

        return $this;
    }

    /**
     * Gets default
     * @return bool
     */
    public function getDefault()
    {
        return $this->container['default'];
    }

    /**
     * Sets default
     * @param bool $default
     * @return $this
     */
    public function setDefault($default)
    {
        $this->container['default'] = $default;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


