<?php
/**
 * JsonNode
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * JsonNode Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class JsonNode implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'JsonNode';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'nodeType' => 'string',
        'float' => 'bool',
        'object' => 'bool',
        'boolean' => 'bool',
        'number' => 'bool',
        'valueNode' => 'bool',
        'containerNode' => 'bool',
        'missingNode' => 'bool',
        'pojo' => 'bool',
        'integralNumber' => 'bool',
        'floatingPointNumber' => 'bool',
        'short' => 'bool',
        'int' => 'bool',
        'long' => 'bool',
        'double' => 'bool',
        'bigDecimal' => 'bool',
        'bigInteger' => 'bool',
        'textual' => 'bool',
        'binary' => 'bool',
        'array' => 'bool',
        'null' => 'bool'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'nodeType' => 'nodeType',
        'float' => 'float',
        'object' => 'object',
        'boolean' => 'boolean',
        'number' => 'number',
        'valueNode' => 'valueNode',
        'containerNode' => 'containerNode',
        'missingNode' => 'missingNode',
        'pojo' => 'pojo',
        'integralNumber' => 'integralNumber',
        'floatingPointNumber' => 'floatingPointNumber',
        'short' => 'short',
        'int' => 'int',
        'long' => 'long',
        'double' => 'double',
        'bigDecimal' => 'bigDecimal',
        'bigInteger' => 'bigInteger',
        'textual' => 'textual',
        'binary' => 'binary',
        'array' => 'array',
        'null' => 'null'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'nodeType' => 'setNodeType',
        'float' => 'setFloat',
        'object' => 'setObject',
        'boolean' => 'setBoolean',
        'number' => 'setNumber',
        'valueNode' => 'setValueNode',
        'containerNode' => 'setContainerNode',
        'missingNode' => 'setMissingNode',
        'pojo' => 'setPojo',
        'integralNumber' => 'setIntegralNumber',
        'floatingPointNumber' => 'setFloatingPointNumber',
        'short' => 'setShort',
        'int' => 'setInt',
        'long' => 'setLong',
        'double' => 'setDouble',
        'bigDecimal' => 'setBigDecimal',
        'bigInteger' => 'setBigInteger',
        'textual' => 'setTextual',
        'binary' => 'setBinary',
        'array' => 'setArray',
        'null' => 'setNull'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'nodeType' => 'getNodeType',
        'float' => 'getFloat',
        'object' => 'getObject',
        'boolean' => 'getBoolean',
        'number' => 'getNumber',
        'valueNode' => 'getValueNode',
        'containerNode' => 'getContainerNode',
        'missingNode' => 'getMissingNode',
        'pojo' => 'getPojo',
        'integralNumber' => 'getIntegralNumber',
        'floatingPointNumber' => 'getFloatingPointNumber',
        'short' => 'getShort',
        'int' => 'getInt',
        'long' => 'getLong',
        'double' => 'getDouble',
        'bigDecimal' => 'getBigDecimal',
        'bigInteger' => 'getBigInteger',
        'textual' => 'getTextual',
        'binary' => 'getBinary',
        'array' => 'getArray',
        'null' => 'getNull'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const NODE_TYPE_ARRAY = 'ARRAY';
    const NODE_TYPE_BINARY = 'BINARY';
    const NODE_TYPE_BOOLEAN = 'BOOLEAN';
    const NODE_TYPE_MISSING = 'MISSING';
    const NODE_TYPE_NULL = 'NULL';
    const NODE_TYPE_NUMBER = 'NUMBER';
    const NODE_TYPE_OBJECT = 'OBJECT';
    const NODE_TYPE_POJO = 'POJO';
    const NODE_TYPE_STRING = 'STRING';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getNodeTypeAllowableValues()
    {
        return [
            self::NODE_TYPE_ARRAY,
            self::NODE_TYPE_BINARY,
            self::NODE_TYPE_BOOLEAN,
            self::NODE_TYPE_MISSING,
            self::NODE_TYPE_NULL,
            self::NODE_TYPE_NUMBER,
            self::NODE_TYPE_OBJECT,
            self::NODE_TYPE_POJO,
            self::NODE_TYPE_STRING,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['nodeType'] = isset($data['nodeType']) ? $data['nodeType'] : null;
        $this->container['float'] = isset($data['float']) ? $data['float'] : null;
        $this->container['object'] = isset($data['object']) ? $data['object'] : null;
        $this->container['boolean'] = isset($data['boolean']) ? $data['boolean'] : null;
        $this->container['number'] = isset($data['number']) ? $data['number'] : null;
        $this->container['valueNode'] = isset($data['valueNode']) ? $data['valueNode'] : null;
        $this->container['containerNode'] = isset($data['containerNode']) ? $data['containerNode'] : null;
        $this->container['missingNode'] = isset($data['missingNode']) ? $data['missingNode'] : null;
        $this->container['pojo'] = isset($data['pojo']) ? $data['pojo'] : null;
        $this->container['integralNumber'] = isset($data['integralNumber']) ? $data['integralNumber'] : null;
        $this->container['floatingPointNumber'] = isset($data['floatingPointNumber']) ? $data['floatingPointNumber'] : null;
        $this->container['short'] = isset($data['short']) ? $data['short'] : null;
        $this->container['int'] = isset($data['int']) ? $data['int'] : null;
        $this->container['long'] = isset($data['long']) ? $data['long'] : null;
        $this->container['double'] = isset($data['double']) ? $data['double'] : null;
        $this->container['bigDecimal'] = isset($data['bigDecimal']) ? $data['bigDecimal'] : null;
        $this->container['bigInteger'] = isset($data['bigInteger']) ? $data['bigInteger'] : null;
        $this->container['textual'] = isset($data['textual']) ? $data['textual'] : null;
        $this->container['binary'] = isset($data['binary']) ? $data['binary'] : null;
        $this->container['array'] = isset($data['array']) ? $data['array'] : null;
        $this->container['null'] = isset($data['null']) ? $data['null'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("ARRAY", "BINARY", "BOOLEAN", "MISSING", "NULL", "NUMBER", "OBJECT", "POJO", "STRING");
        if (!in_array($this->container['nodeType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'nodeType', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("ARRAY", "BINARY", "BOOLEAN", "MISSING", "NULL", "NUMBER", "OBJECT", "POJO", "STRING");
        if (!in_array($this->container['nodeType'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets nodeType
     * @return string
     */
    public function getNodeType()
    {
        return $this->container['nodeType'];
    }

    /**
     * Sets nodeType
     * @param string $nodeType
     * @return $this
     */
    public function setNodeType($nodeType)
    {
        $allowed_values = array('ARRAY', 'BINARY', 'BOOLEAN', 'MISSING', 'NULL', 'NUMBER', 'OBJECT', 'POJO', 'STRING');
        if (!in_array($nodeType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'nodeType', must be one of 'ARRAY', 'BINARY', 'BOOLEAN', 'MISSING', 'NULL', 'NUMBER', 'OBJECT', 'POJO', 'STRING'");
        }
        $this->container['nodeType'] = $nodeType;

        return $this;
    }

    /**
     * Gets float
     * @return bool
     */
    public function getFloat()
    {
        return $this->container['float'];
    }

    /**
     * Sets float
     * @param bool $float
     * @return $this
     */
    public function setFloat($float)
    {
        $this->container['float'] = $float;

        return $this;
    }

    /**
     * Gets object
     * @return bool
     */
    public function getObject()
    {
        return $this->container['object'];
    }

    /**
     * Sets object
     * @param bool $object
     * @return $this
     */
    public function setObject($object)
    {
        $this->container['object'] = $object;

        return $this;
    }

    /**
     * Gets boolean
     * @return bool
     */
    public function getBoolean()
    {
        return $this->container['boolean'];
    }

    /**
     * Sets boolean
     * @param bool $boolean
     * @return $this
     */
    public function setBoolean($boolean)
    {
        $this->container['boolean'] = $boolean;

        return $this;
    }

    /**
     * Gets number
     * @return bool
     */
    public function getNumber()
    {
        return $this->container['number'];
    }

    /**
     * Sets number
     * @param bool $number
     * @return $this
     */
    public function setNumber($number)
    {
        $this->container['number'] = $number;

        return $this;
    }

    /**
     * Gets valueNode
     * @return bool
     */
    public function getValueNode()
    {
        return $this->container['valueNode'];
    }

    /**
     * Sets valueNode
     * @param bool $valueNode
     * @return $this
     */
    public function setValueNode($valueNode)
    {
        $this->container['valueNode'] = $valueNode;

        return $this;
    }

    /**
     * Gets containerNode
     * @return bool
     */
    public function getContainerNode()
    {
        return $this->container['containerNode'];
    }

    /**
     * Sets containerNode
     * @param bool $containerNode
     * @return $this
     */
    public function setContainerNode($containerNode)
    {
        $this->container['containerNode'] = $containerNode;

        return $this;
    }

    /**
     * Gets missingNode
     * @return bool
     */
    public function getMissingNode()
    {
        return $this->container['missingNode'];
    }

    /**
     * Sets missingNode
     * @param bool $missingNode
     * @return $this
     */
    public function setMissingNode($missingNode)
    {
        $this->container['missingNode'] = $missingNode;

        return $this;
    }

    /**
     * Gets pojo
     * @return bool
     */
    public function getPojo()
    {
        return $this->container['pojo'];
    }

    /**
     * Sets pojo
     * @param bool $pojo
     * @return $this
     */
    public function setPojo($pojo)
    {
        $this->container['pojo'] = $pojo;

        return $this;
    }

    /**
     * Gets integralNumber
     * @return bool
     */
    public function getIntegralNumber()
    {
        return $this->container['integralNumber'];
    }

    /**
     * Sets integralNumber
     * @param bool $integralNumber
     * @return $this
     */
    public function setIntegralNumber($integralNumber)
    {
        $this->container['integralNumber'] = $integralNumber;

        return $this;
    }

    /**
     * Gets floatingPointNumber
     * @return bool
     */
    public function getFloatingPointNumber()
    {
        return $this->container['floatingPointNumber'];
    }

    /**
     * Sets floatingPointNumber
     * @param bool $floatingPointNumber
     * @return $this
     */
    public function setFloatingPointNumber($floatingPointNumber)
    {
        $this->container['floatingPointNumber'] = $floatingPointNumber;

        return $this;
    }

    /**
     * Gets short
     * @return bool
     */
    public function getShort()
    {
        return $this->container['short'];
    }

    /**
     * Sets short
     * @param bool $short
     * @return $this
     */
    public function setShort($short)
    {
        $this->container['short'] = $short;

        return $this;
    }

    /**
     * Gets int
     * @return bool
     */
    public function getInt()
    {
        return $this->container['int'];
    }

    /**
     * Sets int
     * @param bool $int
     * @return $this
     */
    public function setInt($int)
    {
        $this->container['int'] = $int;

        return $this;
    }

    /**
     * Gets long
     * @return bool
     */
    public function getLong()
    {
        return $this->container['long'];
    }

    /**
     * Sets long
     * @param bool $long
     * @return $this
     */
    public function setLong($long)
    {
        $this->container['long'] = $long;

        return $this;
    }

    /**
     * Gets double
     * @return bool
     */
    public function getDouble()
    {
        return $this->container['double'];
    }

    /**
     * Sets double
     * @param bool $double
     * @return $this
     */
    public function setDouble($double)
    {
        $this->container['double'] = $double;

        return $this;
    }

    /**
     * Gets bigDecimal
     * @return bool
     */
    public function getBigDecimal()
    {
        return $this->container['bigDecimal'];
    }

    /**
     * Sets bigDecimal
     * @param bool $bigDecimal
     * @return $this
     */
    public function setBigDecimal($bigDecimal)
    {
        $this->container['bigDecimal'] = $bigDecimal;

        return $this;
    }

    /**
     * Gets bigInteger
     * @return bool
     */
    public function getBigInteger()
    {
        return $this->container['bigInteger'];
    }

    /**
     * Sets bigInteger
     * @param bool $bigInteger
     * @return $this
     */
    public function setBigInteger($bigInteger)
    {
        $this->container['bigInteger'] = $bigInteger;

        return $this;
    }

    /**
     * Gets textual
     * @return bool
     */
    public function getTextual()
    {
        return $this->container['textual'];
    }

    /**
     * Sets textual
     * @param bool $textual
     * @return $this
     */
    public function setTextual($textual)
    {
        $this->container['textual'] = $textual;

        return $this;
    }

    /**
     * Gets binary
     * @return bool
     */
    public function getBinary()
    {
        return $this->container['binary'];
    }

    /**
     * Sets binary
     * @param bool $binary
     * @return $this
     */
    public function setBinary($binary)
    {
        $this->container['binary'] = $binary;

        return $this;
    }

    /**
     * Gets array
     * @return bool
     */
    public function getArray()
    {
        return $this->container['array'];
    }

    /**
     * Sets array
     * @param bool $array
     * @return $this
     */
    public function setArray($array)
    {
        $this->container['array'] = $array;

        return $this;
    }

    /**
     * Gets null
     * @return bool
     */
    public function getNull()
    {
        return $this->container['null'];
    }

    /**
     * Sets null
     * @param bool $null
     * @return $this
     */
    public function setNull($null)
    {
        $this->container['null'] = $null;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


