<?php
/**
 * ReportRunEntry
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * ReportRunEntry Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ReportRunEntry implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ReportRunEntry';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'reportId' => 'string',
        'runTime' => '\DateTime',
        'runStatus' => 'string',
        'errorMessage' => 'string',
        'runDurationMsec' => 'int',
        'reportUrl' => 'string',
        'reportFormat' => 'string',
        'scheduleUri' => 'string',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'reportId' => 'reportId',
        'runTime' => 'runTime',
        'runStatus' => 'runStatus',
        'errorMessage' => 'errorMessage',
        'runDurationMsec' => 'runDurationMsec',
        'reportUrl' => 'reportUrl',
        'reportFormat' => 'reportFormat',
        'scheduleUri' => 'scheduleUri',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'reportId' => 'setReportId',
        'runTime' => 'setRunTime',
        'runStatus' => 'setRunStatus',
        'errorMessage' => 'setErrorMessage',
        'runDurationMsec' => 'setRunDurationMsec',
        'reportUrl' => 'setReportUrl',
        'reportFormat' => 'setReportFormat',
        'scheduleUri' => 'setScheduleUri',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'reportId' => 'getReportId',
        'runTime' => 'getRunTime',
        'runStatus' => 'getRunStatus',
        'errorMessage' => 'getErrorMessage',
        'runDurationMsec' => 'getRunDurationMsec',
        'reportUrl' => 'getReportUrl',
        'reportFormat' => 'getReportFormat',
        'scheduleUri' => 'getScheduleUri',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const RUN_STATUS_RUNNING = 'RUNNING';
    const RUN_STATUS_COMPLETED = 'COMPLETED';
    const RUN_STATUS_COMPLETED_WITH_ERRORS = 'COMPLETED_WITH_ERRORS';
    const RUN_STATUS_FAILED = 'FAILED';
    const RUN_STATUS_FAILED_TIMEOUT = 'FAILED_TIMEOUT';
    const RUN_STATUS_FAILED_DATALIMIT = 'FAILED_DATALIMIT';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getRunStatusAllowableValues()
    {
        return [
            self::RUN_STATUS_RUNNING,
            self::RUN_STATUS_COMPLETED,
            self::RUN_STATUS_COMPLETED_WITH_ERRORS,
            self::RUN_STATUS_FAILED,
            self::RUN_STATUS_FAILED_TIMEOUT,
            self::RUN_STATUS_FAILED_DATALIMIT,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['reportId'] = isset($data['reportId']) ? $data['reportId'] : null;
        $this->container['runTime'] = isset($data['runTime']) ? $data['runTime'] : null;
        $this->container['runStatus'] = isset($data['runStatus']) ? $data['runStatus'] : null;
        $this->container['errorMessage'] = isset($data['errorMessage']) ? $data['errorMessage'] : null;
        $this->container['runDurationMsec'] = isset($data['runDurationMsec']) ? $data['runDurationMsec'] : null;
        $this->container['reportUrl'] = isset($data['reportUrl']) ? $data['reportUrl'] : null;
        $this->container['reportFormat'] = isset($data['reportFormat']) ? $data['reportFormat'] : null;
        $this->container['scheduleUri'] = isset($data['scheduleUri']) ? $data['scheduleUri'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("RUNNING", "COMPLETED", "COMPLETED_WITH_ERRORS", "FAILED", "FAILED_TIMEOUT", "FAILED_DATALIMIT");
        if (!in_array($this->container['runStatus'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'runStatus', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("RUNNING", "COMPLETED", "COMPLETED_WITH_ERRORS", "FAILED", "FAILED_TIMEOUT", "FAILED_DATALIMIT");
        if (!in_array($this->container['runStatus'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets reportId
     * @return string
     */
    public function getReportId()
    {
        return $this->container['reportId'];
    }

    /**
     * Sets reportId
     * @param string $reportId
     * @return $this
     */
    public function setReportId($reportId)
    {
        $this->container['reportId'] = $reportId;

        return $this;
    }

    /**
     * Gets runTime
     * @return \DateTime
     */
    public function getRunTime()
    {
        return $this->container['runTime'];
    }

    /**
     * Sets runTime
     * @param \DateTime $runTime Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setRunTime($runTime)
    {
        $this->container['runTime'] = $runTime;

        return $this;
    }

    /**
     * Gets runStatus
     * @return string
     */
    public function getRunStatus()
    {
        return $this->container['runStatus'];
    }

    /**
     * Sets runStatus
     * @param string $runStatus
     * @return $this
     */
    public function setRunStatus($runStatus)
    {
        $allowed_values = array('RUNNING', 'COMPLETED', 'COMPLETED_WITH_ERRORS', 'FAILED', 'FAILED_TIMEOUT', 'FAILED_DATALIMIT');
        if (!in_array($runStatus, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'runStatus', must be one of 'RUNNING', 'COMPLETED', 'COMPLETED_WITH_ERRORS', 'FAILED', 'FAILED_TIMEOUT', 'FAILED_DATALIMIT'");
        }
        $this->container['runStatus'] = $runStatus;

        return $this;
    }

    /**
     * Gets errorMessage
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->container['errorMessage'];
    }

    /**
     * Sets errorMessage
     * @param string $errorMessage
     * @return $this
     */
    public function setErrorMessage($errorMessage)
    {
        $this->container['errorMessage'] = $errorMessage;

        return $this;
    }

    /**
     * Gets runDurationMsec
     * @return int
     */
    public function getRunDurationMsec()
    {
        return $this->container['runDurationMsec'];
    }

    /**
     * Sets runDurationMsec
     * @param int $runDurationMsec
     * @return $this
     */
    public function setRunDurationMsec($runDurationMsec)
    {
        $this->container['runDurationMsec'] = $runDurationMsec;

        return $this;
    }

    /**
     * Gets reportUrl
     * @return string
     */
    public function getReportUrl()
    {
        return $this->container['reportUrl'];
    }

    /**
     * Sets reportUrl
     * @param string $reportUrl
     * @return $this
     */
    public function setReportUrl($reportUrl)
    {
        $this->container['reportUrl'] = $reportUrl;

        return $this;
    }

    /**
     * Gets reportFormat
     * @return string
     */
    public function getReportFormat()
    {
        return $this->container['reportFormat'];
    }

    /**
     * Sets reportFormat
     * @param string $reportFormat
     * @return $this
     */
    public function setReportFormat($reportFormat)
    {
        $this->container['reportFormat'] = $reportFormat;

        return $this;
    }

    /**
     * Gets scheduleUri
     * @return string
     */
    public function getScheduleUri()
    {
        return $this->container['scheduleUri'];
    }

    /**
     * Sets scheduleUri
     * @param string $scheduleUri
     * @return $this
     */
    public function setScheduleUri($scheduleUri)
    {
        $this->container['scheduleUri'] = $scheduleUri;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


