<?php
/**
 * StreetAddress
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * StreetAddress Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class StreetAddress implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'StreetAddress';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'country' => 'string',
        'a1' => 'string',
        'a3' => 'string',
        'rD' => 'string',
        'hNO' => 'string',
        'lOC' => 'string',
        'nAM' => 'string',
        'pC' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'country' => 'country',
        'a1' => 'A1',
        'a3' => 'A3',
        'rD' => 'RD',
        'hNO' => 'HNO',
        'lOC' => 'LOC',
        'nAM' => 'NAM',
        'pC' => 'PC'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'country' => 'setCountry',
        'a1' => 'setA1',
        'a3' => 'setA3',
        'rD' => 'setRD',
        'hNO' => 'setHNO',
        'lOC' => 'setLOC',
        'nAM' => 'setNAM',
        'pC' => 'setPC'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'country' => 'getCountry',
        'a1' => 'getA1',
        'a3' => 'getA3',
        'rD' => 'getRD',
        'hNO' => 'getHNO',
        'lOC' => 'getLOC',
        'nAM' => 'getNAM',
        'pC' => 'getPC'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['country'] = isset($data['country']) ? $data['country'] : null;
        $this->container['a1'] = isset($data['a1']) ? $data['a1'] : null;
        $this->container['a3'] = isset($data['a3']) ? $data['a3'] : null;
        $this->container['rD'] = isset($data['rD']) ? $data['rD'] : null;
        $this->container['hNO'] = isset($data['hNO']) ? $data['hNO'] : null;
        $this->container['lOC'] = isset($data['lOC']) ? $data['lOC'] : null;
        $this->container['nAM'] = isset($data['nAM']) ? $data['nAM'] : null;
        $this->container['pC'] = isset($data['pC']) ? $data['pC'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['country'] === null) {
            $invalid_properties[] = "'country' can't be null";
        }
        if ($this->container['a1'] === null) {
            $invalid_properties[] = "'a1' can't be null";
        }
        if ($this->container['a3'] === null) {
            $invalid_properties[] = "'a3' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['country'] === null) {
            return false;
        }
        if ($this->container['a1'] === null) {
            return false;
        }
        if ($this->container['a3'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets country
     * @return string
     */
    public function getCountry()
    {
        return $this->container['country'];
    }

    /**
     * Sets country
     * @param string $country 2 Letter Country code, like US or GB
     * @return $this
     */
    public function setCountry($country)
    {
        $this->container['country'] = $country;

        return $this;
    }

    /**
     * Gets a1
     * @return string
     */
    public function getA1()
    {
        return $this->container['a1'];
    }

    /**
     * Sets a1
     * @param string $a1 State or Province
     * @return $this
     */
    public function setA1($a1)
    {
        $this->container['a1'] = $a1;

        return $this;
    }

    /**
     * Gets a3
     * @return string
     */
    public function getA3()
    {
        return $this->container['a3'];
    }

    /**
     * Sets a3
     * @param string $a3 City or township
     * @return $this
     */
    public function setA3($a3)
    {
        $this->container['a3'] = $a3;

        return $this;
    }

    /**
     * Gets rD
     * @return string
     */
    public function getRD()
    {
        return $this->container['rD'];
    }

    /**
     * Sets rD
     * @param string $rD
     * @return $this
     */
    public function setRD($rD)
    {
        $this->container['rD'] = $rD;

        return $this;
    }

    /**
     * Gets hNO
     * @return string
     */
    public function getHNO()
    {
        return $this->container['hNO'];
    }

    /**
     * Sets hNO
     * @param string $hNO
     * @return $this
     */
    public function setHNO($hNO)
    {
        $this->container['hNO'] = $hNO;

        return $this;
    }

    /**
     * Gets lOC
     * @return string
     */
    public function getLOC()
    {
        return $this->container['lOC'];
    }

    /**
     * Sets lOC
     * @param string $lOC
     * @return $this
     */
    public function setLOC($lOC)
    {
        $this->container['lOC'] = $lOC;

        return $this;
    }

    /**
     * Gets nAM
     * @return string
     */
    public function getNAM()
    {
        return $this->container['nAM'];
    }

    /**
     * Sets nAM
     * @param string $nAM
     * @return $this
     */
    public function setNAM($nAM)
    {
        $this->container['nAM'] = $nAM;

        return $this;
    }

    /**
     * Gets pC
     * @return string
     */
    public function getPC()
    {
        return $this->container['pC'];
    }

    /**
     * Sets pC
     * @param string $pC
     * @return $this
     */
    public function setPC($pC)
    {
        $this->container['pC'] = $pC;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


