# PureCloudSDK
With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.

This PHP package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: v2
- Build date: 2017-03-13T13:47:06.499+01:00
- Build package: class io.swagger.codegen.languages.PhpClientCodegen
For more information, please visit [https://developer.mypurecloud.com](https://developer.mypurecloud.com)

## Requirements

PHP 5.4.0 and later

## Installation & Usage
### Composer

To install the bindings via [Composer](http://getcomposer.org/), add the following to `composer.json`:

```
{
  "repositories": [
    {
      "type": "git",
      "url": "https://github.com/DealerDirect/PureCloudSDK/PureCloudSDK.git"
    }
  ],
  "require": {
    "DealerDirect/PureCloudSDK/PureCloudSDK": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
    require_once('/path/to/PureCloudSDK/autoload.php');
```

## Tests

To run the unit tests:

```
composer install
./vendor/bin/phpunit lib/Tests
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$alertId = "alertId_example"; // string | Alert ID

try {
    $api_instance->deleteAlertingHeartbeatAlertsAlertId($alertId);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->deleteAlertingHeartbeatAlertsAlertId: ', $e->getMessage(), PHP_EOL;
}

?>
```

## Documentation for API Endpoints

All URIs are relative to *https://api.mypurecloud.ie*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AlertingApi* | [**deleteAlertingHeartbeatAlertsAlertId**](docs/Api/AlertingApi.md#deletealertingheartbeatalertsalertid) | **DELETE** /api/v2/alerting/heartbeat/alerts/{alertId} | Delete a heart beat alert
*AlertingApi* | [**deleteAlertingHeartbeatRulesRuleId**](docs/Api/AlertingApi.md#deletealertingheartbeatrulesruleid) | **DELETE** /api/v2/alerting/heartbeat/rules/{ruleId} | Delete a heart beat rule.
*AlertingApi* | [**deleteAlertingInteractionstatsAlertsAlertId**](docs/Api/AlertingApi.md#deletealertinginteractionstatsalertsalertid) | **DELETE** /api/v2/alerting/interactionstats/alerts/{alertId} | Delete an interaction stats alert
*AlertingApi* | [**deleteAlertingInteractionstatsRulesRuleId**](docs/Api/AlertingApi.md#deletealertinginteractionstatsrulesruleid) | **DELETE** /api/v2/alerting/interactionstats/rules/{ruleId} | Delete an interaction stats rule.
*AlertingApi* | [**deleteAlertingRoutingstatusAlertsAlertId**](docs/Api/AlertingApi.md#deletealertingroutingstatusalertsalertid) | **DELETE** /api/v2/alerting/routingstatus/alerts/{alertId} | Delete a routing status alert
*AlertingApi* | [**deleteAlertingRoutingstatusRulesRuleId**](docs/Api/AlertingApi.md#deletealertingroutingstatusrulesruleid) | **DELETE** /api/v2/alerting/routingstatus/rules/{ruleId} | Delete a routing status rule.
*AlertingApi* | [**deleteAlertingUserpresenceAlertsAlertId**](docs/Api/AlertingApi.md#deletealertinguserpresencealertsalertid) | **DELETE** /api/v2/alerting/userpresence/alerts/{alertId} | Delete a user presence alert
*AlertingApi* | [**deleteAlertingUserpresenceRulesRuleId**](docs/Api/AlertingApi.md#deletealertinguserpresencerulesruleid) | **DELETE** /api/v2/alerting/userpresence/rules/{ruleId} | Delete a user presence rule.
*AlertingApi* | [**getAlertingHeartbeatAlerts**](docs/Api/AlertingApi.md#getalertingheartbeatalerts) | **GET** /api/v2/alerting/heartbeat/alerts | Get heart beat alert list.
*AlertingApi* | [**getAlertingHeartbeatAlertsAlertId**](docs/Api/AlertingApi.md#getalertingheartbeatalertsalertid) | **GET** /api/v2/alerting/heartbeat/alerts/{alertId} | Get a heart beat alert
*AlertingApi* | [**getAlertingHeartbeatRules**](docs/Api/AlertingApi.md#getalertingheartbeatrules) | **GET** /api/v2/alerting/heartbeat/rules | Get a heart beat rule list.
*AlertingApi* | [**getAlertingHeartbeatRulesRuleId**](docs/Api/AlertingApi.md#getalertingheartbeatrulesruleid) | **GET** /api/v2/alerting/heartbeat/rules/{ruleId} | Get a heart beat rule.
*AlertingApi* | [**getAlertingInteractionstatsAlerts**](docs/Api/AlertingApi.md#getalertinginteractionstatsalerts) | **GET** /api/v2/alerting/interactionstats/alerts | Get interaction stats alert list.
*AlertingApi* | [**getAlertingInteractionstatsAlertsAlertId**](docs/Api/AlertingApi.md#getalertinginteractionstatsalertsalertid) | **GET** /api/v2/alerting/interactionstats/alerts/{alertId} | Get an interaction stats alert
*AlertingApi* | [**getAlertingInteractionstatsAlertsUnread**](docs/Api/AlertingApi.md#getalertinginteractionstatsalertsunread) | **GET** /api/v2/alerting/interactionstats/alerts/unread | Gets user unread count of interaction stats alerts.
*AlertingApi* | [**getAlertingInteractionstatsRules**](docs/Api/AlertingApi.md#getalertinginteractionstatsrules) | **GET** /api/v2/alerting/interactionstats/rules | Get an interaction stats rule list.
*AlertingApi* | [**getAlertingInteractionstatsRulesRuleId**](docs/Api/AlertingApi.md#getalertinginteractionstatsrulesruleid) | **GET** /api/v2/alerting/interactionstats/rules/{ruleId} | Get an interaction stats rule.
*AlertingApi* | [**getAlertingRoutingstatusAlerts**](docs/Api/AlertingApi.md#getalertingroutingstatusalerts) | **GET** /api/v2/alerting/routingstatus/alerts | Get routing status alert list.
*AlertingApi* | [**getAlertingRoutingstatusAlertsAlertId**](docs/Api/AlertingApi.md#getalertingroutingstatusalertsalertid) | **GET** /api/v2/alerting/routingstatus/alerts/{alertId} | Get a routing status alert
*AlertingApi* | [**getAlertingRoutingstatusRules**](docs/Api/AlertingApi.md#getalertingroutingstatusrules) | **GET** /api/v2/alerting/routingstatus/rules | Get a routing status rule list.
*AlertingApi* | [**getAlertingRoutingstatusRulesRuleId**](docs/Api/AlertingApi.md#getalertingroutingstatusrulesruleid) | **GET** /api/v2/alerting/routingstatus/rules/{ruleId} | Get a routing status rule.
*AlertingApi* | [**getAlertingUserpresenceAlerts**](docs/Api/AlertingApi.md#getalertinguserpresencealerts) | **GET** /api/v2/alerting/userpresence/alerts | Get user presence alert list.
*AlertingApi* | [**getAlertingUserpresenceAlertsAlertId**](docs/Api/AlertingApi.md#getalertinguserpresencealertsalertid) | **GET** /api/v2/alerting/userpresence/alerts/{alertId} | Get a user presence alert
*AlertingApi* | [**getAlertingUserpresenceRules**](docs/Api/AlertingApi.md#getalertinguserpresencerules) | **GET** /api/v2/alerting/userpresence/rules | Get a user presence rule list.
*AlertingApi* | [**getAlertingUserpresenceRulesRuleId**](docs/Api/AlertingApi.md#getalertinguserpresencerulesruleid) | **GET** /api/v2/alerting/userpresence/rules/{ruleId} | Get a user presence rule.
*AlertingApi* | [**postAlertingHeartbeatRules**](docs/Api/AlertingApi.md#postalertingheartbeatrules) | **POST** /api/v2/alerting/heartbeat/rules | Create a heart beat rule.
*AlertingApi* | [**postAlertingInteractionstatsRules**](docs/Api/AlertingApi.md#postalertinginteractionstatsrules) | **POST** /api/v2/alerting/interactionstats/rules | Create an interaction stats rule.
*AlertingApi* | [**postAlertingRoutingstatusRules**](docs/Api/AlertingApi.md#postalertingroutingstatusrules) | **POST** /api/v2/alerting/routingstatus/rules | Create a routing status rule.
*AlertingApi* | [**postAlertingUserpresenceRules**](docs/Api/AlertingApi.md#postalertinguserpresencerules) | **POST** /api/v2/alerting/userpresence/rules | Create a user presence rule.
*AlertingApi* | [**putAlertingHeartbeatRulesRuleId**](docs/Api/AlertingApi.md#putalertingheartbeatrulesruleid) | **PUT** /api/v2/alerting/heartbeat/rules/{ruleId} | Update a heart beat rule
*AlertingApi* | [**putAlertingInteractionstatsAlertsAlertId**](docs/Api/AlertingApi.md#putalertinginteractionstatsalertsalertid) | **PUT** /api/v2/alerting/interactionstats/alerts/{alertId} | Update an interaction stats alert read status
*AlertingApi* | [**putAlertingInteractionstatsRulesRuleId**](docs/Api/AlertingApi.md#putalertinginteractionstatsrulesruleid) | **PUT** /api/v2/alerting/interactionstats/rules/{ruleId} | Update an interaction stats rule
*AlertingApi* | [**putAlertingRoutingstatusRulesRuleId**](docs/Api/AlertingApi.md#putalertingroutingstatusrulesruleid) | **PUT** /api/v2/alerting/routingstatus/rules/{ruleId} | Update a routing status rule
*AlertingApi* | [**putAlertingUserpresenceRulesRuleId**](docs/Api/AlertingApi.md#putalertinguserpresencerulesruleid) | **PUT** /api/v2/alerting/userpresence/rules/{ruleId} | Update a user presence rule
*AnalyticsApi* | [**deleteAnalyticsReportingSchedulesScheduleId**](docs/Api/AnalyticsApi.md#deleteanalyticsreportingschedulesscheduleid) | **DELETE** /api/v2/analytics/reporting/schedules/{scheduleId} | Delete a scheduled report job.
*AnalyticsApi* | [**getAnalyticsConversationsConversationIdDetails**](docs/Api/AnalyticsApi.md#getanalyticsconversationsconversationiddetails) | **GET** /api/v2/analytics/conversations/{conversationId}/details | Get a conversation by id
*AnalyticsApi* | [**getAnalyticsReportingMetadata**](docs/Api/AnalyticsApi.md#getanalyticsreportingmetadata) | **GET** /api/v2/analytics/reporting/metadata | Get list of reporting metadata.
*AnalyticsApi* | [**getAnalyticsReportingReportIdMetadata**](docs/Api/AnalyticsApi.md#getanalyticsreportingreportidmetadata) | **GET** /api/v2/analytics/reporting/{reportId}/metadata | Get a reporting metadata.
*AnalyticsApi* | [**getAnalyticsReportingReportformats**](docs/Api/AnalyticsApi.md#getanalyticsreportingreportformats) | **GET** /api/v2/analytics/reporting/reportformats | Get a list of report formats
*AnalyticsApi* | [**getAnalyticsReportingSchedules**](docs/Api/AnalyticsApi.md#getanalyticsreportingschedules) | **GET** /api/v2/analytics/reporting/schedules | Get a list of scheduled report jobs
*AnalyticsApi* | [**getAnalyticsReportingSchedulesScheduleId**](docs/Api/AnalyticsApi.md#getanalyticsreportingschedulesscheduleid) | **GET** /api/v2/analytics/reporting/schedules/{scheduleId} | Get a scheduled report job.
*AnalyticsApi* | [**getAnalyticsReportingSchedulesScheduleIdHistory**](docs/Api/AnalyticsApi.md#getanalyticsreportingschedulesscheduleidhistory) | **GET** /api/v2/analytics/reporting/schedules/{scheduleId}/history | Get list of completed scheduled report jobs.
*AnalyticsApi* | [**getAnalyticsReportingSchedulesScheduleIdHistoryLatest**](docs/Api/AnalyticsApi.md#getanalyticsreportingschedulesscheduleidhistorylatest) | **GET** /api/v2/analytics/reporting/schedules/{scheduleId}/history/latest | Get most recently completed scheduled report job.
*AnalyticsApi* | [**getAnalyticsReportingSchedulesScheduleIdHistoryRunId**](docs/Api/AnalyticsApi.md#getanalyticsreportingschedulesscheduleidhistoryrunid) | **GET** /api/v2/analytics/reporting/schedules/{scheduleId}/history/{runId} | A completed scheduled report job
*AnalyticsApi* | [**getAnalyticsReportingTimeperiods**](docs/Api/AnalyticsApi.md#getanalyticsreportingtimeperiods) | **GET** /api/v2/analytics/reporting/timeperiods | Get a list of report time periods.
*AnalyticsApi* | [**postAnalyticsConversationsAggregatesQuery**](docs/Api/AnalyticsApi.md#postanalyticsconversationsaggregatesquery) | **POST** /api/v2/analytics/conversations/aggregates/query | Query for conversation aggregates
*AnalyticsApi* | [**postAnalyticsConversationsConversationIdDetailsProperties**](docs/Api/AnalyticsApi.md#postanalyticsconversationsconversationiddetailsproperties) | **POST** /api/v2/analytics/conversations/{conversationId}/details/properties | Index conversation properties
*AnalyticsApi* | [**postAnalyticsConversationsDetailsQuery**](docs/Api/AnalyticsApi.md#postanalyticsconversationsdetailsquery) | **POST** /api/v2/analytics/conversations/details/query | Query for conversation details
*AnalyticsApi* | [**postAnalyticsEvaluationsAggregatesQuery**](docs/Api/AnalyticsApi.md#postanalyticsevaluationsaggregatesquery) | **POST** /api/v2/analytics/evaluations/aggregates/query | Query for evaluation aggregates
*AnalyticsApi* | [**postAnalyticsQueuesObservationsQuery**](docs/Api/AnalyticsApi.md#postanalyticsqueuesobservationsquery) | **POST** /api/v2/analytics/queues/observations/query | Query for queue observations
*AnalyticsApi* | [**postAnalyticsReportingSchedules**](docs/Api/AnalyticsApi.md#postanalyticsreportingschedules) | **POST** /api/v2/analytics/reporting/schedules | Create a scheduled report job
*AnalyticsApi* | [**postAnalyticsReportingSchedulesScheduleIdRunreport**](docs/Api/AnalyticsApi.md#postanalyticsreportingschedulesscheduleidrunreport) | **POST** /api/v2/analytics/reporting/schedules/{scheduleId}/runreport | Place a scheduled report immediately into the reporting queue
*AnalyticsApi* | [**postAnalyticsUsersAggregatesQuery**](docs/Api/AnalyticsApi.md#postanalyticsusersaggregatesquery) | **POST** /api/v2/analytics/users/aggregates/query | Query for user aggregates
*AnalyticsApi* | [**postAnalyticsUsersDetailsQuery**](docs/Api/AnalyticsApi.md#postanalyticsusersdetailsquery) | **POST** /api/v2/analytics/users/details/query | Query for user details
*AnalyticsApi* | [**postAnalyticsUsersObservationsQuery**](docs/Api/AnalyticsApi.md#postanalyticsusersobservationsquery) | **POST** /api/v2/analytics/users/observations/query | Query for user observations
*AnalyticsApi* | [**putAnalyticsReportingSchedulesScheduleId**](docs/Api/AnalyticsApi.md#putanalyticsreportingschedulesscheduleid) | **PUT** /api/v2/analytics/reporting/schedules/{scheduleId} | Update a scheduled report job.
*AttributesApi* | [**deleteAttributesAttributeId**](docs/Api/AttributesApi.md#deleteattributesattributeid) | **DELETE** /api/v2/attributes/{attributeId} | Delete an existing Attribute.
*AttributesApi* | [**getAttributes**](docs/Api/AttributesApi.md#getattributes) | **GET** /api/v2/attributes | Gets a list of existing attributes.
*AttributesApi* | [**getAttributesAttributeId**](docs/Api/AttributesApi.md#getattributesattributeid) | **GET** /api/v2/attributes/{attributeId} | Get details about an existing attribute.
*AttributesApi* | [**postAttributes**](docs/Api/AttributesApi.md#postattributes) | **POST** /api/v2/attributes | Create an attribute.
*AttributesApi* | [**postAttributesQuery**](docs/Api/AttributesApi.md#postattributesquery) | **POST** /api/v2/attributes/query | Query attributes
*AttributesApi* | [**putAttributesAttributeId**](docs/Api/AttributesApi.md#putattributesattributeid) | **PUT** /api/v2/attributes/{attributeId} | Update an existing attribute.
*AuthorizationApi* | [**deleteAuthorizationRolesRoleId**](docs/Api/AuthorizationApi.md#deleteauthorizationrolesroleid) | **DELETE** /api/v2/authorization/roles/{roleId} | Delete an organization role.
*AuthorizationApi* | [**deleteUsersUserIdRoles**](docs/Api/AuthorizationApi.md#deleteusersuseridroles) | **DELETE** /api/v2/users/{userId}/roles | Removes all the roles from the user.
*AuthorizationApi* | [**getAuthorizationPermissions**](docs/Api/AuthorizationApi.md#getauthorizationpermissions) | **GET** /api/v2/authorization/permissions | Get all permissions.
*AuthorizationApi* | [**getAuthorizationProducts**](docs/Api/AuthorizationApi.md#getauthorizationproducts) | **GET** /api/v2/authorization/products | Get the list of enabled products
*AuthorizationApi* | [**getAuthorizationRoles**](docs/Api/AuthorizationApi.md#getauthorizationroles) | **GET** /api/v2/authorization/roles | Retrieve a list of all roles defined for the organization
*AuthorizationApi* | [**getAuthorizationRolesLeftroleIdComparedefaultRightroleId**](docs/Api/AuthorizationApi.md#getauthorizationrolesleftroleidcomparedefaultrightroleid) | **GET** /api/v2/authorization/roles/{leftRoleId}/comparedefault/{rightRoleId} | Get an org role to default role comparison comparison
*AuthorizationApi* | [**getAuthorizationRolesRoleId**](docs/Api/AuthorizationApi.md#getauthorizationrolesroleid) | **GET** /api/v2/authorization/roles/{roleId} | Get a single organization role.
*AuthorizationApi* | [**getUsersUserIdRoles**](docs/Api/AuthorizationApi.md#getusersuseridroles) | **GET** /api/v2/users/{userId}/roles | Returns a listing of roles and permissions for a user.
*AuthorizationApi* | [**patchAuthorizationRolesRoleId**](docs/Api/AuthorizationApi.md#patchauthorizationrolesroleid) | **PATCH** /api/v2/authorization/roles/{roleId} | Patch Organization Role for needsUpdate Field
*AuthorizationApi* | [**postAuthorizationRoles**](docs/Api/AuthorizationApi.md#postauthorizationroles) | **POST** /api/v2/authorization/roles | Create an organization role.
*AuthorizationApi* | [**postAuthorizationRolesDefault**](docs/Api/AuthorizationApi.md#postauthorizationrolesdefault) | **POST** /api/v2/authorization/roles/default | Restores all default roles
*AuthorizationApi* | [**postAuthorizationRolesLeftroleIdComparedefaultRightroleId**](docs/Api/AuthorizationApi.md#postauthorizationrolesleftroleidcomparedefaultrightroleid) | **POST** /api/v2/authorization/roles/{leftRoleId}/comparedefault/{rightRoleId} | Get an unsaved org role to default role comparison
*AuthorizationApi* | [**putAuthorizationRolesDefault**](docs/Api/AuthorizationApi.md#putauthorizationrolesdefault) | **PUT** /api/v2/authorization/roles/default | Restore specified default roles
*AuthorizationApi* | [**putAuthorizationRolesRoleId**](docs/Api/AuthorizationApi.md#putauthorizationrolesroleid) | **PUT** /api/v2/authorization/roles/{roleId} | Update an organization role.
*AuthorizationApi* | [**putAuthorizationRolesRoleIdUsersAdd**](docs/Api/AuthorizationApi.md#putauthorizationrolesroleidusersadd) | **PUT** /api/v2/authorization/roles/{roleId}/users/add | Sets the users for the role
*AuthorizationApi* | [**putAuthorizationRolesRoleIdUsersRemove**](docs/Api/AuthorizationApi.md#putauthorizationrolesroleidusersremove) | **PUT** /api/v2/authorization/roles/{roleId}/users/remove | Removes the users from the role
*AuthorizationApi* | [**putUsersUserIdRoles**](docs/Api/AuthorizationApi.md#putusersuseridroles) | **PUT** /api/v2/users/{userId}/roles | Sets the user&#39;s roles
*ContentManagementApi* | [**deleteContentmanagementDocumentsDocumentId**](docs/Api/ContentManagementApi.md#deletecontentmanagementdocumentsdocumentid) | **DELETE** /api/v2/contentmanagement/documents/{documentId} | Delete a document.
*ContentManagementApi* | [**deleteContentmanagementSharesShareId**](docs/Api/ContentManagementApi.md#deletecontentmanagementsharesshareid) | **DELETE** /api/v2/contentmanagement/shares/{shareId} | Deletes an existing share.
*ContentManagementApi* | [**deleteContentmanagementStatusStatusId**](docs/Api/ContentManagementApi.md#deletecontentmanagementstatusstatusid) | **DELETE** /api/v2/contentmanagement/status/{statusId} | Cancel the command for this status
*ContentManagementApi* | [**deleteContentmanagementWorkspacesWorkspaceId**](docs/Api/ContentManagementApi.md#deletecontentmanagementworkspacesworkspaceid) | **DELETE** /api/v2/contentmanagement/workspaces/{workspaceId} | Delete a workspace
*ContentManagementApi* | [**deleteContentmanagementWorkspacesWorkspaceIdMembersMemberId**](docs/Api/ContentManagementApi.md#deletecontentmanagementworkspacesworkspaceidmembersmemberid) | **DELETE** /api/v2/contentmanagement/workspaces/{workspaceId}/members/{memberId} | Delete a member from a workspace
*ContentManagementApi* | [**deleteContentmanagementWorkspacesWorkspaceIdTagvaluesTagId**](docs/Api/ContentManagementApi.md#deletecontentmanagementworkspacesworkspaceidtagvaluestagid) | **DELETE** /api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues/{tagId} | Delete workspace tag
*ContentManagementApi* | [**getContentmanagementDocuments**](docs/Api/ContentManagementApi.md#getcontentmanagementdocuments) | **GET** /api/v2/contentmanagement/documents | Get a list of documents.
*ContentManagementApi* | [**getContentmanagementDocumentsDocumentId**](docs/Api/ContentManagementApi.md#getcontentmanagementdocumentsdocumentid) | **GET** /api/v2/contentmanagement/documents/{documentId} | Get a document.
*ContentManagementApi* | [**getContentmanagementDocumentsDocumentIdAudits**](docs/Api/ContentManagementApi.md#getcontentmanagementdocumentsdocumentidaudits) | **GET** /api/v2/contentmanagement/documents/{documentId}/audits | Get a list of audits for a document.
*ContentManagementApi* | [**getContentmanagementDocumentsDocumentIdContent**](docs/Api/ContentManagementApi.md#getcontentmanagementdocumentsdocumentidcontent) | **GET** /api/v2/contentmanagement/documents/{documentId}/content | Download a document.
*ContentManagementApi* | [**getContentmanagementQuery**](docs/Api/ContentManagementApi.md#getcontentmanagementquery) | **GET** /api/v2/contentmanagement/query | Query content
*ContentManagementApi* | [**getContentmanagementSecurityprofiles**](docs/Api/ContentManagementApi.md#getcontentmanagementsecurityprofiles) | **GET** /api/v2/contentmanagement/securityprofiles | Get a List of Security Profiles
*ContentManagementApi* | [**getContentmanagementSecurityprofilesSecurityprofileId**](docs/Api/ContentManagementApi.md#getcontentmanagementsecurityprofilessecurityprofileid) | **GET** /api/v2/contentmanagement/securityprofiles/{securityProfileId} | Get a Security Profile
*ContentManagementApi* | [**getContentmanagementSharedSharedId**](docs/Api/ContentManagementApi.md#getcontentmanagementsharedsharedid) | **GET** /api/v2/contentmanagement/shared/{sharedId} | Get shared documents. Securely download a shared document.
*ContentManagementApi* | [**getContentmanagementShares**](docs/Api/ContentManagementApi.md#getcontentmanagementshares) | **GET** /api/v2/contentmanagement/shares | Gets a list of shares.  You must specify at least one filter (e.g. entityId).
*ContentManagementApi* | [**getContentmanagementSharesShareId**](docs/Api/ContentManagementApi.md#getcontentmanagementsharesshareid) | **GET** /api/v2/contentmanagement/shares/{shareId} | Retrieve details about an existing share.
*ContentManagementApi* | [**getContentmanagementStatus**](docs/Api/ContentManagementApi.md#getcontentmanagementstatus) | **GET** /api/v2/contentmanagement/status | Get a list of statuses for pending operations
*ContentManagementApi* | [**getContentmanagementStatusStatusId**](docs/Api/ContentManagementApi.md#getcontentmanagementstatusstatusid) | **GET** /api/v2/contentmanagement/status/{statusId} | Get a status.
*ContentManagementApi* | [**getContentmanagementUsage**](docs/Api/ContentManagementApi.md#getcontentmanagementusage) | **GET** /api/v2/contentmanagement/usage | Get usage details.
*ContentManagementApi* | [**getContentmanagementWorkspaces**](docs/Api/ContentManagementApi.md#getcontentmanagementworkspaces) | **GET** /api/v2/contentmanagement/workspaces | Get a list of workspaces.
*ContentManagementApi* | [**getContentmanagementWorkspacesWorkspaceId**](docs/Api/ContentManagementApi.md#getcontentmanagementworkspacesworkspaceid) | **GET** /api/v2/contentmanagement/workspaces/{workspaceId} | Get a workspace.
*ContentManagementApi* | [**getContentmanagementWorkspacesWorkspaceIdDocuments**](docs/Api/ContentManagementApi.md#getcontentmanagementworkspacesworkspaceiddocuments) | **GET** /api/v2/contentmanagement/workspaces/{workspaceId}/documents | Get a list of documents.
*ContentManagementApi* | [**getContentmanagementWorkspacesWorkspaceIdMembers**](docs/Api/ContentManagementApi.md#getcontentmanagementworkspacesworkspaceidmembers) | **GET** /api/v2/contentmanagement/workspaces/{workspaceId}/members | Get a list workspace members
*ContentManagementApi* | [**getContentmanagementWorkspacesWorkspaceIdMembersMemberId**](docs/Api/ContentManagementApi.md#getcontentmanagementworkspacesworkspaceidmembersmemberid) | **GET** /api/v2/contentmanagement/workspaces/{workspaceId}/members/{memberId} | Get a workspace member
*ContentManagementApi* | [**getContentmanagementWorkspacesWorkspaceIdTagvalues**](docs/Api/ContentManagementApi.md#getcontentmanagementworkspacesworkspaceidtagvalues) | **GET** /api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues | Get a list of workspace tags
*ContentManagementApi* | [**getContentmanagementWorkspacesWorkspaceIdTagvaluesTagId**](docs/Api/ContentManagementApi.md#getcontentmanagementworkspacesworkspaceidtagvaluestagid) | **GET** /api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues/{tagId} | Get a workspace tag
*ContentManagementApi* | [**postContentmanagementAuditquery**](docs/Api/ContentManagementApi.md#postcontentmanagementauditquery) | **POST** /api/v2/contentmanagement/auditquery | Query audits
*ContentManagementApi* | [**postContentmanagementDocuments**](docs/Api/ContentManagementApi.md#postcontentmanagementdocuments) | **POST** /api/v2/contentmanagement/documents | Add a document.
*ContentManagementApi* | [**postContentmanagementDocumentsDocumentId**](docs/Api/ContentManagementApi.md#postcontentmanagementdocumentsdocumentid) | **POST** /api/v2/contentmanagement/documents/{documentId} | Update a document.
*ContentManagementApi* | [**postContentmanagementDocumentsDocumentIdContent**](docs/Api/ContentManagementApi.md#postcontentmanagementdocumentsdocumentidcontent) | **POST** /api/v2/contentmanagement/documents/{documentId}/content | Replace the contents of a document.
*ContentManagementApi* | [**postContentmanagementQuery**](docs/Api/ContentManagementApi.md#postcontentmanagementquery) | **POST** /api/v2/contentmanagement/query | Query content
*ContentManagementApi* | [**postContentmanagementShares**](docs/Api/ContentManagementApi.md#postcontentmanagementshares) | **POST** /api/v2/contentmanagement/shares | Creates a new share or updates an existing share if the entity has already been shared
*ContentManagementApi* | [**postContentmanagementWorkspaces**](docs/Api/ContentManagementApi.md#postcontentmanagementworkspaces) | **POST** /api/v2/contentmanagement/workspaces | Create a group workspace
*ContentManagementApi* | [**postContentmanagementWorkspacesWorkspaceIdTagvalues**](docs/Api/ContentManagementApi.md#postcontentmanagementworkspacesworkspaceidtagvalues) | **POST** /api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues | Create a workspace tag
*ContentManagementApi* | [**postContentmanagementWorkspacesWorkspaceIdTagvaluesQuery**](docs/Api/ContentManagementApi.md#postcontentmanagementworkspacesworkspaceidtagvaluesquery) | **POST** /api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues/query | Perform a prefix query on tags in the workspace
*ContentManagementApi* | [**putContentmanagementWorkspacesWorkspaceId**](docs/Api/ContentManagementApi.md#putcontentmanagementworkspacesworkspaceid) | **PUT** /api/v2/contentmanagement/workspaces/{workspaceId} | Update a workspace
*ContentManagementApi* | [**putContentmanagementWorkspacesWorkspaceIdMembersMemberId**](docs/Api/ContentManagementApi.md#putcontentmanagementworkspacesworkspaceidmembersmemberid) | **PUT** /api/v2/contentmanagement/workspaces/{workspaceId}/members/{memberId} | Add a member to a workspace
*ContentManagementApi* | [**putContentmanagementWorkspacesWorkspaceIdTagvaluesTagId**](docs/Api/ContentManagementApi.md#putcontentmanagementworkspacesworkspaceidtagvaluestagid) | **PUT** /api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues/{tagId} | Update a workspace tag. Will update all documents with the new tag value.
*ConversationsApi* | [**deleteConversationsCallsCallIdParticipantsParticipantIdConsult**](docs/Api/ConversationsApi.md#deleteconversationscallscallidparticipantsparticipantidconsult) | **DELETE** /api/v2/conversations/calls/{callId}/participants/{participantId}/consult | Cancel the transfer
*ConversationsApi* | [**deleteConversationsConversationIdParticipantsParticipantIdCodesAddcommunicationcode**](docs/Api/ConversationsApi.md#deleteconversationsconversationidparticipantsparticipantidcodesaddcommunicationcode) | **DELETE** /api/v2/conversations/{conversationId}/participants/{participantId}/codes/{addCommunicationCode} | Delete a code used to add a communication to this participant
*ConversationsApi* | [**deleteConversationsEmailsEmailIdMessagesDraftAttachmentsAttachmentId**](docs/Api/ConversationsApi.md#deleteconversationsemailsemailidmessagesdraftattachmentsattachmentid) | **DELETE** /api/v2/conversations/emails/{emailId}/messages/draft/attachments/{attachmentId} | Delete attachment from draft
*ConversationsApi* | [**getAnalyticsConversationsConversationIdDetails**](docs/Api/ConversationsApi.md#getanalyticsconversationsconversationiddetails) | **GET** /api/v2/analytics/conversations/{conversationId}/details | Get a conversation by id
*ConversationsApi* | [**getConversations**](docs/Api/ConversationsApi.md#getconversations) | **GET** /api/v2/conversations | Get conversations
*ConversationsApi* | [**getConversationsCallbacks**](docs/Api/ConversationsApi.md#getconversationscallbacks) | **GET** /api/v2/conversations/callbacks | Get callback conversations
*ConversationsApi* | [**getConversationsCallbacksCallbackId**](docs/Api/ConversationsApi.md#getconversationscallbackscallbackid) | **GET** /api/v2/conversations/callbacks/{callbackId} | Get callback conversation
*ConversationsApi* | [**getConversationsCallbacksCallbackIdParticipantsParticipantIdWrapup**](docs/Api/ConversationsApi.md#getconversationscallbackscallbackidparticipantsparticipantidwrapup) | **GET** /api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/wrapup | Get the wrap-up for this conversation participant.
*ConversationsApi* | [**getConversationsCallbacksCallbackIdParticipantsParticipantIdWrapupcodes**](docs/Api/ConversationsApi.md#getconversationscallbackscallbackidparticipantsparticipantidwrapupcodes) | **GET** /api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/wrapupcodes | Get list of wrapup codes for this conversation participant
*ConversationsApi* | [**getConversationsCalls**](docs/Api/ConversationsApi.md#getconversationscalls) | **GET** /api/v2/conversations/calls | Get recent conversations
*ConversationsApi* | [**getConversationsCallsCallId**](docs/Api/ConversationsApi.md#getconversationscallscallid) | **GET** /api/v2/conversations/calls/{callId} | Get call conversation
*ConversationsApi* | [**getConversationsCallsCallIdParticipantsParticipantIdWrapup**](docs/Api/ConversationsApi.md#getconversationscallscallidparticipantsparticipantidwrapup) | **GET** /api/v2/conversations/calls/{callId}/participants/{participantId}/wrapup | Get the wrap-up for this conversation participant.
*ConversationsApi* | [**getConversationsCallsCallIdParticipantsParticipantIdWrapupcodes**](docs/Api/ConversationsApi.md#getconversationscallscallidparticipantsparticipantidwrapupcodes) | **GET** /api/v2/conversations/calls/{callId}/participants/{participantId}/wrapupcodes | Get list of wrapup codes for this conversation participant
*ConversationsApi* | [**getConversationsCallsHistory**](docs/Api/ConversationsApi.md#getconversationscallshistory) | **GET** /api/v2/conversations/calls/history | Get call history
*ConversationsApi* | [**getConversationsCallsMaximumconferenceparties**](docs/Api/ConversationsApi.md#getconversationscallsmaximumconferenceparties) | **GET** /api/v2/conversations/calls/maximumconferenceparties | Get the maximum number of participants that this user can have on a conference
*ConversationsApi* | [**getConversationsChats**](docs/Api/ConversationsApi.md#getconversationschats) | **GET** /api/v2/conversations/chats | Get recent chat conversations
*ConversationsApi* | [**getConversationsChatsChatId**](docs/Api/ConversationsApi.md#getconversationschatschatid) | **GET** /api/v2/conversations/chats/{chatId} | Get chat conversation
*ConversationsApi* | [**getConversationsChatsChatIdParticipantsParticipantIdWrapup**](docs/Api/ConversationsApi.md#getconversationschatschatidparticipantsparticipantidwrapup) | **GET** /api/v2/conversations/chats/{chatId}/participants/{participantId}/wrapup | Get the wrap-up for this conversation participant.
*ConversationsApi* | [**getConversationsChatsChatIdParticipantsParticipantIdWrapupcodes**](docs/Api/ConversationsApi.md#getconversationschatschatidparticipantsparticipantidwrapupcodes) | **GET** /api/v2/conversations/chats/{chatId}/participants/{participantId}/wrapupcodes | Get list of wrapup codes for this conversation participant
*ConversationsApi* | [**getConversationsCobrowsesessions**](docs/Api/ConversationsApi.md#getconversationscobrowsesessions) | **GET** /api/v2/conversations/cobrowsesessions | Get recent cobrowse conversations
*ConversationsApi* | [**getConversationsCobrowsesessionsCobrowseId**](docs/Api/ConversationsApi.md#getconversationscobrowsesessionscobrowseid) | **GET** /api/v2/conversations/cobrowsesessions/{cobrowseId} | Get cobrowse conversation
*ConversationsApi* | [**getConversationsCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapup**](docs/Api/ConversationsApi.md#getconversationscobrowsesessionscobrowseidparticipantsparticipantidwrapup) | **GET** /api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/wrapup | Get the wrap-up for this conversation participant.
*ConversationsApi* | [**getConversationsCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapupcodes**](docs/Api/ConversationsApi.md#getconversationscobrowsesessionscobrowseidparticipantsparticipantidwrapupcodes) | **GET** /api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/wrapupcodes | Get list of wrapup codes for this conversation participant
*ConversationsApi* | [**getConversationsConversationId**](docs/Api/ConversationsApi.md#getconversationsconversationid) | **GET** /api/v2/conversations/{conversationId} | Get conversation
*ConversationsApi* | [**getConversationsConversationIdParticipantsParticipantIdWrapup**](docs/Api/ConversationsApi.md#getconversationsconversationidparticipantsparticipantidwrapup) | **GET** /api/v2/conversations/{conversationId}/participants/{participantId}/wrapup | Get the wrap-up for this conversation participant.
*ConversationsApi* | [**getConversationsConversationIdParticipantsParticipantIdWrapupcodes**](docs/Api/ConversationsApi.md#getconversationsconversationidparticipantsparticipantidwrapupcodes) | **GET** /api/v2/conversations/{conversationId}/participants/{participantId}/wrapupcodes | Get list of wrapup codes for this conversation participant
*ConversationsApi* | [**getConversationsEmails**](docs/Api/ConversationsApi.md#getconversationsemails) | **GET** /api/v2/conversations/emails | Get recent email conversations
*ConversationsApi* | [**getConversationsEmailsEmailId**](docs/Api/ConversationsApi.md#getconversationsemailsemailid) | **GET** /api/v2/conversations/emails/{emailId} | Get email conversation
*ConversationsApi* | [**getConversationsEmailsEmailIdMessages**](docs/Api/ConversationsApi.md#getconversationsemailsemailidmessages) | **GET** /api/v2/conversations/emails/{emailId}/messages | Get conversation messages
*ConversationsApi* | [**getConversationsEmailsEmailIdMessagesDraft**](docs/Api/ConversationsApi.md#getconversationsemailsemailidmessagesdraft) | **GET** /api/v2/conversations/emails/{emailId}/messages/draft | Get conversation draft reply
*ConversationsApi* | [**getConversationsEmailsEmailIdMessagesMessageId**](docs/Api/ConversationsApi.md#getconversationsemailsemailidmessagesmessageid) | **GET** /api/v2/conversations/emails/{emailId}/messages/{messageId} | Get conversation message
*ConversationsApi* | [**getConversationsEmailsEmailIdParticipantsParticipantIdWrapup**](docs/Api/ConversationsApi.md#getconversationsemailsemailidparticipantsparticipantidwrapup) | **GET** /api/v2/conversations/emails/{emailId}/participants/{participantId}/wrapup | Get the wrap-up for this conversation participant.
*ConversationsApi* | [**getConversationsEmailsEmailIdParticipantsParticipantIdWrapupcodes**](docs/Api/ConversationsApi.md#getconversationsemailsemailidparticipantsparticipantidwrapupcodes) | **GET** /api/v2/conversations/emails/{emailId}/participants/{participantId}/wrapupcodes | Get list of wrapup codes for this conversation participant
*ConversationsApi* | [**patchConversationsCallbacksCallbackId**](docs/Api/ConversationsApi.md#patchconversationscallbackscallbackid) | **PATCH** /api/v2/conversations/callbacks/{callbackId} | Update a conversation by disconnecting all of the participants
*ConversationsApi* | [**patchConversationsCallbacksCallbackIdParticipantsParticipantId**](docs/Api/ConversationsApi.md#patchconversationscallbackscallbackidparticipantsparticipantid) | **PATCH** /api/v2/conversations/callbacks/{callbackId}/participants/{participantId} | Update conversation participant
*ConversationsApi* | [**patchConversationsCallbacksCallbackIdParticipantsParticipantIdAttributes**](docs/Api/ConversationsApi.md#patchconversationscallbackscallbackidparticipantsparticipantidattributes) | **PATCH** /api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/attributes | Update the attributes on a conversation participant.
*ConversationsApi* | [**patchConversationsCallbacksCallbackIdParticipantsParticipantIdCommunicationsCommunicationId**](docs/Api/ConversationsApi.md#patchconversationscallbackscallbackidparticipantsparticipantidcommunicationscommunicationid) | **PATCH** /api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/communications/{communicationId} | Update conversation participant&#39;s communication by disconnecting it.
*ConversationsApi* | [**patchConversationsCallsCallId**](docs/Api/ConversationsApi.md#patchconversationscallscallid) | **PATCH** /api/v2/conversations/calls/{callId} | Update a conversation by setting it&#39;s recording state, merging in other conversations to create a conference, or disconnecting all of the participants
*ConversationsApi* | [**patchConversationsCallsCallIdParticipantsParticipantId**](docs/Api/ConversationsApi.md#patchconversationscallscallidparticipantsparticipantid) | **PATCH** /api/v2/conversations/calls/{callId}/participants/{participantId} | Update conversation participant
*ConversationsApi* | [**patchConversationsCallsCallIdParticipantsParticipantIdAttributes**](docs/Api/ConversationsApi.md#patchconversationscallscallidparticipantsparticipantidattributes) | **PATCH** /api/v2/conversations/calls/{callId}/participants/{participantId}/attributes | Update the attributes on a conversation participant.
*ConversationsApi* | [**patchConversationsCallsCallIdParticipantsParticipantIdCommunicationsCommunicationId**](docs/Api/ConversationsApi.md#patchconversationscallscallidparticipantsparticipantidcommunicationscommunicationid) | **PATCH** /api/v2/conversations/calls/{callId}/participants/{participantId}/communications/{communicationId} | Update conversation participant&#39;s communication by disconnecting it.
*ConversationsApi* | [**patchConversationsCallsCallIdParticipantsParticipantIdConsult**](docs/Api/ConversationsApi.md#patchconversationscallscallidparticipantsparticipantidconsult) | **PATCH** /api/v2/conversations/calls/{callId}/participants/{participantId}/consult | Change who can speak
*ConversationsApi* | [**patchConversationsChatsChatId**](docs/Api/ConversationsApi.md#patchconversationschatschatid) | **PATCH** /api/v2/conversations/chats/{chatId} | Update a conversation by disconnecting all of the participants
*ConversationsApi* | [**patchConversationsChatsChatIdParticipantsParticipantId**](docs/Api/ConversationsApi.md#patchconversationschatschatidparticipantsparticipantid) | **PATCH** /api/v2/conversations/chats/{chatId}/participants/{participantId} | Update conversation participant
*ConversationsApi* | [**patchConversationsChatsChatIdParticipantsParticipantIdAttributes**](docs/Api/ConversationsApi.md#patchconversationschatschatidparticipantsparticipantidattributes) | **PATCH** /api/v2/conversations/chats/{chatId}/participants/{participantId}/attributes | Update the attributes on a conversation participant.
*ConversationsApi* | [**patchConversationsChatsChatIdParticipantsParticipantIdCommunicationsCommunicationId**](docs/Api/ConversationsApi.md#patchconversationschatschatidparticipantsparticipantidcommunicationscommunicationid) | **PATCH** /api/v2/conversations/chats/{chatId}/participants/{participantId}/communications/{communicationId} | Update conversation participant&#39;s communication by disconnecting it.
*ConversationsApi* | [**patchConversationsCobrowsesessionsCobrowseId**](docs/Api/ConversationsApi.md#patchconversationscobrowsesessionscobrowseid) | **PATCH** /api/v2/conversations/cobrowsesessions/{cobrowseId} | Update a conversation by disconnecting all of the participants
*ConversationsApi* | [**patchConversationsCobrowsesessionsCobrowseIdParticipantsParticipantId**](docs/Api/ConversationsApi.md#patchconversationscobrowsesessionscobrowseidparticipantsparticipantid) | **PATCH** /api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId} | Update conversation participant
*ConversationsApi* | [**patchConversationsCobrowsesessionsCobrowseIdParticipantsParticipantIdAttributes**](docs/Api/ConversationsApi.md#patchconversationscobrowsesessionscobrowseidparticipantsparticipantidattributes) | **PATCH** /api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/attributes | Update the attributes on a conversation participant.
*ConversationsApi* | [**patchConversationsCobrowsesessionsCobrowseIdParticipantsParticipantIdCommunicationsCommunicationId**](docs/Api/ConversationsApi.md#patchconversationscobrowsesessionscobrowseidparticipantsparticipantidcommunicationscommunicationid) | **PATCH** /api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/communications/{communicationId} | Update conversation participant&#39;s communication by disconnecting it.
*ConversationsApi* | [**patchConversationsConversationIdParticipantsParticipantId**](docs/Api/ConversationsApi.md#patchconversationsconversationidparticipantsparticipantid) | **PATCH** /api/v2/conversations/{conversationId}/participants/{participantId} | Update a participant.
*ConversationsApi* | [**patchConversationsConversationIdParticipantsParticipantIdAttributes**](docs/Api/ConversationsApi.md#patchconversationsconversationidparticipantsparticipantidattributes) | **PATCH** /api/v2/conversations/{conversationId}/participants/{participantId}/attributes | Update the attributes on a conversation participant.
*ConversationsApi* | [**patchConversationsEmailsEmailId**](docs/Api/ConversationsApi.md#patchconversationsemailsemailid) | **PATCH** /api/v2/conversations/emails/{emailId} | Update a conversation by disconnecting all of the participants
*ConversationsApi* | [**patchConversationsEmailsEmailIdParticipantsParticipantId**](docs/Api/ConversationsApi.md#patchconversationsemailsemailidparticipantsparticipantid) | **PATCH** /api/v2/conversations/emails/{emailId}/participants/{participantId} | Update conversation participant
*ConversationsApi* | [**patchConversationsEmailsEmailIdParticipantsParticipantIdAttributes**](docs/Api/ConversationsApi.md#patchconversationsemailsemailidparticipantsparticipantidattributes) | **PATCH** /api/v2/conversations/emails/{emailId}/participants/{participantId}/attributes | Update the attributes on a conversation participant.
*ConversationsApi* | [**patchConversationsEmailsEmailIdParticipantsParticipantIdCommunicationsCommunicationId**](docs/Api/ConversationsApi.md#patchconversationsemailsemailidparticipantsparticipantidcommunicationscommunicationid) | **PATCH** /api/v2/conversations/emails/{emailId}/participants/{participantId}/communications/{communicationId} | Update conversation participant&#39;s communication by disconnecting it.
*ConversationsApi* | [**postAnalyticsConversationsAggregatesQuery**](docs/Api/ConversationsApi.md#postanalyticsconversationsaggregatesquery) | **POST** /api/v2/analytics/conversations/aggregates/query | Query for conversation aggregates
*ConversationsApi* | [**postAnalyticsConversationsConversationIdDetailsProperties**](docs/Api/ConversationsApi.md#postanalyticsconversationsconversationiddetailsproperties) | **POST** /api/v2/analytics/conversations/{conversationId}/details/properties | Index conversation properties
*ConversationsApi* | [**postAnalyticsConversationsDetailsQuery**](docs/Api/ConversationsApi.md#postanalyticsconversationsdetailsquery) | **POST** /api/v2/analytics/conversations/details/query | Query for conversation details
*ConversationsApi* | [**postConversationsCallbacks**](docs/Api/ConversationsApi.md#postconversationscallbacks) | **POST** /api/v2/conversations/callbacks | Create a Callback
*ConversationsApi* | [**postConversationsCallbacksCallbackIdParticipantsParticipantIdReplace**](docs/Api/ConversationsApi.md#postconversationscallbackscallbackidparticipantsparticipantidreplace) | **POST** /api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/replace | Replace this participant with the specified user and/or address
*ConversationsApi* | [**postConversationsCalls**](docs/Api/ConversationsApi.md#postconversationscalls) | **POST** /api/v2/conversations/calls | Create a call conversation
*ConversationsApi* | [**postConversationsCallsCallId**](docs/Api/ConversationsApi.md#postconversationscallscallid) | **POST** /api/v2/conversations/calls/{callId} | Add a new call to a conversation
*ConversationsApi* | [**postConversationsCallsCallIdParticipants**](docs/Api/ConversationsApi.md#postconversationscallscallidparticipants) | **POST** /api/v2/conversations/calls/{callId}/participants | Add participants to a conversation
*ConversationsApi* | [**postConversationsCallsCallIdParticipantsParticipantIdConsult**](docs/Api/ConversationsApi.md#postconversationscallscallidparticipantsparticipantidconsult) | **POST** /api/v2/conversations/calls/{callId}/participants/{participantId}/consult | Initiate and update consult transfer
*ConversationsApi* | [**postConversationsCallsCallIdParticipantsParticipantIdMonitor**](docs/Api/ConversationsApi.md#postconversationscallscallidparticipantsparticipantidmonitor) | **POST** /api/v2/conversations/calls/{callId}/participants/{participantId}/monitor | Listen in on the conversation from the point of view of a given participant.
*ConversationsApi* | [**postConversationsCallsCallIdParticipantsParticipantIdReplace**](docs/Api/ConversationsApi.md#postconversationscallscallidparticipantsparticipantidreplace) | **POST** /api/v2/conversations/calls/{callId}/participants/{participantId}/replace | Replace this participant with the specified user and/or address
*ConversationsApi* | [**postConversationsChats**](docs/Api/ConversationsApi.md#postconversationschats) | **POST** /api/v2/conversations/chats | Create a web chat conversation
*ConversationsApi* | [**postConversationsChatsChatIdParticipantsParticipantIdReplace**](docs/Api/ConversationsApi.md#postconversationschatschatidparticipantsparticipantidreplace) | **POST** /api/v2/conversations/chats/{chatId}/participants/{participantId}/replace | Replace this participant with the specified user and/or address
*ConversationsApi* | [**postConversationsCobrowsesessionsCobrowseIdParticipantsParticipantIdReplace**](docs/Api/ConversationsApi.md#postconversationscobrowsesessionscobrowseidparticipantsparticipantidreplace) | **POST** /api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/replace | Replace this participant with the specified user and/or address
*ConversationsApi* | [**postConversationsConversationIdParticipantsParticipantIdCallbacks**](docs/Api/ConversationsApi.md#postconversationsconversationidparticipantsparticipantidcallbacks) | **POST** /api/v2/conversations/{conversationId}/participants/{participantId}/callbacks | Create a new callback for the specified participant on the conversation.
*ConversationsApi* | [**postConversationsConversationIdParticipantsParticipantIdReplace**](docs/Api/ConversationsApi.md#postconversationsconversationidparticipantsparticipantidreplace) | **POST** /api/v2/conversations/{conversationId}/participants/{participantId}/replace | Replace this participant with the specified user and/or address
*ConversationsApi* | [**postConversationsEmails**](docs/Api/ConversationsApi.md#postconversationsemails) | **POST** /api/v2/conversations/emails | Create an email conversation
*ConversationsApi* | [**postConversationsEmailsEmailIdMessages**](docs/Api/ConversationsApi.md#postconversationsemailsemailidmessages) | **POST** /api/v2/conversations/emails/{emailId}/messages | Send an email reply
*ConversationsApi* | [**postConversationsEmailsEmailIdParticipantsParticipantIdReplace**](docs/Api/ConversationsApi.md#postconversationsemailsemailidparticipantsparticipantidreplace) | **POST** /api/v2/conversations/emails/{emailId}/participants/{participantId}/replace | Replace this participant with the specified user and/or address
*ConversationsApi* | [**postConversationsFaxes**](docs/Api/ConversationsApi.md#postconversationsfaxes) | **POST** /api/v2/conversations/faxes | Create Fax Conversation
*ConversationsApi* | [**putConversationsEmailsEmailIdMessagesDraft**](docs/Api/ConversationsApi.md#putconversationsemailsemailidmessagesdraft) | **PUT** /api/v2/conversations/emails/{emailId}/messages/draft | Update conversation draft reply
*FaxApi* | [**deleteFaxDocumentsDocumentId**](docs/Api/FaxApi.md#deletefaxdocumentsdocumentid) | **DELETE** /api/v2/fax/documents/{documentId} | Delete a fax document.
*FaxApi* | [**getFaxDocuments**](docs/Api/FaxApi.md#getfaxdocuments) | **GET** /api/v2/fax/documents | Get a list of fax documents.
*FaxApi* | [**getFaxDocumentsDocumentId**](docs/Api/FaxApi.md#getfaxdocumentsdocumentid) | **GET** /api/v2/fax/documents/{documentId} | Get a document.
*FaxApi* | [**getFaxDocumentsDocumentIdContent**](docs/Api/FaxApi.md#getfaxdocumentsdocumentidcontent) | **GET** /api/v2/fax/documents/{documentId}/content | Download a fax document.
*FaxApi* | [**getFaxSummary**](docs/Api/FaxApi.md#getfaxsummary) | **GET** /api/v2/fax/summary | Get fax summary
*FaxApi* | [**putFaxDocumentsDocumentId**](docs/Api/FaxApi.md#putfaxdocumentsdocumentid) | **PUT** /api/v2/fax/documents/{documentId} | Update a fax document.
*GeolocationApi* | [**getGeolocationsSettings**](docs/Api/GeolocationApi.md#getgeolocationssettings) | **GET** /api/v2/geolocations/settings | Get a organization&#39;s GeolocationSettings
*GeolocationApi* | [**getUsersUserIdGeolocationsClientId**](docs/Api/GeolocationApi.md#getusersuseridgeolocationsclientid) | **GET** /api/v2/users/{userId}/geolocations/{clientId} | Get a user&#39;s Geolocation
*GeolocationApi* | [**patchGeolocationsSettings**](docs/Api/GeolocationApi.md#patchgeolocationssettings) | **PATCH** /api/v2/geolocations/settings | Patch a organization&#39;s GeolocationSettings
*GeolocationApi* | [**patchUsersUserIdGeolocationsClientId**](docs/Api/GeolocationApi.md#patchusersuseridgeolocationsclientid) | **PATCH** /api/v2/users/{userId}/geolocations/{clientId} | Patch a user&#39;s Geolocation
*GreetingsApi* | [**deleteGreetingsGreetingId**](docs/Api/GreetingsApi.md#deletegreetingsgreetingid) | **DELETE** /api/v2/greetings/{greetingId} | Deletes a Greeting with the given GreetingId
*GreetingsApi* | [**getGreetings**](docs/Api/GreetingsApi.md#getgreetings) | **GET** /api/v2/greetings | Gets an Organization&#39;s Greetings
*GreetingsApi* | [**getGreetingsDefaults**](docs/Api/GreetingsApi.md#getgreetingsdefaults) | **GET** /api/v2/greetings/defaults | Get an Organization&#39;s DefaultGreetingList
*GreetingsApi* | [**getGreetingsGreetingId**](docs/Api/GreetingsApi.md#getgreetingsgreetingid) | **GET** /api/v2/greetings/{greetingId} | Get a Greeting with the given GreetingId
*GreetingsApi* | [**getGreetingsGreetingIdMedia**](docs/Api/GreetingsApi.md#getgreetingsgreetingidmedia) | **GET** /api/v2/greetings/{greetingId}/media | Get media playback URI for this greeting
*GreetingsApi* | [**getGroupsGroupIdGreetings**](docs/Api/GreetingsApi.md#getgroupsgroupidgreetings) | **GET** /api/v2/groups/{groupId}/greetings | Get a list of the Group&#39;s Greetings
*GreetingsApi* | [**getGroupsGroupIdGreetingsDefaults**](docs/Api/GreetingsApi.md#getgroupsgroupidgreetingsdefaults) | **GET** /api/v2/groups/{groupId}/greetings/defaults | Grabs the list of Default Greetings given a Group&#39;s ID
*GreetingsApi* | [**getUsersUserIdGreetings**](docs/Api/GreetingsApi.md#getusersuseridgreetings) | **GET** /api/v2/users/{userId}/greetings | Get a list of the User&#39;s Greetings
*GreetingsApi* | [**getUsersUserIdGreetingsDefaults**](docs/Api/GreetingsApi.md#getusersuseridgreetingsdefaults) | **GET** /api/v2/users/{userId}/greetings/defaults | Grabs the list of Default Greetings given a User&#39;s ID
*GreetingsApi* | [**postGreetings**](docs/Api/GreetingsApi.md#postgreetings) | **POST** /api/v2/greetings | Create a Greeting for an Organization
*GreetingsApi* | [**postGroupsGroupIdGreetings**](docs/Api/GreetingsApi.md#postgroupsgroupidgreetings) | **POST** /api/v2/groups/{groupId}/greetings | Creates a Greeting for a Group
*GreetingsApi* | [**postUsersUserIdGreetings**](docs/Api/GreetingsApi.md#postusersuseridgreetings) | **POST** /api/v2/users/{userId}/greetings | Creates a Greeting for a User
*GreetingsApi* | [**putGreetingsDefaults**](docs/Api/GreetingsApi.md#putgreetingsdefaults) | **PUT** /api/v2/greetings/defaults | Update an Organization&#39;s DefaultGreetingList
*GreetingsApi* | [**putGreetingsGreetingId**](docs/Api/GreetingsApi.md#putgreetingsgreetingid) | **PUT** /api/v2/greetings/{greetingId} | Updates the Greeting with the given GreetingId
*GreetingsApi* | [**putGroupsGroupIdGreetingsDefaults**](docs/Api/GreetingsApi.md#putgroupsgroupidgreetingsdefaults) | **PUT** /api/v2/groups/{groupId}/greetings/defaults | Updates the DefaultGreetingList of the specified Group
*GreetingsApi* | [**putUsersUserIdGreetingsDefaults**](docs/Api/GreetingsApi.md#putusersuseridgreetingsdefaults) | **PUT** /api/v2/users/{userId}/greetings/defaults | Updates the DefaultGreetingList of the specified User
*GroupsApi* | [**deleteGroupsGroupId**](docs/Api/GroupsApi.md#deletegroupsgroupid) | **DELETE** /api/v2/groups/{groupId} | Delete group
*GroupsApi* | [**deleteGroupsGroupIdMembers**](docs/Api/GroupsApi.md#deletegroupsgroupidmembers) | **DELETE** /api/v2/groups/{groupId}/members | Remove members
*GroupsApi* | [**getFieldconfig**](docs/Api/GroupsApi.md#getfieldconfig) | **GET** /api/v2/fieldconfig | Fetch field config for an entity type
*GroupsApi* | [**getGroups**](docs/Api/GroupsApi.md#getgroups) | **GET** /api/v2/groups | Get a group list
*GroupsApi* | [**getGroupsGroupId**](docs/Api/GroupsApi.md#getgroupsgroupid) | **GET** /api/v2/groups/{groupId} | Get group
*GroupsApi* | [**getGroupsGroupIdMembers**](docs/Api/GroupsApi.md#getgroupsgroupidmembers) | **GET** /api/v2/groups/{groupId}/members | Get group members
*GroupsApi* | [**getGroupsSearch**](docs/Api/GroupsApi.md#getgroupssearch) | **GET** /api/v2/groups/search | Search groups using the q64 value returned from a previous search
*GroupsApi* | [**postGroups**](docs/Api/GroupsApi.md#postgroups) | **POST** /api/v2/groups | Create a group
*GroupsApi* | [**postGroupsGroupIdMembers**](docs/Api/GroupsApi.md#postgroupsgroupidmembers) | **POST** /api/v2/groups/{groupId}/members | Add members
*GroupsApi* | [**postGroupsSearch**](docs/Api/GroupsApi.md#postgroupssearch) | **POST** /api/v2/groups/search | Search groups
*GroupsApi* | [**putGroupsGroupId**](docs/Api/GroupsApi.md#putgroupsgroupid) | **PUT** /api/v2/groups/{groupId} | Update group
*IdentityProviderApi* | [**deleteIdentityprovidersAdfs**](docs/Api/IdentityProviderApi.md#deleteidentityprovidersadfs) | **DELETE** /api/v2/identityproviders/adfs | Delete ADFS Identity Provider
*IdentityProviderApi* | [**deleteIdentityprovidersCic**](docs/Api/IdentityProviderApi.md#deleteidentityproviderscic) | **DELETE** /api/v2/identityproviders/cic | Delete Customer Interaction Center (CIC) Identity Provider
*IdentityProviderApi* | [**deleteIdentityprovidersGsuite**](docs/Api/IdentityProviderApi.md#deleteidentityprovidersgsuite) | **DELETE** /api/v2/identityproviders/gsuite | Delete G Suite Identity Provider
*IdentityProviderApi* | [**deleteIdentityprovidersOkta**](docs/Api/IdentityProviderApi.md#deleteidentityprovidersokta) | **DELETE** /api/v2/identityproviders/okta | Delete Okta Identity Provider
*IdentityProviderApi* | [**deleteIdentityprovidersOnelogin**](docs/Api/IdentityProviderApi.md#deleteidentityprovidersonelogin) | **DELETE** /api/v2/identityproviders/onelogin | Delete OneLogin Identity Provider
*IdentityProviderApi* | [**deleteIdentityprovidersPing**](docs/Api/IdentityProviderApi.md#deleteidentityprovidersping) | **DELETE** /api/v2/identityproviders/ping | Delete Ping Identity Provider
*IdentityProviderApi* | [**deleteIdentityprovidersProviderId**](docs/Api/IdentityProviderApi.md#deleteidentityprovidersproviderid) | **DELETE** /api/v2/identityproviders/{providerId} | Delete an identity provider
*IdentityProviderApi* | [**deleteIdentityprovidersPurecloud**](docs/Api/IdentityProviderApi.md#deleteidentityproviderspurecloud) | **DELETE** /api/v2/identityproviders/purecloud | Delete PureCloud Identity Provider
*IdentityProviderApi* | [**deleteIdentityprovidersSalesforce**](docs/Api/IdentityProviderApi.md#deleteidentityproviderssalesforce) | **DELETE** /api/v2/identityproviders/salesforce | Delete Salesforce Identity Provider
*IdentityProviderApi* | [**getIdentityproviders**](docs/Api/IdentityProviderApi.md#getidentityproviders) | **GET** /api/v2/identityproviders | The list of identity providers
*IdentityProviderApi* | [**getIdentityprovidersAdfs**](docs/Api/IdentityProviderApi.md#getidentityprovidersadfs) | **GET** /api/v2/identityproviders/adfs | Get ADFS Identity Provider
*IdentityProviderApi* | [**getIdentityprovidersCic**](docs/Api/IdentityProviderApi.md#getidentityproviderscic) | **GET** /api/v2/identityproviders/cic | Get Customer Interaction Center (CIC) Identity Provider
*IdentityProviderApi* | [**getIdentityprovidersGsuite**](docs/Api/IdentityProviderApi.md#getidentityprovidersgsuite) | **GET** /api/v2/identityproviders/gsuite | Get G Suite Identity Provider
*IdentityProviderApi* | [**getIdentityprovidersOkta**](docs/Api/IdentityProviderApi.md#getidentityprovidersokta) | **GET** /api/v2/identityproviders/okta | Get Okta Identity Provider
*IdentityProviderApi* | [**getIdentityprovidersOnelogin**](docs/Api/IdentityProviderApi.md#getidentityprovidersonelogin) | **GET** /api/v2/identityproviders/onelogin | Get OneLogin Identity Provider
*IdentityProviderApi* | [**getIdentityprovidersPing**](docs/Api/IdentityProviderApi.md#getidentityprovidersping) | **GET** /api/v2/identityproviders/ping | Get Ping Identity Provider
*IdentityProviderApi* | [**getIdentityprovidersProviderId**](docs/Api/IdentityProviderApi.md#getidentityprovidersproviderid) | **GET** /api/v2/identityproviders/{providerId} | Get an identity provider
*IdentityProviderApi* | [**getIdentityprovidersPurecloud**](docs/Api/IdentityProviderApi.md#getidentityproviderspurecloud) | **GET** /api/v2/identityproviders/purecloud | Get PureCloud Identity Provider
*IdentityProviderApi* | [**getIdentityprovidersSalesforce**](docs/Api/IdentityProviderApi.md#getidentityproviderssalesforce) | **GET** /api/v2/identityproviders/salesforce | Get Salesforce Identity Provider
*IdentityProviderApi* | [**putIdentityprovidersAdfs**](docs/Api/IdentityProviderApi.md#putidentityprovidersadfs) | **PUT** /api/v2/identityproviders/adfs | Update/Create ADFS Identity Provider
*IdentityProviderApi* | [**putIdentityprovidersCic**](docs/Api/IdentityProviderApi.md#putidentityproviderscic) | **PUT** /api/v2/identityproviders/cic | Update/Create Customer Interaction Center (CIC) Identity Provider
*IdentityProviderApi* | [**putIdentityprovidersGsuite**](docs/Api/IdentityProviderApi.md#putidentityprovidersgsuite) | **PUT** /api/v2/identityproviders/gsuite | Update/Create G Suite Identity Provider
*IdentityProviderApi* | [**putIdentityprovidersOkta**](docs/Api/IdentityProviderApi.md#putidentityprovidersokta) | **PUT** /api/v2/identityproviders/okta | Update/Create Okta Identity Provider
*IdentityProviderApi* | [**putIdentityprovidersOnelogin**](docs/Api/IdentityProviderApi.md#putidentityprovidersonelogin) | **PUT** /api/v2/identityproviders/onelogin | Update/Create OneLogin Identity Provider
*IdentityProviderApi* | [**putIdentityprovidersPing**](docs/Api/IdentityProviderApi.md#putidentityprovidersping) | **PUT** /api/v2/identityproviders/ping | Update/Create Ping Identity Provider
*IdentityProviderApi* | [**putIdentityprovidersProviderId**](docs/Api/IdentityProviderApi.md#putidentityprovidersproviderid) | **PUT** /api/v2/identityproviders/{providerId} | Update an identity provider
*IdentityProviderApi* | [**putIdentityprovidersPurecloud**](docs/Api/IdentityProviderApi.md#putidentityproviderspurecloud) | **PUT** /api/v2/identityproviders/purecloud | Update/Create PureCloud Identity Provider
*IdentityProviderApi* | [**putIdentityprovidersSalesforce**](docs/Api/IdentityProviderApi.md#putidentityproviderssalesforce) | **PUT** /api/v2/identityproviders/salesforce | Update/Create Salesforce Identity Provider
*LanguagesApi* | [**deleteLanguagesLanguageId**](docs/Api/LanguagesApi.md#deletelanguageslanguageid) | **DELETE** /api/v2/languages/{languageId} | Delete Language (Deprecated)
*LanguagesApi* | [**deleteRoutingLanguagesLanguageId**](docs/Api/LanguagesApi.md#deleteroutinglanguageslanguageid) | **DELETE** /api/v2/routing/languages/{languageId} | Delete Language
*LanguagesApi* | [**getLanguages**](docs/Api/LanguagesApi.md#getlanguages) | **GET** /api/v2/languages | Get the list of supported languages. (Deprecated)
*LanguagesApi* | [**getLanguagesLanguageId**](docs/Api/LanguagesApi.md#getlanguageslanguageid) | **GET** /api/v2/languages/{languageId} | Get language (Deprecated)
*LanguagesApi* | [**getLanguagesTranslations**](docs/Api/LanguagesApi.md#getlanguagestranslations) | **GET** /api/v2/languages/translations | Get all available languages for translation
*LanguagesApi* | [**getLanguagesTranslationsBuiltin**](docs/Api/LanguagesApi.md#getlanguagestranslationsbuiltin) | **GET** /api/v2/languages/translations/builtin | Get the builtin translation for a language
*LanguagesApi* | [**getLanguagesTranslationsOrganization**](docs/Api/LanguagesApi.md#getlanguagestranslationsorganization) | **GET** /api/v2/languages/translations/organization | Get effective translation for an organization by language
*LanguagesApi* | [**getLanguagesTranslationsUsersUserId**](docs/Api/LanguagesApi.md#getlanguagestranslationsusersuserid) | **GET** /api/v2/languages/translations/users/{userId} | Get effective language translation for a user
*LanguagesApi* | [**getRoutingLanguagesLanguageId**](docs/Api/LanguagesApi.md#getroutinglanguageslanguageid) | **GET** /api/v2/routing/languages/{languageId} | Get language
*LanguagesApi* | [**postLanguages**](docs/Api/LanguagesApi.md#postlanguages) | **POST** /api/v2/languages | Create Language (Deprecated)
*LocationsApi* | [**getLocations**](docs/Api/LocationsApi.md#getlocations) | **GET** /api/v2/locations | Get a list of all locations.
*LocationsApi* | [**getLocationsLocationId**](docs/Api/LocationsApi.md#getlocationslocationid) | **GET** /api/v2/locations/{locationId} | Get Location by ID.
*LocationsApi* | [**getLocationsSearch**](docs/Api/LocationsApi.md#getlocationssearch) | **GET** /api/v2/locations/search | Search locations using the q64 value returned from a previous search
*LocationsApi* | [**postLocationsSearch**](docs/Api/LocationsApi.md#postlocationssearch) | **POST** /api/v2/locations/search | Search locations
*NotificationsApi* | [**deleteNotificationsChannelsChannelIdSubscriptions**](docs/Api/NotificationsApi.md#deletenotificationschannelschannelidsubscriptions) | **DELETE** /api/v2/notifications/channels/{channelId}/subscriptions | Remove all subscriptions
*NotificationsApi* | [**getNotificationsAvailabletopics**](docs/Api/NotificationsApi.md#getnotificationsavailabletopics) | **GET** /api/v2/notifications/availabletopics | Get available notification topics.
*NotificationsApi* | [**getNotificationsChannels**](docs/Api/NotificationsApi.md#getnotificationschannels) | **GET** /api/v2/notifications/channels | The list of existing channels
*NotificationsApi* | [**getNotificationsChannelsChannelIdSubscriptions**](docs/Api/NotificationsApi.md#getnotificationschannelschannelidsubscriptions) | **GET** /api/v2/notifications/channels/{channelId}/subscriptions | The list of all subscriptions for this channel
*NotificationsApi* | [**postNotificationsChannels**](docs/Api/NotificationsApi.md#postnotificationschannels) | **POST** /api/v2/notifications/channels | Create a new channel
*NotificationsApi* | [**postNotificationsChannelsChannelIdSubscriptions**](docs/Api/NotificationsApi.md#postnotificationschannelschannelidsubscriptions) | **POST** /api/v2/notifications/channels/{channelId}/subscriptions | Add a list of subscriptions to the existing list of subscriptions
*NotificationsApi* | [**putNotificationsChannelsChannelIdSubscriptions**](docs/Api/NotificationsApi.md#putnotificationschannelschannelidsubscriptions) | **PUT** /api/v2/notifications/channels/{channelId}/subscriptions | Replace the current list of subscriptions with a new list.
*OAuthApi* | [**deleteOauthClientsClientId**](docs/Api/OAuthApi.md#deleteoauthclientsclientid) | **DELETE** /api/v2/oauth/clients/{clientId} | Delete OAuth Client
*OAuthApi* | [**getOauthClients**](docs/Api/OAuthApi.md#getoauthclients) | **GET** /api/v2/oauth/clients | The list of OAuth clients
*OAuthApi* | [**getOauthClientsClientId**](docs/Api/OAuthApi.md#getoauthclientsclientid) | **GET** /api/v2/oauth/clients/{clientId} | Get OAuth Client
*OAuthApi* | [**postOauthClients**](docs/Api/OAuthApi.md#postoauthclients) | **POST** /api/v2/oauth/clients | Create OAuth client
*OAuthApi* | [**postOauthClientsClientIdSecret**](docs/Api/OAuthApi.md#postoauthclientsclientidsecret) | **POST** /api/v2/oauth/clients/{clientId}/secret | Regenerate Client Secret
*OAuthApi* | [**putOauthClientsClientId**](docs/Api/OAuthApi.md#putoauthclientsclientid) | **PUT** /api/v2/oauth/clients/{clientId} | Update OAuth Client
*OrganizationApi* | [**getFieldconfig**](docs/Api/OrganizationApi.md#getfieldconfig) | **GET** /api/v2/fieldconfig | Fetch field config for an entity type
*OrganizationApi* | [**getOrganizationsMe**](docs/Api/OrganizationApi.md#getorganizationsme) | **GET** /api/v2/organizations/me | Get organization.
*OrganizationApi* | [**patchOrganizationsFeaturesFeaturename**](docs/Api/OrganizationApi.md#patchorganizationsfeaturesfeaturename) | **PATCH** /api/v2/organizations/features/{featureName} | Update organization
*OutboundApi* | [**deleteOutboundAttemptlimitsAttemptlimitsId**](docs/Api/OutboundApi.md#deleteoutboundattemptlimitsattemptlimitsid) | **DELETE** /api/v2/outbound/attemptlimits/{attemptLimitsId} | Delete attempt limits
*OutboundApi* | [**deleteOutboundCallabletimesetsCallabletimesetId**](docs/Api/OutboundApi.md#deleteoutboundcallabletimesetscallabletimesetid) | **DELETE** /api/v2/outbound/callabletimesets/{callableTimeSetId} | Delete callable time set
*OutboundApi* | [**deleteOutboundCallanalysisresponsesetsCallanalysissetId**](docs/Api/OutboundApi.md#deleteoutboundcallanalysisresponsesetscallanalysissetid) | **DELETE** /api/v2/outbound/callanalysisresponsesets/{callAnalysisSetId} | Delete a dialer call analysis response set.
*OutboundApi* | [**deleteOutboundCampaignrulesCampaignruleId**](docs/Api/OutboundApi.md#deleteoutboundcampaignrulescampaignruleid) | **DELETE** /api/v2/outbound/campaignrules/{campaignRuleId} | Delete Campaign Rule
*OutboundApi* | [**deleteOutboundCampaignsCampaignId**](docs/Api/OutboundApi.md#deleteoutboundcampaignscampaignid) | **DELETE** /api/v2/outbound/campaigns/{campaignId} | Delete a campaign.
*OutboundApi* | [**deleteOutboundCampaignsCampaignIdProgress**](docs/Api/OutboundApi.md#deleteoutboundcampaignscampaignidprogress) | **DELETE** /api/v2/outbound/campaigns/{campaignId}/progress | Reset campaign progress and recycle the campaign
*OutboundApi* | [**deleteOutboundContactlistsContactlistId**](docs/Api/OutboundApi.md#deleteoutboundcontactlistscontactlistid) | **DELETE** /api/v2/outbound/contactlists/{contactListId} | Delete a contact list.
*OutboundApi* | [**deleteOutboundContactlistsContactlistIdContactsContactId**](docs/Api/OutboundApi.md#deleteoutboundcontactlistscontactlistidcontactscontactid) | **DELETE** /api/v2/outbound/contactlists/{contactListId}/contacts/{contactId} | Delete a contact.
*OutboundApi* | [**deleteOutboundDnclistsDnclistId**](docs/Api/OutboundApi.md#deleteoutbounddnclistsdnclistid) | **DELETE** /api/v2/outbound/dnclists/{dncListId} | Delete dialer DNC list
*OutboundApi* | [**deleteOutboundRulesetsRulesetId**](docs/Api/OutboundApi.md#deleteoutboundrulesetsrulesetid) | **DELETE** /api/v2/outbound/rulesets/{ruleSetId} | Delete a Rule set.
*OutboundApi* | [**deleteOutboundSchedulesCampaignsCampaignId**](docs/Api/OutboundApi.md#deleteoutboundschedulescampaignscampaignid) | **DELETE** /api/v2/outbound/schedules/campaigns/{campaignId} | Delete a dialer campaign schedule.
*OutboundApi* | [**deleteOutboundSchedulesSequencesSequenceId**](docs/Api/OutboundApi.md#deleteoutboundschedulessequencessequenceid) | **DELETE** /api/v2/outbound/schedules/sequences/{sequenceId} | Delete a dialer sequence schedule.
*OutboundApi* | [**deleteOutboundSequencesSequenceId**](docs/Api/OutboundApi.md#deleteoutboundsequencessequenceid) | **DELETE** /api/v2/outbound/sequences/{sequenceId} | Delete a dialer campaign sequence.
*OutboundApi* | [**getOutboundAttemptlimits**](docs/Api/OutboundApi.md#getoutboundattemptlimits) | **GET** /api/v2/outbound/attemptlimits | Query attempt limits list
*OutboundApi* | [**getOutboundAttemptlimitsAttemptlimitsId**](docs/Api/OutboundApi.md#getoutboundattemptlimitsattemptlimitsid) | **GET** /api/v2/outbound/attemptlimits/{attemptLimitsId} | Get attempt limits
*OutboundApi* | [**getOutboundCallabletimesets**](docs/Api/OutboundApi.md#getoutboundcallabletimesets) | **GET** /api/v2/outbound/callabletimesets | Query callable time set list
*OutboundApi* | [**getOutboundCallabletimesetsCallabletimesetId**](docs/Api/OutboundApi.md#getoutboundcallabletimesetscallabletimesetid) | **GET** /api/v2/outbound/callabletimesets/{callableTimeSetId} | Get callable time set
*OutboundApi* | [**getOutboundCallanalysisresponsesets**](docs/Api/OutboundApi.md#getoutboundcallanalysisresponsesets) | **GET** /api/v2/outbound/callanalysisresponsesets | Query a list of dialer call analysis response sets.
*OutboundApi* | [**getOutboundCallanalysisresponsesetsCallanalysissetId**](docs/Api/OutboundApi.md#getoutboundcallanalysisresponsesetscallanalysissetid) | **GET** /api/v2/outbound/callanalysisresponsesets/{callAnalysisSetId} | Get a dialer call analysis response set.
*OutboundApi* | [**getOutboundCampaignrules**](docs/Api/OutboundApi.md#getoutboundcampaignrules) | **GET** /api/v2/outbound/campaignrules | Query Campaign Rule list
*OutboundApi* | [**getOutboundCampaignrulesCampaignruleId**](docs/Api/OutboundApi.md#getoutboundcampaignrulescampaignruleid) | **GET** /api/v2/outbound/campaignrules/{campaignRuleId} | Get Campaign Rule
*OutboundApi* | [**getOutboundCampaigns**](docs/Api/OutboundApi.md#getoutboundcampaigns) | **GET** /api/v2/outbound/campaigns | Query a list of dialer campaigns.
*OutboundApi* | [**getOutboundCampaignsCampaignId**](docs/Api/OutboundApi.md#getoutboundcampaignscampaignid) | **GET** /api/v2/outbound/campaigns/{campaignId} | Get dialer campaign.
*OutboundApi* | [**getOutboundCampaignsCampaignIdDiagnostics**](docs/Api/OutboundApi.md#getoutboundcampaignscampaigniddiagnostics) | **GET** /api/v2/outbound/campaigns/{campaignId}/diagnostics | Get campaign diagnostics
*OutboundApi* | [**getOutboundCampaignsCampaignIdInteractions**](docs/Api/OutboundApi.md#getoutboundcampaignscampaignidinteractions) | **GET** /api/v2/outbound/campaigns/{campaignId}/interactions | Get dialer campaign interactions.
*OutboundApi* | [**getOutboundCampaignsCampaignIdProgress**](docs/Api/OutboundApi.md#getoutboundcampaignscampaignidprogress) | **GET** /api/v2/outbound/campaigns/{campaignId}/progress | Get campaign progress
*OutboundApi* | [**getOutboundCampaignsCampaignIdStats**](docs/Api/OutboundApi.md#getoutboundcampaignscampaignidstats) | **GET** /api/v2/outbound/campaigns/{campaignId}/stats | Get statistics about a Dialer Campaign
*OutboundApi* | [**getOutboundContactlists**](docs/Api/OutboundApi.md#getoutboundcontactlists) | **GET** /api/v2/outbound/contactlists | Query a list of contact lists.
*OutboundApi* | [**getOutboundContactlistsContactlistId**](docs/Api/OutboundApi.md#getoutboundcontactlistscontactlistid) | **GET** /api/v2/outbound/contactlists/{contactListId} | Get a dialer contact list.
*OutboundApi* | [**getOutboundContactlistsContactlistIdContactsContactId**](docs/Api/OutboundApi.md#getoutboundcontactlistscontactlistidcontactscontactid) | **GET** /api/v2/outbound/contactlists/{contactListId}/contacts/{contactId} | Get a contact.
*OutboundApi* | [**getOutboundContactlistsContactlistIdExport**](docs/Api/OutboundApi.md#getoutboundcontactlistscontactlistidexport) | **GET** /api/v2/outbound/contactlists/{contactListId}/export | Get the URI of a contact list export.
*OutboundApi* | [**getOutboundContactlistsContactlistIdImportstatus**](docs/Api/OutboundApi.md#getoutboundcontactlistscontactlistidimportstatus) | **GET** /api/v2/outbound/contactlists/{contactListId}/importstatus | Get dialer contactList import status.
*OutboundApi* | [**getOutboundDnclists**](docs/Api/OutboundApi.md#getoutbounddnclists) | **GET** /api/v2/outbound/dnclists | Query dialer DNC lists
*OutboundApi* | [**getOutboundDnclistsDnclistId**](docs/Api/OutboundApi.md#getoutbounddnclistsdnclistid) | **GET** /api/v2/outbound/dnclists/{dncListId} | Get dialer DNC list
*OutboundApi* | [**getOutboundDnclistsDnclistIdExport**](docs/Api/OutboundApi.md#getoutbounddnclistsdnclistidexport) | **GET** /api/v2/outbound/dnclists/{dncListId}/export | Get the URI of a DNC list export.
*OutboundApi* | [**getOutboundDnclistsDnclistIdImportstatus**](docs/Api/OutboundApi.md#getoutbounddnclistsdnclistidimportstatus) | **GET** /api/v2/outbound/dnclists/{dncListId}/importstatus | Get dialer dncList import status.
*OutboundApi* | [**getOutboundRulesets**](docs/Api/OutboundApi.md#getoutboundrulesets) | **GET** /api/v2/outbound/rulesets | Query a list of Rule Sets.
*OutboundApi* | [**getOutboundRulesetsRulesetId**](docs/Api/OutboundApi.md#getoutboundrulesetsrulesetid) | **GET** /api/v2/outbound/rulesets/{ruleSetId} | Get a Rule Set by ID.
*OutboundApi* | [**getOutboundSchedulesCampaigns**](docs/Api/OutboundApi.md#getoutboundschedulescampaigns) | **GET** /api/v2/outbound/schedules/campaigns | Query for a list of dialer campaign schedules.
*OutboundApi* | [**getOutboundSchedulesCampaignsCampaignId**](docs/Api/OutboundApi.md#getoutboundschedulescampaignscampaignid) | **GET** /api/v2/outbound/schedules/campaigns/{campaignId} | Get a dialer campaign schedule.
*OutboundApi* | [**getOutboundSchedulesSequences**](docs/Api/OutboundApi.md#getoutboundschedulessequences) | **GET** /api/v2/outbound/schedules/sequences | Query for a list of dialer sequence schedules.
*OutboundApi* | [**getOutboundSchedulesSequencesSequenceId**](docs/Api/OutboundApi.md#getoutboundschedulessequencessequenceid) | **GET** /api/v2/outbound/schedules/sequences/{sequenceId} | Get a dialer sequence schedule.
*OutboundApi* | [**getOutboundSequences**](docs/Api/OutboundApi.md#getoutboundsequences) | **GET** /api/v2/outbound/sequences | Query a list of dialer campaign sequences.
*OutboundApi* | [**getOutboundSequencesSequenceId**](docs/Api/OutboundApi.md#getoutboundsequencessequenceid) | **GET** /api/v2/outbound/sequences/{sequenceId} | Get a dialer campaign sequence.
*OutboundApi* | [**getOutboundWrapupcodemappings**](docs/Api/OutboundApi.md#getoutboundwrapupcodemappings) | **GET** /api/v2/outbound/wrapupcodemappings | Get the Dialer wrap up code mapping.
*OutboundApi* | [**postOutboundAttemptlimits**](docs/Api/OutboundApi.md#postoutboundattemptlimits) | **POST** /api/v2/outbound/attemptlimits | Create attempt limits
*OutboundApi* | [**postOutboundAudits**](docs/Api/OutboundApi.md#postoutboundaudits) | **POST** /api/v2/outbound/audits | Retrieves audits for dialer.
*OutboundApi* | [**postOutboundCallabletimesets**](docs/Api/OutboundApi.md#postoutboundcallabletimesets) | **POST** /api/v2/outbound/callabletimesets | Create callable time set
*OutboundApi* | [**postOutboundCallanalysisresponsesets**](docs/Api/OutboundApi.md#postoutboundcallanalysisresponsesets) | **POST** /api/v2/outbound/callanalysisresponsesets | Create a dialer call analysis response set.
*OutboundApi* | [**postOutboundCampaignrules**](docs/Api/OutboundApi.md#postoutboundcampaignrules) | **POST** /api/v2/outbound/campaignrules | Create Campaign Rule
*OutboundApi* | [**postOutboundCampaigns**](docs/Api/OutboundApi.md#postoutboundcampaigns) | **POST** /api/v2/outbound/campaigns | Create a campaign.
*OutboundApi* | [**postOutboundCampaignsCampaignIdCallbackSchedule**](docs/Api/OutboundApi.md#postoutboundcampaignscampaignidcallbackschedule) | **POST** /api/v2/outbound/campaigns/{campaignId}/callback/schedule | Schedule a Callback for a Dialer Campaign (Deprecated)
*OutboundApi* | [**postOutboundCampaignsProgress**](docs/Api/OutboundApi.md#postoutboundcampaignsprogress) | **POST** /api/v2/outbound/campaigns/progress | Get progress for a list of campaigns
*OutboundApi* | [**postOutboundContactlists**](docs/Api/OutboundApi.md#postoutboundcontactlists) | **POST** /api/v2/outbound/contactlists | Create a contact List.
*OutboundApi* | [**postOutboundContactlistsContactlistIdContacts**](docs/Api/OutboundApi.md#postoutboundcontactlistscontactlistidcontacts) | **POST** /api/v2/outbound/contactlists/{contactListId}/contacts | Add contacts to a contact list.
*OutboundApi* | [**postOutboundContactlistsContactlistIdExport**](docs/Api/OutboundApi.md#postoutboundcontactlistscontactlistidexport) | **POST** /api/v2/outbound/contactlists/{contactListId}/export | Initiate the export of a contact list.
*OutboundApi* | [**postOutboundConversationsConversationIdDnc**](docs/Api/OutboundApi.md#postoutboundconversationsconversationiddnc) | **POST** /api/v2/outbound/conversations/{conversationId}/dnc | Add phone numbers to a Dialer DNC list.
*OutboundApi* | [**postOutboundDnclists**](docs/Api/OutboundApi.md#postoutbounddnclists) | **POST** /api/v2/outbound/dnclists | Create dialer DNC list
*OutboundApi* | [**postOutboundDnclistsDnclistIdExport**](docs/Api/OutboundApi.md#postoutbounddnclistsdnclistidexport) | **POST** /api/v2/outbound/dnclists/{dncListId}/export | Initiate the export of a dnc list.
*OutboundApi* | [**postOutboundDnclistsDnclistIdPhonenumbers**](docs/Api/OutboundApi.md#postoutbounddnclistsdnclistidphonenumbers) | **POST** /api/v2/outbound/dnclists/{dncListId}/phonenumbers | Add phone numbers to a Dialer DNC list.
*OutboundApi* | [**postOutboundRulesets**](docs/Api/OutboundApi.md#postoutboundrulesets) | **POST** /api/v2/outbound/rulesets | Create a Dialer Call Analysis Response Set.
*OutboundApi* | [**postOutboundSequences**](docs/Api/OutboundApi.md#postoutboundsequences) | **POST** /api/v2/outbound/sequences | Create a new campaign sequence.
*OutboundApi* | [**putOutboundAttemptlimitsAttemptlimitsId**](docs/Api/OutboundApi.md#putoutboundattemptlimitsattemptlimitsid) | **PUT** /api/v2/outbound/attemptlimits/{attemptLimitsId} | Update attempt limits
*OutboundApi* | [**putOutboundCallabletimesetsCallabletimesetId**](docs/Api/OutboundApi.md#putoutboundcallabletimesetscallabletimesetid) | **PUT** /api/v2/outbound/callabletimesets/{callableTimeSetId} | Update callable time set
*OutboundApi* | [**putOutboundCallanalysisresponsesetsCallanalysissetId**](docs/Api/OutboundApi.md#putoutboundcallanalysisresponsesetscallanalysissetid) | **PUT** /api/v2/outbound/callanalysisresponsesets/{callAnalysisSetId} | Update a dialer call analysis response set.
*OutboundApi* | [**putOutboundCampaignrulesCampaignruleId**](docs/Api/OutboundApi.md#putoutboundcampaignrulescampaignruleid) | **PUT** /api/v2/outbound/campaignrules/{campaignRuleId} | Update Campaign Rule
*OutboundApi* | [**putOutboundCampaignsCampaignId**](docs/Api/OutboundApi.md#putoutboundcampaignscampaignid) | **PUT** /api/v2/outbound/campaigns/{campaignId} | Update a campaign.
*OutboundApi* | [**putOutboundCampaignsCampaignIdAgentsUserId**](docs/Api/OutboundApi.md#putoutboundcampaignscampaignidagentsuserid) | **PUT** /api/v2/outbound/campaigns/{campaignId}/agents/{userId} | Send notification that an agent&#39;s state changed
*OutboundApi* | [**putOutboundContactlistsContactlistId**](docs/Api/OutboundApi.md#putoutboundcontactlistscontactlistid) | **PUT** /api/v2/outbound/contactlists/{contactListId} | Update a contact list.
*OutboundApi* | [**putOutboundContactlistsContactlistIdContactsContactId**](docs/Api/OutboundApi.md#putoutboundcontactlistscontactlistidcontactscontactid) | **PUT** /api/v2/outbound/contactlists/{contactListId}/contacts/{contactId} | Update a contact.
*OutboundApi* | [**putOutboundDnclistsDnclistId**](docs/Api/OutboundApi.md#putoutbounddnclistsdnclistid) | **PUT** /api/v2/outbound/dnclists/{dncListId} | Update dialer DNC list
*OutboundApi* | [**putOutboundRulesetsRulesetId**](docs/Api/OutboundApi.md#putoutboundrulesetsrulesetid) | **PUT** /api/v2/outbound/rulesets/{ruleSetId} | Update a RuleSet.
*OutboundApi* | [**putOutboundSchedulesCampaignsCampaignId**](docs/Api/OutboundApi.md#putoutboundschedulescampaignscampaignid) | **PUT** /api/v2/outbound/schedules/campaigns/{campaignId} | Update a new campaign schedule.
*OutboundApi* | [**putOutboundSchedulesSequencesSequenceId**](docs/Api/OutboundApi.md#putoutboundschedulessequencessequenceid) | **PUT** /api/v2/outbound/schedules/sequences/{sequenceId} | Update a new sequence schedule.
*OutboundApi* | [**putOutboundSequencesSequenceId**](docs/Api/OutboundApi.md#putoutboundsequencessequenceid) | **PUT** /api/v2/outbound/sequences/{sequenceId} | Update a new campaign sequence.
*OutboundApi* | [**putOutboundWrapupcodemappings**](docs/Api/OutboundApi.md#putoutboundwrapupcodemappings) | **PUT** /api/v2/outbound/wrapupcodemappings | Update the Dialer wrap up code mapping.
*PresenceApi* | [**deletePresencedefinitionsPresenceId**](docs/Api/PresenceApi.md#deletepresencedefinitionspresenceid) | **DELETE** /api/v2/presencedefinitions/{presenceId} | Delete a Presence Definition
*PresenceApi* | [**getPresencedefinitions**](docs/Api/PresenceApi.md#getpresencedefinitions) | **GET** /api/v2/presencedefinitions | Get an Organization&#39;s list of Presence Definitions
*PresenceApi* | [**getPresencedefinitionsPresenceId**](docs/Api/PresenceApi.md#getpresencedefinitionspresenceid) | **GET** /api/v2/presencedefinitions/{presenceId} | Get a Presence Definition
*PresenceApi* | [**getSystempresences**](docs/Api/PresenceApi.md#getsystempresences) | **GET** /api/v2/systempresences | Get the list of SystemPresences
*PresenceApi* | [**getUsersUserIdPresencesSourceId**](docs/Api/PresenceApi.md#getusersuseridpresencessourceid) | **GET** /api/v2/users/{userId}/presences/{sourceId} | Get a user&#39;s Presence
*PresenceApi* | [**patchUsersUserIdPresencesSourceId**](docs/Api/PresenceApi.md#patchusersuseridpresencessourceid) | **PATCH** /api/v2/users/{userId}/presences/{sourceId} | Patch a user&#39;s Presence
*PresenceApi* | [**postPresencedefinitions**](docs/Api/PresenceApi.md#postpresencedefinitions) | **POST** /api/v2/presencedefinitions | Create a Presence Definition
*PresenceApi* | [**putPresencedefinitionsPresenceId**](docs/Api/PresenceApi.md#putpresencedefinitionspresenceid) | **PUT** /api/v2/presencedefinitions/{presenceId} | Update a Presence Definition
*QualityApi* | [**deleteQualityCalibrationsCalibrationId**](docs/Api/QualityApi.md#deletequalitycalibrationscalibrationid) | **DELETE** /api/v2/quality/calibrations/{calibrationId} | Delete a calibration by id.
*QualityApi* | [**deleteQualityConversationsConversationIdEvaluationsEvaluationId**](docs/Api/QualityApi.md#deletequalityconversationsconversationidevaluationsevaluationid) | **DELETE** /api/v2/quality/conversations/{conversationId}/evaluations/{evaluationId} | Delete an evaluation
*QualityApi* | [**deleteQualityFormsFormId**](docs/Api/QualityApi.md#deletequalityformsformid) | **DELETE** /api/v2/quality/forms/{formId} | Delete an evaluation form.
*QualityApi* | [**deleteQualityKeywordsets**](docs/Api/QualityApi.md#deletequalitykeywordsets) | **DELETE** /api/v2/quality/keywordsets | Delete keyword sets
*QualityApi* | [**deleteQualityKeywordsetsKeywordsetId**](docs/Api/QualityApi.md#deletequalitykeywordsetskeywordsetid) | **DELETE** /api/v2/quality/keywordsets/{keywordSetId} | Delete a keywordSet by id.
*QualityApi* | [**getQualityAgentsActivity**](docs/Api/QualityApi.md#getqualityagentsactivity) | **GET** /api/v2/quality/agents/activity | Gets a list of Agent Activities
*QualityApi* | [**getQualityCalibrations**](docs/Api/QualityApi.md#getqualitycalibrations) | **GET** /api/v2/quality/calibrations | Get the list of calibrations
*QualityApi* | [**getQualityCalibrationsCalibrationId**](docs/Api/QualityApi.md#getqualitycalibrationscalibrationid) | **GET** /api/v2/quality/calibrations/{calibrationId} | Get a calibration by id.
*QualityApi* | [**getQualityConversationsConversationIdAudits**](docs/Api/QualityApi.md#getqualityconversationsconversationidaudits) | **GET** /api/v2/quality/conversations/{conversationId}/audits | Get audits for conversation or recording
*QualityApi* | [**getQualityConversationsConversationIdEvaluationsEvaluationId**](docs/Api/QualityApi.md#getqualityconversationsconversationidevaluationsevaluationid) | **GET** /api/v2/quality/conversations/{conversationId}/evaluations/{evaluationId} | Get an evaluation
*QualityApi* | [**getQualityEvaluationsQuery**](docs/Api/QualityApi.md#getqualityevaluationsquery) | **GET** /api/v2/quality/evaluations/query | Queries Evaluations and returns a paged list
*QualityApi* | [**getQualityEvaluatorsActivity**](docs/Api/QualityApi.md#getqualityevaluatorsactivity) | **GET** /api/v2/quality/evaluators/activity | Get an evaluator activity
*QualityApi* | [**getQualityForms**](docs/Api/QualityApi.md#getqualityforms) | **GET** /api/v2/quality/forms | Get the list of evaluation forms
*QualityApi* | [**getQualityFormsFormId**](docs/Api/QualityApi.md#getqualityformsformid) | **GET** /api/v2/quality/forms/{formId} | Get an evaluation form
*QualityApi* | [**getQualityFormsFormIdVersions**](docs/Api/QualityApi.md#getqualityformsformidversions) | **GET** /api/v2/quality/forms/{formId}/versions | Gets all the revisions for a specific evaluation.
*QualityApi* | [**getQualityKeywordsets**](docs/Api/QualityApi.md#getqualitykeywordsets) | **GET** /api/v2/quality/keywordsets | Get the list of keyword sets
*QualityApi* | [**getQualityKeywordsetsKeywordsetId**](docs/Api/QualityApi.md#getqualitykeywordsetskeywordsetid) | **GET** /api/v2/quality/keywordsets/{keywordSetId} | Get a keywordSet by id.
*QualityApi* | [**getQualityPublishedforms**](docs/Api/QualityApi.md#getqualitypublishedforms) | **GET** /api/v2/quality/publishedforms | Get the published evaluation forms.
*QualityApi* | [**getQualityPublishedformsFormId**](docs/Api/QualityApi.md#getqualitypublishedformsformid) | **GET** /api/v2/quality/publishedforms/{formId} | Get the published evaluation forms.
*QualityApi* | [**postAnalyticsEvaluationsAggregatesQuery**](docs/Api/QualityApi.md#postanalyticsevaluationsaggregatesquery) | **POST** /api/v2/analytics/evaluations/aggregates/query | Query for evaluation aggregates
*QualityApi* | [**postQualityCalibrations**](docs/Api/QualityApi.md#postqualitycalibrations) | **POST** /api/v2/quality/calibrations | Create a calibration
*QualityApi* | [**postQualityConversationsConversationIdEvaluations**](docs/Api/QualityApi.md#postqualityconversationsconversationidevaluations) | **POST** /api/v2/quality/conversations/{conversationId}/evaluations | Create an evaluation
*QualityApi* | [**postQualityEvaluationsScoring**](docs/Api/QualityApi.md#postqualityevaluationsscoring) | **POST** /api/v2/quality/evaluations/scoring | Score evaluation
*QualityApi* | [**postQualityForms**](docs/Api/QualityApi.md#postqualityforms) | **POST** /api/v2/quality/forms | Create an evaluation form.
*QualityApi* | [**postQualityKeywordsets**](docs/Api/QualityApi.md#postqualitykeywordsets) | **POST** /api/v2/quality/keywordsets | Create a Keyword Set
*QualityApi* | [**postQualityPublishedforms**](docs/Api/QualityApi.md#postqualitypublishedforms) | **POST** /api/v2/quality/publishedforms | Publish an evaluation form.
*QualityApi* | [**postQualitySpotability**](docs/Api/QualityApi.md#postqualityspotability) | **POST** /api/v2/quality/spotability | Retrieve the spotability statistic
*QualityApi* | [**putQualityCalibrationsCalibrationId**](docs/Api/QualityApi.md#putqualitycalibrationscalibrationid) | **PUT** /api/v2/quality/calibrations/{calibrationId} | Update a calibration to the specified calibration via PUT.  Editable fields include: evaluators, expertEvaluator, and scoringIndex
*QualityApi* | [**putQualityConversationsConversationIdEvaluationsEvaluationId**](docs/Api/QualityApi.md#putqualityconversationsconversationidevaluationsevaluationid) | **PUT** /api/v2/quality/conversations/{conversationId}/evaluations/{evaluationId} | Update an evaluation
*QualityApi* | [**putQualityFormsFormId**](docs/Api/QualityApi.md#putqualityformsformid) | **PUT** /api/v2/quality/forms/{formId} | Update an evaluation form.
*QualityApi* | [**putQualityKeywordsetsKeywordsetId**](docs/Api/QualityApi.md#putqualitykeywordsetskeywordsetid) | **PUT** /api/v2/quality/keywordsets/{keywordSetId} | Update a keywordSet to the specified keywordSet via PUT.
*RecordingApi* | [**deleteConversationsConversationIdRecordingsRecordingIdAnnotationsAnnotationId**](docs/Api/RecordingApi.md#deleteconversationsconversationidrecordingsrecordingidannotationsannotationid) | **DELETE** /api/v2/conversations/{conversationId}/recordings/{recordingId}/annotations/{annotationId} | Delete annotation
*RecordingApi* | [**deleteOrphanrecordingsOrphanId**](docs/Api/RecordingApi.md#deleteorphanrecordingsorphanid) | **DELETE** /api/v2/orphanrecordings/{orphanId} | Deletes a single orphan recording
*RecordingApi* | [**deleteRecordingMediaretentionpolicies**](docs/Api/RecordingApi.md#deleterecordingmediaretentionpolicies) | **DELETE** /api/v2/recording/mediaretentionpolicies | Delete media retention policies
*RecordingApi* | [**deleteRecordingMediaretentionpoliciesPolicyId**](docs/Api/RecordingApi.md#deleterecordingmediaretentionpoliciespolicyid) | **DELETE** /api/v2/recording/mediaretentionpolicies/{policyId} | Delete a media retention policy
*RecordingApi* | [**getConversationsConversationIdRecordings**](docs/Api/RecordingApi.md#getconversationsconversationidrecordings) | **GET** /api/v2/conversations/{conversationId}/recordings | Get all of a Conversation&#39;s Recordings.
*RecordingApi* | [**getConversationsConversationIdRecordingsRecordingId**](docs/Api/RecordingApi.md#getconversationsconversationidrecordingsrecordingid) | **GET** /api/v2/conversations/{conversationId}/recordings/{recordingId} | Gets a specific recording.
*RecordingApi* | [**getConversationsConversationIdRecordingsRecordingIdAnnotations**](docs/Api/RecordingApi.md#getconversationsconversationidrecordingsrecordingidannotations) | **GET** /api/v2/conversations/{conversationId}/recordings/{recordingId}/annotations | Get annotations for recording
*RecordingApi* | [**getConversationsConversationIdRecordingsRecordingIdAnnotationsAnnotationId**](docs/Api/RecordingApi.md#getconversationsconversationidrecordingsrecordingidannotationsannotationid) | **GET** /api/v2/conversations/{conversationId}/recordings/{recordingId}/annotations/{annotationId} | Get annotation
*RecordingApi* | [**getOrphanrecordings**](docs/Api/RecordingApi.md#getorphanrecordings) | **GET** /api/v2/orphanrecordings | Gets all orphan recordings
*RecordingApi* | [**getOrphanrecordingsOrphanId**](docs/Api/RecordingApi.md#getorphanrecordingsorphanid) | **GET** /api/v2/orphanrecordings/{orphanId} | Gets a single orphan recording
*RecordingApi* | [**getOrphanrecordingsOrphanIdMedia**](docs/Api/RecordingApi.md#getorphanrecordingsorphanidmedia) | **GET** /api/v2/orphanrecordings/{orphanId}/media | Gets the media of a single orphan recording
*RecordingApi* | [**getRecordingLocalkeysSettings**](docs/Api/RecordingApi.md#getrecordinglocalkeyssettings) | **GET** /api/v2/recording/localkeys/settings | gets a list local key settings data
*RecordingApi* | [**getRecordingLocalkeysSettingsSettingsId**](docs/Api/RecordingApi.md#getrecordinglocalkeyssettingssettingsid) | **GET** /api/v2/recording/localkeys/settings/{settingsId} | Get the local encryption settings
*RecordingApi* | [**getRecordingMediaretentionpolicies**](docs/Api/RecordingApi.md#getrecordingmediaretentionpolicies) | **GET** /api/v2/recording/mediaretentionpolicies | Gets media retention policy list with query options to filter on name and enabled.
*RecordingApi* | [**getRecordingMediaretentionpoliciesPolicyId**](docs/Api/RecordingApi.md#getrecordingmediaretentionpoliciespolicyid) | **GET** /api/v2/recording/mediaretentionpolicies/{policyId} | Get a media retention policy
*RecordingApi* | [**getRecordingRecordingkeys**](docs/Api/RecordingApi.md#getrecordingrecordingkeys) | **GET** /api/v2/recording/recordingkeys | Get encryption key list
*RecordingApi* | [**getRecordingRecordingkeysRotationschedule**](docs/Api/RecordingApi.md#getrecordingrecordingkeysrotationschedule) | **GET** /api/v2/recording/recordingkeys/rotationschedule | Get key rotation schedule
*RecordingApi* | [**getRecordingSettings**](docs/Api/RecordingApi.md#getrecordingsettings) | **GET** /api/v2/recording/settings | Get the Recording Settings for the Organization
*RecordingApi* | [**getRecordingsScreensessions**](docs/Api/RecordingApi.md#getrecordingsscreensessions) | **GET** /api/v2/recordings/screensessions | Retrieves a paged listing of screen recording sessions
*RecordingApi* | [**patchRecordingMediaretentionpoliciesPolicyId**](docs/Api/RecordingApi.md#patchrecordingmediaretentionpoliciespolicyid) | **PATCH** /api/v2/recording/mediaretentionpolicies/{policyId} | Patch a media retention policy
*RecordingApi* | [**patchRecordingsScreensessionsRecordingsessionId**](docs/Api/RecordingApi.md#patchrecordingsscreensessionsrecordingsessionid) | **PATCH** /api/v2/recordings/screensessions/{recordingSessionId} | Update a screen recording session
*RecordingApi* | [**postConversationsConversationIdRecordingsRecordingIdAnnotations**](docs/Api/RecordingApi.md#postconversationsconversationidrecordingsrecordingidannotations) | **POST** /api/v2/conversations/{conversationId}/recordings/{recordingId}/annotations | Create annotation
*RecordingApi* | [**postRecordingLocalkeys**](docs/Api/RecordingApi.md#postrecordinglocalkeys) | **POST** /api/v2/recording/localkeys | create a local recording key
*RecordingApi* | [**postRecordingLocalkeysSettings**](docs/Api/RecordingApi.md#postrecordinglocalkeyssettings) | **POST** /api/v2/recording/localkeys/settings | create settings for local key creation
*RecordingApi* | [**postRecordingMediaretentionpolicies**](docs/Api/RecordingApi.md#postrecordingmediaretentionpolicies) | **POST** /api/v2/recording/mediaretentionpolicies | Create media retention policy
*RecordingApi* | [**postRecordingRecordingkeys**](docs/Api/RecordingApi.md#postrecordingrecordingkeys) | **POST** /api/v2/recording/recordingkeys | Create encryption key
*RecordingApi* | [**putConversationsConversationIdRecordingsRecordingId**](docs/Api/RecordingApi.md#putconversationsconversationidrecordingsrecordingid) | **PUT** /api/v2/conversations/{conversationId}/recordings/{recordingId} | Updates the retention records on a recording.
*RecordingApi* | [**putConversationsConversationIdRecordingsRecordingIdAnnotationsAnnotationId**](docs/Api/RecordingApi.md#putconversationsconversationidrecordingsrecordingidannotationsannotationid) | **PUT** /api/v2/conversations/{conversationId}/recordings/{recordingId}/annotations/{annotationId} | Update annotation
*RecordingApi* | [**putOrphanrecordingsOrphanId**](docs/Api/RecordingApi.md#putorphanrecordingsorphanid) | **PUT** /api/v2/orphanrecordings/{orphanId} | Updates an orphan recording to a regular recording with retention values
*RecordingApi* | [**putRecordingLocalkeysSettingsSettingsId**](docs/Api/RecordingApi.md#putrecordinglocalkeyssettingssettingsid) | **PUT** /api/v2/recording/localkeys/settings/{settingsId} | Update the local encryption settings
*RecordingApi* | [**putRecordingMediaretentionpoliciesPolicyId**](docs/Api/RecordingApi.md#putrecordingmediaretentionpoliciespolicyid) | **PUT** /api/v2/recording/mediaretentionpolicies/{policyId} | Update a media retention policy
*RecordingApi* | [**putRecordingRecordingkeysRotationschedule**](docs/Api/RecordingApi.md#putrecordingrecordingkeysrotationschedule) | **PUT** /api/v2/recording/recordingkeys/rotationschedule | Update key rotation schedule
*RecordingApi* | [**putRecordingSettings**](docs/Api/RecordingApi.md#putrecordingsettings) | **PUT** /api/v2/recording/settings | Update the Recording Settings for the Organization
*ResponseManagementApi* | [**deleteResponsemanagementLibrariesLibraryId**](docs/Api/ResponseManagementApi.md#deleteresponsemanagementlibrarieslibraryid) | **DELETE** /api/v2/responsemanagement/libraries/{libraryId} | Delete an existing response library.
*ResponseManagementApi* | [**deleteResponsemanagementResponsesResponseId**](docs/Api/ResponseManagementApi.md#deleteresponsemanagementresponsesresponseid) | **DELETE** /api/v2/responsemanagement/responses/{responseId} | Delete an existing response.
*ResponseManagementApi* | [**getResponsemanagementLibraries**](docs/Api/ResponseManagementApi.md#getresponsemanagementlibraries) | **GET** /api/v2/responsemanagement/libraries | Gets a list of existing response libraries.
*ResponseManagementApi* | [**getResponsemanagementLibrariesLibraryId**](docs/Api/ResponseManagementApi.md#getresponsemanagementlibrarieslibraryid) | **GET** /api/v2/responsemanagement/libraries/{libraryId} | Get details about an existing response library.
*ResponseManagementApi* | [**getResponsemanagementResponses**](docs/Api/ResponseManagementApi.md#getresponsemanagementresponses) | **GET** /api/v2/responsemanagement/responses | Gets a list of existing responses.
*ResponseManagementApi* | [**getResponsemanagementResponsesResponseId**](docs/Api/ResponseManagementApi.md#getresponsemanagementresponsesresponseid) | **GET** /api/v2/responsemanagement/responses/{responseId} | Get details about an existing response.
*ResponseManagementApi* | [**postResponsemanagementLibraries**](docs/Api/ResponseManagementApi.md#postresponsemanagementlibraries) | **POST** /api/v2/responsemanagement/libraries | Create a response library.
*ResponseManagementApi* | [**postResponsemanagementResponses**](docs/Api/ResponseManagementApi.md#postresponsemanagementresponses) | **POST** /api/v2/responsemanagement/responses | Create a response.
*ResponseManagementApi* | [**postResponsemanagementResponsesQuery**](docs/Api/ResponseManagementApi.md#postresponsemanagementresponsesquery) | **POST** /api/v2/responsemanagement/responses/query | Query responses
*ResponseManagementApi* | [**putResponsemanagementLibrariesLibraryId**](docs/Api/ResponseManagementApi.md#putresponsemanagementlibrarieslibraryid) | **PUT** /api/v2/responsemanagement/libraries/{libraryId} | Update an existing response library.
*ResponseManagementApi* | [**putResponsemanagementResponsesResponseId**](docs/Api/ResponseManagementApi.md#putresponsemanagementresponsesresponseid) | **PUT** /api/v2/responsemanagement/responses/{responseId} | Update an existing response.
*RoutingApi* | [**deleteRoutingEmailDomainsDomainId**](docs/Api/RoutingApi.md#deleteroutingemaildomainsdomainid) | **DELETE** /api/v2/routing/email/domains/{domainId} | Delete a domain
*RoutingApi* | [**deleteRoutingEmailDomainsDomainnameRoutesRouteId**](docs/Api/RoutingApi.md#deleteroutingemaildomainsdomainnameroutesrouteid) | **DELETE** /api/v2/routing/email/domains/{domainName}/routes/{routeId} | Delete a route
*RoutingApi* | [**deleteRoutingQueuesQueueId**](docs/Api/RoutingApi.md#deleteroutingqueuesqueueid) | **DELETE** /api/v2/routing/queues/{queueId} | Delete a queue
*RoutingApi* | [**deleteRoutingQueuesQueueIdUsersMemberId**](docs/Api/RoutingApi.md#deleteroutingqueuesqueueidusersmemberid) | **DELETE** /api/v2/routing/queues/{queueId}/users/{memberId} | Delete queue member
*RoutingApi* | [**deleteRoutingQueuesQueueIdWrapupcodesCodeId**](docs/Api/RoutingApi.md#deleteroutingqueuesqueueidwrapupcodescodeid) | **DELETE** /api/v2/routing/queues/{queueId}/wrapupcodes/{codeId} | Delete a wrap-up code from a queue
*RoutingApi* | [**deleteRoutingSkillsSkillId**](docs/Api/RoutingApi.md#deleteroutingskillsskillid) | **DELETE** /api/v2/routing/skills/{skillId} | Delete Routing Skill
*RoutingApi* | [**deleteRoutingUtilization**](docs/Api/RoutingApi.md#deleteroutingutilization) | **DELETE** /api/v2/routing/utilization | Delete utilization settings and revert to system defaults.
*RoutingApi* | [**deleteRoutingWrapupcodesCodeId**](docs/Api/RoutingApi.md#deleteroutingwrapupcodescodeid) | **DELETE** /api/v2/routing/wrapupcodes/{codeId} | Delete wrap-up code
*RoutingApi* | [**deleteUsersUserIdRoutingskillsSkillId**](docs/Api/RoutingApi.md#deleteusersuseridroutingskillsskillid) | **DELETE** /api/v2/users/{userId}/routingskills/{skillId} | Remove routing skill from user
*RoutingApi* | [**getRoutingEmailDomains**](docs/Api/RoutingApi.md#getroutingemaildomains) | **GET** /api/v2/routing/email/domains | Get domains
*RoutingApi* | [**getRoutingEmailDomainsDomainId**](docs/Api/RoutingApi.md#getroutingemaildomainsdomainid) | **GET** /api/v2/routing/email/domains/{domainId} | Get domain
*RoutingApi* | [**getRoutingEmailDomainsDomainnameRoutes**](docs/Api/RoutingApi.md#getroutingemaildomainsdomainnameroutes) | **GET** /api/v2/routing/email/domains/{domainName}/routes | Get routes
*RoutingApi* | [**getRoutingEmailDomainsDomainnameRoutesRouteId**](docs/Api/RoutingApi.md#getroutingemaildomainsdomainnameroutesrouteid) | **GET** /api/v2/routing/email/domains/{domainName}/routes/{routeId} | Get a route
*RoutingApi* | [**getRoutingEmailSetup**](docs/Api/RoutingApi.md#getroutingemailsetup) | **GET** /api/v2/routing/email/setup | Get email setup
*RoutingApi* | [**getRoutingLanguages**](docs/Api/RoutingApi.md#getroutinglanguages) | **GET** /api/v2/routing/languages | Get the list of supported languages.
*RoutingApi* | [**getRoutingQueues**](docs/Api/RoutingApi.md#getroutingqueues) | **GET** /api/v2/routing/queues | Get list of queues.
*RoutingApi* | [**getRoutingQueuesQueueId**](docs/Api/RoutingApi.md#getroutingqueuesqueueid) | **GET** /api/v2/routing/queues/{queueId} | Get details about this queue.
*RoutingApi* | [**getRoutingQueuesQueueIdEstimatedwaittime**](docs/Api/RoutingApi.md#getroutingqueuesqueueidestimatedwaittime) | **GET** /api/v2/routing/queues/{queueId}/estimatedwaittime | Get Estimated Wait Time
*RoutingApi* | [**getRoutingQueuesQueueIdUsers**](docs/Api/RoutingApi.md#getroutingqueuesqueueidusers) | **GET** /api/v2/routing/queues/{queueId}/users | Get the members of this queue
*RoutingApi* | [**getRoutingQueuesQueueIdWrapupcodes**](docs/Api/RoutingApi.md#getroutingqueuesqueueidwrapupcodes) | **GET** /api/v2/routing/queues/{queueId}/wrapupcodes | Get the wrap-up codes for a queue
*RoutingApi* | [**getRoutingSkills**](docs/Api/RoutingApi.md#getroutingskills) | **GET** /api/v2/routing/skills | Get the list of routing skills.
*RoutingApi* | [**getRoutingSkillsSkillId**](docs/Api/RoutingApi.md#getroutingskillsskillid) | **GET** /api/v2/routing/skills/{skillId} | Get Routing Skill
*RoutingApi* | [**getRoutingUtilization**](docs/Api/RoutingApi.md#getroutingutilization) | **GET** /api/v2/routing/utilization | Get the utilization settings.
*RoutingApi* | [**getRoutingWrapupcodes**](docs/Api/RoutingApi.md#getroutingwrapupcodes) | **GET** /api/v2/routing/wrapupcodes | Get list of wrapup codes.
*RoutingApi* | [**getRoutingWrapupcodesCodeId**](docs/Api/RoutingApi.md#getroutingwrapupcodescodeid) | **GET** /api/v2/routing/wrapupcodes/{codeId} | Get details about this wrap-up code.
*RoutingApi* | [**getUsersUserIdRoutingskills**](docs/Api/RoutingApi.md#getusersuseridroutingskills) | **GET** /api/v2/users/{userId}/routingskills | List routing skills for user
*RoutingApi* | [**patchRoutingQueuesQueueIdUsers**](docs/Api/RoutingApi.md#patchroutingqueuesqueueidusers) | **PATCH** /api/v2/routing/queues/{queueId}/users | Join or unjoin a set of users for a queue
*RoutingApi* | [**patchRoutingQueuesQueueIdUsersMemberId**](docs/Api/RoutingApi.md#patchroutingqueuesqueueidusersmemberid) | **PATCH** /api/v2/routing/queues/{queueId}/users/{memberId} | Update the ring number of joined status for a User in a Queue
*RoutingApi* | [**postAnalyticsQueuesObservationsQuery**](docs/Api/RoutingApi.md#postanalyticsqueuesobservationsquery) | **POST** /api/v2/analytics/queues/observations/query | Query for queue observations
*RoutingApi* | [**postRoutingEmailDomains**](docs/Api/RoutingApi.md#postroutingemaildomains) | **POST** /api/v2/routing/email/domains | Create a domain
*RoutingApi* | [**postRoutingEmailDomainsDomainnameRoutes**](docs/Api/RoutingApi.md#postroutingemaildomainsdomainnameroutes) | **POST** /api/v2/routing/email/domains/{domainName}/routes | Create a route
*RoutingApi* | [**postRoutingLanguages**](docs/Api/RoutingApi.md#postroutinglanguages) | **POST** /api/v2/routing/languages | Create Language
*RoutingApi* | [**postRoutingQueues**](docs/Api/RoutingApi.md#postroutingqueues) | **POST** /api/v2/routing/queues | Create queue
*RoutingApi* | [**postRoutingQueuesQueueIdUsers**](docs/Api/RoutingApi.md#postroutingqueuesqueueidusers) | **POST** /api/v2/routing/queues/{queueId}/users | Bulk add or delete up to 100 queue members
*RoutingApi* | [**postRoutingQueuesQueueIdWrapupcodes**](docs/Api/RoutingApi.md#postroutingqueuesqueueidwrapupcodes) | **POST** /api/v2/routing/queues/{queueId}/wrapupcodes | Add up to 100 wrap-up codes to a queue
*RoutingApi* | [**postRoutingSkills**](docs/Api/RoutingApi.md#postroutingskills) | **POST** /api/v2/routing/skills | Create Skill
*RoutingApi* | [**postRoutingWrapupcodes**](docs/Api/RoutingApi.md#postroutingwrapupcodes) | **POST** /api/v2/routing/wrapupcodes | Create a wrap-up code
*RoutingApi* | [**postUsersUserIdRoutingskills**](docs/Api/RoutingApi.md#postusersuseridroutingskills) | **POST** /api/v2/users/{userId}/routingskills | Add routing skill to user
*RoutingApi* | [**putRoutingEmailDomainsDomainnameRoutesRouteId**](docs/Api/RoutingApi.md#putroutingemaildomainsdomainnameroutesrouteid) | **PUT** /api/v2/routing/email/domains/{domainName}/routes/{routeId} | Update a route
*RoutingApi* | [**putRoutingQueuesQueueId**](docs/Api/RoutingApi.md#putroutingqueuesqueueid) | **PUT** /api/v2/routing/queues/{queueId} | Update a queue
*RoutingApi* | [**putRoutingUtilization**](docs/Api/RoutingApi.md#putroutingutilization) | **PUT** /api/v2/routing/utilization | Update the utilization settings.
*RoutingApi* | [**putRoutingWrapupcodesCodeId**](docs/Api/RoutingApi.md#putroutingwrapupcodescodeid) | **PUT** /api/v2/routing/wrapupcodes/{codeId} | Update wrap-up code
*RoutingApi* | [**putUsersUserIdRoutingskillsSkillId**](docs/Api/RoutingApi.md#putusersuseridroutingskillsskillid) | **PUT** /api/v2/users/{userId}/routingskills/{skillId} | Update routing skill proficiency or state.
*ScriptsApi* | [**getScripts**](docs/Api/ScriptsApi.md#getscripts) | **GET** /api/v2/scripts | Get the list of scripts
*ScriptsApi* | [**getScriptsPublished**](docs/Api/ScriptsApi.md#getscriptspublished) | **GET** /api/v2/scripts/published | Get the published scripts.
*ScriptsApi* | [**getScriptsPublishedScriptId**](docs/Api/ScriptsApi.md#getscriptspublishedscriptid) | **GET** /api/v2/scripts/published/{scriptId} | Get the published script.
*ScriptsApi* | [**getScriptsPublishedScriptIdPages**](docs/Api/ScriptsApi.md#getscriptspublishedscriptidpages) | **GET** /api/v2/scripts/published/{scriptId}/pages | Get the list of published pages
*ScriptsApi* | [**getScriptsPublishedScriptIdPagesPageId**](docs/Api/ScriptsApi.md#getscriptspublishedscriptidpagespageid) | **GET** /api/v2/scripts/published/{scriptId}/pages/{pageId} | Get the published page.
*ScriptsApi* | [**getScriptsPublishedScriptIdVariables**](docs/Api/ScriptsApi.md#getscriptspublishedscriptidvariables) | **GET** /api/v2/scripts/published/{scriptId}/variables | Get the published variables
*ScriptsApi* | [**getScriptsScriptId**](docs/Api/ScriptsApi.md#getscriptsscriptid) | **GET** /api/v2/scripts/{scriptId} | Get a script
*ScriptsApi* | [**getScriptsScriptIdPages**](docs/Api/ScriptsApi.md#getscriptsscriptidpages) | **GET** /api/v2/scripts/{scriptId}/pages | Get the list of pages
*ScriptsApi* | [**getScriptsScriptIdPagesPageId**](docs/Api/ScriptsApi.md#getscriptsscriptidpagespageid) | **GET** /api/v2/scripts/{scriptId}/pages/{pageId} | Get a page
*SearchApi* | [**getGroupsSearch**](docs/Api/SearchApi.md#getgroupssearch) | **GET** /api/v2/groups/search | Search groups using the q64 value returned from a previous search
*SearchApi* | [**getLocationsSearch**](docs/Api/SearchApi.md#getlocationssearch) | **GET** /api/v2/locations/search | Search locations using the q64 value returned from a previous search
*SearchApi* | [**getSearch**](docs/Api/SearchApi.md#getsearch) | **GET** /api/v2/search | Search using the q64 value returned from a previous search.
*SearchApi* | [**getSearchSuggest**](docs/Api/SearchApi.md#getsearchsuggest) | **GET** /api/v2/search/suggest | Suggest resources using the q64 value returned from a previous suggest query.
*SearchApi* | [**getUsersSearch**](docs/Api/SearchApi.md#getuserssearch) | **GET** /api/v2/users/search | Search users using the q64 value returned from a previous search
*SearchApi* | [**getVoicemailSearch**](docs/Api/SearchApi.md#getvoicemailsearch) | **GET** /api/v2/voicemail/search | Search voicemails using the q64 value returned from a previous search
*SearchApi* | [**postGroupsSearch**](docs/Api/SearchApi.md#postgroupssearch) | **POST** /api/v2/groups/search | Search groups
*SearchApi* | [**postLocationsSearch**](docs/Api/SearchApi.md#postlocationssearch) | **POST** /api/v2/locations/search | Search locations
*SearchApi* | [**postSearch**](docs/Api/SearchApi.md#postsearch) | **POST** /api/v2/search | Search resources.
*SearchApi* | [**postSearchSuggest**](docs/Api/SearchApi.md#postsearchsuggest) | **POST** /api/v2/search/suggest | Suggest resources.
*SearchApi* | [**postUsersSearch**](docs/Api/SearchApi.md#postuserssearch) | **POST** /api/v2/users/search | Search users
*SearchApi* | [**postVoicemailSearch**](docs/Api/SearchApi.md#postvoicemailsearch) | **POST** /api/v2/voicemail/search | Search voicemails
*StationsApi* | [**deleteStationsStationIdAssociateduser**](docs/Api/StationsApi.md#deletestationsstationidassociateduser) | **DELETE** /api/v2/stations/{stationId}/associateduser | Unassigns the user assigned to this station
*StationsApi* | [**getStations**](docs/Api/StationsApi.md#getstations) | **GET** /api/v2/stations | Get the list of available stations.
*StationsApi* | [**getStationsStationId**](docs/Api/StationsApi.md#getstationsstationid) | **GET** /api/v2/stations/{stationId} | Get station.
*SuggestApi* | [**getSearch**](docs/Api/SuggestApi.md#getsearch) | **GET** /api/v2/search | Search using the q64 value returned from a previous search.
*SuggestApi* | [**getSearchSuggest**](docs/Api/SuggestApi.md#getsearchsuggest) | **GET** /api/v2/search/suggest | Suggest resources using the q64 value returned from a previous suggest query.
*SuggestApi* | [**postSearch**](docs/Api/SuggestApi.md#postsearch) | **POST** /api/v2/search | Search resources.
*SuggestApi* | [**postSearchSuggest**](docs/Api/SuggestApi.md#postsearchsuggest) | **POST** /api/v2/search/suggest | Suggest resources.
*TelephonyProvidersEdgeApi* | [**deleteTelephonyProvidersEdgesCertificateauthoritiesCertificateId**](docs/Api/TelephonyProvidersEdgeApi.md#deletetelephonyprovidersedgescertificateauthoritiescertificateid) | **DELETE** /api/v2/telephony/providers/edges/certificateauthorities/{certificateId} | Delete a certificate authority.
*TelephonyProvidersEdgeApi* | [**deleteTelephonyProvidersEdgesDidpoolsDidpoolId**](docs/Api/TelephonyProvidersEdgeApi.md#deletetelephonyprovidersedgesdidpoolsdidpoolid) | **DELETE** /api/v2/telephony/providers/edges/didpools/{didPoolId} | Delete a DID Pool by ID.
*TelephonyProvidersEdgeApi* | [**deleteTelephonyProvidersEdgesEdgeId**](docs/Api/TelephonyProvidersEdgeApi.md#deletetelephonyprovidersedgesedgeid) | **DELETE** /api/v2/telephony/providers/edges/{edgeId} | Delete a edge.
*TelephonyProvidersEdgeApi* | [**deleteTelephonyProvidersEdgesEdgeIdLogicalinterfacesInterfaceId**](docs/Api/TelephonyProvidersEdgeApi.md#deletetelephonyprovidersedgesedgeidlogicalinterfacesinterfaceid) | **DELETE** /api/v2/telephony/providers/edges/{edgeId}/logicalinterfaces/{interfaceId} | Delete an edge logical interface
*TelephonyProvidersEdgeApi* | [**deleteTelephonyProvidersEdgesEdgeIdSoftwareupdate**](docs/Api/TelephonyProvidersEdgeApi.md#deletetelephonyprovidersedgesedgeidsoftwareupdate) | **DELETE** /api/v2/telephony/providers/edges/{edgeId}/softwareupdate | Cancels any in-progress update for this edge.
*TelephonyProvidersEdgeApi* | [**deleteTelephonyProvidersEdgesEdgegroupsEdgegroupId**](docs/Api/TelephonyProvidersEdgeApi.md#deletetelephonyprovidersedgesedgegroupsedgegroupid) | **DELETE** /api/v2/telephony/providers/edges/edgegroups/{edgeGroupId} | Delete an edge group.
*TelephonyProvidersEdgeApi* | [**deleteTelephonyProvidersEdgesEndpointsEndpointId**](docs/Api/TelephonyProvidersEdgeApi.md#deletetelephonyprovidersedgesendpointsendpointid) | **DELETE** /api/v2/telephony/providers/edges/endpoints/{endpointId} | Delete endpoint
*TelephonyProvidersEdgeApi* | [**deleteTelephonyProvidersEdgesExtensionpoolsExtensionpoolId**](docs/Api/TelephonyProvidersEdgeApi.md#deletetelephonyprovidersedgesextensionpoolsextensionpoolid) | **DELETE** /api/v2/telephony/providers/edges/extensionpools/{extensionPoolId} | Delete an extension pool by ID
*TelephonyProvidersEdgeApi* | [**deleteTelephonyProvidersEdgesOutboundroutesOutboundrouteId**](docs/Api/TelephonyProvidersEdgeApi.md#deletetelephonyprovidersedgesoutboundroutesoutboundrouteid) | **DELETE** /api/v2/telephony/providers/edges/outboundroutes/{outboundRouteId} | Delete Outbound Route
*TelephonyProvidersEdgeApi* | [**deleteTelephonyProvidersEdgesPhonebasesettingsPhonebaseId**](docs/Api/TelephonyProvidersEdgeApi.md#deletetelephonyprovidersedgesphonebasesettingsphonebaseid) | **DELETE** /api/v2/telephony/providers/edges/phonebasesettings/{phoneBaseId} | Delete a Phone Base Settings by ID
*TelephonyProvidersEdgeApi* | [**deleteTelephonyProvidersEdgesPhonesPhoneId**](docs/Api/TelephonyProvidersEdgeApi.md#deletetelephonyprovidersedgesphonesphoneid) | **DELETE** /api/v2/telephony/providers/edges/phones/{phoneId} | Delete a Phone by ID
*TelephonyProvidersEdgeApi* | [**deleteTelephonyProvidersEdgesSitesSiteId**](docs/Api/TelephonyProvidersEdgeApi.md#deletetelephonyprovidersedgessitessiteid) | **DELETE** /api/v2/telephony/providers/edges/sites/{siteId} | Delete a Site by ID
*TelephonyProvidersEdgeApi* | [**deleteTelephonyProvidersEdgesSitesSiteIdOutboundroutesOutboundrouteId**](docs/Api/TelephonyProvidersEdgeApi.md#deletetelephonyprovidersedgessitessiteidoutboundroutesoutboundrouteid) | **DELETE** /api/v2/telephony/providers/edges/sites/{siteId}/outboundroutes/{outboundRouteId} | Delete Outbound Route
*TelephonyProvidersEdgeApi* | [**deleteTelephonyProvidersEdgesTrunkbasesettingsTrunkbasesettingsId**](docs/Api/TelephonyProvidersEdgeApi.md#deletetelephonyprovidersedgestrunkbasesettingstrunkbasesettingsid) | **DELETE** /api/v2/telephony/providers/edges/trunkbasesettings/{trunkBaseSettingsId} | Delete a Trunk Base Settings object by ID
*TelephonyProvidersEdgeApi* | [**getConfigurationSchemasEdgesVnext**](docs/Api/TelephonyProvidersEdgeApi.md#getconfigurationschemasedgesvnext) | **GET** /api/v2/configuration/schemas/edges/vnext | Lists available schema categories (Deprecated)
*TelephonyProvidersEdgeApi* | [**getConfigurationSchemasEdgesVnextSchemacategory**](docs/Api/TelephonyProvidersEdgeApi.md#getconfigurationschemasedgesvnextschemacategory) | **GET** /api/v2/configuration/schemas/edges/vnext/{schemaCategory} | List schemas of a specific category (Deprecated)
*TelephonyProvidersEdgeApi* | [**getConfigurationSchemasEdgesVnextSchemacategorySchematype**](docs/Api/TelephonyProvidersEdgeApi.md#getconfigurationschemasedgesvnextschemacategoryschematype) | **GET** /api/v2/configuration/schemas/edges/vnext/{schemaCategory}/{schemaType} | List schemas of a specific category (Deprecated)
*TelephonyProvidersEdgeApi* | [**getConfigurationSchemasEdgesVnextSchemacategorySchematypeSchemaId**](docs/Api/TelephonyProvidersEdgeApi.md#getconfigurationschemasedgesvnextschemacategoryschematypeschemaid) | **GET** /api/v2/configuration/schemas/edges/vnext/{schemaCategory}/{schemaType}/{schemaId} | Get a json schema (Deprecated)
*TelephonyProvidersEdgeApi* | [**getConfigurationSchemasEdgesVnextSchemacategorySchematypeSchemaIdExtensiontypeMetadataId**](docs/Api/TelephonyProvidersEdgeApi.md#getconfigurationschemasedgesvnextschemacategoryschematypeschemaidextensiontypemetadataid) | **GET** /api/v2/configuration/schemas/edges/vnext/{schemaCategory}/{schemaType}/{schemaId}/{extensionType}/{metadataId} | Get metadata for a schema (Deprecated)
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdges**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedges) | **GET** /api/v2/telephony/providers/edges | Get the list of edges.
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesAvailablelanguages**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgesavailablelanguages) | **GET** /api/v2/telephony/providers/edges/availablelanguages | Get the list of available languages.
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesCertificateauthorities**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgescertificateauthorities) | **GET** /api/v2/telephony/providers/edges/certificateauthorities | Get the list of certificate authorities.
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesCertificateauthoritiesCertificateId**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgescertificateauthoritiescertificateid) | **GET** /api/v2/telephony/providers/edges/certificateauthorities/{certificateId} | Get a certificate authority.
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesDidpools**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgesdidpools) | **GET** /api/v2/telephony/providers/edges/didpools | Get a listing of DID Pools
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesDidpoolsDidpoolId**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgesdidpoolsdidpoolid) | **GET** /api/v2/telephony/providers/edges/didpools/{didPoolId} | Get a DID Pool by ID.
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesDids**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgesdids) | **GET** /api/v2/telephony/providers/edges/dids | Get a listing of DIDs
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesDidsDidId**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgesdidsdidid) | **GET** /api/v2/telephony/providers/edges/dids/{didId} | Get a DID by ID.
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesEdgeId**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgesedgeid) | **GET** /api/v2/telephony/providers/edges/{edgeId} | Get edge.
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesEdgeIdLines**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgesedgeidlines) | **GET** /api/v2/telephony/providers/edges/{edgeId}/lines | Get the list of lines.
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesEdgeIdLinesLineId**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgesedgeidlineslineid) | **GET** /api/v2/telephony/providers/edges/{edgeId}/lines/{lineId} | Get line
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesEdgeIdLogicalinterfaces**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgesedgeidlogicalinterfaces) | **GET** /api/v2/telephony/providers/edges/{edgeId}/logicalinterfaces | Get edge logical interfaces.
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesEdgeIdLogicalinterfacesInterfaceId**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgesedgeidlogicalinterfacesinterfaceid) | **GET** /api/v2/telephony/providers/edges/{edgeId}/logicalinterfaces/{interfaceId} | Get an edge logical interface
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesEdgeIdLogsJobsJobId**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgesedgeidlogsjobsjobid) | **GET** /api/v2/telephony/providers/edges/{edgeId}/logs/jobs/{jobId} | Get an Edge logs job.
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesEdgeIdMetrics**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgesedgeidmetrics) | **GET** /api/v2/telephony/providers/edges/{edgeId}/metrics | Get the edge metrics.
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesEdgeIdPhysicalinterfaces**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgesedgeidphysicalinterfaces) | **GET** /api/v2/telephony/providers/edges/{edgeId}/physicalinterfaces | Retrieve a list of all configured physical interfaces from a specific edge.
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesEdgeIdPhysicalinterfacesInterfaceId**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgesedgeidphysicalinterfacesinterfaceid) | **GET** /api/v2/telephony/providers/edges/{edgeId}/physicalinterfaces/{interfaceId} | Get edge physical interface.
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesEdgeIdSetuppackage**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgesedgeidsetuppackage) | **GET** /api/v2/telephony/providers/edges/{edgeId}/setuppackage | Get the setup package for a locally deployed edge device. This is needed to complete the setup process for the virtual edge.
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesEdgeIdSoftwareupdate**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgesedgeidsoftwareupdate) | **GET** /api/v2/telephony/providers/edges/{edgeId}/softwareupdate | Gets software update status information about any edge.
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesEdgeIdSoftwareversions**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgesedgeidsoftwareversions) | **GET** /api/v2/telephony/providers/edges/{edgeId}/softwareversions | Gets all the available software versions for this edge.
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesEdgegroups**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgesedgegroups) | **GET** /api/v2/telephony/providers/edges/edgegroups | Get the list of edge groups.
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesEdgegroupsEdgegroupId**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgesedgegroupsedgegroupid) | **GET** /api/v2/telephony/providers/edges/edgegroups/{edgeGroupId} | Get edge group.
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesEdgeversionreport**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgesedgeversionreport) | **GET** /api/v2/telephony/providers/edges/edgeversionreport | Get the edge version report.
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesEndpoints**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgesendpoints) | **GET** /api/v2/telephony/providers/edges/endpoints | Get endpoints
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesEndpointsEndpointId**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgesendpointsendpointid) | **GET** /api/v2/telephony/providers/edges/endpoints/{endpointId} | Get endpoint
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesExtensionpools**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgesextensionpools) | **GET** /api/v2/telephony/providers/edges/extensionpools | Get a listing of extension pools
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesExtensionpoolsExtensionpoolId**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgesextensionpoolsextensionpoolid) | **GET** /api/v2/telephony/providers/edges/extensionpools/{extensionPoolId} | Get an extension pool by ID
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesExtensions**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgesextensions) | **GET** /api/v2/telephony/providers/edges/extensions | Get a listing of extensions
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesExtensionsExtensionId**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgesextensionsextensionid) | **GET** /api/v2/telephony/providers/edges/extensions/{extensionId} | Get an extension by ID.
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesLinebasesettings**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgeslinebasesettings) | **GET** /api/v2/telephony/providers/edges/linebasesettings | Get a listing of line base settings objects
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesLinebasesettingsLinebaseId**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgeslinebasesettingslinebaseid) | **GET** /api/v2/telephony/providers/edges/linebasesettings/{lineBaseId} | Get a line base settings object by ID
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesLines**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgeslines) | **GET** /api/v2/telephony/providers/edges/lines | Get a list of Lines
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesLinesLineId**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgeslineslineid) | **GET** /api/v2/telephony/providers/edges/lines/{lineId} | Get a Line by ID
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesLinesTemplate**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgeslinestemplate) | **GET** /api/v2/telephony/providers/edges/lines/template | Get a Line instance template based on a Line Base Settings object. This object can then be modified and saved as a new Line instance
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesMetrics**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgesmetrics) | **GET** /api/v2/telephony/providers/edges/metrics | Get the metrics for a list of edges.
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesOutboundroutes**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgesoutboundroutes) | **GET** /api/v2/telephony/providers/edges/outboundroutes | Get outbound routes
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesOutboundroutesOutboundrouteId**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgesoutboundroutesoutboundrouteid) | **GET** /api/v2/telephony/providers/edges/outboundroutes/{outboundRouteId} | Get outbound route
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesPhonebasesettings**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgesphonebasesettings) | **GET** /api/v2/telephony/providers/edges/phonebasesettings | Get a list of Phone Base Settings objects
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesPhonebasesettingsAvailablemetabases**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgesphonebasesettingsavailablemetabases) | **GET** /api/v2/telephony/providers/edges/phonebasesettings/availablemetabases | Get a list of available makes and models to create a new Phone Base Settings
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesPhonebasesettingsPhonebaseId**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgesphonebasesettingsphonebaseid) | **GET** /api/v2/telephony/providers/edges/phonebasesettings/{phoneBaseId} | Get a Phone Base Settings object by ID
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesPhonebasesettingsTemplate**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgesphonebasesettingstemplate) | **GET** /api/v2/telephony/providers/edges/phonebasesettings/template | Get a Phone Base Settings instance template from a given make and model. This object can then be modified and saved as a new Phone Base Settings instance
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesPhones**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgesphones) | **GET** /api/v2/telephony/providers/edges/phones | Get a list of Phone Instances
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesPhonesPhoneId**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgesphonesphoneid) | **GET** /api/v2/telephony/providers/edges/phones/{phoneId} | Get a Phone by ID
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesPhonesTemplate**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgesphonestemplate) | **GET** /api/v2/telephony/providers/edges/phones/template | Get a Phone instance template based on a Phone Base Settings object. This object can then be modified and saved as a new Phone instance
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesSites**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgessites) | **GET** /api/v2/telephony/providers/edges/sites | Get the list of Sites.
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesSitesSiteId**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgessitessiteid) | **GET** /api/v2/telephony/providers/edges/sites/{siteId} | Get a Site by ID.
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesSitesSiteIdNumberplans**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgessitessiteidnumberplans) | **GET** /api/v2/telephony/providers/edges/sites/{siteId}/numberplans | Get the list of Number Plans for this Site.
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesSitesSiteIdNumberplansClassifications**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgessitessiteidnumberplansclassifications) | **GET** /api/v2/telephony/providers/edges/sites/{siteId}/numberplans/classifications | Get a list of Classifications for this Site
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesSitesSiteIdNumberplansNumberplanId**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgessitessiteidnumberplansnumberplanid) | **GET** /api/v2/telephony/providers/edges/sites/{siteId}/numberplans/{numberPlanId} | Get a Number Plan by ID.
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesSitesSiteIdOutboundroutes**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgessitessiteidoutboundroutes) | **GET** /api/v2/telephony/providers/edges/sites/{siteId}/outboundroutes | Get outbound routes
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesSitesSiteIdOutboundroutesOutboundrouteId**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgessitessiteidoutboundroutesoutboundrouteid) | **GET** /api/v2/telephony/providers/edges/sites/{siteId}/outboundroutes/{outboundRouteId} | Get an outbound route
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesTimezones**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgestimezones) | **GET** /api/v2/telephony/providers/edges/timezones | Get a list of Edge-compatible time zones
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesTrunkbasesettings**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgestrunkbasesettings) | **GET** /api/v2/telephony/providers/edges/trunkbasesettings | Get Trunk Base Settings listing
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesTrunkbasesettingsAvailablemetabases**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgestrunkbasesettingsavailablemetabases) | **GET** /api/v2/telephony/providers/edges/trunkbasesettings/availablemetabases | Get a list of available makes and models to create a new Trunk Base Settings
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesTrunkbasesettingsTemplate**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgestrunkbasesettingstemplate) | **GET** /api/v2/telephony/providers/edges/trunkbasesettings/template | Get a Trunk Base Settings instance template from a given make and model. This object can then be modified and saved as a new Trunk Base Settings instance
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesTrunkbasesettingsTrunkbasesettingsId**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgestrunkbasesettingstrunkbasesettingsid) | **GET** /api/v2/telephony/providers/edges/trunkbasesettings/{trunkBaseSettingsId} | Get a Trunk Base Settings object by ID
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesTrunks**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgestrunks) | **GET** /api/v2/telephony/providers/edges/trunks | Get the list of available trunks.
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesTrunksTrunkId**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgestrunkstrunkid) | **GET** /api/v2/telephony/providers/edges/trunks/{trunkId} | Get a Trunk by ID
*TelephonyProvidersEdgeApi* | [**getTelephonyProvidersEdgesTrunkswithrecording**](docs/Api/TelephonyProvidersEdgeApi.md#gettelephonyprovidersedgestrunkswithrecording) | **GET** /api/v2/telephony/providers/edges/trunkswithrecording | Get Counts of trunks that have recording disabled or enabled
*TelephonyProvidersEdgeApi* | [**postTelephonyProvidersEdges**](docs/Api/TelephonyProvidersEdgeApi.md#posttelephonyprovidersedges) | **POST** /api/v2/telephony/providers/edges | Create an edge.
*TelephonyProvidersEdgeApi* | [**postTelephonyProvidersEdgesAddressvalidation**](docs/Api/TelephonyProvidersEdgeApi.md#posttelephonyprovidersedgesaddressvalidation) | **POST** /api/v2/telephony/providers/edges/addressvalidation | Validates a street address
*TelephonyProvidersEdgeApi* | [**postTelephonyProvidersEdgesCertificateauthorities**](docs/Api/TelephonyProvidersEdgeApi.md#posttelephonyprovidersedgescertificateauthorities) | **POST** /api/v2/telephony/providers/edges/certificateauthorities | Create a certificate authority.
*TelephonyProvidersEdgeApi* | [**postTelephonyProvidersEdgesDidpools**](docs/Api/TelephonyProvidersEdgeApi.md#posttelephonyprovidersedgesdidpools) | **POST** /api/v2/telephony/providers/edges/didpools | Create a new DID pool
*TelephonyProvidersEdgeApi* | [**postTelephonyProvidersEdgesEdgeIdLogicalinterfaces**](docs/Api/TelephonyProvidersEdgeApi.md#posttelephonyprovidersedgesedgeidlogicalinterfaces) | **POST** /api/v2/telephony/providers/edges/{edgeId}/logicalinterfaces | Create an edge logical interface.
*TelephonyProvidersEdgeApi* | [**postTelephonyProvidersEdgesEdgeIdLogsJobs**](docs/Api/TelephonyProvidersEdgeApi.md#posttelephonyprovidersedgesedgeidlogsjobs) | **POST** /api/v2/telephony/providers/edges/{edgeId}/logs/jobs | Create a job to upload a list of Edge logs.
*TelephonyProvidersEdgeApi* | [**postTelephonyProvidersEdgesEdgeIdLogsJobsJobIdUpload**](docs/Api/TelephonyProvidersEdgeApi.md#posttelephonyprovidersedgesedgeidlogsjobsjobidupload) | **POST** /api/v2/telephony/providers/edges/{edgeId}/logs/jobs/{jobId}/upload | Request that the specified fileIds be uploaded from the Edge.
*TelephonyProvidersEdgeApi* | [**postTelephonyProvidersEdgesEdgeIdReboot**](docs/Api/TelephonyProvidersEdgeApi.md#posttelephonyprovidersedgesedgeidreboot) | **POST** /api/v2/telephony/providers/edges/{edgeId}/reboot | Reboot an Edge
*TelephonyProvidersEdgeApi* | [**postTelephonyProvidersEdgesEdgeIdSoftwareupdate**](docs/Api/TelephonyProvidersEdgeApi.md#posttelephonyprovidersedgesedgeidsoftwareupdate) | **POST** /api/v2/telephony/providers/edges/{edgeId}/softwareupdate | Starts a software update for this edge.
*TelephonyProvidersEdgeApi* | [**postTelephonyProvidersEdgesEdgeIdStatuscode**](docs/Api/TelephonyProvidersEdgeApi.md#posttelephonyprovidersedgesedgeidstatuscode) | **POST** /api/v2/telephony/providers/edges/{edgeId}/statuscode | Take an Edge in or out of service
*TelephonyProvidersEdgeApi* | [**postTelephonyProvidersEdgesEdgeIdUnpair**](docs/Api/TelephonyProvidersEdgeApi.md#posttelephonyprovidersedgesedgeidunpair) | **POST** /api/v2/telephony/providers/edges/{edgeId}/unpair | Unpair an Edge
*TelephonyProvidersEdgeApi* | [**postTelephonyProvidersEdgesEdgegroups**](docs/Api/TelephonyProvidersEdgeApi.md#posttelephonyprovidersedgesedgegroups) | **POST** /api/v2/telephony/providers/edges/edgegroups | Create an edge group.
*TelephonyProvidersEdgeApi* | [**postTelephonyProvidersEdgesEndpoints**](docs/Api/TelephonyProvidersEdgeApi.md#posttelephonyprovidersedgesendpoints) | **POST** /api/v2/telephony/providers/edges/endpoints | Create endpoint
*TelephonyProvidersEdgeApi* | [**postTelephonyProvidersEdgesExtensionpools**](docs/Api/TelephonyProvidersEdgeApi.md#posttelephonyprovidersedgesextensionpools) | **POST** /api/v2/telephony/providers/edges/extensionpools | Create a new extension pool
*TelephonyProvidersEdgeApi* | [**postTelephonyProvidersEdgesOfflineconfiguration**](docs/Api/TelephonyProvidersEdgeApi.md#posttelephonyprovidersedgesofflineconfiguration) | **POST** /api/v2/telephony/providers/edges/offlineconfiguration | Create a file that can be used to configure a hardware Edge&#39;s settings.
*TelephonyProvidersEdgeApi* | [**postTelephonyProvidersEdgesOutboundroutes**](docs/Api/TelephonyProvidersEdgeApi.md#posttelephonyprovidersedgesoutboundroutes) | **POST** /api/v2/telephony/providers/edges/outboundroutes | Create outbound rule
*TelephonyProvidersEdgeApi* | [**postTelephonyProvidersEdgesPhonebasesettings**](docs/Api/TelephonyProvidersEdgeApi.md#posttelephonyprovidersedgesphonebasesettings) | **POST** /api/v2/telephony/providers/edges/phonebasesettings | Create a new Phone Base Settings object
*TelephonyProvidersEdgeApi* | [**postTelephonyProvidersEdgesPhones**](docs/Api/TelephonyProvidersEdgeApi.md#posttelephonyprovidersedgesphones) | **POST** /api/v2/telephony/providers/edges/phones | Create a new Phone
*TelephonyProvidersEdgeApi* | [**postTelephonyProvidersEdgesPhonesPhoneIdReboot**](docs/Api/TelephonyProvidersEdgeApi.md#posttelephonyprovidersedgesphonesphoneidreboot) | **POST** /api/v2/telephony/providers/edges/phones/{phoneId}/reboot | Reboot a Phone
*TelephonyProvidersEdgeApi* | [**postTelephonyProvidersEdgesPhonesReboot**](docs/Api/TelephonyProvidersEdgeApi.md#posttelephonyprovidersedgesphonesreboot) | **POST** /api/v2/telephony/providers/edges/phones/reboot | Reboot Multiple Phones
*TelephonyProvidersEdgeApi* | [**postTelephonyProvidersEdgesSites**](docs/Api/TelephonyProvidersEdgeApi.md#posttelephonyprovidersedgessites) | **POST** /api/v2/telephony/providers/edges/sites | Create a Site.
*TelephonyProvidersEdgeApi* | [**postTelephonyProvidersEdgesSitesSiteIdOutboundroutes**](docs/Api/TelephonyProvidersEdgeApi.md#posttelephonyprovidersedgessitessiteidoutboundroutes) | **POST** /api/v2/telephony/providers/edges/sites/{siteId}/outboundroutes | Create outbound route
*TelephonyProvidersEdgeApi* | [**postTelephonyProvidersEdgesSitesSiteIdRebalance**](docs/Api/TelephonyProvidersEdgeApi.md#posttelephonyprovidersedgessitessiteidrebalance) | **POST** /api/v2/telephony/providers/edges/sites/{siteId}/rebalance | Triggers the rebalance operation.
*TelephonyProvidersEdgeApi* | [**postTelephonyProvidersEdgesTrunkbasesettings**](docs/Api/TelephonyProvidersEdgeApi.md#posttelephonyprovidersedgestrunkbasesettings) | **POST** /api/v2/telephony/providers/edges/trunkbasesettings | Create a Trunk Base Settings object
*TelephonyProvidersEdgeApi* | [**putTelephonyProvidersEdgesCertificateauthoritiesCertificateId**](docs/Api/TelephonyProvidersEdgeApi.md#puttelephonyprovidersedgescertificateauthoritiescertificateid) | **PUT** /api/v2/telephony/providers/edges/certificateauthorities/{certificateId} | Update a certificate authority.
*TelephonyProvidersEdgeApi* | [**putTelephonyProvidersEdgesDidpoolsDidpoolId**](docs/Api/TelephonyProvidersEdgeApi.md#puttelephonyprovidersedgesdidpoolsdidpoolid) | **PUT** /api/v2/telephony/providers/edges/didpools/{didPoolId} | Update a DID Pool by ID.
*TelephonyProvidersEdgeApi* | [**putTelephonyProvidersEdgesDidsDidId**](docs/Api/TelephonyProvidersEdgeApi.md#puttelephonyprovidersedgesdidsdidid) | **PUT** /api/v2/telephony/providers/edges/dids/{didId} | Update a DID by ID.
*TelephonyProvidersEdgeApi* | [**putTelephonyProvidersEdgesEdgeId**](docs/Api/TelephonyProvidersEdgeApi.md#puttelephonyprovidersedgesedgeid) | **PUT** /api/v2/telephony/providers/edges/{edgeId} | Update a edge.
*TelephonyProvidersEdgeApi* | [**putTelephonyProvidersEdgesEdgeIdLinesLineId**](docs/Api/TelephonyProvidersEdgeApi.md#puttelephonyprovidersedgesedgeidlineslineid) | **PUT** /api/v2/telephony/providers/edges/{edgeId}/lines/{lineId} | Update a line.
*TelephonyProvidersEdgeApi* | [**putTelephonyProvidersEdgesEdgeIdLogicalinterfacesInterfaceId**](docs/Api/TelephonyProvidersEdgeApi.md#puttelephonyprovidersedgesedgeidlogicalinterfacesinterfaceid) | **PUT** /api/v2/telephony/providers/edges/{edgeId}/logicalinterfaces/{interfaceId} | Update an edge logical interface.
*TelephonyProvidersEdgeApi* | [**putTelephonyProvidersEdgesEdgegroupsEdgegroupId**](docs/Api/TelephonyProvidersEdgeApi.md#puttelephonyprovidersedgesedgegroupsedgegroupid) | **PUT** /api/v2/telephony/providers/edges/edgegroups/{edgeGroupId} | Update an edge group.
*TelephonyProvidersEdgeApi* | [**putTelephonyProvidersEdgesEndpointsEndpointId**](docs/Api/TelephonyProvidersEdgeApi.md#puttelephonyprovidersedgesendpointsendpointid) | **PUT** /api/v2/telephony/providers/edges/endpoints/{endpointId} | Update endpoint
*TelephonyProvidersEdgeApi* | [**putTelephonyProvidersEdgesExtensionpoolsExtensionpoolId**](docs/Api/TelephonyProvidersEdgeApi.md#puttelephonyprovidersedgesextensionpoolsextensionpoolid) | **PUT** /api/v2/telephony/providers/edges/extensionpools/{extensionPoolId} | Update an extension pool by ID
*TelephonyProvidersEdgeApi* | [**putTelephonyProvidersEdgesExtensionsExtensionId**](docs/Api/TelephonyProvidersEdgeApi.md#puttelephonyprovidersedgesextensionsextensionid) | **PUT** /api/v2/telephony/providers/edges/extensions/{extensionId} | Update an extension by ID.
*TelephonyProvidersEdgeApi* | [**putTelephonyProvidersEdgesOutboundroutesOutboundrouteId**](docs/Api/TelephonyProvidersEdgeApi.md#puttelephonyprovidersedgesoutboundroutesoutboundrouteid) | **PUT** /api/v2/telephony/providers/edges/outboundroutes/{outboundRouteId} | Update outbound route
*TelephonyProvidersEdgeApi* | [**putTelephonyProvidersEdgesPhonebasesettingsPhonebaseId**](docs/Api/TelephonyProvidersEdgeApi.md#puttelephonyprovidersedgesphonebasesettingsphonebaseid) | **PUT** /api/v2/telephony/providers/edges/phonebasesettings/{phoneBaseId} | Update a Phone Base Settings by ID
*TelephonyProvidersEdgeApi* | [**putTelephonyProvidersEdgesPhonesPhoneId**](docs/Api/TelephonyProvidersEdgeApi.md#puttelephonyprovidersedgesphonesphoneid) | **PUT** /api/v2/telephony/providers/edges/phones/{phoneId} | Update a Phone by ID
*TelephonyProvidersEdgeApi* | [**putTelephonyProvidersEdgesSitesSiteId**](docs/Api/TelephonyProvidersEdgeApi.md#puttelephonyprovidersedgessitessiteid) | **PUT** /api/v2/telephony/providers/edges/sites/{siteId} | Update a Site by ID.
*TelephonyProvidersEdgeApi* | [**putTelephonyProvidersEdgesSitesSiteIdNumberplans**](docs/Api/TelephonyProvidersEdgeApi.md#puttelephonyprovidersedgessitessiteidnumberplans) | **PUT** /api/v2/telephony/providers/edges/sites/{siteId}/numberplans | Update the list of Number Plans.
*TelephonyProvidersEdgeApi* | [**putTelephonyProvidersEdgesSitesSiteIdOutboundroutesOutboundrouteId**](docs/Api/TelephonyProvidersEdgeApi.md#puttelephonyprovidersedgessitessiteidoutboundroutesoutboundrouteid) | **PUT** /api/v2/telephony/providers/edges/sites/{siteId}/outboundroutes/{outboundRouteId} | Update outbound route
*TelephonyProvidersEdgeApi* | [**putTelephonyProvidersEdgesTrunkbasesettingsTrunkbasesettingsId**](docs/Api/TelephonyProvidersEdgeApi.md#puttelephonyprovidersedgestrunkbasesettingstrunkbasesettingsid) | **PUT** /api/v2/telephony/providers/edges/trunkbasesettings/{trunkBaseSettingsId} | Update a Trunk Base Settings object by ID
*TokensApi* | [**deleteTokensMe**](docs/Api/TokensApi.md#deletetokensme) | **DELETE** /api/v2/tokens/me | Delete  auth token used to make the request.
*UserRecordingsApi* | [**deleteUserrecordingsRecordingId**](docs/Api/UserRecordingsApi.md#deleteuserrecordingsrecordingid) | **DELETE** /api/v2/userrecordings/{recordingId} | Delete a user recording.
*UserRecordingsApi* | [**getUserrecordings**](docs/Api/UserRecordingsApi.md#getuserrecordings) | **GET** /api/v2/userrecordings | Get a list of user recordings.
*UserRecordingsApi* | [**getUserrecordingsRecordingId**](docs/Api/UserRecordingsApi.md#getuserrecordingsrecordingid) | **GET** /api/v2/userrecordings/{recordingId} | Get a user recording.
*UserRecordingsApi* | [**getUserrecordingsRecordingIdMedia**](docs/Api/UserRecordingsApi.md#getuserrecordingsrecordingidmedia) | **GET** /api/v2/userrecordings/{recordingId}/media | Download a user recording.
*UserRecordingsApi* | [**getUserrecordingsSummary**](docs/Api/UserRecordingsApi.md#getuserrecordingssummary) | **GET** /api/v2/userrecordings/summary | Get user recording summary
*UserRecordingsApi* | [**putUserrecordingsRecordingId**](docs/Api/UserRecordingsApi.md#putuserrecordingsrecordingid) | **PUT** /api/v2/userrecordings/{recordingId} | Update a user recording.
*UsersApi* | [**deleteUsersUserId**](docs/Api/UsersApi.md#deleteusersuserid) | **DELETE** /api/v2/users/{userId} | Delete user
*UsersApi* | [**deleteUsersUserIdRoles**](docs/Api/UsersApi.md#deleteusersuseridroles) | **DELETE** /api/v2/users/{userId}/roles | Removes all the roles from the user.
*UsersApi* | [**deleteUsersUserIdRoutingskillsSkillId**](docs/Api/UsersApi.md#deleteusersuseridroutingskillsskillid) | **DELETE** /api/v2/users/{userId}/routingskills/{skillId} | Remove routing skill from user
*UsersApi* | [**deleteUsersUserIdStationAssociatedstation**](docs/Api/UsersApi.md#deleteusersuseridstationassociatedstation) | **DELETE** /api/v2/users/{userId}/station/associatedstation | Clear associated station
*UsersApi* | [**deleteUsersUserIdStationDefaultstation**](docs/Api/UsersApi.md#deleteusersuseridstationdefaultstation) | **DELETE** /api/v2/users/{userId}/station/defaultstation | Clear default station
*UsersApi* | [**getFieldconfig**](docs/Api/UsersApi.md#getfieldconfig) | **GET** /api/v2/fieldconfig | Fetch field config for an entity type
*UsersApi* | [**getUsers**](docs/Api/UsersApi.md#getusers) | **GET** /api/v2/users | Get the list of available users.
*UsersApi* | [**getUsersMe**](docs/Api/UsersApi.md#getusersme) | **GET** /api/v2/users/me | Get current user details.
*UsersApi* | [**getUsersSearch**](docs/Api/UsersApi.md#getuserssearch) | **GET** /api/v2/users/search | Search users using the q64 value returned from a previous search
*UsersApi* | [**getUsersUserId**](docs/Api/UsersApi.md#getusersuserid) | **GET** /api/v2/users/{userId} | Get user.
*UsersApi* | [**getUsersUserIdAdjacents**](docs/Api/UsersApi.md#getusersuseridadjacents) | **GET** /api/v2/users/{userId}/adjacents | Get adjacents
*UsersApi* | [**getUsersUserIdCallforwarding**](docs/Api/UsersApi.md#getusersuseridcallforwarding) | **GET** /api/v2/users/{userId}/callforwarding | Get a user&#39;s CallForwarding
*UsersApi* | [**getUsersUserIdDirectreports**](docs/Api/UsersApi.md#getusersuseriddirectreports) | **GET** /api/v2/users/{userId}/directreports | Get direct reports
*UsersApi* | [**getUsersUserIdFavorites**](docs/Api/UsersApi.md#getusersuseridfavorites) | **GET** /api/v2/users/{userId}/favorites | Get favorites
*UsersApi* | [**getUsersUserIdGeolocationsClientId**](docs/Api/UsersApi.md#getusersuseridgeolocationsclientid) | **GET** /api/v2/users/{userId}/geolocations/{clientId} | Get a user&#39;s Geolocation
*UsersApi* | [**getUsersUserIdOutofoffice**](docs/Api/UsersApi.md#getusersuseridoutofoffice) | **GET** /api/v2/users/{userId}/outofoffice | Get a OutOfOffice
*UsersApi* | [**getUsersUserIdProfileskills**](docs/Api/UsersApi.md#getusersuseridprofileskills) | **GET** /api/v2/users/{userId}/profileskills | List profile skills for a user
*UsersApi* | [**getUsersUserIdQueues**](docs/Api/UsersApi.md#getusersuseridqueues) | **GET** /api/v2/users/{userId}/queues | Get queues for user
*UsersApi* | [**getUsersUserIdRoles**](docs/Api/UsersApi.md#getusersuseridroles) | **GET** /api/v2/users/{userId}/roles | Returns a listing of roles and permissions for a user.
*UsersApi* | [**getUsersUserIdRoutingskills**](docs/Api/UsersApi.md#getusersuseridroutingskills) | **GET** /api/v2/users/{userId}/routingskills | List routing skills for user
*UsersApi* | [**getUsersUserIdRoutingstatus**](docs/Api/UsersApi.md#getusersuseridroutingstatus) | **GET** /api/v2/users/{userId}/routingstatus | Fetch the routing status of a user
*UsersApi* | [**getUsersUserIdStation**](docs/Api/UsersApi.md#getusersuseridstation) | **GET** /api/v2/users/{userId}/station | Get station information for user
*UsersApi* | [**getUsersUserIdSuperiors**](docs/Api/UsersApi.md#getusersuseridsuperiors) | **GET** /api/v2/users/{userId}/superiors | Get superiors
*UsersApi* | [**patchUsersUserId**](docs/Api/UsersApi.md#patchusersuserid) | **PATCH** /api/v2/users/{userId} | Update user
*UsersApi* | [**patchUsersUserIdCallforwarding**](docs/Api/UsersApi.md#patchusersuseridcallforwarding) | **PATCH** /api/v2/users/{userId}/callforwarding | Patch a user&#39;s CallForwarding
*UsersApi* | [**patchUsersUserIdGeolocationsClientId**](docs/Api/UsersApi.md#patchusersuseridgeolocationsclientid) | **PATCH** /api/v2/users/{userId}/geolocations/{clientId} | Patch a user&#39;s Geolocation
*UsersApi* | [**patchUsersUserIdQueues**](docs/Api/UsersApi.md#patchusersuseridqueues) | **PATCH** /api/v2/users/{userId}/queues | Join or unjoin a set of queues for a user
*UsersApi* | [**patchUsersUserIdQueuesQueueId**](docs/Api/UsersApi.md#patchusersuseridqueuesqueueid) | **PATCH** /api/v2/users/{userId}/queues/{queueId} | Join or unjoin a queue for a user
*UsersApi* | [**postAnalyticsUsersAggregatesQuery**](docs/Api/UsersApi.md#postanalyticsusersaggregatesquery) | **POST** /api/v2/analytics/users/aggregates/query | Query for user aggregates
*UsersApi* | [**postAnalyticsUsersDetailsQuery**](docs/Api/UsersApi.md#postanalyticsusersdetailsquery) | **POST** /api/v2/analytics/users/details/query | Query for user details
*UsersApi* | [**postAnalyticsUsersObservationsQuery**](docs/Api/UsersApi.md#postanalyticsusersobservationsquery) | **POST** /api/v2/analytics/users/observations/query | Query for user observations
*UsersApi* | [**postUsers**](docs/Api/UsersApi.md#postusers) | **POST** /api/v2/users | Create user
*UsersApi* | [**postUsersSearch**](docs/Api/UsersApi.md#postuserssearch) | **POST** /api/v2/users/search | Search users
*UsersApi* | [**postUsersUserIdRoutingskills**](docs/Api/UsersApi.md#postusersuseridroutingskills) | **POST** /api/v2/users/{userId}/routingskills | Add routing skill to user
*UsersApi* | [**putUsersUserIdCallforwarding**](docs/Api/UsersApi.md#putusersuseridcallforwarding) | **PUT** /api/v2/users/{userId}/callforwarding | Update a user&#39;s CallForwarding
*UsersApi* | [**putUsersUserIdOutofoffice**](docs/Api/UsersApi.md#putusersuseridoutofoffice) | **PUT** /api/v2/users/{userId}/outofoffice | Update an OutOfOffice
*UsersApi* | [**putUsersUserIdProfileskills**](docs/Api/UsersApi.md#putusersuseridprofileskills) | **PUT** /api/v2/users/{userId}/profileskills | Update profile skills for a user
*UsersApi* | [**putUsersUserIdRoles**](docs/Api/UsersApi.md#putusersuseridroles) | **PUT** /api/v2/users/{userId}/roles | Sets the user&#39;s roles
*UsersApi* | [**putUsersUserIdRoutingskillsSkillId**](docs/Api/UsersApi.md#putusersuseridroutingskillsskillid) | **PUT** /api/v2/users/{userId}/routingskills/{skillId} | Update routing skill proficiency or state.
*UsersApi* | [**putUsersUserIdRoutingstatus**](docs/Api/UsersApi.md#putusersuseridroutingstatus) | **PUT** /api/v2/users/{userId}/routingstatus | Update the routing status of a user
*UsersApi* | [**putUsersUserIdStationAssociatedstationStationId**](docs/Api/UsersApi.md#putusersuseridstationassociatedstationstationid) | **PUT** /api/v2/users/{userId}/station/associatedstation/{stationId} | Set associated station
*UsersApi* | [**putUsersUserIdStationDefaultstationStationId**](docs/Api/UsersApi.md#putusersuseridstationdefaultstationstationid) | **PUT** /api/v2/users/{userId}/station/defaultstation/{stationId} | Set default station
*UtilitiesApi* | [**getDate**](docs/Api/UtilitiesApi.md#getdate) | **GET** /api/v2/date | Get the current system date/time
*UtilitiesApi* | [**getTimezones**](docs/Api/UtilitiesApi.md#gettimezones) | **GET** /api/v2/timezones | Get time zones list
*UtilitiesApi* | [**postCertificateDetails**](docs/Api/UtilitiesApi.md#postcertificatedetails) | **POST** /api/v2/certificate/details | Returns the information about an X509 PEM encoded certificate or certificate chain.
*VoicemailApi* | [**deleteVoicemailMessages**](docs/Api/VoicemailApi.md#deletevoicemailmessages) | **DELETE** /api/v2/voicemail/messages | Delete all voicemail messages
*VoicemailApi* | [**deleteVoicemailMessagesMessageId**](docs/Api/VoicemailApi.md#deletevoicemailmessagesmessageid) | **DELETE** /api/v2/voicemail/messages/{messageId} | Delete a message.
*VoicemailApi* | [**getVoicemailGroupsGroupIdMailbox**](docs/Api/VoicemailApi.md#getvoicemailgroupsgroupidmailbox) | **GET** /api/v2/voicemail/groups/{groupId}/mailbox | Get the group&#39;s mailbox information
*VoicemailApi* | [**getVoicemailGroupsGroupIdMessages**](docs/Api/VoicemailApi.md#getvoicemailgroupsgroupidmessages) | **GET** /api/v2/voicemail/groups/{groupId}/messages | List voicemail messages
*VoicemailApi* | [**getVoicemailGroupsGroupIdPolicy**](docs/Api/VoicemailApi.md#getvoicemailgroupsgroupidpolicy) | **GET** /api/v2/voicemail/groups/{groupId}/policy | Get a group&#39;s voicemail policy
*VoicemailApi* | [**getVoicemailMailbox**](docs/Api/VoicemailApi.md#getvoicemailmailbox) | **GET** /api/v2/voicemail/mailbox | Get the current user&#39;s mailbox information
*VoicemailApi* | [**getVoicemailMeMailbox**](docs/Api/VoicemailApi.md#getvoicemailmemailbox) | **GET** /api/v2/voicemail/me/mailbox | Get the current user&#39;s mailbox information
*VoicemailApi* | [**getVoicemailMeMessages**](docs/Api/VoicemailApi.md#getvoicemailmemessages) | **GET** /api/v2/voicemail/me/messages | List voicemail messages
*VoicemailApi* | [**getVoicemailMePolicy**](docs/Api/VoicemailApi.md#getvoicemailmepolicy) | **GET** /api/v2/voicemail/me/policy | Get the current user&#39;s voicemail policy
*VoicemailApi* | [**getVoicemailMessages**](docs/Api/VoicemailApi.md#getvoicemailmessages) | **GET** /api/v2/voicemail/messages | List voicemail messages
*VoicemailApi* | [**getVoicemailMessagesMessageId**](docs/Api/VoicemailApi.md#getvoicemailmessagesmessageid) | **GET** /api/v2/voicemail/messages/{messageId} | Get message.
*VoicemailApi* | [**getVoicemailMessagesMessageIdMedia**](docs/Api/VoicemailApi.md#getvoicemailmessagesmessageidmedia) | **GET** /api/v2/voicemail/messages/{messageId}/media | Get media playback URI for this message
*VoicemailApi* | [**getVoicemailPolicy**](docs/Api/VoicemailApi.md#getvoicemailpolicy) | **GET** /api/v2/voicemail/policy | Get a policy
*VoicemailApi* | [**getVoicemailSearch**](docs/Api/VoicemailApi.md#getvoicemailsearch) | **GET** /api/v2/voicemail/search | Search voicemails using the q64 value returned from a previous search
*VoicemailApi* | [**getVoicemailUserpoliciesUserId**](docs/Api/VoicemailApi.md#getvoicemailuserpoliciesuserid) | **GET** /api/v2/voicemail/userpolicies/{userId} | Get a user&#39;s voicemail policy
*VoicemailApi* | [**patchVoicemailGroupsGroupIdPolicy**](docs/Api/VoicemailApi.md#patchvoicemailgroupsgroupidpolicy) | **PATCH** /api/v2/voicemail/groups/{groupId}/policy | Update a group&#39;s voicemail policy
*VoicemailApi* | [**patchVoicemailMePolicy**](docs/Api/VoicemailApi.md#patchvoicemailmepolicy) | **PATCH** /api/v2/voicemail/me/policy | Update the current user&#39;s voicemail policy
*VoicemailApi* | [**patchVoicemailUserpoliciesUserId**](docs/Api/VoicemailApi.md#patchvoicemailuserpoliciesuserid) | **PATCH** /api/v2/voicemail/userpolicies/{userId} | Update a user&#39;s voicemail policy
*VoicemailApi* | [**postVoicemailMessages**](docs/Api/VoicemailApi.md#postvoicemailmessages) | **POST** /api/v2/voicemail/messages | Copy a voicemail message to a user or group
*VoicemailApi* | [**postVoicemailSearch**](docs/Api/VoicemailApi.md#postvoicemailsearch) | **POST** /api/v2/voicemail/search | Search voicemails
*VoicemailApi* | [**putVoicemailMessagesMessageId**](docs/Api/VoicemailApi.md#putvoicemailmessagesmessageid) | **PUT** /api/v2/voicemail/messages/{messageId} | Update a message.
*VoicemailApi* | [**putVoicemailPolicy**](docs/Api/VoicemailApi.md#putvoicemailpolicy) | **PUT** /api/v2/voicemail/policy | Update a policy
*WorkforceManagementApi* | [**getWorkforcemanagementAdherence**](docs/Api/WorkforceManagementApi.md#getworkforcemanagementadherence) | **GET** /api/v2/workforcemanagement/adherence | Get a list of UserScheduleAdherence records for the requested users
*WorkforceManagementApi* | [**getWorkforcemanagementManagementunits**](docs/Api/WorkforceManagementApi.md#getworkforcemanagementmanagementunits) | **GET** /api/v2/workforcemanagement/managementunits | Get management units
*WorkforceManagementApi* | [**getWorkforcemanagementManagementunitsMuIdActivitycodes**](docs/Api/WorkforceManagementApi.md#getworkforcemanagementmanagementunitsmuidactivitycodes) | **GET** /api/v2/workforcemanagement/managementunits/{muId}/activitycodes | Get activity codes corresponding to a management unit
*WorkforceManagementApi* | [**getWorkforcemanagementManagementunitsMuIdUsers**](docs/Api/WorkforceManagementApi.md#getworkforcemanagementmanagementunitsmuidusers) | **GET** /api/v2/workforcemanagement/managementunits/{muId}/users | Get agents in the management unit
*WorkforceManagementApi* | [**getWorkforcemanagementManagementunitsMuIdUsersUserIdTimeoffrequests**](docs/Api/WorkforceManagementApi.md#getworkforcemanagementmanagementunitsmuidusersuseridtimeoffrequests) | **GET** /api/v2/workforcemanagement/managementunits/{muId}/users/{userId}/timeoffrequests | Get a list of time off requests for any user
*WorkforceManagementApi* | [**getWorkforcemanagementManagementunitsMuIdUsersUserIdTimeoffrequestsTimeoffrequestId**](docs/Api/WorkforceManagementApi.md#getworkforcemanagementmanagementunitsmuidusersuseridtimeoffrequeststimeoffrequestid) | **GET** /api/v2/workforcemanagement/managementunits/{muId}/users/{userId}/timeoffrequests/{timeOffRequestId} | Get a time off request by id
*WorkforceManagementApi* | [**getWorkforcemanagementTimeoffrequests**](docs/Api/WorkforceManagementApi.md#getworkforcemanagementtimeoffrequests) | **GET** /api/v2/workforcemanagement/timeoffrequests | Get a list of time off requests for the current user
*WorkforceManagementApi* | [**getWorkforcemanagementTimeoffrequestsTimeoffrequestId**](docs/Api/WorkforceManagementApi.md#getworkforcemanagementtimeoffrequeststimeoffrequestid) | **GET** /api/v2/workforcemanagement/timeoffrequests/{timeOffRequestId} | Get a time off request for the current user by id
*WorkforceManagementApi* | [**patchWorkforcemanagementTimeoffrequestsTimeoffrequestId**](docs/Api/WorkforceManagementApi.md#patchworkforcemanagementtimeoffrequeststimeoffrequestid) | **PATCH** /api/v2/workforcemanagement/timeoffrequests/{timeOffRequestId} | Mark a time off request for the current user as read or unread
*WorkforceManagementApi* | [**postWorkforcemanagementManagementunitsMuIdSchedulesSearch**](docs/Api/WorkforceManagementApi.md#postworkforcemanagementmanagementunitsmuidschedulessearch) | **POST** /api/v2/workforcemanagement/managementunits/{muId}/schedules/search | Get user schedules within the given time range
*WorkforceManagementApi* | [**postWorkforcemanagementSchedules**](docs/Api/WorkforceManagementApi.md#postworkforcemanagementschedules) | **POST** /api/v2/workforcemanagement/schedules | Get a schedule for the current user


## Documentation For Models

 - [ADFS](docs/Model/ADFS.md)
 - [Actions](docs/Model/Actions.md)
 - [ActivityCode](docs/Model/ActivityCode.md)
 - [ActivityCodeContainer](docs/Model/ActivityCodeContainer.md)
 - [AcwSettings](docs/Model/AcwSettings.md)
 - [Address](docs/Model/Address.md)
 - [Adjacents](docs/Model/Adjacents.md)
 - [Agent](docs/Model/Agent.md)
 - [AgentActivity](docs/Model/AgentActivity.md)
 - [AgentActivityEntityListing](docs/Model/AgentActivityEntityListing.md)
 - [AgentEvaluatorActivity](docs/Model/AgentEvaluatorActivity.md)
 - [AggregateDataContainer](docs/Model/AggregateDataContainer.md)
 - [AggregateMetricData](docs/Model/AggregateMetricData.md)
 - [AggregateQueryResponse](docs/Model/AggregateQueryResponse.md)
 - [AggregateViewData](docs/Model/AggregateViewData.md)
 - [AggregationQuery](docs/Model/AggregationQuery.md)
 - [AggregationRange](docs/Model/AggregationRange.md)
 - [AggregationResult](docs/Model/AggregationResult.md)
 - [AggregationResultEntry](docs/Model/AggregationResultEntry.md)
 - [AnalyticsConversation](docs/Model/AnalyticsConversation.md)
 - [AnalyticsConversationQueryResponse](docs/Model/AnalyticsConversationQueryResponse.md)
 - [AnalyticsConversationSegment](docs/Model/AnalyticsConversationSegment.md)
 - [AnalyticsEvaluation](docs/Model/AnalyticsEvaluation.md)
 - [AnalyticsParticipant](docs/Model/AnalyticsParticipant.md)
 - [AnalyticsProperty](docs/Model/AnalyticsProperty.md)
 - [AnalyticsQueryAggregation](docs/Model/AnalyticsQueryAggregation.md)
 - [AnalyticsQueryClause](docs/Model/AnalyticsQueryClause.md)
 - [AnalyticsQueryFilter](docs/Model/AnalyticsQueryFilter.md)
 - [AnalyticsQueryPredicate](docs/Model/AnalyticsQueryPredicate.md)
 - [AnalyticsRoutingStatusRecord](docs/Model/AnalyticsRoutingStatusRecord.md)
 - [AnalyticsSession](docs/Model/AnalyticsSession.md)
 - [AnalyticsUserDetail](docs/Model/AnalyticsUserDetail.md)
 - [AnalyticsUserDetailsQueryResponse](docs/Model/AnalyticsUserDetailsQueryResponse.md)
 - [AnalyticsUserPresenceRecord](docs/Model/AnalyticsUserPresenceRecord.md)
 - [AnalyticsView](docs/Model/AnalyticsView.md)
 - [Annotation](docs/Model/Annotation.md)
 - [AnswerOption](docs/Model/AnswerOption.md)
 - [ArchiveRetention](docs/Model/ArchiveRetention.md)
 - [Attachment](docs/Model/Attachment.md)
 - [AttemptLimits](docs/Model/AttemptLimits.md)
 - [AttemptLimitsEntityListing](docs/Model/AttemptLimitsEntityListing.md)
 - [Attribute](docs/Model/Attribute.md)
 - [AttributeEntityListing](docs/Model/AttributeEntityListing.md)
 - [AttributeFilterItem](docs/Model/AttributeFilterItem.md)
 - [AttributeQueryRequest](docs/Model/AttributeQueryRequest.md)
 - [AuditChange](docs/Model/AuditChange.md)
 - [AuditEntity](docs/Model/AuditEntity.md)
 - [AuditEntityReference](docs/Model/AuditEntityReference.md)
 - [AuditFacet](docs/Model/AuditFacet.md)
 - [AuditFilter](docs/Model/AuditFilter.md)
 - [AuditMessage](docs/Model/AuditMessage.md)
 - [AuditSearchResult](docs/Model/AuditSearchResult.md)
 - [AuditUser](docs/Model/AuditUser.md)
 - [AvailableLanguageList](docs/Model/AvailableLanguageList.md)
 - [AvailableTopic](docs/Model/AvailableTopic.md)
 - [AvailableTopicEntityListing](docs/Model/AvailableTopicEntityListing.md)
 - [AvailableTranslations](docs/Model/AvailableTranslations.md)
 - [Bullseye](docs/Model/Bullseye.md)
 - [Calibration](docs/Model/Calibration.md)
 - [CalibrationAssignment](docs/Model/CalibrationAssignment.md)
 - [CalibrationCreate](docs/Model/CalibrationCreate.md)
 - [CalibrationEntityListing](docs/Model/CalibrationEntityListing.md)
 - [Call](docs/Model/Call.md)
 - [CallBasic](docs/Model/CallBasic.md)
 - [CallCommand](docs/Model/CallCommand.md)
 - [CallConversation](docs/Model/CallConversation.md)
 - [CallConversationEntityListing](docs/Model/CallConversationEntityListing.md)
 - [CallForwarding](docs/Model/CallForwarding.md)
 - [CallMediaParticipant](docs/Model/CallMediaParticipant.md)
 - [CallMediaPolicy](docs/Model/CallMediaPolicy.md)
 - [CallMediaPolicyConditions](docs/Model/CallMediaPolicyConditions.md)
 - [CallRecord](docs/Model/CallRecord.md)
 - [CallableContactsDiagnostic](docs/Model/CallableContactsDiagnostic.md)
 - [CallableTime](docs/Model/CallableTime.md)
 - [CallableTimeSet](docs/Model/CallableTimeSet.md)
 - [CallableTimeSetEntityListing](docs/Model/CallableTimeSetEntityListing.md)
 - [Callback](docs/Model/Callback.md)
 - [CallbackBasic](docs/Model/CallbackBasic.md)
 - [CallbackConversation](docs/Model/CallbackConversation.md)
 - [CallbackConversationEntityListing](docs/Model/CallbackConversationEntityListing.md)
 - [CallbackIdentifier](docs/Model/CallbackIdentifier.md)
 - [CallbackMediaParticipant](docs/Model/CallbackMediaParticipant.md)
 - [Campaign](docs/Model/Campaign.md)
 - [CampaignDiagnostics](docs/Model/CampaignDiagnostics.md)
 - [CampaignEntityListing](docs/Model/CampaignEntityListing.md)
 - [CampaignInteraction](docs/Model/CampaignInteraction.md)
 - [CampaignInteractions](docs/Model/CampaignInteractions.md)
 - [CampaignProgress](docs/Model/CampaignProgress.md)
 - [CampaignRule](docs/Model/CampaignRule.md)
 - [CampaignRuleAction](docs/Model/CampaignRuleAction.md)
 - [CampaignRuleActionEntities](docs/Model/CampaignRuleActionEntities.md)
 - [CampaignRuleCondition](docs/Model/CampaignRuleCondition.md)
 - [CampaignRuleEntities](docs/Model/CampaignRuleEntities.md)
 - [CampaignRuleEntityListing](docs/Model/CampaignRuleEntityListing.md)
 - [CampaignSchedule](docs/Model/CampaignSchedule.md)
 - [CampaignSequence](docs/Model/CampaignSequence.md)
 - [CampaignSequenceEntityListing](docs/Model/CampaignSequenceEntityListing.md)
 - [CampaignStats](docs/Model/CampaignStats.md)
 - [CampaignTimeSlot](docs/Model/CampaignTimeSlot.md)
 - [Certificate](docs/Model/Certificate.md)
 - [CertificateAuthorityEntityListing](docs/Model/CertificateAuthorityEntityListing.md)
 - [CertificateDetails](docs/Model/CertificateDetails.md)
 - [Change](docs/Model/Change.md)
 - [Channel](docs/Model/Channel.md)
 - [ChannelEntityListing](docs/Model/ChannelEntityListing.md)
 - [ChannelTopic](docs/Model/ChannelTopic.md)
 - [ChannelTopicEntityListing](docs/Model/ChannelTopicEntityListing.md)
 - [Chat](docs/Model/Chat.md)
 - [ChatConversation](docs/Model/ChatConversation.md)
 - [ChatConversationEntityListing](docs/Model/ChatConversationEntityListing.md)
 - [ChatMediaParticipant](docs/Model/ChatMediaParticipant.md)
 - [ChatMediaPolicy](docs/Model/ChatMediaPolicy.md)
 - [ChatMediaPolicyConditions](docs/Model/ChatMediaPolicyConditions.md)
 - [ChatMessage](docs/Model/ChatMessage.md)
 - [ChatMessageUser](docs/Model/ChatMessageUser.md)
 - [CobrowseConversation](docs/Model/CobrowseConversation.md)
 - [CobrowseConversationEntityListing](docs/Model/CobrowseConversationEntityListing.md)
 - [CobrowseMediaParticipant](docs/Model/CobrowseMediaParticipant.md)
 - [Cobrowsesession](docs/Model/Cobrowsesession.md)
 - [CommandStatus](docs/Model/CommandStatus.md)
 - [CommandStatusEntityListing](docs/Model/CommandStatusEntityListing.md)
 - [Condition](docs/Model/Condition.md)
 - [ConnectRate](docs/Model/ConnectRate.md)
 - [ConsultTransfer](docs/Model/ConsultTransfer.md)
 - [ConsultTransferResponse](docs/Model/ConsultTransferResponse.md)
 - [ConsultTransferUpdate](docs/Model/ConsultTransferUpdate.md)
 - [Contact](docs/Model/Contact.md)
 - [ContactCallbackRequest](docs/Model/ContactCallbackRequest.md)
 - [ContactList](docs/Model/ContactList.md)
 - [ContactListEntityListing](docs/Model/ContactListEntityListing.md)
 - [ContactPhoneNumberColumn](docs/Model/ContactPhoneNumberColumn.md)
 - [ContactSort](docs/Model/ContactSort.md)
 - [ContentAttributeFilterItem](docs/Model/ContentAttributeFilterItem.md)
 - [ContentFacetFilterItem](docs/Model/ContentFacetFilterItem.md)
 - [ContentFilterItem](docs/Model/ContentFilterItem.md)
 - [ContentQueryRequest](docs/Model/ContentQueryRequest.md)
 - [ContentSortItem](docs/Model/ContentSortItem.md)
 - [Conversation](docs/Model/Conversation.md)
 - [ConversationBasic](docs/Model/ConversationBasic.md)
 - [ConversationChat](docs/Model/ConversationChat.md)
 - [ConversationEntityListing](docs/Model/ConversationEntityListing.md)
 - [ConversationQuery](docs/Model/ConversationQuery.md)
 - [CopyVoicemailMessage](docs/Model/CopyVoicemailMessage.md)
 - [CoverSheet](docs/Model/CoverSheet.md)
 - [CreateCallRequest](docs/Model/CreateCallRequest.md)
 - [CreateCallResponse](docs/Model/CreateCallResponse.md)
 - [CreateCallbackCommand](docs/Model/CreateCallbackCommand.md)
 - [CreateCallbackResponse](docs/Model/CreateCallbackResponse.md)
 - [CreateEmailRequest](docs/Model/CreateEmailRequest.md)
 - [CreateQueueRequest](docs/Model/CreateQueueRequest.md)
 - [CreateShareRequest](docs/Model/CreateShareRequest.md)
 - [CreateShareRequestMember](docs/Model/CreateShareRequestMember.md)
 - [CreateShareResponse](docs/Model/CreateShareResponse.md)
 - [CreateUser](docs/Model/CreateUser.md)
 - [CreateWebChatRequest](docs/Model/CreateWebChatRequest.md)
 - [CurrentUserScheduleRequestBody](docs/Model/CurrentUserScheduleRequestBody.md)
 - [CustomerInteractionCenter](docs/Model/CustomerInteractionCenter.md)
 - [DID](docs/Model/DID.md)
 - [DIDEntityListing](docs/Model/DIDEntityListing.md)
 - [DIDPool](docs/Model/DIDPool.md)
 - [DIDPoolEntityListing](docs/Model/DIDPoolEntityListing.md)
 - [DefaultGreetingList](docs/Model/DefaultGreetingList.md)
 - [DeleteRetention](docs/Model/DeleteRetention.md)
 - [Destination](docs/Model/Destination.md)
 - [Detail](docs/Model/Detail.md)
 - [DialerAction](docs/Model/DialerAction.md)
 - [DialerAuditRequest](docs/Model/DialerAuditRequest.md)
 - [DialerContact](docs/Model/DialerContact.md)
 - [DialerPreview](docs/Model/DialerPreview.md)
 - [DialerRule](docs/Model/DialerRule.md)
 - [DigitLength](docs/Model/DigitLength.md)
 - [DisconnectReason](docs/Model/DisconnectReason.md)
 - [DncList](docs/Model/DncList.md)
 - [DncListEntityListing](docs/Model/DncListEntityListing.md)
 - [Document](docs/Model/Document.md)
 - [DocumentAttribute](docs/Model/DocumentAttribute.md)
 - [DocumentAudit](docs/Model/DocumentAudit.md)
 - [DocumentAuditEntityListing](docs/Model/DocumentAuditEntityListing.md)
 - [DocumentEntityListing](docs/Model/DocumentEntityListing.md)
 - [DocumentThumbnail](docs/Model/DocumentThumbnail.md)
 - [DocumentUpdate](docs/Model/DocumentUpdate.md)
 - [DocumentUpload](docs/Model/DocumentUpload.md)
 - [DomainCapabilities](docs/Model/DomainCapabilities.md)
 - [DomainCertificateAuthority](docs/Model/DomainCertificateAuthority.md)
 - [DomainEdgeSoftwareUpdateDto](docs/Model/DomainEdgeSoftwareUpdateDto.md)
 - [DomainEdgeSoftwareVersionDto](docs/Model/DomainEdgeSoftwareVersionDto.md)
 - [DomainEdgeSoftwareVersionDtoEntityListing](docs/Model/DomainEdgeSoftwareVersionDtoEntityListing.md)
 - [DomainEntity](docs/Model/DomainEntity.md)
 - [DomainEntityListing](docs/Model/DomainEntityListing.md)
 - [DomainEntityListingEvaluationForm](docs/Model/DomainEntityListingEvaluationForm.md)
 - [DomainEntityListingQueryResult](docs/Model/DomainEntityListingQueryResult.md)
 - [DomainLogicalInterface](docs/Model/DomainLogicalInterface.md)
 - [DomainNetworkAddress](docs/Model/DomainNetworkAddress.md)
 - [DomainNetworkCommandResponse](docs/Model/DomainNetworkCommandResponse.md)
 - [DomainNetworkRoute](docs/Model/DomainNetworkRoute.md)
 - [DomainOrgRoleDifference](docs/Model/DomainOrgRoleDifference.md)
 - [DomainOrganizationProduct](docs/Model/DomainOrganizationProduct.md)
 - [DomainOrganizationRole](docs/Model/DomainOrganizationRole.md)
 - [DomainOrganizationRoleCreate](docs/Model/DomainOrganizationRoleCreate.md)
 - [DomainOrganizationRoleUpdate](docs/Model/DomainOrganizationRoleUpdate.md)
 - [DomainPermission](docs/Model/DomainPermission.md)
 - [DomainPermissionCollection](docs/Model/DomainPermissionCollection.md)
 - [DomainPermissionPolicy](docs/Model/DomainPermissionPolicy.md)
 - [DomainPhysicalCapabilities](docs/Model/DomainPhysicalCapabilities.md)
 - [DomainPhysicalInterface](docs/Model/DomainPhysicalInterface.md)
 - [DomainResourceConditionNode](docs/Model/DomainResourceConditionNode.md)
 - [DomainResourceConditionValue](docs/Model/DomainResourceConditionValue.md)
 - [DomainRole](docs/Model/DomainRole.md)
 - [DomainSchemaReference](docs/Model/DomainSchemaReference.md)
 - [DownloadResponse](docs/Model/DownloadResponse.md)
 - [DurationCondition](docs/Model/DurationCondition.md)
 - [Edge](docs/Model/Edge.md)
 - [EdgeAutoUpdateConfig](docs/Model/EdgeAutoUpdateConfig.md)
 - [EdgeEntityListing](docs/Model/EdgeEntityListing.md)
 - [EdgeGroup](docs/Model/EdgeGroup.md)
 - [EdgeGroupEntityListing](docs/Model/EdgeGroupEntityListing.md)
 - [EdgeInterface](docs/Model/EdgeInterface.md)
 - [EdgeLine](docs/Model/EdgeLine.md)
 - [EdgeLineEntityListing](docs/Model/EdgeLineEntityListing.md)
 - [EdgeLogsJob](docs/Model/EdgeLogsJob.md)
 - [EdgeLogsJobFile](docs/Model/EdgeLogsJobFile.md)
 - [EdgeLogsJobRequest](docs/Model/EdgeLogsJobRequest.md)
 - [EdgeLogsJobResponse](docs/Model/EdgeLogsJobResponse.md)
 - [EdgeLogsJobUploadRequest](docs/Model/EdgeLogsJobUploadRequest.md)
 - [EdgeMetrics](docs/Model/EdgeMetrics.md)
 - [EdgeMetricsDisk](docs/Model/EdgeMetricsDisk.md)
 - [EdgeMetricsMemory](docs/Model/EdgeMetricsMemory.md)
 - [EdgeMetricsNetwork](docs/Model/EdgeMetricsNetwork.md)
 - [EdgeMetricsProcessor](docs/Model/EdgeMetricsProcessor.md)
 - [EdgeMetricsSubsystem](docs/Model/EdgeMetricsSubsystem.md)
 - [EdgeOfflineConfiguration](docs/Model/EdgeOfflineConfiguration.md)
 - [EdgeOfflineConfigurationInterface](docs/Model/EdgeOfflineConfigurationInterface.md)
 - [EdgeOfflineConfigurationNetwork](docs/Model/EdgeOfflineConfigurationNetwork.md)
 - [EdgeOfflineConfigurationResponse](docs/Model/EdgeOfflineConfigurationResponse.md)
 - [EdgeRebootParameters](docs/Model/EdgeRebootParameters.md)
 - [EdgeServiceStateRequest](docs/Model/EdgeServiceStateRequest.md)
 - [EdgeVersionInformation](docs/Model/EdgeVersionInformation.md)
 - [EdgeVersionReport](docs/Model/EdgeVersionReport.md)
 - [Email](docs/Model/Email.md)
 - [EmailAddress](docs/Model/EmailAddress.md)
 - [EmailAttachment](docs/Model/EmailAttachment.md)
 - [EmailConversation](docs/Model/EmailConversation.md)
 - [EmailConversationEntityListing](docs/Model/EmailConversationEntityListing.md)
 - [EmailMediaParticipant](docs/Model/EmailMediaParticipant.md)
 - [EmailMediaPolicy](docs/Model/EmailMediaPolicy.md)
 - [EmailMediaPolicyConditions](docs/Model/EmailMediaPolicyConditions.md)
 - [EmailMessage](docs/Model/EmailMessage.md)
 - [EmailMessageListing](docs/Model/EmailMessageListing.md)
 - [EmailSetup](docs/Model/EmailSetup.md)
 - [EncryptionKey](docs/Model/EncryptionKey.md)
 - [EncryptionKeyEntityListing](docs/Model/EncryptionKeyEntityListing.md)
 - [Endpoint](docs/Model/Endpoint.md)
 - [EndpointEntityListing](docs/Model/EndpointEntityListing.md)
 - [Entry](docs/Model/Entry.md)
 - [ErrorBody](docs/Model/ErrorBody.md)
 - [ErrorDetails](docs/Model/ErrorDetails.md)
 - [EstimatedWaitTimePredictions](docs/Model/EstimatedWaitTimePredictions.md)
 - [Evaluation](docs/Model/Evaluation.md)
 - [EvaluationAssignment](docs/Model/EvaluationAssignment.md)
 - [EvaluationEntityListing](docs/Model/EvaluationEntityListing.md)
 - [EvaluationForm](docs/Model/EvaluationForm.md)
 - [EvaluationFormAndScoringSet](docs/Model/EvaluationFormAndScoringSet.md)
 - [EvaluationFormEntityListing](docs/Model/EvaluationFormEntityListing.md)
 - [EvaluationScoringSet](docs/Model/EvaluationScoringSet.md)
 - [EvaluatorActivity](docs/Model/EvaluatorActivity.md)
 - [EvaluatorActivityEntityListing](docs/Model/EvaluatorActivityEntityListing.md)
 - [ExpansionCriterium](docs/Model/ExpansionCriterium.md)
 - [ExportUri](docs/Model/ExportUri.md)
 - [Extension](docs/Model/Extension.md)
 - [ExtensionEntityListing](docs/Model/ExtensionEntityListing.md)
 - [ExtensionPool](docs/Model/ExtensionPool.md)
 - [ExtensionPoolEntityListing](docs/Model/ExtensionPoolEntityListing.md)
 - [FacetEntry](docs/Model/FacetEntry.md)
 - [FacetInfo](docs/Model/FacetInfo.md)
 - [FacetKeyAttribute](docs/Model/FacetKeyAttribute.md)
 - [FacetStatistics](docs/Model/FacetStatistics.md)
 - [FacetTerm](docs/Model/FacetTerm.md)
 - [FaxDocument](docs/Model/FaxDocument.md)
 - [FaxDocumentEntityListing](docs/Model/FaxDocumentEntityListing.md)
 - [FaxSendRequest](docs/Model/FaxSendRequest.md)
 - [FaxSendResponse](docs/Model/FaxSendResponse.md)
 - [FaxStatus](docs/Model/FaxStatus.md)
 - [FaxSummary](docs/Model/FaxSummary.md)
 - [FeatureState](docs/Model/FeatureState.md)
 - [FieldConfig](docs/Model/FieldConfig.md)
 - [FieldConfigs](docs/Model/FieldConfigs.md)
 - [FieldList](docs/Model/FieldList.md)
 - [GSuite](docs/Model/GSuite.md)
 - [Geolocation](docs/Model/Geolocation.md)
 - [GeolocationSettings](docs/Model/GeolocationSettings.md)
 - [Greeting](docs/Model/Greeting.md)
 - [GreetingAudioFile](docs/Model/GreetingAudioFile.md)
 - [GreetingListing](docs/Model/GreetingListing.md)
 - [GreetingMediaInfo](docs/Model/GreetingMediaInfo.md)
 - [GreetingOwner](docs/Model/GreetingOwner.md)
 - [Group](docs/Model/Group.md)
 - [GroupContact](docs/Model/GroupContact.md)
 - [GroupEntityListing](docs/Model/GroupEntityListing.md)
 - [GroupMembersUpdate](docs/Model/GroupMembersUpdate.md)
 - [GroupSearchCriteria](docs/Model/GroupSearchCriteria.md)
 - [GroupSearchRequest](docs/Model/GroupSearchRequest.md)
 - [GroupUpdate](docs/Model/GroupUpdate.md)
 - [GroupsSearchResponse](docs/Model/GroupsSearchResponse.md)
 - [HeartBeatAlert](docs/Model/HeartBeatAlert.md)
 - [HeartBeatAlertContainer](docs/Model/HeartBeatAlertContainer.md)
 - [HeartBeatRule](docs/Model/HeartBeatRule.md)
 - [HeartBeatRuleContainer](docs/Model/HeartBeatRuleContainer.md)
 - [ImportStatus](docs/Model/ImportStatus.md)
 - [InboundDomain](docs/Model/InboundDomain.md)
 - [InboundDomainEntityListing](docs/Model/InboundDomainEntityListing.md)
 - [InboundRoute](docs/Model/InboundRoute.md)
 - [InboundRouteEntityListing](docs/Model/InboundRouteEntityListing.md)
 - [InitiateScreenRecording](docs/Model/InitiateScreenRecording.md)
 - [InteractionStatsAlert](docs/Model/InteractionStatsAlert.md)
 - [InteractionStatsAlertContainer](docs/Model/InteractionStatsAlertContainer.md)
 - [InteractionStatsRule](docs/Model/InteractionStatsRule.md)
 - [InteractionStatsRuleContainer](docs/Model/InteractionStatsRuleContainer.md)
 - [JsonNode](docs/Model/JsonNode.md)
 - [JsonNodeSearchResponse](docs/Model/JsonNodeSearchResponse.md)
 - [KeyRotationSchedule](docs/Model/KeyRotationSchedule.md)
 - [Keyword](docs/Model/Keyword.md)
 - [KeywordSet](docs/Model/KeywordSet.md)
 - [KeywordSetEntityListing](docs/Model/KeywordSetEntityListing.md)
 - [Language](docs/Model/Language.md)
 - [LanguageEntityListing](docs/Model/LanguageEntityListing.md)
 - [Library](docs/Model/Library.md)
 - [LibraryEntityListing](docs/Model/LibraryEntityListing.md)
 - [Line](docs/Model/Line.md)
 - [LineBase](docs/Model/LineBase.md)
 - [LineBaseEntityListing](docs/Model/LineBaseEntityListing.md)
 - [LineEntityListing](docs/Model/LineEntityListing.md)
 - [LineStatus](docs/Model/LineStatus.md)
 - [LocalEncryptionConfiguration](docs/Model/LocalEncryptionConfiguration.md)
 - [LocalEncryptionConfigurationListing](docs/Model/LocalEncryptionConfigurationListing.md)
 - [LocalEncryptionKeyRequest](docs/Model/LocalEncryptionKeyRequest.md)
 - [Location](docs/Model/Location.md)
 - [LocationAddress](docs/Model/LocationAddress.md)
 - [LocationDefinition](docs/Model/LocationDefinition.md)
 - [LocationEmergencyNumber](docs/Model/LocationEmergencyNumber.md)
 - [LocationSearchCriteria](docs/Model/LocationSearchCriteria.md)
 - [LocationSearchRequest](docs/Model/LocationSearchRequest.md)
 - [LocationsSearchResponse](docs/Model/LocationsSearchResponse.md)
 - [LockInfo](docs/Model/LockInfo.md)
 - [LogicalInterfaceEntityListing](docs/Model/LogicalInterfaceEntityListing.md)
 - [ManagementUnit](docs/Model/ManagementUnit.md)
 - [MaxParticipants](docs/Model/MaxParticipants.md)
 - [MediaParticipantRequest](docs/Model/MediaParticipantRequest.md)
 - [MediaPolicies](docs/Model/MediaPolicies.md)
 - [MediaResult](docs/Model/MediaResult.md)
 - [MediaSetting](docs/Model/MediaSetting.md)
 - [MediaSummary](docs/Model/MediaSummary.md)
 - [MediaSummaryDetail](docs/Model/MediaSummaryDetail.md)
 - [MemberEntity](docs/Model/MemberEntity.md)
 - [MetaData](docs/Model/MetaData.md)
 - [Metabase](docs/Model/Metabase.md)
 - [MeteredEvaluationAssignment](docs/Model/MeteredEvaluationAssignment.md)
 - [ModelEmpty](docs/Model/ModelEmpty.md)
 - [Number](docs/Model/Number.md)
 - [NumberPlan](docs/Model/NumberPlan.md)
 - [NumericRange](docs/Model/NumericRange.md)
 - [OAuthClient](docs/Model/OAuthClient.md)
 - [OAuthClientEntityListing](docs/Model/OAuthClientEntityListing.md)
 - [OAuthClientListing](docs/Model/OAuthClientListing.md)
 - [OAuthProvider](docs/Model/OAuthProvider.md)
 - [OAuthProviderEntityListing](docs/Model/OAuthProviderEntityListing.md)
 - [ObservationDataContainer](docs/Model/ObservationDataContainer.md)
 - [ObservationQuery](docs/Model/ObservationQuery.md)
 - [ObservationQueryResponse](docs/Model/ObservationQueryResponse.md)
 - [Okta](docs/Model/Okta.md)
 - [OneLogin](docs/Model/OneLogin.md)
 - [OrgMediaUtilization](docs/Model/OrgMediaUtilization.md)
 - [Organization](docs/Model/Organization.md)
 - [OrganizationFeatures](docs/Model/OrganizationFeatures.md)
 - [OrganizationPresence](docs/Model/OrganizationPresence.md)
 - [OrganizationPresenceEntityListing](docs/Model/OrganizationPresenceEntityListing.md)
 - [OrganizationProductEntityListing](docs/Model/OrganizationProductEntityListing.md)
 - [OrganizationRoleEntityListing](docs/Model/OrganizationRoleEntityListing.md)
 - [OrphanRecording](docs/Model/OrphanRecording.md)
 - [OrphanRecordingListing](docs/Model/OrphanRecordingListing.md)
 - [OrphanUpdateRequest](docs/Model/OrphanUpdateRequest.md)
 - [OutOfOffice](docs/Model/OutOfOffice.md)
 - [OutboundRoute](docs/Model/OutboundRoute.md)
 - [OutboundRouteBase](docs/Model/OutboundRouteBase.md)
 - [OutboundRouteBaseEntityListing](docs/Model/OutboundRouteBaseEntityListing.md)
 - [OutboundRouteEntityListing](docs/Model/OutboundRouteEntityListing.md)
 - [PINConfiguration](docs/Model/PINConfiguration.md)
 - [Page](docs/Model/Page.md)
 - [PagingSpec](docs/Model/PagingSpec.md)
 - [Parameter](docs/Model/Parameter.md)
 - [ParsedCertificate](docs/Model/ParsedCertificate.md)
 - [Participant](docs/Model/Participant.md)
 - [ParticipantAttributes](docs/Model/ParticipantAttributes.md)
 - [ParticipantBasic](docs/Model/ParticipantBasic.md)
 - [PermissionCollectionEntityListing](docs/Model/PermissionCollectionEntityListing.md)
 - [Phone](docs/Model/Phone.md)
 - [PhoneBase](docs/Model/PhoneBase.md)
 - [PhoneBaseEntityListing](docs/Model/PhoneBaseEntityListing.md)
 - [PhoneCapabilities](docs/Model/PhoneCapabilities.md)
 - [PhoneColumn](docs/Model/PhoneColumn.md)
 - [PhoneEntityListing](docs/Model/PhoneEntityListing.md)
 - [PhoneMetaBaseEntityListing](docs/Model/PhoneMetaBaseEntityListing.md)
 - [PhoneNumberColumn](docs/Model/PhoneNumberColumn.md)
 - [PhoneNumberStatus](docs/Model/PhoneNumberStatus.md)
 - [PhoneStatus](docs/Model/PhoneStatus.md)
 - [PhonesReboot](docs/Model/PhonesReboot.md)
 - [PhysicalInterfaceEntityListing](docs/Model/PhysicalInterfaceEntityListing.md)
 - [PingIdentity](docs/Model/PingIdentity.md)
 - [Policy](docs/Model/Policy.md)
 - [PolicyActions](docs/Model/PolicyActions.md)
 - [PolicyConditions](docs/Model/PolicyConditions.md)
 - [PolicyCreate](docs/Model/PolicyCreate.md)
 - [PolicyEntityListing](docs/Model/PolicyEntityListing.md)
 - [PolicyErrorMessage](docs/Model/PolicyErrorMessage.md)
 - [PolicyErrors](docs/Model/PolicyErrors.md)
 - [Predicate](docs/Model/Predicate.md)
 - [PredictionResults](docs/Model/PredictionResults.md)
 - [PresenceQueryResponse](docs/Model/PresenceQueryResponse.md)
 - [PropertyIndexRequest](docs/Model/PropertyIndexRequest.md)
 - [ProvisionInfo](docs/Model/ProvisionInfo.md)
 - [PureCloud](docs/Model/PureCloud.md)
 - [QualifierMappingObservationQueryResponse](docs/Model/QualifierMappingObservationQueryResponse.md)
 - [QualityAudit](docs/Model/QualityAudit.md)
 - [QualityAuditPage](docs/Model/QualityAuditPage.md)
 - [QueryFacetInfo](docs/Model/QueryFacetInfo.md)
 - [QueryRequest](docs/Model/QueryRequest.md)
 - [QueryResult](docs/Model/QueryResult.md)
 - [QueryResults](docs/Model/QueryResults.md)
 - [Question](docs/Model/Question.md)
 - [QuestionGroup](docs/Model/QuestionGroup.md)
 - [QuestionGroupScore](docs/Model/QuestionGroupScore.md)
 - [QuestionScore](docs/Model/QuestionScore.md)
 - [Queue](docs/Model/Queue.md)
 - [QueueEmailAddress](docs/Model/QueueEmailAddress.md)
 - [QueueEntityListing](docs/Model/QueueEntityListing.md)
 - [QueueMember](docs/Model/QueueMember.md)
 - [QueueMemberEntityListing](docs/Model/QueueMemberEntityListing.md)
 - [QueueUtilizationDiagnostic](docs/Model/QueueUtilizationDiagnostic.md)
 - [Reaction](docs/Model/Reaction.md)
 - [RecallEntry](docs/Model/RecallEntry.md)
 - [Recording](docs/Model/Recording.md)
 - [RecordingEmailMessage](docs/Model/RecordingEmailMessage.md)
 - [RecordingSettings](docs/Model/RecordingSettings.md)
 - [ReplaceRequest](docs/Model/ReplaceRequest.md)
 - [ReplaceResponse](docs/Model/ReplaceResponse.md)
 - [ReportMetaData](docs/Model/ReportMetaData.md)
 - [ReportMetaDataEntityListing](docs/Model/ReportMetaDataEntityListing.md)
 - [ReportRunEntry](docs/Model/ReportRunEntry.md)
 - [ReportRunEntryEntityDomainListing](docs/Model/ReportRunEntryEntityDomainListing.md)
 - [ReportSchedule](docs/Model/ReportSchedule.md)
 - [ReportScheduleEntityListing](docs/Model/ReportScheduleEntityListing.md)
 - [ResourceConditionNode](docs/Model/ResourceConditionNode.md)
 - [ResourceConditionValue](docs/Model/ResourceConditionValue.md)
 - [ResourcePermissionPolicy](docs/Model/ResourcePermissionPolicy.md)
 - [Response](docs/Model/Response.md)
 - [ResponseEntityList](docs/Model/ResponseEntityList.md)
 - [ResponseEntityListing](docs/Model/ResponseEntityListing.md)
 - [ResponseFilter](docs/Model/ResponseFilter.md)
 - [ResponseQueryRequest](docs/Model/ResponseQueryRequest.md)
 - [ResponseQueryResults](docs/Model/ResponseQueryResults.md)
 - [ResponseSet](docs/Model/ResponseSet.md)
 - [ResponseSetEntityListing](docs/Model/ResponseSetEntityListing.md)
 - [ResponseText](docs/Model/ResponseText.md)
 - [RestErrorDetail](docs/Model/RestErrorDetail.md)
 - [RetentionDuration](docs/Model/RetentionDuration.md)
 - [Ring](docs/Model/Ring.md)
 - [RoutingData](docs/Model/RoutingData.md)
 - [RoutingSkill](docs/Model/RoutingSkill.md)
 - [RoutingStatus](docs/Model/RoutingStatus.md)
 - [RoutingStatusAlert](docs/Model/RoutingStatusAlert.md)
 - [RoutingStatusAlertContainer](docs/Model/RoutingStatusAlertContainer.md)
 - [RoutingStatusRule](docs/Model/RoutingStatusRule.md)
 - [RoutingStatusRuleContainer](docs/Model/RoutingStatusRuleContainer.md)
 - [RuleSet](docs/Model/RuleSet.md)
 - [RuleSetDiagnostic](docs/Model/RuleSetDiagnostic.md)
 - [RuleSetEntityListing](docs/Model/RuleSetEntityListing.md)
 - [RunNowResponse](docs/Model/RunNowResponse.md)
 - [Salesforce](docs/Model/Salesforce.md)
 - [ScheduleInterval](docs/Model/ScheduleInterval.md)
 - [SchemaCategory](docs/Model/SchemaCategory.md)
 - [SchemaCategoryEntityListing](docs/Model/SchemaCategoryEntityListing.md)
 - [SchemaReferenceEntityListing](docs/Model/SchemaReferenceEntityListing.md)
 - [ScreenRecordingSession](docs/Model/ScreenRecordingSession.md)
 - [ScreenRecordingSessionListing](docs/Model/ScreenRecordingSessionListing.md)
 - [ScreenRecordingSessionRequest](docs/Model/ScreenRecordingSessionRequest.md)
 - [Screenshare](docs/Model/Screenshare.md)
 - [Script](docs/Model/Script.md)
 - [ScriptEntityListing](docs/Model/ScriptEntityListing.md)
 - [SearchAggregation](docs/Model/SearchAggregation.md)
 - [SearchCriteria](docs/Model/SearchCriteria.md)
 - [SearchRequest](docs/Model/SearchRequest.md)
 - [Section](docs/Model/Section.md)
 - [SecurityProfile](docs/Model/SecurityProfile.md)
 - [SecurityProfileEntityListing](docs/Model/SecurityProfileEntityListing.md)
 - [Segment](docs/Model/Segment.md)
 - [SequenceSchedule](docs/Model/SequenceSchedule.md)
 - [ServerDate](docs/Model/ServerDate.md)
 - [ServiceContext](docs/Model/ServiceContext.md)
 - [ServiceLevel](docs/Model/ServiceLevel.md)
 - [Share](docs/Model/Share.md)
 - [ShareEntityListing](docs/Model/ShareEntityListing.md)
 - [SharedEntity](docs/Model/SharedEntity.md)
 - [SharedResponse](docs/Model/SharedResponse.md)
 - [Site](docs/Model/Site.md)
 - [SiteEntityListing](docs/Model/SiteEntityListing.md)
 - [SkillEntityListing](docs/Model/SkillEntityListing.md)
 - [SkillsToRemove](docs/Model/SkillsToRemove.md)
 - [SocialExpression](docs/Model/SocialExpression.md)
 - [SortItem](docs/Model/SortItem.md)
 - [Station](docs/Model/Station.md)
 - [StationEntityListing](docs/Model/StationEntityListing.md)
 - [StatisticalResponse](docs/Model/StatisticalResponse.md)
 - [StatisticalSummary](docs/Model/StatisticalSummary.md)
 - [StreetAddress](docs/Model/StreetAddress.md)
 - [SubscriberResponse](docs/Model/SubscriberResponse.md)
 - [SuggestSearchCriteria](docs/Model/SuggestSearchCriteria.md)
 - [SuggestSearchRequest](docs/Model/SuggestSearchRequest.md)
 - [SystemPresence](docs/Model/SystemPresence.md)
 - [TagQueryRequest](docs/Model/TagQueryRequest.md)
 - [TagValue](docs/Model/TagValue.md)
 - [TagValueEntityListing](docs/Model/TagValueEntityListing.md)
 - [TermAttribute](docs/Model/TermAttribute.md)
 - [TimeAllowed](docs/Model/TimeAllowed.md)
 - [TimeInterval](docs/Model/TimeInterval.md)
 - [TimeOffRequest](docs/Model/TimeOffRequest.md)
 - [TimeOffRequestList](docs/Model/TimeOffRequestList.md)
 - [TimeOffRequestPatch](docs/Model/TimeOffRequestPatch.md)
 - [TimeSlot](docs/Model/TimeSlot.md)
 - [TimeZone](docs/Model/TimeZone.md)
 - [TimeZoneEntityListing](docs/Model/TimeZoneEntityListing.md)
 - [TransferRequest](docs/Model/TransferRequest.md)
 - [Trunk](docs/Model/Trunk.md)
 - [TrunkBase](docs/Model/TrunkBase.md)
 - [TrunkBaseAssignment](docs/Model/TrunkBaseAssignment.md)
 - [TrunkBaseEntityListing](docs/Model/TrunkBaseEntityListing.md)
 - [TrunkEntityListing](docs/Model/TrunkEntityListing.md)
 - [TrunkMetabaseEntityListing](docs/Model/TrunkMetabaseEntityListing.md)
 - [TrunkRecordingEnabledCount](docs/Model/TrunkRecordingEnabledCount.md)
 - [UnreadMetric](docs/Model/UnreadMetric.md)
 - [UnreadStatus](docs/Model/UnreadStatus.md)
 - [UriReference](docs/Model/UriReference.md)
 - [Usage](docs/Model/Usage.md)
 - [UsageItem](docs/Model/UsageItem.md)
 - [User](docs/Model/User.md)
 - [UserAgentInfo](docs/Model/UserAgentInfo.md)
 - [UserAuthorization](docs/Model/UserAuthorization.md)
 - [UserConversationSummary](docs/Model/UserConversationSummary.md)
 - [UserDetailsQuery](docs/Model/UserDetailsQuery.md)
 - [UserEntityListing](docs/Model/UserEntityListing.md)
 - [UserImage](docs/Model/UserImage.md)
 - [UserListScheduleRequestBody](docs/Model/UserListScheduleRequestBody.md)
 - [UserMe](docs/Model/UserMe.md)
 - [UserParam](docs/Model/UserParam.md)
 - [UserPresence](docs/Model/UserPresence.md)
 - [UserPresenceAlert](docs/Model/UserPresenceAlert.md)
 - [UserPresenceAlertContainer](docs/Model/UserPresenceAlertContainer.md)
 - [UserPresenceRule](docs/Model/UserPresenceRule.md)
 - [UserPresenceRuleContainer](docs/Model/UserPresenceRuleContainer.md)
 - [UserQueue](docs/Model/UserQueue.md)
 - [UserQueueEntityListing](docs/Model/UserQueueEntityListing.md)
 - [UserRecording](docs/Model/UserRecording.md)
 - [UserRecordingEntityListing](docs/Model/UserRecordingEntityListing.md)
 - [UserRoutingSkill](docs/Model/UserRoutingSkill.md)
 - [UserRoutingSkillPost](docs/Model/UserRoutingSkillPost.md)
 - [UserSchedule](docs/Model/UserSchedule.md)
 - [UserScheduleActivity](docs/Model/UserScheduleActivity.md)
 - [UserScheduleAdherence](docs/Model/UserScheduleAdherence.md)
 - [UserScheduleContainer](docs/Model/UserScheduleContainer.md)
 - [UserScheduleFullDayTimeOffMarker](docs/Model/UserScheduleFullDayTimeOffMarker.md)
 - [UserScheduleShift](docs/Model/UserScheduleShift.md)
 - [UserSearchCriteria](docs/Model/UserSearchCriteria.md)
 - [UserSearchRequest](docs/Model/UserSearchRequest.md)
 - [UserSkillEntityListing](docs/Model/UserSkillEntityListing.md)
 - [UserStation](docs/Model/UserStation.md)
 - [UserStations](docs/Model/UserStations.md)
 - [UsersSearchResponse](docs/Model/UsersSearchResponse.md)
 - [Utilization](docs/Model/Utilization.md)
 - [ValidateAddressRequest](docs/Model/ValidateAddressRequest.md)
 - [ValidateAddressResponse](docs/Model/ValidateAddressResponse.md)
 - [Video](docs/Model/Video.md)
 - [VisibilityCondition](docs/Model/VisibilityCondition.md)
 - [VmPairingInfo](docs/Model/VmPairingInfo.md)
 - [VoicemailGroupPolicy](docs/Model/VoicemailGroupPolicy.md)
 - [VoicemailMailboxInfo](docs/Model/VoicemailMailboxInfo.md)
 - [VoicemailMediaInfo](docs/Model/VoicemailMediaInfo.md)
 - [VoicemailMessage](docs/Model/VoicemailMessage.md)
 - [VoicemailMessageEntityListing](docs/Model/VoicemailMessageEntityListing.md)
 - [VoicemailOrganizationPolicy](docs/Model/VoicemailOrganizationPolicy.md)
 - [VoicemailSearchCriteria](docs/Model/VoicemailSearchCriteria.md)
 - [VoicemailSearchRequest](docs/Model/VoicemailSearchRequest.md)
 - [VoicemailUserPolicy](docs/Model/VoicemailUserPolicy.md)
 - [VoicemailsSearchResponse](docs/Model/VoicemailsSearchResponse.md)
 - [WfmUserEntityListing](docs/Model/WfmUserEntityListing.md)
 - [Workspace](docs/Model/Workspace.md)
 - [WorkspaceCreate](docs/Model/WorkspaceCreate.md)
 - [WorkspaceEntityListing](docs/Model/WorkspaceEntityListing.md)
 - [WorkspaceMember](docs/Model/WorkspaceMember.md)
 - [WorkspaceMemberEntityListing](docs/Model/WorkspaceMemberEntityListing.md)
 - [WorkspaceSummary](docs/Model/WorkspaceSummary.md)
 - [WrapUpCodeMapping](docs/Model/WrapUpCodeMapping.md)
 - [Wrapup](docs/Model/Wrapup.md)
 - [WrapupCode](docs/Model/WrapupCode.md)
 - [WrapupCodeEntityListing](docs/Model/WrapupCodeEntityListing.md)


## Documentation For Authorization


## PureCloud Auth

- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: https://auth.eu-west-1.mypurecloud.ie/authorize
- **Scopes**: 
 - **all**: All the scopes


## Author

DeveloperEvangelists@inin.com


