<?php
/**
 * SpreadsheetTransform
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * SpreadsheetTransform Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class SpreadsheetTransform implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'SpreadsheetTransform';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'restEndpoint' => '\PureCloudSDK\TransformEndpoint',
        'filenameTransforms' => '\PureCloudSDK\BasicTransform[]',
        'tags' => '\PureCloudSDK\TagModel[]',
        'sheetNameTransforms' => '\PureCloudSDK\IndexedTransform[]',
        'sheets' => '\PureCloudSDK\SheetTransform[]',
        'clientTransformModel' => '\PureCloudSDK\ClientSpreadsheetTransform',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'restEndpoint' => 'restEndpoint',
        'filenameTransforms' => 'filenameTransforms',
        'tags' => 'tags',
        'sheetNameTransforms' => 'sheetNameTransforms',
        'sheets' => 'sheets',
        'clientTransformModel' => 'clientTransformModel',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'restEndpoint' => 'setRestEndpoint',
        'filenameTransforms' => 'setFilenameTransforms',
        'tags' => 'setTags',
        'sheetNameTransforms' => 'setSheetNameTransforms',
        'sheets' => 'setSheets',
        'clientTransformModel' => 'setClientTransformModel',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'restEndpoint' => 'getRestEndpoint',
        'filenameTransforms' => 'getFilenameTransforms',
        'tags' => 'getTags',
        'sheetNameTransforms' => 'getSheetNameTransforms',
        'sheets' => 'getSheets',
        'clientTransformModel' => 'getClientTransformModel',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['restEndpoint'] = isset($data['restEndpoint']) ? $data['restEndpoint'] : null;
        $this->container['filenameTransforms'] = isset($data['filenameTransforms']) ? $data['filenameTransforms'] : null;
        $this->container['tags'] = isset($data['tags']) ? $data['tags'] : null;
        $this->container['sheetNameTransforms'] = isset($data['sheetNameTransforms']) ? $data['sheetNameTransforms'] : null;
        $this->container['sheets'] = isset($data['sheets']) ? $data['sheets'] : null;
        $this->container['clientTransformModel'] = isset($data['clientTransformModel']) ? $data['clientTransformModel'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets restEndpoint
     * @return \PureCloudSDK\TransformEndpoint
     */
    public function getRestEndpoint()
    {
        return $this->container['restEndpoint'];
    }

    /**
     * Sets restEndpoint
     * @param \PureCloudSDK\TransformEndpoint $restEndpoint
     * @return $this
     */
    public function setRestEndpoint($restEndpoint)
    {
        $this->container['restEndpoint'] = $restEndpoint;

        return $this;
    }

    /**
     * Gets filenameTransforms
     * @return \PureCloudSDK\BasicTransform[]
     */
    public function getFilenameTransforms()
    {
        return $this->container['filenameTransforms'];
    }

    /**
     * Sets filenameTransforms
     * @param \PureCloudSDK\BasicTransform[] $filenameTransforms
     * @return $this
     */
    public function setFilenameTransforms($filenameTransforms)
    {
        $this->container['filenameTransforms'] = $filenameTransforms;

        return $this;
    }

    /**
     * Gets tags
     * @return \PureCloudSDK\TagModel[]
     */
    public function getTags()
    {
        return $this->container['tags'];
    }

    /**
     * Sets tags
     * @param \PureCloudSDK\TagModel[] $tags
     * @return $this
     */
    public function setTags($tags)
    {
        $this->container['tags'] = $tags;

        return $this;
    }

    /**
     * Gets sheetNameTransforms
     * @return \PureCloudSDK\IndexedTransform[]
     */
    public function getSheetNameTransforms()
    {
        return $this->container['sheetNameTransforms'];
    }

    /**
     * Sets sheetNameTransforms
     * @param \PureCloudSDK\IndexedTransform[] $sheetNameTransforms
     * @return $this
     */
    public function setSheetNameTransforms($sheetNameTransforms)
    {
        $this->container['sheetNameTransforms'] = $sheetNameTransforms;

        return $this;
    }

    /**
     * Gets sheets
     * @return \PureCloudSDK\SheetTransform[]
     */
    public function getSheets()
    {
        return $this->container['sheets'];
    }

    /**
     * Sets sheets
     * @param \PureCloudSDK\SheetTransform[] $sheets
     * @return $this
     */
    public function setSheets($sheets)
    {
        $this->container['sheets'] = $sheets;

        return $this;
    }

    /**
     * Gets clientTransformModel
     * @return \PureCloudSDK\ClientSpreadsheetTransform
     */
    public function getClientTransformModel()
    {
        return $this->container['clientTransformModel'];
    }

    /**
     * Sets clientTransformModel
     * @param \PureCloudSDK\ClientSpreadsheetTransform $clientTransformModel
     * @return $this
     */
    public function setClientTransformModel($clientTransformModel)
    {
        $this->container['clientTransformModel'] = $clientTransformModel;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


