<?php
/**
 * UserPresenceAlert
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * UserPresenceAlert Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class UserPresenceAlert implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'UserPresenceAlert';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'presenceUser' => '\PureCloudSDK\User',
        'presenceType' => 'string',
        'presenceValue' => 'string',
        'presenceLimitInSeconds' => 'int',
        'ruleId' => 'string',
        'startDate' => '\DateTime',
        'endDate' => '\DateTime',
        'notificationUsers' => '\PureCloudSDK\User[]',
        'alertTypes' => 'string[]',
        'ruleUri' => 'string',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'presenceUser' => 'presenceUser',
        'presenceType' => 'presenceType',
        'presenceValue' => 'presenceValue',
        'presenceLimitInSeconds' => 'presenceLimitInSeconds',
        'ruleId' => 'ruleId',
        'startDate' => 'startDate',
        'endDate' => 'endDate',
        'notificationUsers' => 'notificationUsers',
        'alertTypes' => 'alertTypes',
        'ruleUri' => 'ruleUri',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'presenceUser' => 'setPresenceUser',
        'presenceType' => 'setPresenceType',
        'presenceValue' => 'setPresenceValue',
        'presenceLimitInSeconds' => 'setPresenceLimitInSeconds',
        'ruleId' => 'setRuleId',
        'startDate' => 'setStartDate',
        'endDate' => 'setEndDate',
        'notificationUsers' => 'setNotificationUsers',
        'alertTypes' => 'setAlertTypes',
        'ruleUri' => 'setRuleUri',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'presenceUser' => 'getPresenceUser',
        'presenceType' => 'getPresenceType',
        'presenceValue' => 'getPresenceValue',
        'presenceLimitInSeconds' => 'getPresenceLimitInSeconds',
        'ruleId' => 'getRuleId',
        'startDate' => 'getStartDate',
        'endDate' => 'getEndDate',
        'notificationUsers' => 'getNotificationUsers',
        'alertTypes' => 'getAlertTypes',
        'ruleUri' => 'getRuleUri',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const PRESENCE_TYPE_SYSTEM = 'SYSTEM';
    const PRESENCE_TYPE_ORGANIZATION = 'ORGANIZATION';
    const ALERT_TYPES_SMS = 'SMS';
    const ALERT_TYPES_DEVICE = 'DEVICE';
    const ALERT_TYPES_EMAIL = 'EMAIL';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getPresenceTypeAllowableValues()
    {
        return [
            self::PRESENCE_TYPE_SYSTEM,
            self::PRESENCE_TYPE_ORGANIZATION,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getAlertTypesAllowableValues()
    {
        return [
            self::ALERT_TYPES_SMS,
            self::ALERT_TYPES_DEVICE,
            self::ALERT_TYPES_EMAIL,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['presenceUser'] = isset($data['presenceUser']) ? $data['presenceUser'] : null;
        $this->container['presenceType'] = isset($data['presenceType']) ? $data['presenceType'] : null;
        $this->container['presenceValue'] = isset($data['presenceValue']) ? $data['presenceValue'] : null;
        $this->container['presenceLimitInSeconds'] = isset($data['presenceLimitInSeconds']) ? $data['presenceLimitInSeconds'] : null;
        $this->container['ruleId'] = isset($data['ruleId']) ? $data['ruleId'] : null;
        $this->container['startDate'] = isset($data['startDate']) ? $data['startDate'] : null;
        $this->container['endDate'] = isset($data['endDate']) ? $data['endDate'] : null;
        $this->container['notificationUsers'] = isset($data['notificationUsers']) ? $data['notificationUsers'] : null;
        $this->container['alertTypes'] = isset($data['alertTypes']) ? $data['alertTypes'] : null;
        $this->container['ruleUri'] = isset($data['ruleUri']) ? $data['ruleUri'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['name'] === null) {
            $invalid_properties[] = "'name' can't be null";
        }
        if ($this->container['presenceUser'] === null) {
            $invalid_properties[] = "'presenceUser' can't be null";
        }
        if ($this->container['presenceType'] === null) {
            $invalid_properties[] = "'presenceType' can't be null";
        }
        $allowed_values = array("SYSTEM", "ORGANIZATION");
        if (!in_array($this->container['presenceType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'presenceType', must be one of #{allowed_values}.";
        }

        if ($this->container['presenceValue'] === null) {
            $invalid_properties[] = "'presenceValue' can't be null";
        }
        if ($this->container['presenceLimitInSeconds'] === null) {
            $invalid_properties[] = "'presenceLimitInSeconds' can't be null";
        }
        if ($this->container['ruleId'] === null) {
            $invalid_properties[] = "'ruleId' can't be null";
        }
        if ($this->container['startDate'] === null) {
            $invalid_properties[] = "'startDate' can't be null";
        }
        if ($this->container['notificationUsers'] === null) {
            $invalid_properties[] = "'notificationUsers' can't be null";
        }
        if ($this->container['alertTypes'] === null) {
            $invalid_properties[] = "'alertTypes' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['name'] === null) {
            return false;
        }
        if ($this->container['presenceUser'] === null) {
            return false;
        }
        if ($this->container['presenceType'] === null) {
            return false;
        }
        $allowed_values = array("SYSTEM", "ORGANIZATION");
        if (!in_array($this->container['presenceType'], $allowed_values)) {
            return false;
        }
        if ($this->container['presenceValue'] === null) {
            return false;
        }
        if ($this->container['presenceLimitInSeconds'] === null) {
            return false;
        }
        if ($this->container['ruleId'] === null) {
            return false;
        }
        if ($this->container['startDate'] === null) {
            return false;
        }
        if ($this->container['notificationUsers'] === null) {
            return false;
        }
        if ($this->container['alertTypes'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name Name of the rule
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets presenceUser
     * @return \PureCloudSDK\User
     */
    public function getPresenceUser()
    {
        return $this->container['presenceUser'];
    }

    /**
     * Sets presenceUser
     * @param \PureCloudSDK\User $presenceUser The user whose presence will be watched.
     * @return $this
     */
    public function setPresenceUser($presenceUser)
    {
        $this->container['presenceUser'] = $presenceUser;

        return $this;
    }

    /**
     * Gets presenceType
     * @return string
     */
    public function getPresenceType()
    {
        return $this->container['presenceType'];
    }

    /**
     * Sets presenceType
     * @param string $presenceType Indicates to which presence type the presence value belongs.
     * @return $this
     */
    public function setPresenceType($presenceType)
    {
        $allowed_values = array('SYSTEM', 'ORGANIZATION');
        if (!in_array($presenceType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'presenceType', must be one of 'SYSTEM', 'ORGANIZATION'");
        }
        $this->container['presenceType'] = $presenceType;

        return $this;
    }

    /**
     * Gets presenceValue
     * @return string
     */
    public function getPresenceValue()
    {
        return $this->container['presenceValue'];
    }

    /**
     * Sets presenceValue
     * @param string $presenceValue The Org's UUID or Systems enum constance indicating the presence of concern.
     * @return $this
     */
    public function setPresenceValue($presenceValue)
    {
        $this->container['presenceValue'] = $presenceValue;

        return $this;
    }

    /**
     * Gets presenceLimitInSeconds
     * @return int
     */
    public function getPresenceLimitInSeconds()
    {
        return $this->container['presenceLimitInSeconds'];
    }

    /**
     * Sets presenceLimitInSeconds
     * @param int $presenceLimitInSeconds The number of seconds to wait before alerting based upon the user's presence.
     * @return $this
     */
    public function setPresenceLimitInSeconds($presenceLimitInSeconds)
    {
        $this->container['presenceLimitInSeconds'] = $presenceLimitInSeconds;

        return $this;
    }

    /**
     * Gets ruleId
     * @return string
     */
    public function getRuleId()
    {
        return $this->container['ruleId'];
    }

    /**
     * Sets ruleId
     * @param string $ruleId The id of the rule.
     * @return $this
     */
    public function setRuleId($ruleId)
    {
        $this->container['ruleId'] = $ruleId;

        return $this;
    }

    /**
     * Gets startDate
     * @return \DateTime
     */
    public function getStartDate()
    {
        return $this->container['startDate'];
    }

    /**
     * Sets startDate
     * @param \DateTime $startDate The date/time the alert was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setStartDate($startDate)
    {
        $this->container['startDate'] = $startDate;

        return $this;
    }

    /**
     * Gets endDate
     * @return \DateTime
     */
    public function getEndDate()
    {
        return $this->container['endDate'];
    }

    /**
     * Sets endDate
     * @param \DateTime $endDate The date/time the owning rule exiting in alarm status. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setEndDate($endDate)
    {
        $this->container['endDate'] = $endDate;

        return $this;
    }

    /**
     * Gets notificationUsers
     * @return \PureCloudSDK\User[]
     */
    public function getNotificationUsers()
    {
        return $this->container['notificationUsers'];
    }

    /**
     * Sets notificationUsers
     * @param \PureCloudSDK\User[] $notificationUsers The ids of users who were notified of alarm state change.
     * @return $this
     */
    public function setNotificationUsers($notificationUsers)
    {
        $this->container['notificationUsers'] = $notificationUsers;

        return $this;
    }

    /**
     * Gets alertTypes
     * @return string[]
     */
    public function getAlertTypes()
    {
        return $this->container['alertTypes'];
    }

    /**
     * Sets alertTypes
     * @param string[] $alertTypes A collection of notification methods.
     * @return $this
     */
    public function setAlertTypes($alertTypes)
    {
        $allowed_values = array('SMS', 'DEVICE', 'EMAIL');
        if (!in_array($alertTypes, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'alertTypes', must be one of 'SMS', 'DEVICE', 'EMAIL'");
        }
        $this->container['alertTypes'] = $alertTypes;

        return $this;
    }

    /**
     * Gets ruleUri
     * @return string
     */
    public function getRuleUri()
    {
        return $this->container['ruleUri'];
    }

    /**
     * Sets ruleUri
     * @param string $ruleUri
     * @return $this
     */
    public function setRuleUri($ruleUri)
    {
        $this->container['ruleUri'] = $ruleUri;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


