<?php
/**
 * VoiceRateUpdate
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * VoiceRateUpdate Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class VoiceRateUpdate implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'VoiceRateUpdate';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'currency' => 'string',
        'inboundTollFree' => '\PureCloudSDK\VoiceRate',
        'extended' => '\PureCloudSDK\VoiceRateExtended[]',
        'inboundTolled' => '\PureCloudSDK\VoiceRate',
        'outboundLocal' => '\PureCloudSDK\VoiceRate',
        'outboundIntraState' => '\PureCloudSDK\VoiceRate',
        'outboundInterState' => '\PureCloudSDK\VoiceRate',
        'outboundInternational' => '\PureCloudSDK\VoiceRateInternational[]',
        'amendmentDate' => '\DateTime',
        'effectiveDate' => '\DateTime',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'currency' => 'currency',
        'inboundTollFree' => 'inboundTollFree',
        'extended' => 'extended',
        'inboundTolled' => 'inboundTolled',
        'outboundLocal' => 'outboundLocal',
        'outboundIntraState' => 'outboundIntraState',
        'outboundInterState' => 'outboundInterState',
        'outboundInternational' => 'outboundInternational',
        'amendmentDate' => 'amendmentDate',
        'effectiveDate' => 'effectiveDate',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'currency' => 'setCurrency',
        'inboundTollFree' => 'setInboundTollFree',
        'extended' => 'setExtended',
        'inboundTolled' => 'setInboundTolled',
        'outboundLocal' => 'setOutboundLocal',
        'outboundIntraState' => 'setOutboundIntraState',
        'outboundInterState' => 'setOutboundInterState',
        'outboundInternational' => 'setOutboundInternational',
        'amendmentDate' => 'setAmendmentDate',
        'effectiveDate' => 'setEffectiveDate',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'currency' => 'getCurrency',
        'inboundTollFree' => 'getInboundTollFree',
        'extended' => 'getExtended',
        'inboundTolled' => 'getInboundTolled',
        'outboundLocal' => 'getOutboundLocal',
        'outboundIntraState' => 'getOutboundIntraState',
        'outboundInterState' => 'getOutboundInterState',
        'outboundInternational' => 'getOutboundInternational',
        'amendmentDate' => 'getAmendmentDate',
        'effectiveDate' => 'getEffectiveDate',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['currency'] = isset($data['currency']) ? $data['currency'] : null;
        $this->container['inboundTollFree'] = isset($data['inboundTollFree']) ? $data['inboundTollFree'] : null;
        $this->container['extended'] = isset($data['extended']) ? $data['extended'] : null;
        $this->container['inboundTolled'] = isset($data['inboundTolled']) ? $data['inboundTolled'] : null;
        $this->container['outboundLocal'] = isset($data['outboundLocal']) ? $data['outboundLocal'] : null;
        $this->container['outboundIntraState'] = isset($data['outboundIntraState']) ? $data['outboundIntraState'] : null;
        $this->container['outboundInterState'] = isset($data['outboundInterState']) ? $data['outboundInterState'] : null;
        $this->container['outboundInternational'] = isset($data['outboundInternational']) ? $data['outboundInternational'] : null;
        $this->container['amendmentDate'] = isset($data['amendmentDate']) ? $data['amendmentDate'] : null;
        $this->container['effectiveDate'] = isset($data['effectiveDate']) ? $data['effectiveDate'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['currency'] === null) {
            $invalid_properties[] = "'currency' can't be null";
        }
        if ($this->container['amendmentDate'] === null) {
            $invalid_properties[] = "'amendmentDate' can't be null";
        }
        if ($this->container['effectiveDate'] === null) {
            $invalid_properties[] = "'effectiveDate' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['currency'] === null) {
            return false;
        }
        if ($this->container['amendmentDate'] === null) {
            return false;
        }
        if ($this->container['effectiveDate'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets currency
     * @return string
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     * @param string $currency The ISO 4217 currency code of the voice rate.
     * @return $this
     */
    public function setCurrency($currency)
    {
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets inboundTollFree
     * @return \PureCloudSDK\VoiceRate
     */
    public function getInboundTollFree()
    {
        return $this->container['inboundTollFree'];
    }

    /**
     * Sets inboundTollFree
     * @param \PureCloudSDK\VoiceRate $inboundTollFree The inbound toll free rate.
     * @return $this
     */
    public function setInboundTollFree($inboundTollFree)
    {
        $this->container['inboundTollFree'] = $inboundTollFree;

        return $this;
    }

    /**
     * Gets extended
     * @return \PureCloudSDK\VoiceRateExtended[]
     */
    public function getExtended()
    {
        return $this->container['extended'];
    }

    /**
     * Sets extended
     * @param \PureCloudSDK\VoiceRateExtended[] $extended The domestic extended rates.
     * @return $this
     */
    public function setExtended($extended)
    {
        $this->container['extended'] = $extended;

        return $this;
    }

    /**
     * Gets inboundTolled
     * @return \PureCloudSDK\VoiceRate
     */
    public function getInboundTolled()
    {
        return $this->container['inboundTolled'];
    }

    /**
     * Sets inboundTolled
     * @param \PureCloudSDK\VoiceRate $inboundTolled The inbound tolled rate.
     * @return $this
     */
    public function setInboundTolled($inboundTolled)
    {
        $this->container['inboundTolled'] = $inboundTolled;

        return $this;
    }

    /**
     * Gets outboundLocal
     * @return \PureCloudSDK\VoiceRate
     */
    public function getOutboundLocal()
    {
        return $this->container['outboundLocal'];
    }

    /**
     * Sets outboundLocal
     * @param \PureCloudSDK\VoiceRate $outboundLocal The outbound local rate.
     * @return $this
     */
    public function setOutboundLocal($outboundLocal)
    {
        $this->container['outboundLocal'] = $outboundLocal;

        return $this;
    }

    /**
     * Gets outboundIntraState
     * @return \PureCloudSDK\VoiceRate
     */
    public function getOutboundIntraState()
    {
        return $this->container['outboundIntraState'];
    }

    /**
     * Sets outboundIntraState
     * @param \PureCloudSDK\VoiceRate $outboundIntraState The outbound intra-state rate.
     * @return $this
     */
    public function setOutboundIntraState($outboundIntraState)
    {
        $this->container['outboundIntraState'] = $outboundIntraState;

        return $this;
    }

    /**
     * Gets outboundInterState
     * @return \PureCloudSDK\VoiceRate
     */
    public function getOutboundInterState()
    {
        return $this->container['outboundInterState'];
    }

    /**
     * Sets outboundInterState
     * @param \PureCloudSDK\VoiceRate $outboundInterState The outbound inter-state rate.
     * @return $this
     */
    public function setOutboundInterState($outboundInterState)
    {
        $this->container['outboundInterState'] = $outboundInterState;

        return $this;
    }

    /**
     * Gets outboundInternational
     * @return \PureCloudSDK\VoiceRateInternational[]
     */
    public function getOutboundInternational()
    {
        return $this->container['outboundInternational'];
    }

    /**
     * Sets outboundInternational
     * @param \PureCloudSDK\VoiceRateInternational[] $outboundInternational The outbound international rates.
     * @return $this
     */
    public function setOutboundInternational($outboundInternational)
    {
        $this->container['outboundInternational'] = $outboundInternational;

        return $this;
    }

    /**
     * Gets amendmentDate
     * @return \DateTime
     */
    public function getAmendmentDate()
    {
        return $this->container['amendmentDate'];
    }

    /**
     * Sets amendmentDate
     * @param \DateTime $amendmentDate The date of the rate amendment. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setAmendmentDate($amendmentDate)
    {
        $this->container['amendmentDate'] = $amendmentDate;

        return $this;
    }

    /**
     * Gets effectiveDate
     * @return \DateTime
     */
    public function getEffectiveDate()
    {
        return $this->container['effectiveDate'];
    }

    /**
     * Sets effectiveDate
     * @param \DateTime $effectiveDate The effective date of the rate amendment. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setEffectiveDate($effectiveDate)
    {
        $this->container['effectiveDate'] = $effectiveDate;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


