<?php
/**
 * WorkItemDetails
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * WorkItemDetails Class Doc Comment
 *
 * @category    Class */
 // @description Details about a WorkItem
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class WorkItemDetails implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'WorkItemDetails';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'workItemDefinition' => '\PureCloudSDK\WorkItemDefinition',
        'flowExecId' => '\PureCloudSDK\FlowExecId',
        'flowConfigId' => '\PureCloudSDK\FlowConfigId',
        'flowCreateTime' => '\DateTime',
        'createTime' => '\DateTime',
        'owner' => '\PureCloudSDK\User',
        'offeredToUsers' => '\PureCloudSDK\User[]',
        'offeredToQueues' => '\PureCloudSDK\Queue[]',
        'title' => 'string',
        'subtitle' => 'string',
        'associatedDocuments' => '\PureCloudSDK\AssociatedDocument[]',
        'availableActions' => '\PureCloudSDK\WorkItemActions',
        'dataValueInfo' => '\PureCloudSDK\DataValueInfo',
        'workItemCache' => '\PureCloudSDK\WorkItemCache',
        'lastOfferedTime' => '\DateTime',
        'lastOwnershipUpdateTime' => '\DateTime',
        'currentTaskStartTime' => '\DateTime',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'workItemDefinition' => 'workItemDefinition',
        'flowExecId' => 'flowExecId',
        'flowConfigId' => 'flowConfigId',
        'flowCreateTime' => 'flowCreateTime',
        'createTime' => 'createTime',
        'owner' => 'owner',
        'offeredToUsers' => 'offeredToUsers',
        'offeredToQueues' => 'offeredToQueues',
        'title' => 'title',
        'subtitle' => 'subtitle',
        'associatedDocuments' => 'associatedDocuments',
        'availableActions' => 'availableActions',
        'dataValueInfo' => 'dataValueInfo',
        'workItemCache' => 'workItemCache',
        'lastOfferedTime' => 'lastOfferedTime',
        'lastOwnershipUpdateTime' => 'lastOwnershipUpdateTime',
        'currentTaskStartTime' => 'currentTaskStartTime',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'workItemDefinition' => 'setWorkItemDefinition',
        'flowExecId' => 'setFlowExecId',
        'flowConfigId' => 'setFlowConfigId',
        'flowCreateTime' => 'setFlowCreateTime',
        'createTime' => 'setCreateTime',
        'owner' => 'setOwner',
        'offeredToUsers' => 'setOfferedToUsers',
        'offeredToQueues' => 'setOfferedToQueues',
        'title' => 'setTitle',
        'subtitle' => 'setSubtitle',
        'associatedDocuments' => 'setAssociatedDocuments',
        'availableActions' => 'setAvailableActions',
        'dataValueInfo' => 'setDataValueInfo',
        'workItemCache' => 'setWorkItemCache',
        'lastOfferedTime' => 'setLastOfferedTime',
        'lastOwnershipUpdateTime' => 'setLastOwnershipUpdateTime',
        'currentTaskStartTime' => 'setCurrentTaskStartTime',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'workItemDefinition' => 'getWorkItemDefinition',
        'flowExecId' => 'getFlowExecId',
        'flowConfigId' => 'getFlowConfigId',
        'flowCreateTime' => 'getFlowCreateTime',
        'createTime' => 'getCreateTime',
        'owner' => 'getOwner',
        'offeredToUsers' => 'getOfferedToUsers',
        'offeredToQueues' => 'getOfferedToQueues',
        'title' => 'getTitle',
        'subtitle' => 'getSubtitle',
        'associatedDocuments' => 'getAssociatedDocuments',
        'availableActions' => 'getAvailableActions',
        'dataValueInfo' => 'getDataValueInfo',
        'workItemCache' => 'getWorkItemCache',
        'lastOfferedTime' => 'getLastOfferedTime',
        'lastOwnershipUpdateTime' => 'getLastOwnershipUpdateTime',
        'currentTaskStartTime' => 'getCurrentTaskStartTime',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['workItemDefinition'] = isset($data['workItemDefinition']) ? $data['workItemDefinition'] : null;
        $this->container['flowExecId'] = isset($data['flowExecId']) ? $data['flowExecId'] : null;
        $this->container['flowConfigId'] = isset($data['flowConfigId']) ? $data['flowConfigId'] : null;
        $this->container['flowCreateTime'] = isset($data['flowCreateTime']) ? $data['flowCreateTime'] : null;
        $this->container['createTime'] = isset($data['createTime']) ? $data['createTime'] : null;
        $this->container['owner'] = isset($data['owner']) ? $data['owner'] : null;
        $this->container['offeredToUsers'] = isset($data['offeredToUsers']) ? $data['offeredToUsers'] : null;
        $this->container['offeredToQueues'] = isset($data['offeredToQueues']) ? $data['offeredToQueues'] : null;
        $this->container['title'] = isset($data['title']) ? $data['title'] : null;
        $this->container['subtitle'] = isset($data['subtitle']) ? $data['subtitle'] : null;
        $this->container['associatedDocuments'] = isset($data['associatedDocuments']) ? $data['associatedDocuments'] : null;
        $this->container['availableActions'] = isset($data['availableActions']) ? $data['availableActions'] : null;
        $this->container['dataValueInfo'] = isset($data['dataValueInfo']) ? $data['dataValueInfo'] : null;
        $this->container['workItemCache'] = isset($data['workItemCache']) ? $data['workItemCache'] : null;
        $this->container['lastOfferedTime'] = isset($data['lastOfferedTime']) ? $data['lastOfferedTime'] : null;
        $this->container['lastOwnershipUpdateTime'] = isset($data['lastOwnershipUpdateTime']) ? $data['lastOwnershipUpdateTime'] : null;
        $this->container['currentTaskStartTime'] = isset($data['currentTaskStartTime']) ? $data['currentTaskStartTime'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['flowExecId'] === null) {
            $invalid_properties[] = "'flowExecId' can't be null";
        }
        if ($this->container['flowConfigId'] === null) {
            $invalid_properties[] = "'flowConfigId' can't be null";
        }
        if ($this->container['flowCreateTime'] === null) {
            $invalid_properties[] = "'flowCreateTime' can't be null";
        }
        if ($this->container['createTime'] === null) {
            $invalid_properties[] = "'createTime' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['flowExecId'] === null) {
            return false;
        }
        if ($this->container['flowConfigId'] === null) {
            return false;
        }
        if ($this->container['flowCreateTime'] === null) {
            return false;
        }
        if ($this->container['createTime'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets workItemDefinition
     * @return \PureCloudSDK\WorkItemDefinition
     */
    public function getWorkItemDefinition()
    {
        return $this->container['workItemDefinition'];
    }

    /**
     * Sets workItemDefinition
     * @param \PureCloudSDK\WorkItemDefinition $workItemDefinition
     * @return $this
     */
    public function setWorkItemDefinition($workItemDefinition)
    {
        $this->container['workItemDefinition'] = $workItemDefinition;

        return $this;
    }

    /**
     * Gets flowExecId
     * @return \PureCloudSDK\FlowExecId
     */
    public function getFlowExecId()
    {
        return $this->container['flowExecId'];
    }

    /**
     * Sets flowExecId
     * @param \PureCloudSDK\FlowExecId $flowExecId The flow instance ID that created this WorkItem
     * @return $this
     */
    public function setFlowExecId($flowExecId)
    {
        $this->container['flowExecId'] = $flowExecId;

        return $this;
    }

    /**
     * Gets flowConfigId
     * @return \PureCloudSDK\FlowConfigId
     */
    public function getFlowConfigId()
    {
        return $this->container['flowConfigId'];
    }

    /**
     * Sets flowConfigId
     * @param \PureCloudSDK\FlowConfigId $flowConfigId The flow config ID that this workitem was created from.
     * @return $this
     */
    public function setFlowConfigId($flowConfigId)
    {
        $this->container['flowConfigId'] = $flowConfigId;

        return $this;
    }

    /**
     * Gets flowCreateTime
     * @return \DateTime
     */
    public function getFlowCreateTime()
    {
        return $this->container['flowCreateTime'];
    }

    /**
     * Sets flowCreateTime
     * @param \DateTime $flowCreateTime The time the flow was started. (that created this workitem). Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setFlowCreateTime($flowCreateTime)
    {
        $this->container['flowCreateTime'] = $flowCreateTime;

        return $this;
    }

    /**
     * Gets createTime
     * @return \DateTime
     */
    public function getCreateTime()
    {
        return $this->container['createTime'];
    }

    /**
     * Sets createTime
     * @param \DateTime $createTime The time this workitem was started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setCreateTime($createTime)
    {
        $this->container['createTime'] = $createTime;

        return $this;
    }

    /**
     * Gets owner
     * @return \PureCloudSDK\User
     */
    public function getOwner()
    {
        return $this->container['owner'];
    }

    /**
     * Sets owner
     * @param \PureCloudSDK\User $owner The user currently working on/has responsibility for this WorkItem.  May be null if no owner.
     * @return $this
     */
    public function setOwner($owner)
    {
        $this->container['owner'] = $owner;

        return $this;
    }

    /**
     * Gets offeredToUsers
     * @return \PureCloudSDK\User[]
     */
    public function getOfferedToUsers()
    {
        return $this->container['offeredToUsers'];
    }

    /**
     * Sets offeredToUsers
     * @param \PureCloudSDK\User[] $offeredToUsers List of users that this workItem is offered to.  May be null if only offered to queues.
     * @return $this
     */
    public function setOfferedToUsers($offeredToUsers)
    {
        $this->container['offeredToUsers'] = $offeredToUsers;

        return $this;
    }

    /**
     * Gets offeredToQueues
     * @return \PureCloudSDK\Queue[]
     */
    public function getOfferedToQueues()
    {
        return $this->container['offeredToQueues'];
    }

    /**
     * Sets offeredToQueues
     * @param \PureCloudSDK\Queue[] $offeredToQueues List of queues that this workItem is offered to.  May be null if only offered to users.
     * @return $this
     */
    public function setOfferedToQueues($offeredToQueues)
    {
        $this->container['offeredToQueues'] = $offeredToQueues;

        return $this;
    }

    /**
     * Gets title
     * @return string
     */
    public function getTitle()
    {
        return $this->container['title'];
    }

    /**
     * Sets title
     * @param string $title The work item title
     * @return $this
     */
    public function setTitle($title)
    {
        $this->container['title'] = $title;

        return $this;
    }

    /**
     * Gets subtitle
     * @return string
     */
    public function getSubtitle()
    {
        return $this->container['subtitle'];
    }

    /**
     * Sets subtitle
     * @param string $subtitle The work item's subtitle - 2nd line/description
     * @return $this
     */
    public function setSubtitle($subtitle)
    {
        $this->container['subtitle'] = $subtitle;

        return $this;
    }

    /**
     * Gets associatedDocuments
     * @return \PureCloudSDK\AssociatedDocument[]
     */
    public function getAssociatedDocuments()
    {
        return $this->container['associatedDocuments'];
    }

    /**
     * Sets associatedDocuments
     * @param \PureCloudSDK\AssociatedDocument[] $associatedDocuments The documents associated with this workitem
     * @return $this
     */
    public function setAssociatedDocuments($associatedDocuments)
    {
        $this->container['associatedDocuments'] = $associatedDocuments;

        return $this;
    }

    /**
     * Gets availableActions
     * @return \PureCloudSDK\WorkItemActions
     */
    public function getAvailableActions()
    {
        return $this->container['availableActions'];
    }

    /**
     * Sets availableActions
     * @param \PureCloudSDK\WorkItemActions $availableActions The actions that the user can take on this workitem (submit, transfer, etc).
     * @return $this
     */
    public function setAvailableActions($availableActions)
    {
        $this->container['availableActions'] = $availableActions;

        return $this;
    }

    /**
     * Gets dataValueInfo
     * @return \PureCloudSDK\DataValueInfo
     */
    public function getDataValueInfo()
    {
        return $this->container['dataValueInfo'];
    }

    /**
     * Sets dataValueInfo
     * @param \PureCloudSDK\DataValueInfo $dataValueInfo The data items that provide values for any work item form elements, if applicable.
     * @return $this
     */
    public function setDataValueInfo($dataValueInfo)
    {
        $this->container['dataValueInfo'] = $dataValueInfo;

        return $this;
    }

    /**
     * Gets workItemCache
     * @return \PureCloudSDK\WorkItemCache
     */
    public function getWorkItemCache()
    {
        return $this->container['workItemCache'];
    }

    /**
     * Sets workItemCache
     * @param \PureCloudSDK\WorkItemCache $workItemCache The data items in the current work item cache, if one exists.
     * @return $this
     */
    public function setWorkItemCache($workItemCache)
    {
        $this->container['workItemCache'] = $workItemCache;

        return $this;
    }

    /**
     * Gets lastOfferedTime
     * @return \DateTime
     */
    public function getLastOfferedTime()
    {
        return $this->container['lastOfferedTime'];
    }

    /**
     * Sets lastOfferedTime
     * @param \DateTime $lastOfferedTime The time this work item was last offered to a user or queue. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setLastOfferedTime($lastOfferedTime)
    {
        $this->container['lastOfferedTime'] = $lastOfferedTime;

        return $this;
    }

    /**
     * Gets lastOwnershipUpdateTime
     * @return \DateTime
     */
    public function getLastOwnershipUpdateTime()
    {
        return $this->container['lastOwnershipUpdateTime'];
    }

    /**
     * Sets lastOwnershipUpdateTime
     * @param \DateTime $lastOwnershipUpdateTime The most recent time a user assumed ownership of a work item. This may be blank if the work item has no owner. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setLastOwnershipUpdateTime($lastOwnershipUpdateTime)
    {
        $this->container['lastOwnershipUpdateTime'] = $lastOwnershipUpdateTime;

        return $this;
    }

    /**
     * Gets currentTaskStartTime
     * @return \DateTime
     */
    public function getCurrentTaskStartTime()
    {
        return $this->container['currentTaskStartTime'];
    }

    /**
     * Sets currentTaskStartTime
     * @param \DateTime $currentTaskStartTime This is the time when the current task that started the work item was started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setCurrentTaskStartTime($currentTaskStartTime)
    {
        $this->container['currentTaskStartTime'] = $currentTaskStartTime;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


