# PureCloudSDK\GroupsApi

All URIs are relative to *https://api.mypurecloud.ie*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteGroupsGroupId**](GroupsApi.md#deleteGroupsGroupId) | **DELETE** /api/v2/groups/{groupId} | Delete group
[**deleteGroupsGroupIdMembers**](GroupsApi.md#deleteGroupsGroupIdMembers) | **DELETE** /api/v2/groups/{groupId}/members | Remove members
[**getFieldconfig**](GroupsApi.md#getFieldconfig) | **GET** /api/v2/fieldconfig | Fetch field config for an entity type
[**getGroups**](GroupsApi.md#getGroups) | **GET** /api/v2/groups | Get a group list
[**getGroupsGroupId**](GroupsApi.md#getGroupsGroupId) | **GET** /api/v2/groups/{groupId} | Get group
[**getGroupsGroupIdMembers**](GroupsApi.md#getGroupsGroupIdMembers) | **GET** /api/v2/groups/{groupId}/members | Get group members
[**getGroupsSearch**](GroupsApi.md#getGroupsSearch) | **GET** /api/v2/groups/search | Search groups using the q64 value returned from a previous search
[**postGroups**](GroupsApi.md#postGroups) | **POST** /api/v2/groups | Create a group
[**postGroupsGroupIdMembers**](GroupsApi.md#postGroupsGroupIdMembers) | **POST** /api/v2/groups/{groupId}/members | Add members
[**postGroupsSearch**](GroupsApi.md#postGroupsSearch) | **POST** /api/v2/groups/search | Search groups
[**putGroupsGroupId**](GroupsApi.md#putGroupsGroupId) | **PUT** /api/v2/groups/{groupId} | Update group


# **deleteGroupsGroupId**
> deleteGroupsGroupId($groupId)

Delete group



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GroupsApi();
$groupId = "groupId_example"; // string | Group ID

try {
    $api_instance->deleteGroupsGroupId($groupId);
} catch (Exception $e) {
    echo 'Exception when calling GroupsApi->deleteGroupsGroupId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **groupId** | **string**| Group ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteGroupsGroupIdMembers**
> \PureCloudSDK\ModelEmpty deleteGroupsGroupIdMembers($groupId, $ids)

Remove members



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GroupsApi();
$groupId = "groupId_example"; // string | Group ID
$ids = "ids_example"; // string | Comma separated list of userIds to remove

try {
    $result = $api_instance->deleteGroupsGroupIdMembers($groupId, $ids);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GroupsApi->deleteGroupsGroupIdMembers: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **groupId** | **string**| Group ID |
 **ids** | **string**| Comma separated list of userIds to remove |

### Return type

[**\PureCloudSDK\ModelEmpty**](../Model/ModelEmpty.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getFieldconfig**
> \PureCloudSDK\FieldConfig getFieldconfig($type)

Fetch field config for an entity type



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GroupsApi();
$type = "type_example"; // string | Field type

try {
    $result = $api_instance->getFieldconfig($type);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GroupsApi->getFieldconfig: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **type** | **string**| Field type |

### Return type

[**\PureCloudSDK\FieldConfig**](../Model/FieldConfig.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getGroups**
> \PureCloudSDK\GroupEntityListing getGroups($pageSize, $pageNumber, $sortOrder)

Get a group list



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GroupsApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$sortOrder = "ASC"; // string | Ascending or descending sort order

try {
    $result = $api_instance->getGroups($pageSize, $pageNumber, $sortOrder);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GroupsApi->getGroups: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **sortOrder** | **string**| Ascending or descending sort order | [optional] [default to ASC]

### Return type

[**\PureCloudSDK\GroupEntityListing**](../Model/GroupEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getGroupsGroupId**
> \PureCloudSDK\Group getGroupsGroupId($groupId)

Get group



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GroupsApi();
$groupId = "groupId_example"; // string | Group ID

try {
    $result = $api_instance->getGroupsGroupId($groupId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GroupsApi->getGroupsGroupId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **groupId** | **string**| Group ID |

### Return type

[**\PureCloudSDK\Group**](../Model/Group.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getGroupsGroupIdMembers**
> \PureCloudSDK\UserEntityListing getGroupsGroupIdMembers($groupId, $pageSize, $pageNumber, $sortOrder, $expand)

Get group members



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GroupsApi();
$groupId = "groupId_example"; // string | Group ID
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$sortOrder = "ASC"; // string | Ascending or descending sort order
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $result = $api_instance->getGroupsGroupIdMembers($groupId, $pageSize, $pageNumber, $sortOrder, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GroupsApi->getGroupsGroupIdMembers: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **groupId** | **string**| Group ID |
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **sortOrder** | **string**| Ascending or descending sort order | [optional] [default to ASC]
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\UserEntityListing**](../Model/UserEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getGroupsSearch**
> \PureCloudSDK\GroupsSearchResponse getGroupsSearch($q64, $expand)

Search groups using the q64 value returned from a previous search



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GroupsApi();
$q64 = "q64_example"; // string | q64
$expand = array("expand_example"); // string[] | expand

try {
    $result = $api_instance->getGroupsSearch($q64, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GroupsApi->getGroupsSearch: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **q64** | **string**| q64 |
 **expand** | [**string[]**](../Model/string.md)| expand | [optional]

### Return type

[**\PureCloudSDK\GroupsSearchResponse**](../Model/GroupsSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postGroups**
> \PureCloudSDK\Group postGroups($body)

Create a group



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GroupsApi();
$body = new \PureCloudSDK\Group(); // \PureCloudSDK\Group | Group

try {
    $result = $api_instance->postGroups($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GroupsApi->postGroups: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Group**](../Model/\PureCloudSDK\Group.md)| Group |

### Return type

[**\PureCloudSDK\Group**](../Model/Group.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postGroupsGroupIdMembers**
> \PureCloudSDK\ModelEmpty postGroupsGroupIdMembers($groupId, $body)

Add members



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GroupsApi();
$groupId = "groupId_example"; // string | Group ID
$body = new \PureCloudSDK\GroupMembersUpdate(); // \PureCloudSDK\GroupMembersUpdate | Add members

try {
    $result = $api_instance->postGroupsGroupIdMembers($groupId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GroupsApi->postGroupsGroupIdMembers: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **groupId** | **string**| Group ID |
 **body** | [**\PureCloudSDK\GroupMembersUpdate**](../Model/\PureCloudSDK\GroupMembersUpdate.md)| Add members |

### Return type

[**\PureCloudSDK\ModelEmpty**](../Model/ModelEmpty.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postGroupsSearch**
> \PureCloudSDK\GroupsSearchResponse postGroupsSearch($body)

Search groups



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GroupsApi();
$body = new \PureCloudSDK\GroupSearchRequest(); // \PureCloudSDK\GroupSearchRequest | Search request options

try {
    $result = $api_instance->postGroupsSearch($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GroupsApi->postGroupsSearch: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\GroupSearchRequest**](../Model/\PureCloudSDK\GroupSearchRequest.md)| Search request options |

### Return type

[**\PureCloudSDK\GroupsSearchResponse**](../Model/GroupsSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putGroupsGroupId**
> \PureCloudSDK\Group putGroupsGroupId($groupId, $body)

Update group



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GroupsApi();
$groupId = "groupId_example"; // string | Group ID
$body = new \PureCloudSDK\GroupUpdate(); // \PureCloudSDK\GroupUpdate | Group

try {
    $result = $api_instance->putGroupsGroupId($groupId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GroupsApi->putGroupsGroupId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **groupId** | **string**| Group ID |
 **body** | [**\PureCloudSDK\GroupUpdate**](../Model/\PureCloudSDK\GroupUpdate.md)| Group | [optional]

### Return type

[**\PureCloudSDK\Group**](../Model/Group.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

