# PureCloudSDK\NotificationsApi

All URIs are relative to *https://api.mypurecloud.ie*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteNotificationsChannelsChannelIdSubscriptions**](NotificationsApi.md#deleteNotificationsChannelsChannelIdSubscriptions) | **DELETE** /api/v2/notifications/channels/{channelId}/subscriptions | Remove all subscriptions
[**getNotificationsAvailabletopics**](NotificationsApi.md#getNotificationsAvailabletopics) | **GET** /api/v2/notifications/availabletopics | Get available notification topics.
[**getNotificationsChannels**](NotificationsApi.md#getNotificationsChannels) | **GET** /api/v2/notifications/channels | The list of existing channels
[**getNotificationsChannelsChannelIdSubscriptions**](NotificationsApi.md#getNotificationsChannelsChannelIdSubscriptions) | **GET** /api/v2/notifications/channels/{channelId}/subscriptions | The list of all subscriptions for this channel
[**postNotificationsChannels**](NotificationsApi.md#postNotificationsChannels) | **POST** /api/v2/notifications/channels | Create a new channel
[**postNotificationsChannelsChannelIdSubscriptions**](NotificationsApi.md#postNotificationsChannelsChannelIdSubscriptions) | **POST** /api/v2/notifications/channels/{channelId}/subscriptions | Add a list of subscriptions to the existing list of subscriptions
[**putNotificationsChannelsChannelIdSubscriptions**](NotificationsApi.md#putNotificationsChannelsChannelIdSubscriptions) | **PUT** /api/v2/notifications/channels/{channelId}/subscriptions | Replace the current list of subscriptions with a new list.


# **deleteNotificationsChannelsChannelIdSubscriptions**
> deleteNotificationsChannelsChannelIdSubscriptions($channelId)

Remove all subscriptions



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\NotificationsApi();
$channelId = "channelId_example"; // string | Channel ID

try {
    $api_instance->deleteNotificationsChannelsChannelIdSubscriptions($channelId);
} catch (Exception $e) {
    echo 'Exception when calling NotificationsApi->deleteNotificationsChannelsChannelIdSubscriptions: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **channelId** | **string**| Channel ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getNotificationsAvailabletopics**
> \PureCloudSDK\AvailableTopicEntityListing getNotificationsAvailabletopics($expand)

Get available notification topics.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\NotificationsApi();
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $result = $api_instance->getNotificationsAvailabletopics($expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling NotificationsApi->getNotificationsAvailabletopics: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\AvailableTopicEntityListing**](../Model/AvailableTopicEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getNotificationsChannels**
> \PureCloudSDK\ChannelEntityListing getNotificationsChannels()

The list of existing channels



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\NotificationsApi();

try {
    $result = $api_instance->getNotificationsChannels();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling NotificationsApi->getNotificationsChannels: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\ChannelEntityListing**](../Model/ChannelEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getNotificationsChannelsChannelIdSubscriptions**
> \PureCloudSDK\ChannelTopicEntityListing getNotificationsChannelsChannelIdSubscriptions($channelId)

The list of all subscriptions for this channel



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\NotificationsApi();
$channelId = "channelId_example"; // string | Channel ID

try {
    $result = $api_instance->getNotificationsChannelsChannelIdSubscriptions($channelId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling NotificationsApi->getNotificationsChannelsChannelIdSubscriptions: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **channelId** | **string**| Channel ID |

### Return type

[**\PureCloudSDK\ChannelTopicEntityListing**](../Model/ChannelTopicEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postNotificationsChannels**
> \PureCloudSDK\Channel postNotificationsChannels()

Create a new channel

There is a limit of 10 channels. Creating an 11th channel will remove the channel with oldest last used date.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\NotificationsApi();

try {
    $result = $api_instance->postNotificationsChannels();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling NotificationsApi->postNotificationsChannels: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\Channel**](../Model/Channel.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postNotificationsChannelsChannelIdSubscriptions**
> \PureCloudSDK\ChannelTopicEntityListing postNotificationsChannelsChannelIdSubscriptions($channelId, $body)

Add a list of subscriptions to the existing list of subscriptions



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\NotificationsApi();
$channelId = "channelId_example"; // string | Channel ID
$body = array(new ChannelTopic()); // \PureCloudSDK\ChannelTopic[] | Topic

try {
    $result = $api_instance->postNotificationsChannelsChannelIdSubscriptions($channelId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling NotificationsApi->postNotificationsChannelsChannelIdSubscriptions: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **channelId** | **string**| Channel ID |
 **body** | [**\PureCloudSDK\ChannelTopic[]**](../Model/ChannelTopic.md)| Topic |

### Return type

[**\PureCloudSDK\ChannelTopicEntityListing**](../Model/ChannelTopicEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putNotificationsChannelsChannelIdSubscriptions**
> \PureCloudSDK\ChannelTopicEntityListing putNotificationsChannelsChannelIdSubscriptions($channelId, $body)

Replace the current list of subscriptions with a new list.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\NotificationsApi();
$channelId = "channelId_example"; // string | Channel ID
$body = array(new ChannelTopic()); // \PureCloudSDK\ChannelTopic[] | Topic

try {
    $result = $api_instance->putNotificationsChannelsChannelIdSubscriptions($channelId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling NotificationsApi->putNotificationsChannelsChannelIdSubscriptions: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **channelId** | **string**| Channel ID |
 **body** | [**\PureCloudSDK\ChannelTopic[]**](../Model/ChannelTopic.md)| Topic |

### Return type

[**\PureCloudSDK\ChannelTopicEntityListing**](../Model/ChannelTopicEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

