# PureCloudSDK\PresenceApi

All URIs are relative to *https://api.mypurecloud.ie*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deletePresencedefinitionsPresenceId**](PresenceApi.md#deletePresencedefinitionsPresenceId) | **DELETE** /api/v2/presencedefinitions/{presenceId} | Delete a Presence Definition
[**getPresencedefinitions**](PresenceApi.md#getPresencedefinitions) | **GET** /api/v2/presencedefinitions | Get an Organization&#39;s list of Presence Definitions
[**getPresencedefinitionsPresenceId**](PresenceApi.md#getPresencedefinitionsPresenceId) | **GET** /api/v2/presencedefinitions/{presenceId} | Get a Presence Definition
[**getSystempresences**](PresenceApi.md#getSystempresences) | **GET** /api/v2/systempresences | Get the list of SystemPresences
[**getUsersUserIdPresencesSourceId**](PresenceApi.md#getUsersUserIdPresencesSourceId) | **GET** /api/v2/users/{userId}/presences/{sourceId} | Get a user&#39;s Presence
[**patchUsersUserIdPresencesSourceId**](PresenceApi.md#patchUsersUserIdPresencesSourceId) | **PATCH** /api/v2/users/{userId}/presences/{sourceId} | Patch a user&#39;s Presence
[**postPresencedefinitions**](PresenceApi.md#postPresencedefinitions) | **POST** /api/v2/presencedefinitions | Create a Presence Definition
[**putPresencedefinitionsPresenceId**](PresenceApi.md#putPresencedefinitionsPresenceId) | **PUT** /api/v2/presencedefinitions/{presenceId} | Update a Presence Definition


# **deletePresencedefinitionsPresenceId**
> deletePresencedefinitionsPresenceId($presenceId)

Delete a Presence Definition



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\PresenceApi();
$presenceId = "presenceId_example"; // string | Organization Presence ID

try {
    $api_instance->deletePresencedefinitionsPresenceId($presenceId);
} catch (Exception $e) {
    echo 'Exception when calling PresenceApi->deletePresencedefinitionsPresenceId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **presenceId** | **string**| Organization Presence ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getPresencedefinitions**
> \PureCloudSDK\OrganizationPresenceEntityListing getPresencedefinitions($pageNumber, $pageSize, $deleted, $localeCode)

Get an Organization's list of Presence Definitions



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\PresenceApi();
$pageNumber = 1; // int | Page number
$pageSize = 25; // int | Page size
$deleted = "false"; // string | Deleted query can be TRUE, FALSE or ALL
$localeCode = "localeCode_example"; // string | The locale code to fetch for each presence definition. Use ALL to fetch everything.

try {
    $result = $api_instance->getPresencedefinitions($pageNumber, $pageSize, $deleted, $localeCode);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PresenceApi->getPresencedefinitions: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **deleted** | **string**| Deleted query can be TRUE, FALSE or ALL | [optional] [default to false]
 **localeCode** | **string**| The locale code to fetch for each presence definition. Use ALL to fetch everything. | [optional]

### Return type

[**\PureCloudSDK\OrganizationPresenceEntityListing**](../Model/OrganizationPresenceEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getPresencedefinitionsPresenceId**
> \PureCloudSDK\OrganizationPresence getPresencedefinitionsPresenceId($presenceId, $localeCode)

Get a Presence Definition



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\PresenceApi();
$presenceId = "presenceId_example"; // string | Organization Presence ID
$localeCode = "localeCode_example"; // string | The locale code to fetch for the presence definition. Use ALL to fetch everything.

try {
    $result = $api_instance->getPresencedefinitionsPresenceId($presenceId, $localeCode);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PresenceApi->getPresencedefinitionsPresenceId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **presenceId** | **string**| Organization Presence ID |
 **localeCode** | **string**| The locale code to fetch for the presence definition. Use ALL to fetch everything. | [optional]

### Return type

[**\PureCloudSDK\OrganizationPresence**](../Model/OrganizationPresence.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSystempresences**
> \PureCloudSDK\SystemPresence[] getSystempresences()

Get the list of SystemPresences



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\PresenceApi();

try {
    $result = $api_instance->getSystempresences();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PresenceApi->getSystempresences: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\SystemPresence[]**](../Model/SystemPresence.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUsersUserIdPresencesSourceId**
> \PureCloudSDK\UserPresence getUsersUserIdPresencesSourceId($userId, $sourceId)

Get a user's Presence



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\PresenceApi();
$userId = "userId_example"; // string | user Id
$sourceId = "sourceId_example"; // string | Source

try {
    $result = $api_instance->getUsersUserIdPresencesSourceId($userId, $sourceId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PresenceApi->getUsersUserIdPresencesSourceId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| user Id |
 **sourceId** | **string**| Source |

### Return type

[**\PureCloudSDK\UserPresence**](../Model/UserPresence.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchUsersUserIdPresencesSourceId**
> \PureCloudSDK\UserPresence patchUsersUserIdPresencesSourceId($userId, $sourceId, $body)

Patch a user's Presence

The presence object can be patched one of three ways. Option 1: Set the 'primary' property to true. This will set the 'source' defined in the path as the user's primary presence source. Option 2: Provide the presenceDefinition value. The 'id' is the only value required within the presenceDefinition. Option 3: Provide the message value. Option 1 can be combined with Option 2 and/or Option 3.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\PresenceApi();
$userId = "userId_example"; // string | user Id
$sourceId = "sourceId_example"; // string | Source
$body = new \PureCloudSDK\UserPresence(); // \PureCloudSDK\UserPresence | User presence

try {
    $result = $api_instance->patchUsersUserIdPresencesSourceId($userId, $sourceId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PresenceApi->patchUsersUserIdPresencesSourceId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| user Id |
 **sourceId** | **string**| Source |
 **body** | [**\PureCloudSDK\UserPresence**](../Model/\PureCloudSDK\UserPresence.md)| User presence |

### Return type

[**\PureCloudSDK\UserPresence**](../Model/UserPresence.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postPresencedefinitions**
> \PureCloudSDK\OrganizationPresence postPresencedefinitions($body)

Create a Presence Definition



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\PresenceApi();
$body = new \PureCloudSDK\OrganizationPresence(); // \PureCloudSDK\OrganizationPresence | The Presence Definition to create

try {
    $result = $api_instance->postPresencedefinitions($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PresenceApi->postPresencedefinitions: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\OrganizationPresence**](../Model/\PureCloudSDK\OrganizationPresence.md)| The Presence Definition to create |

### Return type

[**\PureCloudSDK\OrganizationPresence**](../Model/OrganizationPresence.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putPresencedefinitionsPresenceId**
> \PureCloudSDK\OrganizationPresence putPresencedefinitionsPresenceId($presenceId, $body)

Update a Presence Definition



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\PresenceApi();
$presenceId = "presenceId_example"; // string | Organization Presence ID
$body = new \PureCloudSDK\OrganizationPresence(); // \PureCloudSDK\OrganizationPresence | The OrganizationPresence to update

try {
    $result = $api_instance->putPresencedefinitionsPresenceId($presenceId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PresenceApi->putPresencedefinitionsPresenceId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **presenceId** | **string**| Organization Presence ID |
 **body** | [**\PureCloudSDK\OrganizationPresence**](../Model/\PureCloudSDK\OrganizationPresence.md)| The OrganizationPresence to update |

### Return type

[**\PureCloudSDK\OrganizationPresence**](../Model/OrganizationPresence.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

