# PureCloudSDK\RecordingApi

All URIs are relative to *https://api.mypurecloud.ie*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteConversationsConversationIdRecordingsRecordingIdAnnotationsAnnotationId**](RecordingApi.md#deleteConversationsConversationIdRecordingsRecordingIdAnnotationsAnnotationId) | **DELETE** /api/v2/conversations/{conversationId}/recordings/{recordingId}/annotations/{annotationId} | Delete annotation
[**deleteOrphanrecordingsOrphanId**](RecordingApi.md#deleteOrphanrecordingsOrphanId) | **DELETE** /api/v2/orphanrecordings/{orphanId} | Deletes a single orphan recording
[**deleteRecordingMediaretentionpolicies**](RecordingApi.md#deleteRecordingMediaretentionpolicies) | **DELETE** /api/v2/recording/mediaretentionpolicies | Delete media retention policies
[**deleteRecordingMediaretentionpoliciesPolicyId**](RecordingApi.md#deleteRecordingMediaretentionpoliciesPolicyId) | **DELETE** /api/v2/recording/mediaretentionpolicies/{policyId} | Delete a media retention policy
[**getConversationsConversationIdRecordings**](RecordingApi.md#getConversationsConversationIdRecordings) | **GET** /api/v2/conversations/{conversationId}/recordings | Get all of a Conversation&#39;s Recordings.
[**getConversationsConversationIdRecordingsRecordingId**](RecordingApi.md#getConversationsConversationIdRecordingsRecordingId) | **GET** /api/v2/conversations/{conversationId}/recordings/{recordingId} | Gets a specific recording.
[**getConversationsConversationIdRecordingsRecordingIdAnnotations**](RecordingApi.md#getConversationsConversationIdRecordingsRecordingIdAnnotations) | **GET** /api/v2/conversations/{conversationId}/recordings/{recordingId}/annotations | Get annotations for recording
[**getConversationsConversationIdRecordingsRecordingIdAnnotationsAnnotationId**](RecordingApi.md#getConversationsConversationIdRecordingsRecordingIdAnnotationsAnnotationId) | **GET** /api/v2/conversations/{conversationId}/recordings/{recordingId}/annotations/{annotationId} | Get annotation
[**getOrphanrecordings**](RecordingApi.md#getOrphanrecordings) | **GET** /api/v2/orphanrecordings | Gets all orphan recordings
[**getOrphanrecordingsOrphanId**](RecordingApi.md#getOrphanrecordingsOrphanId) | **GET** /api/v2/orphanrecordings/{orphanId} | Gets a single orphan recording
[**getOrphanrecordingsOrphanIdMedia**](RecordingApi.md#getOrphanrecordingsOrphanIdMedia) | **GET** /api/v2/orphanrecordings/{orphanId}/media | Gets the media of a single orphan recording
[**getRecordingLocalkeysSettings**](RecordingApi.md#getRecordingLocalkeysSettings) | **GET** /api/v2/recording/localkeys/settings | gets a list local key settings data
[**getRecordingLocalkeysSettingsSettingsId**](RecordingApi.md#getRecordingLocalkeysSettingsSettingsId) | **GET** /api/v2/recording/localkeys/settings/{settingsId} | Get the local encryption settings
[**getRecordingMediaretentionpolicies**](RecordingApi.md#getRecordingMediaretentionpolicies) | **GET** /api/v2/recording/mediaretentionpolicies | Gets media retention policy list with query options to filter on name and enabled.
[**getRecordingMediaretentionpoliciesPolicyId**](RecordingApi.md#getRecordingMediaretentionpoliciesPolicyId) | **GET** /api/v2/recording/mediaretentionpolicies/{policyId} | Get a media retention policy
[**getRecordingRecordingkeys**](RecordingApi.md#getRecordingRecordingkeys) | **GET** /api/v2/recording/recordingkeys | Get encryption key list
[**getRecordingRecordingkeysRotationschedule**](RecordingApi.md#getRecordingRecordingkeysRotationschedule) | **GET** /api/v2/recording/recordingkeys/rotationschedule | Get key rotation schedule
[**getRecordingSettings**](RecordingApi.md#getRecordingSettings) | **GET** /api/v2/recording/settings | Get the Recording Settings for the Organization
[**getRecordingsScreensessions**](RecordingApi.md#getRecordingsScreensessions) | **GET** /api/v2/recordings/screensessions | Retrieves a paged listing of screen recording sessions
[**patchRecordingMediaretentionpoliciesPolicyId**](RecordingApi.md#patchRecordingMediaretentionpoliciesPolicyId) | **PATCH** /api/v2/recording/mediaretentionpolicies/{policyId} | Patch a media retention policy
[**patchRecordingsScreensessionsRecordingsessionId**](RecordingApi.md#patchRecordingsScreensessionsRecordingsessionId) | **PATCH** /api/v2/recordings/screensessions/{recordingSessionId} | Update a screen recording session
[**postConversationsConversationIdRecordingsRecordingIdAnnotations**](RecordingApi.md#postConversationsConversationIdRecordingsRecordingIdAnnotations) | **POST** /api/v2/conversations/{conversationId}/recordings/{recordingId}/annotations | Create annotation
[**postRecordingLocalkeys**](RecordingApi.md#postRecordingLocalkeys) | **POST** /api/v2/recording/localkeys | create a local recording key
[**postRecordingLocalkeysSettings**](RecordingApi.md#postRecordingLocalkeysSettings) | **POST** /api/v2/recording/localkeys/settings | create settings for local key creation
[**postRecordingMediaretentionpolicies**](RecordingApi.md#postRecordingMediaretentionpolicies) | **POST** /api/v2/recording/mediaretentionpolicies | Create media retention policy
[**postRecordingRecordingkeys**](RecordingApi.md#postRecordingRecordingkeys) | **POST** /api/v2/recording/recordingkeys | Create encryption key
[**putConversationsConversationIdRecordingsRecordingId**](RecordingApi.md#putConversationsConversationIdRecordingsRecordingId) | **PUT** /api/v2/conversations/{conversationId}/recordings/{recordingId} | Updates the retention records on a recording.
[**putConversationsConversationIdRecordingsRecordingIdAnnotationsAnnotationId**](RecordingApi.md#putConversationsConversationIdRecordingsRecordingIdAnnotationsAnnotationId) | **PUT** /api/v2/conversations/{conversationId}/recordings/{recordingId}/annotations/{annotationId} | Update annotation
[**putOrphanrecordingsOrphanId**](RecordingApi.md#putOrphanrecordingsOrphanId) | **PUT** /api/v2/orphanrecordings/{orphanId} | Updates an orphan recording to a regular recording with retention values
[**putRecordingLocalkeysSettingsSettingsId**](RecordingApi.md#putRecordingLocalkeysSettingsSettingsId) | **PUT** /api/v2/recording/localkeys/settings/{settingsId} | Update the local encryption settings
[**putRecordingMediaretentionpoliciesPolicyId**](RecordingApi.md#putRecordingMediaretentionpoliciesPolicyId) | **PUT** /api/v2/recording/mediaretentionpolicies/{policyId} | Update a media retention policy
[**putRecordingRecordingkeysRotationschedule**](RecordingApi.md#putRecordingRecordingkeysRotationschedule) | **PUT** /api/v2/recording/recordingkeys/rotationschedule | Update key rotation schedule
[**putRecordingSettings**](RecordingApi.md#putRecordingSettings) | **PUT** /api/v2/recording/settings | Update the Recording Settings for the Organization


# **deleteConversationsConversationIdRecordingsRecordingIdAnnotationsAnnotationId**
> deleteConversationsConversationIdRecordingsRecordingIdAnnotationsAnnotationId($conversationId, $recordingId, $annotationId)

Delete annotation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$conversationId = "conversationId_example"; // string | Conversation ID
$recordingId = "recordingId_example"; // string | Recording ID
$annotationId = "annotationId_example"; // string | Annotation ID

try {
    $api_instance->deleteConversationsConversationIdRecordingsRecordingIdAnnotationsAnnotationId($conversationId, $recordingId, $annotationId);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->deleteConversationsConversationIdRecordingsRecordingIdAnnotationsAnnotationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| Conversation ID |
 **recordingId** | **string**| Recording ID |
 **annotationId** | **string**| Annotation ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteOrphanrecordingsOrphanId**
> \PureCloudSDK\OrphanRecording deleteOrphanrecordingsOrphanId($orphanId)

Deletes a single orphan recording



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$orphanId = "orphanId_example"; // string | Orphan ID

try {
    $result = $api_instance->deleteOrphanrecordingsOrphanId($orphanId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->deleteOrphanrecordingsOrphanId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orphanId** | **string**| Orphan ID |

### Return type

[**\PureCloudSDK\OrphanRecording**](../Model/OrphanRecording.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteRecordingMediaretentionpolicies**
> string deleteRecordingMediaretentionpolicies($ids)

Delete media retention policies

Bulk delete of media retention policies, this will only delete the polices that match the ids specified in the query param.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$ids = "ids_example"; // string | 

try {
    $result = $api_instance->deleteRecordingMediaretentionpolicies($ids);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->deleteRecordingMediaretentionpolicies: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ids** | **string**|  |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteRecordingMediaretentionpoliciesPolicyId**
> string deleteRecordingMediaretentionpoliciesPolicyId($policyId)

Delete a media retention policy



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$policyId = "policyId_example"; // string | Policy ID

try {
    $result = $api_instance->deleteRecordingMediaretentionpoliciesPolicyId($policyId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->deleteRecordingMediaretentionpoliciesPolicyId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **policyId** | **string**| Policy ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsConversationIdRecordings**
> \PureCloudSDK\Recording[] getConversationsConversationIdRecordings($conversationId, $maxWaitMs, $formatId)

Get all of a Conversation's Recordings.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$conversationId = "conversationId_example"; // string | Conversation ID
$maxWaitMs = 5000; // int | The maximum number of milliseconds to wait for the recording to be ready. Must be a positive value.
$formatId = "WEBM"; // string | The desired media format

try {
    $result = $api_instance->getConversationsConversationIdRecordings($conversationId, $maxWaitMs, $formatId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->getConversationsConversationIdRecordings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| Conversation ID |
 **maxWaitMs** | **int**| The maximum number of milliseconds to wait for the recording to be ready. Must be a positive value. | [optional] [default to 5000]
 **formatId** | **string**| The desired media format | [optional] [default to WEBM]

### Return type

[**\PureCloudSDK\Recording[]**](../Model/Recording.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsConversationIdRecordingsRecordingId**
> \PureCloudSDK\Recording getConversationsConversationIdRecordingsRecordingId($conversationId, $recordingId, $formatId, $download, $fileName)

Gets a specific recording.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$conversationId = "conversationId_example"; // string | Conversation ID
$recordingId = "recordingId_example"; // string | Recording ID
$formatId = "WEBM"; // string | The desired media format.
$download = false; // bool | requesting a download format of the recording
$fileName = "fileName_example"; // string | the name of the downloaded fileName

try {
    $result = $api_instance->getConversationsConversationIdRecordingsRecordingId($conversationId, $recordingId, $formatId, $download, $fileName);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->getConversationsConversationIdRecordingsRecordingId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| Conversation ID |
 **recordingId** | **string**| Recording ID |
 **formatId** | **string**| The desired media format. | [optional] [default to WEBM]
 **download** | **bool**| requesting a download format of the recording | [optional] [default to false]
 **fileName** | **string**| the name of the downloaded fileName | [optional]

### Return type

[**\PureCloudSDK\Recording**](../Model/Recording.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsConversationIdRecordingsRecordingIdAnnotations**
> \PureCloudSDK\Annotation[] getConversationsConversationIdRecordingsRecordingIdAnnotations($conversationId, $recordingId)

Get annotations for recording



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$conversationId = "conversationId_example"; // string | Conversation ID
$recordingId = "recordingId_example"; // string | Recording ID

try {
    $result = $api_instance->getConversationsConversationIdRecordingsRecordingIdAnnotations($conversationId, $recordingId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->getConversationsConversationIdRecordingsRecordingIdAnnotations: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| Conversation ID |
 **recordingId** | **string**| Recording ID |

### Return type

[**\PureCloudSDK\Annotation[]**](../Model/Annotation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsConversationIdRecordingsRecordingIdAnnotationsAnnotationId**
> \PureCloudSDK\Annotation getConversationsConversationIdRecordingsRecordingIdAnnotationsAnnotationId($conversationId, $recordingId, $annotationId)

Get annotation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$conversationId = "conversationId_example"; // string | Conversation ID
$recordingId = "recordingId_example"; // string | Recording ID
$annotationId = "annotationId_example"; // string | Annotation ID

try {
    $result = $api_instance->getConversationsConversationIdRecordingsRecordingIdAnnotationsAnnotationId($conversationId, $recordingId, $annotationId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->getConversationsConversationIdRecordingsRecordingIdAnnotationsAnnotationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| Conversation ID |
 **recordingId** | **string**| Recording ID |
 **annotationId** | **string**| Annotation ID |

### Return type

[**\PureCloudSDK\Annotation**](../Model/Annotation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getOrphanrecordings**
> \PureCloudSDK\OrphanRecordingListing getOrphanrecordings($pageSize, $pageNumber, $sortBy, $expand, $nextPage, $previousPage, $hasConversation)

Gets all orphan recordings



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$pageSize = 25; // int | The total page size requested
$pageNumber = 1; // int | The page number requested
$sortBy = "sortBy_example"; // string | variable name requested to sort by
$expand = NULL; // object[] | variable name requested by expand list
$nextPage = "nextPage_example"; // string | next page token
$previousPage = "previousPage_example"; // string | Previous page token
$hasConversation = false; // bool | Filter resulting orphans by whether the conversation is known. False returns all orphans for the organization.

try {
    $result = $api_instance->getOrphanrecordings($pageSize, $pageNumber, $sortBy, $expand, $nextPage, $previousPage, $hasConversation);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->getOrphanrecordings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| The total page size requested | [optional] [default to 25]
 **pageNumber** | **int**| The page number requested | [optional] [default to 1]
 **sortBy** | **string**| variable name requested to sort by | [optional]
 **expand** | [**object[]**](../Model/object.md)| variable name requested by expand list | [optional]
 **nextPage** | **string**| next page token | [optional]
 **previousPage** | **string**| Previous page token | [optional]
 **hasConversation** | **bool**| Filter resulting orphans by whether the conversation is known. False returns all orphans for the organization. | [optional] [default to false]

### Return type

[**\PureCloudSDK\OrphanRecordingListing**](../Model/OrphanRecordingListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getOrphanrecordingsOrphanId**
> \PureCloudSDK\OrphanRecording getOrphanrecordingsOrphanId($orphanId)

Gets a single orphan recording



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$orphanId = "orphanId_example"; // string | Orphan ID

try {
    $result = $api_instance->getOrphanrecordingsOrphanId($orphanId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->getOrphanrecordingsOrphanId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orphanId** | **string**| Orphan ID |

### Return type

[**\PureCloudSDK\OrphanRecording**](../Model/OrphanRecording.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getOrphanrecordingsOrphanIdMedia**
> \PureCloudSDK\Recording getOrphanrecordingsOrphanIdMedia($orphanId, $formatId, $download, $fileName)

Gets the media of a single orphan recording

A 202 response means the orphaned media is currently transcoding and will be available shortly.A 200 response denotes the transcoded orphan media is available now and is contained in the response body.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$orphanId = "orphanId_example"; // string | Orphan ID
$formatId = "WEBM"; // string | The desired media format.
$download = false; // bool | requesting a download format of the recording
$fileName = "fileName_example"; // string | the name of the downloaded fileName

try {
    $result = $api_instance->getOrphanrecordingsOrphanIdMedia($orphanId, $formatId, $download, $fileName);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->getOrphanrecordingsOrphanIdMedia: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orphanId** | **string**| Orphan ID |
 **formatId** | **string**| The desired media format. | [optional] [default to WEBM]
 **download** | **bool**| requesting a download format of the recording | [optional] [default to false]
 **fileName** | **string**| the name of the downloaded fileName | [optional]

### Return type

[**\PureCloudSDK\Recording**](../Model/Recording.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRecordingLocalkeysSettings**
> \PureCloudSDK\LocalEncryptionConfigurationListing getRecordingLocalkeysSettings()

gets a list local key settings data



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();

try {
    $result = $api_instance->getRecordingLocalkeysSettings();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->getRecordingLocalkeysSettings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\LocalEncryptionConfigurationListing**](../Model/LocalEncryptionConfigurationListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRecordingLocalkeysSettingsSettingsId**
> \PureCloudSDK\LocalEncryptionConfiguration getRecordingLocalkeysSettingsSettingsId($settingsId)

Get the local encryption settings



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$settingsId = "settingsId_example"; // string | Settings Id

try {
    $result = $api_instance->getRecordingLocalkeysSettingsSettingsId($settingsId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->getRecordingLocalkeysSettingsSettingsId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **settingsId** | **string**| Settings Id |

### Return type

[**\PureCloudSDK\LocalEncryptionConfiguration**](../Model/LocalEncryptionConfiguration.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRecordingMediaretentionpolicies**
> \PureCloudSDK\PolicyEntityListing getRecordingMediaretentionpolicies($pageSize, $pageNumber, $sortBy, $expand, $nextPage, $previousPage, $name, $enabled, $summary, $hasErrors)

Gets media retention policy list with query options to filter on name and enabled.

for a less verbose response, add summary=true to this endpoint

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$pageSize = 25; // int | The total page size requested
$pageNumber = 1; // int | The page number requested
$sortBy = "sortBy_example"; // string | variable name requested to sort by
$expand = NULL; // object[] | variable name requested by expand list
$nextPage = "nextPage_example"; // string | next page token
$previousPage = "previousPage_example"; // string | Previous page token
$name = "name_example"; // string | the policy name - used for filtering results in searches.
$enabled = true; // bool | checks to see if policy is enabled - use enabled = true or enabled = false
$summary = false; // bool | provides a less verbose response of policy lists.
$hasErrors = true; // bool | provides a way to fetch all policies with errors or policies that do not have errors

try {
    $result = $api_instance->getRecordingMediaretentionpolicies($pageSize, $pageNumber, $sortBy, $expand, $nextPage, $previousPage, $name, $enabled, $summary, $hasErrors);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->getRecordingMediaretentionpolicies: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| The total page size requested | [optional] [default to 25]
 **pageNumber** | **int**| The page number requested | [optional] [default to 1]
 **sortBy** | **string**| variable name requested to sort by | [optional]
 **expand** | [**object[]**](../Model/object.md)| variable name requested by expand list | [optional]
 **nextPage** | **string**| next page token | [optional]
 **previousPage** | **string**| Previous page token | [optional]
 **name** | **string**| the policy name - used for filtering results in searches. | [optional]
 **enabled** | **bool**| checks to see if policy is enabled - use enabled &#x3D; true or enabled &#x3D; false | [optional]
 **summary** | **bool**| provides a less verbose response of policy lists. | [optional] [default to false]
 **hasErrors** | **bool**| provides a way to fetch all policies with errors or policies that do not have errors | [optional]

### Return type

[**\PureCloudSDK\PolicyEntityListing**](../Model/PolicyEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRecordingMediaretentionpoliciesPolicyId**
> \PureCloudSDK\Policy getRecordingMediaretentionpoliciesPolicyId($policyId)

Get a media retention policy



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$policyId = "policyId_example"; // string | Policy ID

try {
    $result = $api_instance->getRecordingMediaretentionpoliciesPolicyId($policyId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->getRecordingMediaretentionpoliciesPolicyId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **policyId** | **string**| Policy ID |

### Return type

[**\PureCloudSDK\Policy**](../Model/Policy.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRecordingRecordingkeys**
> \PureCloudSDK\EncryptionKeyEntityListing getRecordingRecordingkeys($pageSize, $pageNumber)

Get encryption key list



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number

try {
    $result = $api_instance->getRecordingRecordingkeys($pageSize, $pageNumber);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->getRecordingRecordingkeys: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\EncryptionKeyEntityListing**](../Model/EncryptionKeyEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRecordingRecordingkeysRotationschedule**
> \PureCloudSDK\KeyRotationSchedule getRecordingRecordingkeysRotationschedule()

Get key rotation schedule



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();

try {
    $result = $api_instance->getRecordingRecordingkeysRotationschedule();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->getRecordingRecordingkeysRotationschedule: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\KeyRotationSchedule**](../Model/KeyRotationSchedule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRecordingSettings**
> \PureCloudSDK\RecordingSettings getRecordingSettings($createDefault)

Get the Recording Settings for the Organization



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$createDefault = false; // bool | If no settings are found, a new one is created with default values

try {
    $result = $api_instance->getRecordingSettings($createDefault);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->getRecordingSettings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **createDefault** | **bool**| If no settings are found, a new one is created with default values | [optional] [default to false]

### Return type

[**\PureCloudSDK\RecordingSettings**](../Model/RecordingSettings.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRecordingsScreensessions**
> \PureCloudSDK\ScreenRecordingSessionListing getRecordingsScreensessions($pageSize, $pageNumber)

Retrieves a paged listing of screen recording sessions



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number

try {
    $result = $api_instance->getRecordingsScreensessions($pageSize, $pageNumber);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->getRecordingsScreensessions: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\ScreenRecordingSessionListing**](../Model/ScreenRecordingSessionListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchRecordingMediaretentionpoliciesPolicyId**
> \PureCloudSDK\Policy patchRecordingMediaretentionpoliciesPolicyId($policyId, $body)

Patch a media retention policy



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$policyId = "policyId_example"; // string | Policy ID
$body = new \PureCloudSDK\Policy(); // \PureCloudSDK\Policy | Policy

try {
    $result = $api_instance->patchRecordingMediaretentionpoliciesPolicyId($policyId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->patchRecordingMediaretentionpoliciesPolicyId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **policyId** | **string**| Policy ID |
 **body** | [**\PureCloudSDK\Policy**](../Model/\PureCloudSDK\Policy.md)| Policy |

### Return type

[**\PureCloudSDK\Policy**](../Model/Policy.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchRecordingsScreensessionsRecordingsessionId**
> patchRecordingsScreensessionsRecordingsessionId($recordingSessionId, $body)

Update a screen recording session



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$recordingSessionId = "recordingSessionId_example"; // string | Screen recording session ID
$body = new \PureCloudSDK\ScreenRecordingSessionRequest(); // \PureCloudSDK\ScreenRecordingSessionRequest | 

try {
    $api_instance->patchRecordingsScreensessionsRecordingsessionId($recordingSessionId, $body);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->patchRecordingsScreensessionsRecordingsessionId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **recordingSessionId** | **string**| Screen recording session ID |
 **body** | [**\PureCloudSDK\ScreenRecordingSessionRequest**](../Model/\PureCloudSDK\ScreenRecordingSessionRequest.md)|  | [optional]

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsConversationIdRecordingsRecordingIdAnnotations**
> \PureCloudSDK\Annotation postConversationsConversationIdRecordingsRecordingIdAnnotations($conversationId, $recordingId, $body)

Create annotation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$conversationId = "conversationId_example"; // string | Conversation ID
$recordingId = "recordingId_example"; // string | Recording ID
$body = new \PureCloudSDK\Annotation(); // \PureCloudSDK\Annotation | annotation

try {
    $result = $api_instance->postConversationsConversationIdRecordingsRecordingIdAnnotations($conversationId, $recordingId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->postConversationsConversationIdRecordingsRecordingIdAnnotations: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| Conversation ID |
 **recordingId** | **string**| Recording ID |
 **body** | [**\PureCloudSDK\Annotation**](../Model/\PureCloudSDK\Annotation.md)| annotation |

### Return type

[**\PureCloudSDK\Annotation**](../Model/Annotation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postRecordingLocalkeys**
> \PureCloudSDK\EncryptionKey postRecordingLocalkeys($body)

create a local recording key



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$body = new \PureCloudSDK\LocalEncryptionKeyRequest(); // \PureCloudSDK\LocalEncryptionKeyRequest | Local Encryption body

try {
    $result = $api_instance->postRecordingLocalkeys($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->postRecordingLocalkeys: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\LocalEncryptionKeyRequest**](../Model/\PureCloudSDK\LocalEncryptionKeyRequest.md)| Local Encryption body |

### Return type

[**\PureCloudSDK\EncryptionKey**](../Model/EncryptionKey.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postRecordingLocalkeysSettings**
> \PureCloudSDK\LocalEncryptionConfiguration postRecordingLocalkeysSettings($body)

create settings for local key creation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$body = new \PureCloudSDK\LocalEncryptionConfiguration(); // \PureCloudSDK\LocalEncryptionConfiguration | Local Encryption Configuration

try {
    $result = $api_instance->postRecordingLocalkeysSettings($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->postRecordingLocalkeysSettings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\LocalEncryptionConfiguration**](../Model/\PureCloudSDK\LocalEncryptionConfiguration.md)| Local Encryption Configuration |

### Return type

[**\PureCloudSDK\LocalEncryptionConfiguration**](../Model/LocalEncryptionConfiguration.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postRecordingMediaretentionpolicies**
> \PureCloudSDK\Policy postRecordingMediaretentionpolicies($body)

Create media retention policy



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$body = new \PureCloudSDK\PolicyCreate(); // \PureCloudSDK\PolicyCreate | Policy

try {
    $result = $api_instance->postRecordingMediaretentionpolicies($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->postRecordingMediaretentionpolicies: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\PolicyCreate**](../Model/\PureCloudSDK\PolicyCreate.md)| Policy |

### Return type

[**\PureCloudSDK\Policy**](../Model/Policy.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postRecordingRecordingkeys**
> \PureCloudSDK\EncryptionKey postRecordingRecordingkeys()

Create encryption key



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();

try {
    $result = $api_instance->postRecordingRecordingkeys();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->postRecordingRecordingkeys: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\EncryptionKey**](../Model/EncryptionKey.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putConversationsConversationIdRecordingsRecordingId**
> \PureCloudSDK\Recording putConversationsConversationIdRecordingsRecordingId($conversationId, $recordingId, $body)

Updates the retention records on a recording.

Currently supports updating and removing both archive and delete dates for eligible recordings. A request to change the archival date of an archived recording will result in a restoration of the recording until the new date set.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$conversationId = "conversationId_example"; // string | Conversation ID
$recordingId = "recordingId_example"; // string | Recording ID
$body = new \PureCloudSDK\Recording(); // \PureCloudSDK\Recording | recording

try {
    $result = $api_instance->putConversationsConversationIdRecordingsRecordingId($conversationId, $recordingId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->putConversationsConversationIdRecordingsRecordingId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| Conversation ID |
 **recordingId** | **string**| Recording ID |
 **body** | [**\PureCloudSDK\Recording**](../Model/\PureCloudSDK\Recording.md)| recording |

### Return type

[**\PureCloudSDK\Recording**](../Model/Recording.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putConversationsConversationIdRecordingsRecordingIdAnnotationsAnnotationId**
> \PureCloudSDK\Annotation putConversationsConversationIdRecordingsRecordingIdAnnotationsAnnotationId($conversationId, $recordingId, $annotationId, $body)

Update annotation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$conversationId = "conversationId_example"; // string | Conversation ID
$recordingId = "recordingId_example"; // string | Recording ID
$annotationId = "annotationId_example"; // string | Annotation ID
$body = new \PureCloudSDK\Annotation(); // \PureCloudSDK\Annotation | annotation

try {
    $result = $api_instance->putConversationsConversationIdRecordingsRecordingIdAnnotationsAnnotationId($conversationId, $recordingId, $annotationId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->putConversationsConversationIdRecordingsRecordingIdAnnotationsAnnotationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| Conversation ID |
 **recordingId** | **string**| Recording ID |
 **annotationId** | **string**| Annotation ID |
 **body** | [**\PureCloudSDK\Annotation**](../Model/\PureCloudSDK\Annotation.md)| annotation |

### Return type

[**\PureCloudSDK\Annotation**](../Model/Annotation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putOrphanrecordingsOrphanId**
> \PureCloudSDK\Recording putOrphanrecordingsOrphanId($orphanId, $body)

Updates an orphan recording to a regular recording with retention values

If this operation is successful the orphan will no longer exist. It will be replaced by the resulting recording in the response. This replacement recording is accessible by the normal Recording api.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$orphanId = "orphanId_example"; // string | Orphan ID
$body = new \PureCloudSDK\OrphanUpdateRequest(); // \PureCloudSDK\OrphanUpdateRequest | 

try {
    $result = $api_instance->putOrphanrecordingsOrphanId($orphanId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->putOrphanrecordingsOrphanId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orphanId** | **string**| Orphan ID |
 **body** | [**\PureCloudSDK\OrphanUpdateRequest**](../Model/\PureCloudSDK\OrphanUpdateRequest.md)|  | [optional]

### Return type

[**\PureCloudSDK\Recording**](../Model/Recording.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putRecordingLocalkeysSettingsSettingsId**
> \PureCloudSDK\LocalEncryptionConfiguration putRecordingLocalkeysSettingsSettingsId($settingsId, $body)

Update the local encryption settings



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$settingsId = "settingsId_example"; // string | Settings Id
$body = new \PureCloudSDK\LocalEncryptionConfiguration(); // \PureCloudSDK\LocalEncryptionConfiguration | Local Encryption metadata

try {
    $result = $api_instance->putRecordingLocalkeysSettingsSettingsId($settingsId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->putRecordingLocalkeysSettingsSettingsId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **settingsId** | **string**| Settings Id |
 **body** | [**\PureCloudSDK\LocalEncryptionConfiguration**](../Model/\PureCloudSDK\LocalEncryptionConfiguration.md)| Local Encryption metadata |

### Return type

[**\PureCloudSDK\LocalEncryptionConfiguration**](../Model/LocalEncryptionConfiguration.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putRecordingMediaretentionpoliciesPolicyId**
> \PureCloudSDK\Policy putRecordingMediaretentionpoliciesPolicyId($policyId, $body)

Update a media retention policy



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$policyId = "policyId_example"; // string | Policy ID
$body = new \PureCloudSDK\Policy(); // \PureCloudSDK\Policy | Policy

try {
    $result = $api_instance->putRecordingMediaretentionpoliciesPolicyId($policyId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->putRecordingMediaretentionpoliciesPolicyId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **policyId** | **string**| Policy ID |
 **body** | [**\PureCloudSDK\Policy**](../Model/\PureCloudSDK\Policy.md)| Policy |

### Return type

[**\PureCloudSDK\Policy**](../Model/Policy.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putRecordingRecordingkeysRotationschedule**
> \PureCloudSDK\KeyRotationSchedule putRecordingRecordingkeysRotationschedule($body)

Update key rotation schedule



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$body = new \PureCloudSDK\KeyRotationSchedule(); // \PureCloudSDK\KeyRotationSchedule | KeyRotationSchedule

try {
    $result = $api_instance->putRecordingRecordingkeysRotationschedule($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->putRecordingRecordingkeysRotationschedule: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\KeyRotationSchedule**](../Model/\PureCloudSDK\KeyRotationSchedule.md)| KeyRotationSchedule |

### Return type

[**\PureCloudSDK\KeyRotationSchedule**](../Model/KeyRotationSchedule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putRecordingSettings**
> \PureCloudSDK\RecordingSettings putRecordingSettings($body)

Update the Recording Settings for the Organization



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$body = new \PureCloudSDK\RecordingSettings(); // \PureCloudSDK\RecordingSettings | Recording settings

try {
    $result = $api_instance->putRecordingSettings($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->putRecordingSettings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\RecordingSettings**](../Model/\PureCloudSDK\RecordingSettings.md)| Recording settings |

### Return type

[**\PureCloudSDK\RecordingSettings**](../Model/RecordingSettings.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

