# PureCloudSDK\ResponseManagementApi

All URIs are relative to *https://api.mypurecloud.ie*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteResponsemanagementLibrariesLibraryId**](ResponseManagementApi.md#deleteResponsemanagementLibrariesLibraryId) | **DELETE** /api/v2/responsemanagement/libraries/{libraryId} | Delete an existing response library.
[**deleteResponsemanagementResponsesResponseId**](ResponseManagementApi.md#deleteResponsemanagementResponsesResponseId) | **DELETE** /api/v2/responsemanagement/responses/{responseId} | Delete an existing response.
[**getResponsemanagementLibraries**](ResponseManagementApi.md#getResponsemanagementLibraries) | **GET** /api/v2/responsemanagement/libraries | Gets a list of existing response libraries.
[**getResponsemanagementLibrariesLibraryId**](ResponseManagementApi.md#getResponsemanagementLibrariesLibraryId) | **GET** /api/v2/responsemanagement/libraries/{libraryId} | Get details about an existing response library.
[**getResponsemanagementResponses**](ResponseManagementApi.md#getResponsemanagementResponses) | **GET** /api/v2/responsemanagement/responses | Gets a list of existing responses.
[**getResponsemanagementResponsesResponseId**](ResponseManagementApi.md#getResponsemanagementResponsesResponseId) | **GET** /api/v2/responsemanagement/responses/{responseId} | Get details about an existing response.
[**postResponsemanagementLibraries**](ResponseManagementApi.md#postResponsemanagementLibraries) | **POST** /api/v2/responsemanagement/libraries | Create a response library.
[**postResponsemanagementResponses**](ResponseManagementApi.md#postResponsemanagementResponses) | **POST** /api/v2/responsemanagement/responses | Create a response.
[**postResponsemanagementResponsesQuery**](ResponseManagementApi.md#postResponsemanagementResponsesQuery) | **POST** /api/v2/responsemanagement/responses/query | Query responses
[**putResponsemanagementLibrariesLibraryId**](ResponseManagementApi.md#putResponsemanagementLibrariesLibraryId) | **PUT** /api/v2/responsemanagement/libraries/{libraryId} | Update an existing response library.
[**putResponsemanagementResponsesResponseId**](ResponseManagementApi.md#putResponsemanagementResponsesResponseId) | **PUT** /api/v2/responsemanagement/responses/{responseId} | Update an existing response.


# **deleteResponsemanagementLibrariesLibraryId**
> deleteResponsemanagementLibrariesLibraryId($libraryId)

Delete an existing response library.

This will remove any responses associated with the library.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ResponseManagementApi();
$libraryId = "libraryId_example"; // string | Library ID

try {
    $api_instance->deleteResponsemanagementLibrariesLibraryId($libraryId);
} catch (Exception $e) {
    echo 'Exception when calling ResponseManagementApi->deleteResponsemanagementLibrariesLibraryId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **libraryId** | **string**| Library ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteResponsemanagementResponsesResponseId**
> deleteResponsemanagementResponsesResponseId($responseId)

Delete an existing response.

This will remove the response from any libraries associated with it.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ResponseManagementApi();
$responseId = "responseId_example"; // string | Response ID

try {
    $api_instance->deleteResponsemanagementResponsesResponseId($responseId);
} catch (Exception $e) {
    echo 'Exception when calling ResponseManagementApi->deleteResponsemanagementResponsesResponseId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **responseId** | **string**| Response ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getResponsemanagementLibraries**
> \PureCloudSDK\LibraryEntityListing getResponsemanagementLibraries($pageNumber, $pageSize)

Gets a list of existing response libraries.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ResponseManagementApi();
$pageNumber = 1; // int | Page number
$pageSize = 25; // int | Page size

try {
    $result = $api_instance->getResponsemanagementLibraries($pageNumber, $pageSize);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ResponseManagementApi->getResponsemanagementLibraries: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **pageSize** | **int**| Page size | [optional] [default to 25]

### Return type

[**\PureCloudSDK\LibraryEntityListing**](../Model/LibraryEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getResponsemanagementLibrariesLibraryId**
> \PureCloudSDK\Library getResponsemanagementLibrariesLibraryId($libraryId)

Get details about an existing response library.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ResponseManagementApi();
$libraryId = "libraryId_example"; // string | Library ID

try {
    $result = $api_instance->getResponsemanagementLibrariesLibraryId($libraryId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ResponseManagementApi->getResponsemanagementLibrariesLibraryId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **libraryId** | **string**| Library ID |

### Return type

[**\PureCloudSDK\Library**](../Model/Library.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getResponsemanagementResponses**
> \PureCloudSDK\ResponseEntityListing getResponsemanagementResponses($libraryId, $pageNumber, $pageSize)

Gets a list of existing responses.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ResponseManagementApi();
$libraryId = "libraryId_example"; // string | Library ID
$pageNumber = 1; // int | Page number
$pageSize = 25; // int | Page size

try {
    $result = $api_instance->getResponsemanagementResponses($libraryId, $pageNumber, $pageSize);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ResponseManagementApi->getResponsemanagementResponses: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **libraryId** | **string**| Library ID |
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **pageSize** | **int**| Page size | [optional] [default to 25]

### Return type

[**\PureCloudSDK\ResponseEntityListing**](../Model/ResponseEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getResponsemanagementResponsesResponseId**
> \PureCloudSDK\Response getResponsemanagementResponsesResponseId($responseId)

Get details about an existing response.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ResponseManagementApi();
$responseId = "responseId_example"; // string | Response ID

try {
    $result = $api_instance->getResponsemanagementResponsesResponseId($responseId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ResponseManagementApi->getResponsemanagementResponsesResponseId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **responseId** | **string**| Response ID |

### Return type

[**\PureCloudSDK\Response**](../Model/Response.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postResponsemanagementLibraries**
> \PureCloudSDK\Library postResponsemanagementLibraries($body)

Create a response library.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ResponseManagementApi();
$body = new \PureCloudSDK\Library(); // \PureCloudSDK\Library | Library

try {
    $result = $api_instance->postResponsemanagementLibraries($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ResponseManagementApi->postResponsemanagementLibraries: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Library**](../Model/\PureCloudSDK\Library.md)| Library |

### Return type

[**\PureCloudSDK\Library**](../Model/Library.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postResponsemanagementResponses**
> \PureCloudSDK\Response postResponsemanagementResponses($body)

Create a response.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ResponseManagementApi();
$body = new \PureCloudSDK\Response(); // \PureCloudSDK\Response | Response

try {
    $result = $api_instance->postResponsemanagementResponses($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ResponseManagementApi->postResponsemanagementResponses: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Response**](../Model/\PureCloudSDK\Response.md)| Response |

### Return type

[**\PureCloudSDK\Response**](../Model/Response.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postResponsemanagementResponsesQuery**
> \PureCloudSDK\ResponseQueryResults postResponsemanagementResponsesQuery($body)

Query responses



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ResponseManagementApi();
$body = new \PureCloudSDK\ResponseQueryRequest(); // \PureCloudSDK\ResponseQueryRequest | Response

try {
    $result = $api_instance->postResponsemanagementResponsesQuery($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ResponseManagementApi->postResponsemanagementResponsesQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\ResponseQueryRequest**](../Model/\PureCloudSDK\ResponseQueryRequest.md)| Response |

### Return type

[**\PureCloudSDK\ResponseQueryResults**](../Model/ResponseQueryResults.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putResponsemanagementLibrariesLibraryId**
> \PureCloudSDK\Library putResponsemanagementLibrariesLibraryId($libraryId, $body)

Update an existing response library.

Fields that can be updated: name. The most recent version is required for updates.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ResponseManagementApi();
$libraryId = "libraryId_example"; // string | Library ID
$body = new \PureCloudSDK\Library(); // \PureCloudSDK\Library | Library

try {
    $result = $api_instance->putResponsemanagementLibrariesLibraryId($libraryId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ResponseManagementApi->putResponsemanagementLibrariesLibraryId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **libraryId** | **string**| Library ID |
 **body** | [**\PureCloudSDK\Library**](../Model/\PureCloudSDK\Library.md)| Library |

### Return type

[**\PureCloudSDK\Library**](../Model/Library.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putResponsemanagementResponsesResponseId**
> \PureCloudSDK\Response putResponsemanagementResponsesResponseId($responseId, $body)

Update an existing response.

Fields that can be updated: name, libraries, and texts. The most recent version is required for updates.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ResponseManagementApi();
$responseId = "responseId_example"; // string | Response ID
$body = new \PureCloudSDK\Response(); // \PureCloudSDK\Response | Response

try {
    $result = $api_instance->putResponsemanagementResponsesResponseId($responseId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ResponseManagementApi->putResponsemanagementResponsesResponseId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **responseId** | **string**| Response ID |
 **body** | [**\PureCloudSDK\Response**](../Model/\PureCloudSDK\Response.md)| Response |

### Return type

[**\PureCloudSDK\Response**](../Model/Response.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

