# PureCloudSDK\StationsApi

All URIs are relative to *https://api.mypurecloud.ie*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteStationsStationIdAssociateduser**](StationsApi.md#deleteStationsStationIdAssociateduser) | **DELETE** /api/v2/stations/{stationId}/associateduser | Unassigns the user assigned to this station
[**getStations**](StationsApi.md#getStations) | **GET** /api/v2/stations | Get the list of available stations.
[**getStationsStationId**](StationsApi.md#getStationsStationId) | **GET** /api/v2/stations/{stationId} | Get station.


# **deleteStationsStationIdAssociateduser**
> string deleteStationsStationIdAssociateduser($stationId)

Unassigns the user assigned to this station



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\StationsApi();
$stationId = "stationId_example"; // string | Station ID

try {
    $result = $api_instance->deleteStationsStationIdAssociateduser($stationId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StationsApi->deleteStationsStationIdAssociateduser: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **stationId** | **string**| Station ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getStations**
> \PureCloudSDK\StationEntityListing getStations($pageSize, $pageNumber, $sortBy, $name, $id, $lineAppearanceId)

Get the list of available stations.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\StationsApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$sortBy = "name"; // string | Sort by
$name = "name_example"; // string | Name
$id = "id_example"; // string | Comma separated list of stationIds
$lineAppearanceId = "lineAppearanceId_example"; // string | lineAppearanceId

try {
    $result = $api_instance->getStations($pageSize, $pageNumber, $sortBy, $name, $id, $lineAppearanceId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StationsApi->getStations: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **sortBy** | **string**| Sort by | [optional] [default to name]
 **name** | **string**| Name | [optional]
 **id** | **string**| Comma separated list of stationIds | [optional]
 **lineAppearanceId** | **string**| lineAppearanceId | [optional]

### Return type

[**\PureCloudSDK\StationEntityListing**](../Model/StationEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getStationsStationId**
> \PureCloudSDK\Station getStationsStationId($stationId)

Get station.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\StationsApi();
$stationId = "stationId_example"; // string | Station ID

try {
    $result = $api_instance->getStationsStationId($stationId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StationsApi->getStationsStationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **stationId** | **string**| Station ID |

### Return type

[**\PureCloudSDK\Station**](../Model/Station.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

