# Campaign

## Properties
Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**id** | **string** | The globally unique identifier for the object. | [optional] 
**name** | **string** |  | [optional] 
**dateCreated** | [**\DateTime**](\DateTime.md) | Creation time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional] 
**dateModified** | [**\DateTime**](\DateTime.md) | Last modified time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional] 
**version** | **int** | Required for updates, must match the version number of the most recent update | [optional] 
**contactList** | [**\PureCloudSDK\UriReference**](UriReference.md) | identifier of the contact list for the campaign | 
**queue** | [**\PureCloudSDK\UriReference**](UriReference.md) | identifier of the agent assignment queue, required for all dialing modes other than agentless | 
**dialingMode** | **string** | dialing mode of the campaign | 
**script** | [**\PureCloudSDK\UriReference**](UriReference.md) | identifier of the campaign script, required for all dialing modes other than agentless | 
**edgeGroup** | [**\PureCloudSDK\UriReference**](UriReference.md) | identifier of the edge group, required for all dialing modes other than preview | 
**campaignStatus** | **string** | status of the campaign; can be set to &#39;on&#39; or &#39;off&#39; | 
**phoneColumns** | [**\PureCloudSDK\PhoneColumn[]**](PhoneColumn.md) | the contact list phone columns to be called for the campaign | 
**abandonRate** | **double** | the targeted abandon rate percentage | [optional] 
**dncLists** | [**\PureCloudSDK\UriReference[]**](UriReference.md) | identifiers of the do not call lists | [optional] 
**callableTimeSet** | [**\PureCloudSDK\UriReference**](UriReference.md) | the identifier of the callable time set | [optional] 
**callAnalysisResponseSet** | [**\PureCloudSDK\UriReference**](UriReference.md) | the identifier of the call analysis response set, required for all dialing modes other than preview | 
**errors** | [**\PureCloudSDK\RestErrorDetail[]**](RestErrorDetail.md) | a list of current error conditions associated with the campaign | [optional] 
**callerName** | **string** | caller id name to be displayed on the outbound call | [optional] 
**callerAddress** | **string** | caller id phone number to be displayed on the outbound call | [optional] 
**outboundLineCount** | **int** | for agentless campaigns, the number of outbound lines to be concurrently dialed | [optional] 
**ruleSets** | [**\PureCloudSDK\UriReference[]**](UriReference.md) | identifiers of the rule sets | [optional] 
**skipPreviewDisabled** | **bool** | for preview campaigns, indicator of whether the agent can skip a preview without placing a call | [optional] 
**previewTimeOutSeconds** | **int** | for preview campaigns, number of seconds before a call will be automatically placed. A value of 0 indicates no automatic placement of calls | [optional] 
**contactSort** | [**\PureCloudSDK\ContactSort**](ContactSort.md) | information determining the order in which the contacts will be dialed | [optional] 
**noAnswerTimeout** | **int** | for non-preview campaigns, how long to wait before dispositioning as &#39;no-answer&#39;, default 30 seconds | [optional] 
**callAnalysisLanguage** | **string** | The language the edge will use to analyse the call | [optional] 
**priority** | **int** | The priority of this campaign relative to other campaigns | [optional] 
**selfUri** | **string** | The URI for this object | [optional] 

[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


