# TimeOffRequest

## Properties
Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**id** | **string** | The globally unique identifier for the object. | [optional] 
**name** | **string** |  | [optional] 
**user** | [**\PureCloudSDK\User**](User.md) | The user associated with this TimeOffRequest | 
**isFullDayRequest** | **bool** | Whether this is a full day request (false means partial day) | 
**markedAsRead** | **bool** | Whether this request has been marked as read by the agent | 
**activityCodeId** | **string** | The ID of the activity code associated with this TimeOffRequest | 
**status** | **string** | The administrative status of this TimeOffRequest | 
**partialDayStartDateTimes** | [**\DateTime[]**](\DateTime.md) | The start date-times for partial day requests.  Required if isFullDayRequest &#x3D;&#x3D; false | [optional] 
**dailyDurationMinutes** | **int** | The daily duration of this TimeOffRequest in minutes | 
**notes** | **string** | The notes as input by the one who entered the TimeOffRequest | [optional] 
**submittedBy** | [**\PureCloudSDK\User**](User.md) | The user who submitted this TimeOffRequest | [optional] 
**submittedDate** | [**\DateTime**](\DateTime.md) | The timestamp when this request was submitted. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional] 
**reviewedBy** | [**\PureCloudSDK\User**](User.md) | The user who reviewed this TimeOffRequest | [optional] 
**reviewedDate** | [**\DateTime**](\DateTime.md) | The timestamp when this request was reviewed. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional] 
**modifiedBy** | [**\PureCloudSDK\User**](User.md) | The user who last modified this TimeOffRequest | [optional] 
**modifiedDate** | [**\DateTime**](\DateTime.md) | The timestamp when this request was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional] 
**selfUri** | **string** | The URI for this object | [optional] 
**fullDayManagementUnitDates** | **string[]** | ISO-8601 date only with no timezones.  Should be interpreted in the Management Unit&#39;s configured time zone.  Required if isFullDayRequest &#x3D;&#x3D; true | [optional] 

[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


