# PureCloudSDK\ArchitectApi

All URIs are relative to *https://api.mypurecloud.ie*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteArchitectPrompts**](ArchitectApi.md#deleteArchitectPrompts) | **DELETE** /api/v2/architect/prompts | Batch-delete a list of prompts asynchronously
[**deleteArchitectPromptsPromptId**](ArchitectApi.md#deleteArchitectPromptsPromptId) | **DELETE** /api/v2/architect/prompts/{promptId} | Delete specified user prompt
[**deleteArchitectPromptsPromptIdResourcesLanguagecode**](ArchitectApi.md#deleteArchitectPromptsPromptIdResourcesLanguagecode) | **DELETE** /api/v2/architect/prompts/{promptId}/resources/{languageCode} | Delete specified user prompt resource
[**deleteArchitectSystempromptsPromptIdResourcesLanguagecode**](ArchitectApi.md#deleteArchitectSystempromptsPromptIdResourcesLanguagecode) | **DELETE** /api/v2/architect/systemprompts/{promptId}/resources/{languageCode} | Delete a system prompt resource override.
[**getArchitectPrompts**](ArchitectApi.md#getArchitectPrompts) | **GET** /api/v2/architect/prompts | Get a pageable list of user prompts
[**getArchitectPromptsPromptId**](ArchitectApi.md#getArchitectPromptsPromptId) | **GET** /api/v2/architect/prompts/{promptId} | Get specified user prompt
[**getArchitectPromptsPromptIdResources**](ArchitectApi.md#getArchitectPromptsPromptIdResources) | **GET** /api/v2/architect/prompts/{promptId}/resources | Get a pageable list of user prompt resources
[**getArchitectPromptsPromptIdResourcesLanguagecode**](ArchitectApi.md#getArchitectPromptsPromptIdResourcesLanguagecode) | **GET** /api/v2/architect/prompts/{promptId}/resources/{languageCode} | Get specified user prompt resource
[**getArchitectSystemprompts**](ArchitectApi.md#getArchitectSystemprompts) | **GET** /api/v2/architect/systemprompts | Get System Prompts
[**getArchitectSystempromptsPromptId**](ArchitectApi.md#getArchitectSystempromptsPromptId) | **GET** /api/v2/architect/systemprompts/{promptId} | Get a system prompt
[**getArchitectSystempromptsPromptIdResources**](ArchitectApi.md#getArchitectSystempromptsPromptIdResources) | **GET** /api/v2/architect/systemprompts/{promptId}/resources | Get IVR System Prompt resources.
[**getArchitectSystempromptsPromptIdResourcesLanguagecode**](ArchitectApi.md#getArchitectSystempromptsPromptIdResourcesLanguagecode) | **GET** /api/v2/architect/systemprompts/{promptId}/resources/{languageCode} | Get a system prompt resource.
[**getFlows**](ArchitectApi.md#getFlows) | **GET** /api/v2/flows | Get a pageable list of flows, filtered by query parameters
[**postArchitectPrompts**](ArchitectApi.md#postArchitectPrompts) | **POST** /api/v2/architect/prompts | Create a new user prompt
[**postArchitectPromptsPromptIdResources**](ArchitectApi.md#postArchitectPromptsPromptIdResources) | **POST** /api/v2/architect/prompts/{promptId}/resources | Create a new user prompt resource
[**postArchitectSystempromptsPromptIdResources**](ArchitectApi.md#postArchitectSystempromptsPromptIdResources) | **POST** /api/v2/architect/systemprompts/{promptId}/resources | Create system prompt resource override.
[**putArchitectPromptsPromptId**](ArchitectApi.md#putArchitectPromptsPromptId) | **PUT** /api/v2/architect/prompts/{promptId} | Update specified user prompt
[**putArchitectPromptsPromptIdResourcesLanguagecode**](ArchitectApi.md#putArchitectPromptsPromptIdResourcesLanguagecode) | **PUT** /api/v2/architect/prompts/{promptId}/resources/{languageCode} | Update specified user prompt resource
[**putArchitectSystempromptsPromptIdResourcesLanguagecode**](ArchitectApi.md#putArchitectSystempromptsPromptIdResourcesLanguagecode) | **PUT** /api/v2/architect/systemprompts/{promptId}/resources/{languageCode} | Updates a system prompt resource override.


# **deleteArchitectPrompts**
> \PureCloudSDK\Operation deleteArchitectPrompts($id)

Batch-delete a list of prompts asynchronously

Multiple IDs can be specified, in which case all specified prompts will be deleted.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$id = array("id_example"); // string[] | List of Prompt IDs

try {
    $result = $api_instance->deleteArchitectPrompts($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->deleteArchitectPrompts: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | [**string[]**](../Model/string.md)| List of Prompt IDs |

### Return type

[**\PureCloudSDK\Operation**](../Model/Operation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteArchitectPromptsPromptId**
> deleteArchitectPromptsPromptId($promptId, $allResources)

Delete specified user prompt



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$promptId = "promptId_example"; // string | Prompt ID
$allResources = true; // bool | Whether or not to delete all the prompt resources

try {
    $api_instance->deleteArchitectPromptsPromptId($promptId, $allResources);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->deleteArchitectPromptsPromptId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **promptId** | **string**| Prompt ID |
 **allResources** | **bool**| Whether or not to delete all the prompt resources | [optional]

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteArchitectPromptsPromptIdResourcesLanguagecode**
> deleteArchitectPromptsPromptIdResourcesLanguagecode($promptId, $languageCode)

Delete specified user prompt resource



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$promptId = "promptId_example"; // string | Prompt ID
$languageCode = "languageCode_example"; // string | Language

try {
    $api_instance->deleteArchitectPromptsPromptIdResourcesLanguagecode($promptId, $languageCode);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->deleteArchitectPromptsPromptIdResourcesLanguagecode: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **promptId** | **string**| Prompt ID |
 **languageCode** | **string**| Language |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteArchitectSystempromptsPromptIdResourcesLanguagecode**
> string deleteArchitectSystempromptsPromptIdResourcesLanguagecode($promptId, $languageCode)

Delete a system prompt resource override.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$promptId = "promptId_example"; // string | Prompt ID
$languageCode = "languageCode_example"; // string | Language

try {
    $result = $api_instance->deleteArchitectSystempromptsPromptIdResourcesLanguagecode($promptId, $languageCode);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->deleteArchitectSystempromptsPromptIdResourcesLanguagecode: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **promptId** | **string**| Prompt ID |
 **languageCode** | **string**| Language |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getArchitectPrompts**
> \PureCloudSDK\PromptEntityListing getArchitectPrompts($pageNumber, $pageSize, $name, $description, $nameOrDescription)

Get a pageable list of user prompts

The returned list is pageable, and query parameters can be used for filtering.  Multiple names can be specified, in which case all matching prompts will be returned, and no other filters will be evaluated.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$pageNumber = 1; // int | Page number
$pageSize = 25; // int | Page size
$name = "name_example"; // string | Name
$description = "description_example"; // string | Description
$nameOrDescription = "nameOrDescription_example"; // string | Name or description

try {
    $result = $api_instance->getArchitectPrompts($pageNumber, $pageSize, $name, $description, $nameOrDescription);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->getArchitectPrompts: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **name** | **string**| Name | [optional]
 **description** | **string**| Description | [optional]
 **nameOrDescription** | **string**| Name or description | [optional]

### Return type

[**\PureCloudSDK\PromptEntityListing**](../Model/PromptEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getArchitectPromptsPromptId**
> \PureCloudSDK\Prompt getArchitectPromptsPromptId($promptId)

Get specified user prompt



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$promptId = "promptId_example"; // string | Prompt ID

try {
    $result = $api_instance->getArchitectPromptsPromptId($promptId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->getArchitectPromptsPromptId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **promptId** | **string**| Prompt ID |

### Return type

[**\PureCloudSDK\Prompt**](../Model/Prompt.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getArchitectPromptsPromptIdResources**
> \PureCloudSDK\PromptAssetEntityListing getArchitectPromptsPromptIdResources($promptId, $pageNumber, $pageSize)

Get a pageable list of user prompt resources

The returned list is pageable, and query parameters can be used for filtering.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$promptId = "promptId_example"; // string | Prompt ID
$pageNumber = 1; // int | Page number
$pageSize = 25; // int | Page size

try {
    $result = $api_instance->getArchitectPromptsPromptIdResources($promptId, $pageNumber, $pageSize);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->getArchitectPromptsPromptIdResources: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **promptId** | **string**| Prompt ID |
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **pageSize** | **int**| Page size | [optional] [default to 25]

### Return type

[**\PureCloudSDK\PromptAssetEntityListing**](../Model/PromptAssetEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getArchitectPromptsPromptIdResourcesLanguagecode**
> \PureCloudSDK\PromptAsset getArchitectPromptsPromptIdResourcesLanguagecode($promptId, $languageCode)

Get specified user prompt resource



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$promptId = "promptId_example"; // string | Prompt ID
$languageCode = "languageCode_example"; // string | Language

try {
    $result = $api_instance->getArchitectPromptsPromptIdResourcesLanguagecode($promptId, $languageCode);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->getArchitectPromptsPromptIdResourcesLanguagecode: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **promptId** | **string**| Prompt ID |
 **languageCode** | **string**| Language |

### Return type

[**\PureCloudSDK\PromptAsset**](../Model/PromptAsset.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getArchitectSystemprompts**
> \PureCloudSDK\SystemPromptEntityListing getArchitectSystemprompts($pageNumber, $pageSize, $sortBy, $sortOrder, $name, $description, $nameOrDescription)

Get System Prompts



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$pageNumber = 1; // int | Page number
$pageSize = 25; // int | Page size
$sortBy = "id"; // string | Sort by
$sortOrder = "asc"; // string | Sort order
$name = "name_example"; // string | Name
$description = "description_example"; // string | Description
$nameOrDescription = "nameOrDescription_example"; // string | Name or description

try {
    $result = $api_instance->getArchitectSystemprompts($pageNumber, $pageSize, $sortBy, $sortOrder, $name, $description, $nameOrDescription);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->getArchitectSystemprompts: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **sortBy** | **string**| Sort by | [optional] [default to id]
 **sortOrder** | **string**| Sort order | [optional] [default to asc]
 **name** | **string**| Name | [optional]
 **description** | **string**| Description | [optional]
 **nameOrDescription** | **string**| Name or description | [optional]

### Return type

[**\PureCloudSDK\SystemPromptEntityListing**](../Model/SystemPromptEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getArchitectSystempromptsPromptId**
> \PureCloudSDK\SystemPrompt getArchitectSystempromptsPromptId($promptId)

Get a system prompt



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$promptId = "promptId_example"; // string | promptId

try {
    $result = $api_instance->getArchitectSystempromptsPromptId($promptId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->getArchitectSystempromptsPromptId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **promptId** | **string**| promptId |

### Return type

[**\PureCloudSDK\SystemPrompt**](../Model/SystemPrompt.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getArchitectSystempromptsPromptIdResources**
> \PureCloudSDK\SystemPromptAssetEntityListing getArchitectSystempromptsPromptIdResources($promptId, $pageNumber, $pageSize, $sortBy, $sortOrder)

Get IVR System Prompt resources.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$promptId = "promptId_example"; // string | Prompt ID
$pageNumber = 1; // int | Page number
$pageSize = 25; // int | Page size
$sortBy = "id"; // string | Sort by
$sortOrder = "asc"; // string | Sort order

try {
    $result = $api_instance->getArchitectSystempromptsPromptIdResources($promptId, $pageNumber, $pageSize, $sortBy, $sortOrder);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->getArchitectSystempromptsPromptIdResources: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **promptId** | **string**| Prompt ID |
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **sortBy** | **string**| Sort by | [optional] [default to id]
 **sortOrder** | **string**| Sort order | [optional] [default to asc]

### Return type

[**\PureCloudSDK\SystemPromptAssetEntityListing**](../Model/SystemPromptAssetEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getArchitectSystempromptsPromptIdResourcesLanguagecode**
> \PureCloudSDK\SystemPromptAsset getArchitectSystempromptsPromptIdResourcesLanguagecode($promptId, $languageCode)

Get a system prompt resource.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$promptId = "promptId_example"; // string | Prompt ID
$languageCode = "languageCode_example"; // string | Language

try {
    $result = $api_instance->getArchitectSystempromptsPromptIdResourcesLanguagecode($promptId, $languageCode);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->getArchitectSystempromptsPromptIdResourcesLanguagecode: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **promptId** | **string**| Prompt ID |
 **languageCode** | **string**| Language |

### Return type

[**\PureCloudSDK\SystemPromptAsset**](../Model/SystemPromptAsset.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getFlows**
> \PureCloudSDK\FlowEntityListing getFlows($type, $pageNumber, $pageSize, $sortBy, $sortOrder, $id, $name, $description, $nameOrDescription, $publishVersionId, $editableBy, $lockedBy, $secure, $deleted, $includeSchemas)

Get a pageable list of flows, filtered by query parameters

Multiple IDs can be specified, in which case all matching flows will be returned, and no other parameters will be evaluated.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$type = "type_example"; // string | Type
$pageNumber = 1; // int | Page number
$pageSize = 25; // int | Page size
$sortBy = "id"; // string | Sort by
$sortOrder = "asc"; // string | Sort order
$id = array("id_example"); // string[] | ID
$name = "name_example"; // string | Name
$description = "description_example"; // string | Description
$nameOrDescription = "nameOrDescription_example"; // string | Name or description
$publishVersionId = "publishVersionId_example"; // string | Publish version ID
$editableBy = "editableBy_example"; // string | Editable by
$lockedBy = "lockedBy_example"; // string | Locked by
$secure = "secure_example"; // string | Secure
$deleted = false; // bool | Include deleted
$includeSchemas = false; // bool | Include variable schemas

try {
    $result = $api_instance->getFlows($type, $pageNumber, $pageSize, $sortBy, $sortOrder, $id, $name, $description, $nameOrDescription, $publishVersionId, $editableBy, $lockedBy, $secure, $deleted, $includeSchemas);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->getFlows: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **type** | **string**| Type |
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **sortBy** | **string**| Sort by | [optional] [default to id]
 **sortOrder** | **string**| Sort order | [optional] [default to asc]
 **id** | [**string[]**](../Model/string.md)| ID | [optional]
 **name** | **string**| Name | [optional]
 **description** | **string**| Description | [optional]
 **nameOrDescription** | **string**| Name or description | [optional]
 **publishVersionId** | **string**| Publish version ID | [optional]
 **editableBy** | **string**| Editable by | [optional]
 **lockedBy** | **string**| Locked by | [optional]
 **secure** | **string**| Secure | [optional]
 **deleted** | **bool**| Include deleted | [optional] [default to false]
 **includeSchemas** | **bool**| Include variable schemas | [optional] [default to false]

### Return type

[**\PureCloudSDK\FlowEntityListing**](../Model/FlowEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postArchitectPrompts**
> \PureCloudSDK\Prompt postArchitectPrompts($body)

Create a new user prompt



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$body = new \PureCloudSDK\Prompt(); // \PureCloudSDK\Prompt | 

try {
    $result = $api_instance->postArchitectPrompts($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->postArchitectPrompts: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Prompt**](../Model/\PureCloudSDK\Prompt.md)|  | [optional]

### Return type

[**\PureCloudSDK\Prompt**](../Model/Prompt.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postArchitectPromptsPromptIdResources**
> \PureCloudSDK\PromptAsset postArchitectPromptsPromptIdResources($promptId, $body)

Create a new user prompt resource



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$promptId = "promptId_example"; // string | Prompt ID
$body = new \PureCloudSDK\PromptAssetCreate(); // \PureCloudSDK\PromptAssetCreate | 

try {
    $result = $api_instance->postArchitectPromptsPromptIdResources($promptId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->postArchitectPromptsPromptIdResources: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **promptId** | **string**| Prompt ID |
 **body** | [**\PureCloudSDK\PromptAssetCreate**](../Model/\PureCloudSDK\PromptAssetCreate.md)|  | [optional]

### Return type

[**\PureCloudSDK\PromptAsset**](../Model/PromptAsset.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postArchitectSystempromptsPromptIdResources**
> \PureCloudSDK\SystemPromptAsset postArchitectSystempromptsPromptIdResources($promptId, $body)

Create system prompt resource override.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$promptId = "promptId_example"; // string | Prompt ID
$body = new \PureCloudSDK\SystemPromptAsset(); // \PureCloudSDK\SystemPromptAsset | 

try {
    $result = $api_instance->postArchitectSystempromptsPromptIdResources($promptId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->postArchitectSystempromptsPromptIdResources: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **promptId** | **string**| Prompt ID |
 **body** | [**\PureCloudSDK\SystemPromptAsset**](../Model/\PureCloudSDK\SystemPromptAsset.md)|  | [optional]

### Return type

[**\PureCloudSDK\SystemPromptAsset**](../Model/SystemPromptAsset.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putArchitectPromptsPromptId**
> \PureCloudSDK\Prompt putArchitectPromptsPromptId($promptId, $body)

Update specified user prompt



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$promptId = "promptId_example"; // string | Prompt ID
$body = new \PureCloudSDK\Prompt(); // \PureCloudSDK\Prompt | 

try {
    $result = $api_instance->putArchitectPromptsPromptId($promptId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->putArchitectPromptsPromptId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **promptId** | **string**| Prompt ID |
 **body** | [**\PureCloudSDK\Prompt**](../Model/\PureCloudSDK\Prompt.md)|  | [optional]

### Return type

[**\PureCloudSDK\Prompt**](../Model/Prompt.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putArchitectPromptsPromptIdResourcesLanguagecode**
> \PureCloudSDK\PromptAsset putArchitectPromptsPromptIdResourcesLanguagecode($promptId, $languageCode, $body)

Update specified user prompt resource



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$promptId = "promptId_example"; // string | Prompt ID
$languageCode = "languageCode_example"; // string | Language
$body = new \PureCloudSDK\PromptAsset(); // \PureCloudSDK\PromptAsset | 

try {
    $result = $api_instance->putArchitectPromptsPromptIdResourcesLanguagecode($promptId, $languageCode, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->putArchitectPromptsPromptIdResourcesLanguagecode: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **promptId** | **string**| Prompt ID |
 **languageCode** | **string**| Language |
 **body** | [**\PureCloudSDK\PromptAsset**](../Model/\PureCloudSDK\PromptAsset.md)|  | [optional]

### Return type

[**\PureCloudSDK\PromptAsset**](../Model/PromptAsset.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putArchitectSystempromptsPromptIdResourcesLanguagecode**
> \PureCloudSDK\SystemPromptAsset putArchitectSystempromptsPromptIdResourcesLanguagecode($promptId, $languageCode, $body)

Updates a system prompt resource override.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$promptId = "promptId_example"; // string | Prompt ID
$languageCode = "languageCode_example"; // string | Language
$body = new \PureCloudSDK\SystemPromptAsset(); // \PureCloudSDK\SystemPromptAsset | 

try {
    $result = $api_instance->putArchitectSystempromptsPromptIdResourcesLanguagecode($promptId, $languageCode, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->putArchitectSystempromptsPromptIdResourcesLanguagecode: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **promptId** | **string**| Prompt ID |
 **languageCode** | **string**| Language |
 **body** | [**\PureCloudSDK\SystemPromptAsset**](../Model/\PureCloudSDK\SystemPromptAsset.md)|  | [optional]

### Return type

[**\PureCloudSDK\SystemPromptAsset**](../Model/SystemPromptAsset.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

