# PureCloudSDK\ExternalContactsApi

All URIs are relative to *https://api.mypurecloud.ie*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteExternalcontactsContactsContactId**](ExternalContactsApi.md#deleteExternalcontactsContactsContactId) | **DELETE** /api/v2/externalcontacts/contacts/{contactId} | Delete an external contact
[**deleteExternalcontactsContactsContactIdNotesNoteId**](ExternalContactsApi.md#deleteExternalcontactsContactsContactIdNotesNoteId) | **DELETE** /api/v2/externalcontacts/contacts/{contactId}/notes/{noteId} | Delete a note for an external contact
[**deleteExternalcontactsOrganizationsExternalorganizationId**](ExternalContactsApi.md#deleteExternalcontactsOrganizationsExternalorganizationId) | **DELETE** /api/v2/externalcontacts/organizations/{externalOrganizationId} | Delete an external organization
[**deleteExternalcontactsOrganizationsExternalorganizationIdNotesNoteId**](ExternalContactsApi.md#deleteExternalcontactsOrganizationsExternalorganizationIdNotesNoteId) | **DELETE** /api/v2/externalcontacts/organizations/{externalOrganizationId}/notes/{noteId} | Delete a note for an external organization
[**deleteExternalcontactsRelationshipsRelationshipId**](ExternalContactsApi.md#deleteExternalcontactsRelationshipsRelationshipId) | **DELETE** /api/v2/externalcontacts/relationships/{relationshipId} | Delete a relationship
[**getExternalcontactsContacts**](ExternalContactsApi.md#getExternalcontactsContacts) | **GET** /api/v2/externalcontacts/contacts | Search for external contacts
[**getExternalcontactsContactsContactId**](ExternalContactsApi.md#getExternalcontactsContactsContactId) | **GET** /api/v2/externalcontacts/contacts/{contactId} | Fetch an external contact
[**getExternalcontactsContactsContactIdNotes**](ExternalContactsApi.md#getExternalcontactsContactsContactIdNotes) | **GET** /api/v2/externalcontacts/contacts/{contactId}/notes | List notes for an external contact
[**getExternalcontactsContactsContactIdNotesNoteId**](ExternalContactsApi.md#getExternalcontactsContactsContactIdNotesNoteId) | **GET** /api/v2/externalcontacts/contacts/{contactId}/notes/{noteId} | Fetch a note for an external contact
[**getExternalcontactsOrganizations**](ExternalContactsApi.md#getExternalcontactsOrganizations) | **GET** /api/v2/externalcontacts/organizations | Search for external organizations
[**getExternalcontactsOrganizationsExternalorganizationId**](ExternalContactsApi.md#getExternalcontactsOrganizationsExternalorganizationId) | **GET** /api/v2/externalcontacts/organizations/{externalOrganizationId} | Fetch an external organization
[**getExternalcontactsOrganizationsExternalorganizationIdContacts**](ExternalContactsApi.md#getExternalcontactsOrganizationsExternalorganizationIdContacts) | **GET** /api/v2/externalcontacts/organizations/{externalOrganizationId}/contacts | Search for external contacts in an external organization
[**getExternalcontactsOrganizationsExternalorganizationIdNotes**](ExternalContactsApi.md#getExternalcontactsOrganizationsExternalorganizationIdNotes) | **GET** /api/v2/externalcontacts/organizations/{externalOrganizationId}/notes | List notes for an external organization
[**getExternalcontactsOrganizationsExternalorganizationIdNotesNoteId**](ExternalContactsApi.md#getExternalcontactsOrganizationsExternalorganizationIdNotesNoteId) | **GET** /api/v2/externalcontacts/organizations/{externalOrganizationId}/notes/{noteId} | Fetch a note for an external organization
[**getExternalcontactsOrganizationsExternalorganizationIdRelationships**](ExternalContactsApi.md#getExternalcontactsOrganizationsExternalorganizationIdRelationships) | **GET** /api/v2/externalcontacts/organizations/{externalOrganizationId}/relationships | Fetch a relationship for an external organization
[**getExternalcontactsRelationshipsRelationshipId**](ExternalContactsApi.md#getExternalcontactsRelationshipsRelationshipId) | **GET** /api/v2/externalcontacts/relationships/{relationshipId} | Fetch a relationship
[**getExternalcontactsReversewhitepageslookup**](ExternalContactsApi.md#getExternalcontactsReversewhitepageslookup) | **GET** /api/v2/externalcontacts/reversewhitepageslookup | Lookup contacts and externalOrganizations based on an attribute
[**postExternalcontactsContacts**](ExternalContactsApi.md#postExternalcontactsContacts) | **POST** /api/v2/externalcontacts/contacts | Create an external contact
[**postExternalcontactsContactsContactIdAssociateconversation**](ExternalContactsApi.md#postExternalcontactsContactsContactIdAssociateconversation) | **POST** /api/v2/externalcontacts/contacts/{contactId}/associateconversation | Associate an external contact with a conversation
[**postExternalcontactsContactsContactIdNotes**](ExternalContactsApi.md#postExternalcontactsContactsContactIdNotes) | **POST** /api/v2/externalcontacts/contacts/{contactId}/notes | Create a note for an external contact
[**postExternalcontactsOrganizations**](ExternalContactsApi.md#postExternalcontactsOrganizations) | **POST** /api/v2/externalcontacts/organizations | Create an external organization
[**postExternalcontactsOrganizationsExternalorganizationIdNotes**](ExternalContactsApi.md#postExternalcontactsOrganizationsExternalorganizationIdNotes) | **POST** /api/v2/externalcontacts/organizations/{externalOrganizationId}/notes | Create a note for an external organization
[**postExternalcontactsRelationships**](ExternalContactsApi.md#postExternalcontactsRelationships) | **POST** /api/v2/externalcontacts/relationships | Create a relationship
[**putExternalcontactsContactsContactId**](ExternalContactsApi.md#putExternalcontactsContactsContactId) | **PUT** /api/v2/externalcontacts/contacts/{contactId} | Update an external contact
[**putExternalcontactsContactsContactIdNotesNoteId**](ExternalContactsApi.md#putExternalcontactsContactsContactIdNotesNoteId) | **PUT** /api/v2/externalcontacts/contacts/{contactId}/notes/{noteId} | Update a note for an external contact
[**putExternalcontactsConversationsConversationId**](ExternalContactsApi.md#putExternalcontactsConversationsConversationId) | **PUT** /api/v2/externalcontacts/conversations/{conversationId} | Associate an external contact with a conversation
[**putExternalcontactsOrganizationsExternalorganizationId**](ExternalContactsApi.md#putExternalcontactsOrganizationsExternalorganizationId) | **PUT** /api/v2/externalcontacts/organizations/{externalOrganizationId} | Update an external organization
[**putExternalcontactsOrganizationsExternalorganizationIdNotesNoteId**](ExternalContactsApi.md#putExternalcontactsOrganizationsExternalorganizationIdNotesNoteId) | **PUT** /api/v2/externalcontacts/organizations/{externalOrganizationId}/notes/{noteId} | Update a note for an external organization
[**putExternalcontactsRelationshipsRelationshipId**](ExternalContactsApi.md#putExternalcontactsRelationshipsRelationshipId) | **PUT** /api/v2/externalcontacts/relationships/{relationshipId} | Update a relationship


# **deleteExternalcontactsContactsContactId**
> deleteExternalcontactsContactsContactId($contactId)

Delete an external contact



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ExternalContactsApi();
$contactId = "contactId_example"; // string | ExternalContact ID

try {
    $api_instance->deleteExternalcontactsContactsContactId($contactId);
} catch (Exception $e) {
    echo 'Exception when calling ExternalContactsApi->deleteExternalcontactsContactsContactId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contactId** | **string**| ExternalContact ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteExternalcontactsContactsContactIdNotesNoteId**
> deleteExternalcontactsContactsContactIdNotesNoteId($contactId, $noteId)

Delete a note for an external contact



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ExternalContactsApi();
$contactId = "contactId_example"; // string | ExternalContact Id
$noteId = "noteId_example"; // string | Note Id

try {
    $api_instance->deleteExternalcontactsContactsContactIdNotesNoteId($contactId, $noteId);
} catch (Exception $e) {
    echo 'Exception when calling ExternalContactsApi->deleteExternalcontactsContactsContactIdNotesNoteId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contactId** | **string**| ExternalContact Id |
 **noteId** | **string**| Note Id |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteExternalcontactsOrganizationsExternalorganizationId**
> deleteExternalcontactsOrganizationsExternalorganizationId($externalOrganizationId)

Delete an external organization



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ExternalContactsApi();
$externalOrganizationId = "externalOrganizationId_example"; // string | External Organization ID

try {
    $api_instance->deleteExternalcontactsOrganizationsExternalorganizationId($externalOrganizationId);
} catch (Exception $e) {
    echo 'Exception when calling ExternalContactsApi->deleteExternalcontactsOrganizationsExternalorganizationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **externalOrganizationId** | **string**| External Organization ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteExternalcontactsOrganizationsExternalorganizationIdNotesNoteId**
> deleteExternalcontactsOrganizationsExternalorganizationIdNotesNoteId($externalOrganizationId, $noteId)

Delete a note for an external organization



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ExternalContactsApi();
$externalOrganizationId = "externalOrganizationId_example"; // string | External Organization Id
$noteId = "noteId_example"; // string | Note Id

try {
    $api_instance->deleteExternalcontactsOrganizationsExternalorganizationIdNotesNoteId($externalOrganizationId, $noteId);
} catch (Exception $e) {
    echo 'Exception when calling ExternalContactsApi->deleteExternalcontactsOrganizationsExternalorganizationIdNotesNoteId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **externalOrganizationId** | **string**| External Organization Id |
 **noteId** | **string**| Note Id |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteExternalcontactsRelationshipsRelationshipId**
> deleteExternalcontactsRelationshipsRelationshipId($relationshipId)

Delete a relationship



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ExternalContactsApi();
$relationshipId = "relationshipId_example"; // string | Relationship Id

try {
    $api_instance->deleteExternalcontactsRelationshipsRelationshipId($relationshipId);
} catch (Exception $e) {
    echo 'Exception when calling ExternalContactsApi->deleteExternalcontactsRelationshipsRelationshipId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **relationshipId** | **string**| Relationship Id |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getExternalcontactsContacts**
> \PureCloudSDK\ContactListing getExternalcontactsContacts($pageSize, $pageNumber, $q, $sortOrder, $expand)

Search for external contacts



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ExternalContactsApi();
$pageSize = 20; // int | Page size
$pageNumber = 1; // int | Page number
$q = "q_example"; // string | User supplied search keywords (no special syntax is currently supported)
$sortOrder = "sortOrder_example"; // string | Sort order
$expand = array("expand_example"); // string[] | which fields, if any, to expand

try {
    $result = $api_instance->getExternalcontactsContacts($pageSize, $pageNumber, $q, $sortOrder, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ExternalContactsApi->getExternalcontactsContacts: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 20]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **q** | **string**| User supplied search keywords (no special syntax is currently supported) | [optional]
 **sortOrder** | **string**| Sort order | [optional]
 **expand** | [**string[]**](../Model/string.md)| which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\ContactListing**](../Model/ContactListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getExternalcontactsContactsContactId**
> \PureCloudSDK\ExternalContact getExternalcontactsContactsContactId($contactId, $expand)

Fetch an external contact



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ExternalContactsApi();
$contactId = "contactId_example"; // string | ExternalContact ID
$expand = array("expand_example"); // string[] | which fields, if any, to expand (externalOrganization,externalDataSources)

try {
    $result = $api_instance->getExternalcontactsContactsContactId($contactId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ExternalContactsApi->getExternalcontactsContactsContactId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contactId** | **string**| ExternalContact ID |
 **expand** | [**string[]**](../Model/string.md)| which fields, if any, to expand (externalOrganization,externalDataSources) | [optional]

### Return type

[**\PureCloudSDK\ExternalContact**](../Model/ExternalContact.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getExternalcontactsContactsContactIdNotes**
> \PureCloudSDK\NoteListing getExternalcontactsContactsContactIdNotes($contactId, $pageSize, $pageNumber, $sortOrder, $expand)

List notes for an external contact



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ExternalContactsApi();
$contactId = "contactId_example"; // string | ExternalContact Id
$pageSize = 20; // int | Page size
$pageNumber = 1; // int | Page number
$sortOrder = "sortOrder_example"; // string | Sort order
$expand = array("expand_example"); // string[] | which fields, if any, to expand

try {
    $result = $api_instance->getExternalcontactsContactsContactIdNotes($contactId, $pageSize, $pageNumber, $sortOrder, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ExternalContactsApi->getExternalcontactsContactsContactIdNotes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contactId** | **string**| ExternalContact Id |
 **pageSize** | **int**| Page size | [optional] [default to 20]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **sortOrder** | **string**| Sort order | [optional]
 **expand** | [**string[]**](../Model/string.md)| which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\NoteListing**](../Model/NoteListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getExternalcontactsContactsContactIdNotesNoteId**
> \PureCloudSDK\Note getExternalcontactsContactsContactIdNotesNoteId($contactId, $noteId, $expand)

Fetch a note for an external contact



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ExternalContactsApi();
$contactId = "contactId_example"; // string | ExternalContact Id
$noteId = "noteId_example"; // string | Note Id
$expand = array("expand_example"); // string[] | which fields, if any, to expand

try {
    $result = $api_instance->getExternalcontactsContactsContactIdNotesNoteId($contactId, $noteId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ExternalContactsApi->getExternalcontactsContactsContactIdNotesNoteId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contactId** | **string**| ExternalContact Id |
 **noteId** | **string**| Note Id |
 **expand** | [**string[]**](../Model/string.md)| which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\Note**](../Model/Note.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getExternalcontactsOrganizations**
> \PureCloudSDK\ExternalOrganizationListing getExternalcontactsOrganizations($pageSize, $pageNumber, $q, $sortOrder, $expand)

Search for external organizations



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ExternalContactsApi();
$pageSize = 20; // int | Page size
$pageNumber = 1; // int | Page number
$q = "q_example"; // string | Search query
$sortOrder = "sortOrder_example"; // string | Sort order
$expand = "expand_example"; // string | which fields, if any, to expand

try {
    $result = $api_instance->getExternalcontactsOrganizations($pageSize, $pageNumber, $q, $sortOrder, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ExternalContactsApi->getExternalcontactsOrganizations: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 20]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **q** | **string**| Search query | [optional]
 **sortOrder** | **string**| Sort order | [optional]
 **expand** | **string**| which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\ExternalOrganizationListing**](../Model/ExternalOrganizationListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getExternalcontactsOrganizationsExternalorganizationId**
> \PureCloudSDK\ExternalOrganization getExternalcontactsOrganizationsExternalorganizationId($externalOrganizationId, $expand)

Fetch an external organization



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ExternalContactsApi();
$externalOrganizationId = "externalOrganizationId_example"; // string | External Organization ID
$expand = array("expand_example"); // string[] | which fields, if any, to expand (externalDataSources)

try {
    $result = $api_instance->getExternalcontactsOrganizationsExternalorganizationId($externalOrganizationId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ExternalContactsApi->getExternalcontactsOrganizationsExternalorganizationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **externalOrganizationId** | **string**| External Organization ID |
 **expand** | [**string[]**](../Model/string.md)| which fields, if any, to expand (externalDataSources) | [optional]

### Return type

[**\PureCloudSDK\ExternalOrganization**](../Model/ExternalOrganization.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getExternalcontactsOrganizationsExternalorganizationIdContacts**
> \PureCloudSDK\ContactListing getExternalcontactsOrganizationsExternalorganizationIdContacts($externalOrganizationId, $pageSize, $pageNumber, $q, $sortOrder, $expand)

Search for external contacts in an external organization



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ExternalContactsApi();
$externalOrganizationId = "externalOrganizationId_example"; // string | External Organization ID
$pageSize = 20; // int | Page size
$pageNumber = 1; // int | Page number
$q = "q_example"; // string | User supplied search keywords (no special syntax is currently supported)
$sortOrder = "sortOrder_example"; // string | Sort order
$expand = array("expand_example"); // string[] | which fields, if any, to expand (externalOrganization)

try {
    $result = $api_instance->getExternalcontactsOrganizationsExternalorganizationIdContacts($externalOrganizationId, $pageSize, $pageNumber, $q, $sortOrder, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ExternalContactsApi->getExternalcontactsOrganizationsExternalorganizationIdContacts: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **externalOrganizationId** | **string**| External Organization ID |
 **pageSize** | **int**| Page size | [optional] [default to 20]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **q** | **string**| User supplied search keywords (no special syntax is currently supported) | [optional]
 **sortOrder** | **string**| Sort order | [optional]
 **expand** | [**string[]**](../Model/string.md)| which fields, if any, to expand (externalOrganization) | [optional]

### Return type

[**\PureCloudSDK\ContactListing**](../Model/ContactListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getExternalcontactsOrganizationsExternalorganizationIdNotes**
> \PureCloudSDK\NoteListing getExternalcontactsOrganizationsExternalorganizationIdNotes($externalOrganizationId, $pageSize, $pageNumber, $sortOrder, $expand)

List notes for an external organization



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ExternalContactsApi();
$externalOrganizationId = "externalOrganizationId_example"; // string | External Organization Id
$pageSize = 20; // int | Page size
$pageNumber = 1; // int | Page number
$sortOrder = "sortOrder_example"; // string | Sort order
$expand = array("expand_example"); // string[] | which fields, if any, to expand

try {
    $result = $api_instance->getExternalcontactsOrganizationsExternalorganizationIdNotes($externalOrganizationId, $pageSize, $pageNumber, $sortOrder, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ExternalContactsApi->getExternalcontactsOrganizationsExternalorganizationIdNotes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **externalOrganizationId** | **string**| External Organization Id |
 **pageSize** | **int**| Page size | [optional] [default to 20]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **sortOrder** | **string**| Sort order | [optional]
 **expand** | [**string[]**](../Model/string.md)| which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\NoteListing**](../Model/NoteListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getExternalcontactsOrganizationsExternalorganizationIdNotesNoteId**
> \PureCloudSDK\Note getExternalcontactsOrganizationsExternalorganizationIdNotesNoteId($externalOrganizationId, $noteId, $expand)

Fetch a note for an external organization



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ExternalContactsApi();
$externalOrganizationId = "externalOrganizationId_example"; // string | External Organization Id
$noteId = "noteId_example"; // string | Note Id
$expand = array("expand_example"); // string[] | which fields, if any, to expand

try {
    $result = $api_instance->getExternalcontactsOrganizationsExternalorganizationIdNotesNoteId($externalOrganizationId, $noteId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ExternalContactsApi->getExternalcontactsOrganizationsExternalorganizationIdNotesNoteId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **externalOrganizationId** | **string**| External Organization Id |
 **noteId** | **string**| Note Id |
 **expand** | [**string[]**](../Model/string.md)| which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\Note**](../Model/Note.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getExternalcontactsOrganizationsExternalorganizationIdRelationships**
> \PureCloudSDK\RelationshipListing getExternalcontactsOrganizationsExternalorganizationIdRelationships($externalOrganizationId, $pageSize, $pageNumber, $expand, $sortOrder)

Fetch a relationship for an external organization



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ExternalContactsApi();
$externalOrganizationId = "externalOrganizationId_example"; // string | External Organization ID
$pageSize = 20; // int | Page size
$pageNumber = 1; // int | Page number
$expand = "expand_example"; // string | which fields, if any, to expand
$sortOrder = "sortOrder_example"; // string | Sort order

try {
    $result = $api_instance->getExternalcontactsOrganizationsExternalorganizationIdRelationships($externalOrganizationId, $pageSize, $pageNumber, $expand, $sortOrder);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ExternalContactsApi->getExternalcontactsOrganizationsExternalorganizationIdRelationships: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **externalOrganizationId** | **string**| External Organization ID |
 **pageSize** | **int**| Page size | [optional] [default to 20]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **expand** | **string**| which fields, if any, to expand | [optional]
 **sortOrder** | **string**| Sort order | [optional]

### Return type

[**\PureCloudSDK\RelationshipListing**](../Model/RelationshipListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getExternalcontactsRelationshipsRelationshipId**
> \PureCloudSDK\Relationship getExternalcontactsRelationshipsRelationshipId($relationshipId, $expand)

Fetch a relationship



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ExternalContactsApi();
$relationshipId = "relationshipId_example"; // string | Relationship Id
$expand = "expand_example"; // string | which fields, if any, to expand

try {
    $result = $api_instance->getExternalcontactsRelationshipsRelationshipId($relationshipId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ExternalContactsApi->getExternalcontactsRelationshipsRelationshipId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **relationshipId** | **string**| Relationship Id |
 **expand** | **string**| which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\Relationship**](../Model/Relationship.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getExternalcontactsReversewhitepageslookup**
> \PureCloudSDK\ReverseWhitepagesLookupResult getExternalcontactsReversewhitepageslookup($lookupVal, $expand)

Lookup contacts and externalOrganizations based on an attribute



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ExternalContactsApi();
$lookupVal = "lookupVal_example"; // string | User supplied value to lookup contacts/externalOrganizations (supports email addresses, e164 phone numbers, Twitter screen names)
$expand = array("expand_example"); // string[] | which field, if any, to expand

try {
    $result = $api_instance->getExternalcontactsReversewhitepageslookup($lookupVal, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ExternalContactsApi->getExternalcontactsReversewhitepageslookup: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **lookupVal** | **string**| User supplied value to lookup contacts/externalOrganizations (supports email addresses, e164 phone numbers, Twitter screen names) |
 **expand** | [**string[]**](../Model/string.md)| which field, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\ReverseWhitepagesLookupResult**](../Model/ReverseWhitepagesLookupResult.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postExternalcontactsContacts**
> \PureCloudSDK\ExternalContact postExternalcontactsContacts($body)

Create an external contact



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ExternalContactsApi();
$body = new \PureCloudSDK\ExternalContact(); // \PureCloudSDK\ExternalContact | ExternalContact

try {
    $result = $api_instance->postExternalcontactsContacts($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ExternalContactsApi->postExternalcontactsContacts: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\ExternalContact**](../Model/\PureCloudSDK\ExternalContact.md)| ExternalContact | [optional]

### Return type

[**\PureCloudSDK\ExternalContact**](../Model/ExternalContact.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postExternalcontactsContactsContactIdAssociateconversation**
> postExternalcontactsContactsContactIdAssociateconversation($contactId, $body)

Associate an external contact with a conversation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ExternalContactsApi();
$contactId = "contactId_example"; // string | ExternalContact ID
$body = new \PureCloudSDK\ConversationAssociation(); // \PureCloudSDK\ConversationAssociation | ConversationAssociation

try {
    $api_instance->postExternalcontactsContactsContactIdAssociateconversation($contactId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ExternalContactsApi->postExternalcontactsContactsContactIdAssociateconversation: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contactId** | **string**| ExternalContact ID |
 **body** | [**\PureCloudSDK\ConversationAssociation**](../Model/\PureCloudSDK\ConversationAssociation.md)| ConversationAssociation | [optional]

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postExternalcontactsContactsContactIdNotes**
> \PureCloudSDK\Note postExternalcontactsContactsContactIdNotes($contactId, $body)

Create a note for an external contact



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ExternalContactsApi();
$contactId = "contactId_example"; // string | ExternalContact Id
$body = new \PureCloudSDK\Note(); // \PureCloudSDK\Note | ExternalContact

try {
    $result = $api_instance->postExternalcontactsContactsContactIdNotes($contactId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ExternalContactsApi->postExternalcontactsContactsContactIdNotes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contactId** | **string**| ExternalContact Id |
 **body** | [**\PureCloudSDK\Note**](../Model/\PureCloudSDK\Note.md)| ExternalContact | [optional]

### Return type

[**\PureCloudSDK\Note**](../Model/Note.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postExternalcontactsOrganizations**
> \PureCloudSDK\ExternalOrganization postExternalcontactsOrganizations($body)

Create an external organization



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ExternalContactsApi();
$body = new \PureCloudSDK\ExternalOrganization(); // \PureCloudSDK\ExternalOrganization | ExternalOrganization

try {
    $result = $api_instance->postExternalcontactsOrganizations($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ExternalContactsApi->postExternalcontactsOrganizations: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\ExternalOrganization**](../Model/\PureCloudSDK\ExternalOrganization.md)| ExternalOrganization | [optional]

### Return type

[**\PureCloudSDK\ExternalOrganization**](../Model/ExternalOrganization.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postExternalcontactsOrganizationsExternalorganizationIdNotes**
> \PureCloudSDK\Note postExternalcontactsOrganizationsExternalorganizationIdNotes($externalOrganizationId, $body)

Create a note for an external organization



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ExternalContactsApi();
$externalOrganizationId = "externalOrganizationId_example"; // string | External Organization Id
$body = new \PureCloudSDK\Note(); // \PureCloudSDK\Note | ExternalContact

try {
    $result = $api_instance->postExternalcontactsOrganizationsExternalorganizationIdNotes($externalOrganizationId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ExternalContactsApi->postExternalcontactsOrganizationsExternalorganizationIdNotes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **externalOrganizationId** | **string**| External Organization Id |
 **body** | [**\PureCloudSDK\Note**](../Model/\PureCloudSDK\Note.md)| ExternalContact | [optional]

### Return type

[**\PureCloudSDK\Note**](../Model/Note.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postExternalcontactsRelationships**
> \PureCloudSDK\Relationship postExternalcontactsRelationships($body)

Create a relationship



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ExternalContactsApi();
$body = new \PureCloudSDK\Relationship(); // \PureCloudSDK\Relationship | Relationship

try {
    $result = $api_instance->postExternalcontactsRelationships($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ExternalContactsApi->postExternalcontactsRelationships: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Relationship**](../Model/\PureCloudSDK\Relationship.md)| Relationship | [optional]

### Return type

[**\PureCloudSDK\Relationship**](../Model/Relationship.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putExternalcontactsContactsContactId**
> \PureCloudSDK\ExternalContact putExternalcontactsContactsContactId($contactId, $body)

Update an external contact



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ExternalContactsApi();
$contactId = "contactId_example"; // string | ExternalContact ID
$body = new \PureCloudSDK\ExternalContact(); // \PureCloudSDK\ExternalContact | ExternalContact

try {
    $result = $api_instance->putExternalcontactsContactsContactId($contactId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ExternalContactsApi->putExternalcontactsContactsContactId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contactId** | **string**| ExternalContact ID |
 **body** | [**\PureCloudSDK\ExternalContact**](../Model/\PureCloudSDK\ExternalContact.md)| ExternalContact | [optional]

### Return type

[**\PureCloudSDK\ExternalContact**](../Model/ExternalContact.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putExternalcontactsContactsContactIdNotesNoteId**
> \PureCloudSDK\Note putExternalcontactsContactsContactIdNotesNoteId($contactId, $noteId, $body)

Update a note for an external contact



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ExternalContactsApi();
$contactId = "contactId_example"; // string | ExternalContact Id
$noteId = "noteId_example"; // string | Note Id
$body = new \PureCloudSDK\Note(); // \PureCloudSDK\Note | Note

try {
    $result = $api_instance->putExternalcontactsContactsContactIdNotesNoteId($contactId, $noteId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ExternalContactsApi->putExternalcontactsContactsContactIdNotesNoteId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contactId** | **string**| ExternalContact Id |
 **noteId** | **string**| Note Id |
 **body** | [**\PureCloudSDK\Note**](../Model/\PureCloudSDK\Note.md)| Note | [optional]

### Return type

[**\PureCloudSDK\Note**](../Model/Note.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putExternalcontactsConversationsConversationId**
> putExternalcontactsConversationsConversationId($conversationId, $body)

Associate an external contact with a conversation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ExternalContactsApi();
$conversationId = "conversationId_example"; // string | Conversation ID
$body = new \PureCloudSDK\ConversationAssociation(); // \PureCloudSDK\ConversationAssociation | ConversationAssociation

try {
    $api_instance->putExternalcontactsConversationsConversationId($conversationId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ExternalContactsApi->putExternalcontactsConversationsConversationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| Conversation ID |
 **body** | [**\PureCloudSDK\ConversationAssociation**](../Model/\PureCloudSDK\ConversationAssociation.md)| ConversationAssociation | [optional]

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putExternalcontactsOrganizationsExternalorganizationId**
> \PureCloudSDK\ExternalOrganization putExternalcontactsOrganizationsExternalorganizationId($externalOrganizationId, $body)

Update an external organization



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ExternalContactsApi();
$externalOrganizationId = "externalOrganizationId_example"; // string | External Organization ID
$body = new \PureCloudSDK\ExternalOrganization(); // \PureCloudSDK\ExternalOrganization | ExternalOrganization

try {
    $result = $api_instance->putExternalcontactsOrganizationsExternalorganizationId($externalOrganizationId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ExternalContactsApi->putExternalcontactsOrganizationsExternalorganizationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **externalOrganizationId** | **string**| External Organization ID |
 **body** | [**\PureCloudSDK\ExternalOrganization**](../Model/\PureCloudSDK\ExternalOrganization.md)| ExternalOrganization | [optional]

### Return type

[**\PureCloudSDK\ExternalOrganization**](../Model/ExternalOrganization.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putExternalcontactsOrganizationsExternalorganizationIdNotesNoteId**
> \PureCloudSDK\Note putExternalcontactsOrganizationsExternalorganizationIdNotesNoteId($externalOrganizationId, $noteId, $body)

Update a note for an external organization



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ExternalContactsApi();
$externalOrganizationId = "externalOrganizationId_example"; // string | External Organization Id
$noteId = "noteId_example"; // string | Note Id
$body = new \PureCloudSDK\Note(); // \PureCloudSDK\Note | Note

try {
    $result = $api_instance->putExternalcontactsOrganizationsExternalorganizationIdNotesNoteId($externalOrganizationId, $noteId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ExternalContactsApi->putExternalcontactsOrganizationsExternalorganizationIdNotesNoteId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **externalOrganizationId** | **string**| External Organization Id |
 **noteId** | **string**| Note Id |
 **body** | [**\PureCloudSDK\Note**](../Model/\PureCloudSDK\Note.md)| Note | [optional]

### Return type

[**\PureCloudSDK\Note**](../Model/Note.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putExternalcontactsRelationshipsRelationshipId**
> \PureCloudSDK\Relationship putExternalcontactsRelationshipsRelationshipId($relationshipId, $body)

Update a relationship



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ExternalContactsApi();
$relationshipId = "relationshipId_example"; // string | Relationship Id
$body = new \PureCloudSDK\Relationship(); // \PureCloudSDK\Relationship | Relationship

try {
    $result = $api_instance->putExternalcontactsRelationshipsRelationshipId($relationshipId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ExternalContactsApi->putExternalcontactsRelationshipsRelationshipId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **relationshipId** | **string**| Relationship Id |
 **body** | [**\PureCloudSDK\Relationship**](../Model/\PureCloudSDK\Relationship.md)| Relationship | [optional]

### Return type

[**\PureCloudSDK\Relationship**](../Model/Relationship.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

