# PureCloudSDK\RoutingApi

All URIs are relative to *https://api.mypurecloud.ie*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteRoutingEmailDomainsDomainId**](RoutingApi.md#deleteRoutingEmailDomainsDomainId) | **DELETE** /api/v2/routing/email/domains/{domainId} | Delete a domain
[**deleteRoutingEmailDomainsDomainnameRoutesRouteId**](RoutingApi.md#deleteRoutingEmailDomainsDomainnameRoutesRouteId) | **DELETE** /api/v2/routing/email/domains/{domainName}/routes/{routeId} | Delete a route
[**deleteRoutingQueuesQueueId**](RoutingApi.md#deleteRoutingQueuesQueueId) | **DELETE** /api/v2/routing/queues/{queueId} | Delete a queue
[**deleteRoutingQueuesQueueIdUsersMemberId**](RoutingApi.md#deleteRoutingQueuesQueueIdUsersMemberId) | **DELETE** /api/v2/routing/queues/{queueId}/users/{memberId} | Delete queue member
[**deleteRoutingQueuesQueueIdWrapupcodesCodeId**](RoutingApi.md#deleteRoutingQueuesQueueIdWrapupcodesCodeId) | **DELETE** /api/v2/routing/queues/{queueId}/wrapupcodes/{codeId} | Delete a wrap-up code from a queue
[**deleteRoutingSkillsSkillId**](RoutingApi.md#deleteRoutingSkillsSkillId) | **DELETE** /api/v2/routing/skills/{skillId} | Delete Routing Skill
[**deleteRoutingUtilization**](RoutingApi.md#deleteRoutingUtilization) | **DELETE** /api/v2/routing/utilization | Delete utilization settings and revert to system defaults.
[**deleteRoutingWrapupcodesCodeId**](RoutingApi.md#deleteRoutingWrapupcodesCodeId) | **DELETE** /api/v2/routing/wrapupcodes/{codeId} | Delete wrap-up code
[**deleteUsersUserIdRoutingskillsSkillId**](RoutingApi.md#deleteUsersUserIdRoutingskillsSkillId) | **DELETE** /api/v2/users/{userId}/routingskills/{skillId} | Remove routing skill from user
[**getRoutingEmailDomains**](RoutingApi.md#getRoutingEmailDomains) | **GET** /api/v2/routing/email/domains | Get domains
[**getRoutingEmailDomainsDomainId**](RoutingApi.md#getRoutingEmailDomainsDomainId) | **GET** /api/v2/routing/email/domains/{domainId} | Get domain
[**getRoutingEmailDomainsDomainnameRoutes**](RoutingApi.md#getRoutingEmailDomainsDomainnameRoutes) | **GET** /api/v2/routing/email/domains/{domainName}/routes | Get routes
[**getRoutingEmailDomainsDomainnameRoutesRouteId**](RoutingApi.md#getRoutingEmailDomainsDomainnameRoutesRouteId) | **GET** /api/v2/routing/email/domains/{domainName}/routes/{routeId} | Get a route
[**getRoutingEmailSetup**](RoutingApi.md#getRoutingEmailSetup) | **GET** /api/v2/routing/email/setup | Get email setup
[**getRoutingLanguages**](RoutingApi.md#getRoutingLanguages) | **GET** /api/v2/routing/languages | Get the list of supported languages.
[**getRoutingQueues**](RoutingApi.md#getRoutingQueues) | **GET** /api/v2/routing/queues | Get list of queues.
[**getRoutingQueuesQueueId**](RoutingApi.md#getRoutingQueuesQueueId) | **GET** /api/v2/routing/queues/{queueId} | Get details about this queue.
[**getRoutingQueuesQueueIdEstimatedwaittime**](RoutingApi.md#getRoutingQueuesQueueIdEstimatedwaittime) | **GET** /api/v2/routing/queues/{queueId}/estimatedwaittime | Get Estimated Wait Time
[**getRoutingQueuesQueueIdMediatypesMediatypeEstimatedwaittime**](RoutingApi.md#getRoutingQueuesQueueIdMediatypesMediatypeEstimatedwaittime) | **GET** /api/v2/routing/queues/{queueId}/mediatypes/{mediaType}/estimatedwaittime | Get Estimated Wait Time
[**getRoutingQueuesQueueIdUsers**](RoutingApi.md#getRoutingQueuesQueueIdUsers) | **GET** /api/v2/routing/queues/{queueId}/users | Get the members of this queue
[**getRoutingQueuesQueueIdWrapupcodes**](RoutingApi.md#getRoutingQueuesQueueIdWrapupcodes) | **GET** /api/v2/routing/queues/{queueId}/wrapupcodes | Get the wrap-up codes for a queue
[**getRoutingSkills**](RoutingApi.md#getRoutingSkills) | **GET** /api/v2/routing/skills | Get the list of routing skills.
[**getRoutingSkillsSkillId**](RoutingApi.md#getRoutingSkillsSkillId) | **GET** /api/v2/routing/skills/{skillId} | Get Routing Skill
[**getRoutingUtilization**](RoutingApi.md#getRoutingUtilization) | **GET** /api/v2/routing/utilization | Get the utilization settings.
[**getRoutingWrapupcodes**](RoutingApi.md#getRoutingWrapupcodes) | **GET** /api/v2/routing/wrapupcodes | Get list of wrapup codes.
[**getRoutingWrapupcodesCodeId**](RoutingApi.md#getRoutingWrapupcodesCodeId) | **GET** /api/v2/routing/wrapupcodes/{codeId} | Get details about this wrap-up code.
[**getUsersUserIdRoutingskills**](RoutingApi.md#getUsersUserIdRoutingskills) | **GET** /api/v2/users/{userId}/routingskills | List routing skills for user
[**patchRoutingQueuesQueueIdUsers**](RoutingApi.md#patchRoutingQueuesQueueIdUsers) | **PATCH** /api/v2/routing/queues/{queueId}/users | Join or unjoin a set of users for a queue
[**patchRoutingQueuesQueueIdUsersMemberId**](RoutingApi.md#patchRoutingQueuesQueueIdUsersMemberId) | **PATCH** /api/v2/routing/queues/{queueId}/users/{memberId} | Update the ring number of joined status for a User in a Queue
[**postAnalyticsQueuesObservationsQuery**](RoutingApi.md#postAnalyticsQueuesObservationsQuery) | **POST** /api/v2/analytics/queues/observations/query | Query for queue observations
[**postRoutingEmailDomains**](RoutingApi.md#postRoutingEmailDomains) | **POST** /api/v2/routing/email/domains | Create a domain
[**postRoutingEmailDomainsDomainnameRoutes**](RoutingApi.md#postRoutingEmailDomainsDomainnameRoutes) | **POST** /api/v2/routing/email/domains/{domainName}/routes | Create a route
[**postRoutingLanguages**](RoutingApi.md#postRoutingLanguages) | **POST** /api/v2/routing/languages | Create Language
[**postRoutingQueues**](RoutingApi.md#postRoutingQueues) | **POST** /api/v2/routing/queues | Create queue
[**postRoutingQueuesQueueIdUsers**](RoutingApi.md#postRoutingQueuesQueueIdUsers) | **POST** /api/v2/routing/queues/{queueId}/users | Bulk add or delete up to 100 queue members
[**postRoutingQueuesQueueIdWrapupcodes**](RoutingApi.md#postRoutingQueuesQueueIdWrapupcodes) | **POST** /api/v2/routing/queues/{queueId}/wrapupcodes | Add up to 100 wrap-up codes to a queue
[**postRoutingSkills**](RoutingApi.md#postRoutingSkills) | **POST** /api/v2/routing/skills | Create Skill
[**postRoutingWrapupcodes**](RoutingApi.md#postRoutingWrapupcodes) | **POST** /api/v2/routing/wrapupcodes | Create a wrap-up code
[**postUsersUserIdRoutingskills**](RoutingApi.md#postUsersUserIdRoutingskills) | **POST** /api/v2/users/{userId}/routingskills | Add routing skill to user
[**putRoutingEmailDomainsDomainnameRoutesRouteId**](RoutingApi.md#putRoutingEmailDomainsDomainnameRoutesRouteId) | **PUT** /api/v2/routing/email/domains/{domainName}/routes/{routeId} | Update a route
[**putRoutingQueuesQueueId**](RoutingApi.md#putRoutingQueuesQueueId) | **PUT** /api/v2/routing/queues/{queueId} | Update a queue
[**putRoutingUtilization**](RoutingApi.md#putRoutingUtilization) | **PUT** /api/v2/routing/utilization | Update the utilization settings.
[**putRoutingWrapupcodesCodeId**](RoutingApi.md#putRoutingWrapupcodesCodeId) | **PUT** /api/v2/routing/wrapupcodes/{codeId} | Update wrap-up code
[**putUsersUserIdRoutingskillsSkillId**](RoutingApi.md#putUsersUserIdRoutingskillsSkillId) | **PUT** /api/v2/users/{userId}/routingskills/{skillId} | Update routing skill proficiency or state.


# **deleteRoutingEmailDomainsDomainId**
> string deleteRoutingEmailDomainsDomainId($domainId)

Delete a domain



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$domainId = "domainId_example"; // string | domain ID

try {
    $result = $api_instance->deleteRoutingEmailDomainsDomainId($domainId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->deleteRoutingEmailDomainsDomainId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **domainId** | **string**| domain ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteRoutingEmailDomainsDomainnameRoutesRouteId**
> string deleteRoutingEmailDomainsDomainnameRoutesRouteId($domainName, $routeId)

Delete a route



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$domainName = "domainName_example"; // string | email domain
$routeId = "routeId_example"; // string | route ID

try {
    $result = $api_instance->deleteRoutingEmailDomainsDomainnameRoutesRouteId($domainName, $routeId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->deleteRoutingEmailDomainsDomainnameRoutesRouteId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **domainName** | **string**| email domain |
 **routeId** | **string**| route ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteRoutingQueuesQueueId**
> string deleteRoutingQueuesQueueId($queueId, $forceDelete)

Delete a queue



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$queueId = "queueId_example"; // string | Queue ID
$forceDelete = true; // bool | forceDelete

try {
    $result = $api_instance->deleteRoutingQueuesQueueId($queueId, $forceDelete);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->deleteRoutingQueuesQueueId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **queueId** | **string**| Queue ID |
 **forceDelete** | **bool**| forceDelete | [optional]

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteRoutingQueuesQueueIdUsersMemberId**
> string deleteRoutingQueuesQueueIdUsersMemberId($queueId, $memberId)

Delete queue member



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$queueId = "queueId_example"; // string | Queue ID
$memberId = "memberId_example"; // string | Member ID

try {
    $result = $api_instance->deleteRoutingQueuesQueueIdUsersMemberId($queueId, $memberId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->deleteRoutingQueuesQueueIdUsersMemberId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **queueId** | **string**| Queue ID |
 **memberId** | **string**| Member ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteRoutingQueuesQueueIdWrapupcodesCodeId**
> string deleteRoutingQueuesQueueIdWrapupcodesCodeId($queueId, $codeId)

Delete a wrap-up code from a queue



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$queueId = "queueId_example"; // string | Queue ID
$codeId = "codeId_example"; // string | Code ID

try {
    $result = $api_instance->deleteRoutingQueuesQueueIdWrapupcodesCodeId($queueId, $codeId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->deleteRoutingQueuesQueueIdWrapupcodesCodeId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **queueId** | **string**| Queue ID |
 **codeId** | **string**| Code ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteRoutingSkillsSkillId**
> string deleteRoutingSkillsSkillId($skillId)

Delete Routing Skill



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$skillId = "skillId_example"; // string | Skill ID

try {
    $result = $api_instance->deleteRoutingSkillsSkillId($skillId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->deleteRoutingSkillsSkillId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **skillId** | **string**| Skill ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteRoutingUtilization**
> string deleteRoutingUtilization()

Delete utilization settings and revert to system defaults.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();

try {
    $result = $api_instance->deleteRoutingUtilization();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->deleteRoutingUtilization: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteRoutingWrapupcodesCodeId**
> string deleteRoutingWrapupcodesCodeId($codeId)

Delete wrap-up code



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$codeId = "codeId_example"; // string | Wrapup Code ID

try {
    $result = $api_instance->deleteRoutingWrapupcodesCodeId($codeId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->deleteRoutingWrapupcodesCodeId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **codeId** | **string**| Wrapup Code ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteUsersUserIdRoutingskillsSkillId**
> string deleteUsersUserIdRoutingskillsSkillId($userId, $skillId)

Remove routing skill from user



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$userId = "userId_example"; // string | User ID
$skillId = "skillId_example"; // string | skillId

try {
    $result = $api_instance->deleteUsersUserIdRoutingskillsSkillId($userId, $skillId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->deleteUsersUserIdRoutingskillsSkillId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |
 **skillId** | **string**| skillId |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRoutingEmailDomains**
> \PureCloudSDK\InboundDomainEntityListing getRoutingEmailDomains()

Get domains



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();

try {
    $result = $api_instance->getRoutingEmailDomains();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getRoutingEmailDomains: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\InboundDomainEntityListing**](../Model/InboundDomainEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRoutingEmailDomainsDomainId**
> \PureCloudSDK\InboundDomain getRoutingEmailDomainsDomainId($domainId)

Get domain



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$domainId = "domainId_example"; // string | domain ID

try {
    $result = $api_instance->getRoutingEmailDomainsDomainId($domainId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getRoutingEmailDomainsDomainId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **domainId** | **string**| domain ID |

### Return type

[**\PureCloudSDK\InboundDomain**](../Model/InboundDomain.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRoutingEmailDomainsDomainnameRoutes**
> \PureCloudSDK\InboundRouteEntityListing getRoutingEmailDomainsDomainnameRoutes($domainName, $pageSize, $pageNumber, $pattern)

Get routes



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$domainName = "domainName_example"; // string | email domain
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$pattern = "pattern_example"; // string | Filter routes by the route's pattern property

try {
    $result = $api_instance->getRoutingEmailDomainsDomainnameRoutes($domainName, $pageSize, $pageNumber, $pattern);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getRoutingEmailDomainsDomainnameRoutes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **domainName** | **string**| email domain |
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **pattern** | **string**| Filter routes by the route&#39;s pattern property | [optional]

### Return type

[**\PureCloudSDK\InboundRouteEntityListing**](../Model/InboundRouteEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRoutingEmailDomainsDomainnameRoutesRouteId**
> \PureCloudSDK\InboundRoute getRoutingEmailDomainsDomainnameRoutesRouteId($domainName, $routeId)

Get a route



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$domainName = "domainName_example"; // string | email domain
$routeId = "routeId_example"; // string | route ID

try {
    $result = $api_instance->getRoutingEmailDomainsDomainnameRoutesRouteId($domainName, $routeId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getRoutingEmailDomainsDomainnameRoutesRouteId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **domainName** | **string**| email domain |
 **routeId** | **string**| route ID |

### Return type

[**\PureCloudSDK\InboundRoute**](../Model/InboundRoute.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRoutingEmailSetup**
> \PureCloudSDK\EmailSetup getRoutingEmailSetup()

Get email setup



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();

try {
    $result = $api_instance->getRoutingEmailSetup();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getRoutingEmailSetup: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\EmailSetup**](../Model/EmailSetup.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRoutingLanguages**
> \PureCloudSDK\LanguageEntityListing getRoutingLanguages($pageSize, $pageNumber, $sortOrder, $name)

Get the list of supported languages.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$sortOrder = "ASC"; // string | Ascending or descending sort order
$name = "name_example"; // string | Name

try {
    $result = $api_instance->getRoutingLanguages($pageSize, $pageNumber, $sortOrder, $name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getRoutingLanguages: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **sortOrder** | **string**| Ascending or descending sort order | [optional] [default to ASC]
 **name** | **string**| Name | [optional]

### Return type

[**\PureCloudSDK\LanguageEntityListing**](../Model/LanguageEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRoutingQueues**
> \PureCloudSDK\QueueEntityListing getRoutingQueues($pageSize, $pageNumber, $sortBy, $name, $active)

Get list of queues.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$sortBy = "name"; // string | Sort by
$name = "name_example"; // string | Name
$active = true; // bool | Active

try {
    $result = $api_instance->getRoutingQueues($pageSize, $pageNumber, $sortBy, $name, $active);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getRoutingQueues: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **sortBy** | **string**| Sort by | [optional] [default to name]
 **name** | **string**| Name | [optional]
 **active** | **bool**| Active | [optional]

### Return type

[**\PureCloudSDK\QueueEntityListing**](../Model/QueueEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRoutingQueuesQueueId**
> \PureCloudSDK\Queue getRoutingQueuesQueueId($queueId)

Get details about this queue.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$queueId = "queueId_example"; // string | Queue ID

try {
    $result = $api_instance->getRoutingQueuesQueueId($queueId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getRoutingQueuesQueueId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **queueId** | **string**| Queue ID |

### Return type

[**\PureCloudSDK\Queue**](../Model/Queue.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRoutingQueuesQueueIdEstimatedwaittime**
> \PureCloudSDK\EstimatedWaitTimePredictions getRoutingQueuesQueueIdEstimatedwaittime($queueId, $conversationId)

Get Estimated Wait Time



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$queueId = "queueId_example"; // string | queueId
$conversationId = "conversationId_example"; // string | conversationId

try {
    $result = $api_instance->getRoutingQueuesQueueIdEstimatedwaittime($queueId, $conversationId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getRoutingQueuesQueueIdEstimatedwaittime: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **queueId** | **string**| queueId |
 **conversationId** | **string**| conversationId | [optional]

### Return type

[**\PureCloudSDK\EstimatedWaitTimePredictions**](../Model/EstimatedWaitTimePredictions.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRoutingQueuesQueueIdMediatypesMediatypeEstimatedwaittime**
> \PureCloudSDK\EstimatedWaitTimePredictions getRoutingQueuesQueueIdMediatypesMediatypeEstimatedwaittime($queueId, $mediaType)

Get Estimated Wait Time



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$queueId = "queueId_example"; // string | queueId
$mediaType = "mediaType_example"; // string | mediaType

try {
    $result = $api_instance->getRoutingQueuesQueueIdMediatypesMediatypeEstimatedwaittime($queueId, $mediaType);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getRoutingQueuesQueueIdMediatypesMediatypeEstimatedwaittime: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **queueId** | **string**| queueId |
 **mediaType** | **string**| mediaType |

### Return type

[**\PureCloudSDK\EstimatedWaitTimePredictions**](../Model/EstimatedWaitTimePredictions.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRoutingQueuesQueueIdUsers**
> \PureCloudSDK\QueueMemberEntityListing getRoutingQueuesQueueIdUsers($queueId, $pageSize, $pageNumber, $sortBy, $expand, $joined, $name, $profileSkills, $skills, $languages, $routingStatus, $presence)

Get the members of this queue



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$queueId = "queueId_example"; // string | Queue ID
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$sortBy = "name"; // string | Sort by
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.
$joined = true; // bool | Filter by joined status
$name = "name_example"; // string | Filter by queue member name
$profileSkills = array("profileSkills_example"); // string[] | Filter by profile skill
$skills = array("skills_example"); // string[] | Filter by skill
$languages = array("languages_example"); // string[] | Filter by language
$routingStatus = array("routingStatus_example"); // string[] | Filter by routing status
$presence = array("presence_example"); // string[] | Filter by presence

try {
    $result = $api_instance->getRoutingQueuesQueueIdUsers($queueId, $pageSize, $pageNumber, $sortBy, $expand, $joined, $name, $profileSkills, $skills, $languages, $routingStatus, $presence);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getRoutingQueuesQueueIdUsers: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **queueId** | **string**| Queue ID |
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **sortBy** | **string**| Sort by | [optional] [default to name]
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]
 **joined** | **bool**| Filter by joined status | [optional]
 **name** | **string**| Filter by queue member name | [optional]
 **profileSkills** | [**string[]**](../Model/string.md)| Filter by profile skill | [optional]
 **skills** | [**string[]**](../Model/string.md)| Filter by skill | [optional]
 **languages** | [**string[]**](../Model/string.md)| Filter by language | [optional]
 **routingStatus** | [**string[]**](../Model/string.md)| Filter by routing status | [optional]
 **presence** | [**string[]**](../Model/string.md)| Filter by presence | [optional]

### Return type

[**\PureCloudSDK\QueueMemberEntityListing**](../Model/QueueMemberEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRoutingQueuesQueueIdWrapupcodes**
> \PureCloudSDK\WrapupCodeEntityListing getRoutingQueuesQueueIdWrapupcodes($queueId)

Get the wrap-up codes for a queue



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$queueId = "queueId_example"; // string | Queue ID

try {
    $result = $api_instance->getRoutingQueuesQueueIdWrapupcodes($queueId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getRoutingQueuesQueueIdWrapupcodes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **queueId** | **string**| Queue ID |

### Return type

[**\PureCloudSDK\WrapupCodeEntityListing**](../Model/WrapupCodeEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRoutingSkills**
> \PureCloudSDK\SkillEntityListing getRoutingSkills($pageSize, $pageNumber, $name)

Get the list of routing skills.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$name = "name_example"; // string | Filter for results that start with this value

try {
    $result = $api_instance->getRoutingSkills($pageSize, $pageNumber, $name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getRoutingSkills: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **name** | **string**| Filter for results that start with this value | [optional]

### Return type

[**\PureCloudSDK\SkillEntityListing**](../Model/SkillEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRoutingSkillsSkillId**
> \PureCloudSDK\RoutingSkill getRoutingSkillsSkillId($skillId)

Get Routing Skill



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$skillId = "skillId_example"; // string | Skill ID

try {
    $result = $api_instance->getRoutingSkillsSkillId($skillId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getRoutingSkillsSkillId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **skillId** | **string**| Skill ID |

### Return type

[**\PureCloudSDK\RoutingSkill**](../Model/RoutingSkill.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRoutingUtilization**
> \PureCloudSDK\Utilization getRoutingUtilization()

Get the utilization settings.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();

try {
    $result = $api_instance->getRoutingUtilization();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getRoutingUtilization: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\Utilization**](../Model/Utilization.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRoutingWrapupcodes**
> \PureCloudSDK\WrapupCodeEntityListing getRoutingWrapupcodes($pageSize, $pageNumber, $sortBy)

Get list of wrapup codes.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$sortBy = "name"; // string | Sort by

try {
    $result = $api_instance->getRoutingWrapupcodes($pageSize, $pageNumber, $sortBy);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getRoutingWrapupcodes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **sortBy** | **string**| Sort by | [optional] [default to name]

### Return type

[**\PureCloudSDK\WrapupCodeEntityListing**](../Model/WrapupCodeEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRoutingWrapupcodesCodeId**
> \PureCloudSDK\WrapupCode getRoutingWrapupcodesCodeId($codeId)

Get details about this wrap-up code.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$codeId = "codeId_example"; // string | Wrapup Code ID

try {
    $result = $api_instance->getRoutingWrapupcodesCodeId($codeId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getRoutingWrapupcodesCodeId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **codeId** | **string**| Wrapup Code ID |

### Return type

[**\PureCloudSDK\WrapupCode**](../Model/WrapupCode.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUsersUserIdRoutingskills**
> \PureCloudSDK\UserSkillEntityListing getUsersUserIdRoutingskills($userId, $pageSize, $pageNumber, $sortOrder)

List routing skills for user



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$userId = "userId_example"; // string | User ID
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$sortOrder = "ASC"; // string | Ascending or descending sort order

try {
    $result = $api_instance->getUsersUserIdRoutingskills($userId, $pageSize, $pageNumber, $sortOrder);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getUsersUserIdRoutingskills: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **sortOrder** | **string**| Ascending or descending sort order | [optional] [default to ASC]

### Return type

[**\PureCloudSDK\UserSkillEntityListing**](../Model/UserSkillEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchRoutingQueuesQueueIdUsers**
> \PureCloudSDK\QueueMemberEntityListing patchRoutingQueuesQueueIdUsers($queueId, $body)

Join or unjoin a set of users for a queue



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$queueId = "queueId_example"; // string | Queue ID
$body = array(new QueueMember()); // \PureCloudSDK\QueueMember[] | Queue Members

try {
    $result = $api_instance->patchRoutingQueuesQueueIdUsers($queueId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->patchRoutingQueuesQueueIdUsers: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **queueId** | **string**| Queue ID |
 **body** | [**\PureCloudSDK\QueueMember[]**](../Model/QueueMember.md)| Queue Members |

### Return type

[**\PureCloudSDK\QueueMemberEntityListing**](../Model/QueueMemberEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchRoutingQueuesQueueIdUsersMemberId**
> \PureCloudSDK\QueueMember patchRoutingQueuesQueueIdUsersMemberId($queueId, $memberId, $body)

Update the ring number of joined status for a User in a Queue



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$queueId = "queueId_example"; // string | Queue ID
$memberId = "memberId_example"; // string | Member ID
$body = new \PureCloudSDK\QueueMember(); // \PureCloudSDK\QueueMember | Queue Member

try {
    $result = $api_instance->patchRoutingQueuesQueueIdUsersMemberId($queueId, $memberId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->patchRoutingQueuesQueueIdUsersMemberId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **queueId** | **string**| Queue ID |
 **memberId** | **string**| Member ID |
 **body** | [**\PureCloudSDK\QueueMember**](../Model/\PureCloudSDK\QueueMember.md)| Queue Member |

### Return type

[**\PureCloudSDK\QueueMember**](../Model/QueueMember.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postAnalyticsQueuesObservationsQuery**
> \PureCloudSDK\QualifierMappingObservationQueryResponse postAnalyticsQueuesObservationsQuery($body)

Query for queue observations



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$body = new \PureCloudSDK\ObservationQuery(); // \PureCloudSDK\ObservationQuery | query

try {
    $result = $api_instance->postAnalyticsQueuesObservationsQuery($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->postAnalyticsQueuesObservationsQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\ObservationQuery**](../Model/\PureCloudSDK\ObservationQuery.md)| query |

### Return type

[**\PureCloudSDK\QualifierMappingObservationQueryResponse**](../Model/QualifierMappingObservationQueryResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postRoutingEmailDomains**
> \PureCloudSDK\InboundDomain postRoutingEmailDomains($body)

Create a domain



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$body = new \PureCloudSDK\InboundDomain(); // \PureCloudSDK\InboundDomain | Domain

try {
    $result = $api_instance->postRoutingEmailDomains($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->postRoutingEmailDomains: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\InboundDomain**](../Model/\PureCloudSDK\InboundDomain.md)| Domain |

### Return type

[**\PureCloudSDK\InboundDomain**](../Model/InboundDomain.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postRoutingEmailDomainsDomainnameRoutes**
> \PureCloudSDK\InboundRoute postRoutingEmailDomainsDomainnameRoutes($domainName, $body)

Create a route



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$domainName = "domainName_example"; // string | email domain
$body = new \PureCloudSDK\InboundRoute(); // \PureCloudSDK\InboundRoute | Route

try {
    $result = $api_instance->postRoutingEmailDomainsDomainnameRoutes($domainName, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->postRoutingEmailDomainsDomainnameRoutes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **domainName** | **string**| email domain |
 **body** | [**\PureCloudSDK\InboundRoute**](../Model/\PureCloudSDK\InboundRoute.md)| Route |

### Return type

[**\PureCloudSDK\InboundRoute**](../Model/InboundRoute.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postRoutingLanguages**
> \PureCloudSDK\Language postRoutingLanguages($body)

Create Language



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$body = new \PureCloudSDK\Language(); // \PureCloudSDK\Language | Language

try {
    $result = $api_instance->postRoutingLanguages($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->postRoutingLanguages: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Language**](../Model/\PureCloudSDK\Language.md)| Language |

### Return type

[**\PureCloudSDK\Language**](../Model/Language.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postRoutingQueues**
> \PureCloudSDK\Queue postRoutingQueues($body)

Create queue



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$body = new \PureCloudSDK\CreateQueueRequest(); // \PureCloudSDK\CreateQueueRequest | Queue

try {
    $result = $api_instance->postRoutingQueues($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->postRoutingQueues: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\CreateQueueRequest**](../Model/\PureCloudSDK\CreateQueueRequest.md)| Queue |

### Return type

[**\PureCloudSDK\Queue**](../Model/Queue.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postRoutingQueuesQueueIdUsers**
> string postRoutingQueuesQueueIdUsers($queueId, $body, $delete)

Bulk add or delete up to 100 queue members



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$queueId = "queueId_example"; // string | Queue ID
$body = array(new QueueMember()); // \PureCloudSDK\QueueMember[] | Queue Members
$delete = false; // bool | True to delete queue members

try {
    $result = $api_instance->postRoutingQueuesQueueIdUsers($queueId, $body, $delete);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->postRoutingQueuesQueueIdUsers: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **queueId** | **string**| Queue ID |
 **body** | [**\PureCloudSDK\QueueMember[]**](../Model/QueueMember.md)| Queue Members |
 **delete** | **bool**| True to delete queue members | [optional] [default to false]

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postRoutingQueuesQueueIdWrapupcodes**
> \PureCloudSDK\WrapupCode[] postRoutingQueuesQueueIdWrapupcodes($queueId, $body)

Add up to 100 wrap-up codes to a queue



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$queueId = "queueId_example"; // string | Queue ID
$body = array(new WrapupCode()); // \PureCloudSDK\WrapupCode[] | List of wrapup codes

try {
    $result = $api_instance->postRoutingQueuesQueueIdWrapupcodes($queueId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->postRoutingQueuesQueueIdWrapupcodes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **queueId** | **string**| Queue ID |
 **body** | [**\PureCloudSDK\WrapupCode[]**](../Model/WrapupCode.md)| List of wrapup codes |

### Return type

[**\PureCloudSDK\WrapupCode[]**](../Model/WrapupCode.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postRoutingSkills**
> \PureCloudSDK\RoutingSkill postRoutingSkills($body)

Create Skill



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$body = new \PureCloudSDK\RoutingSkill(); // \PureCloudSDK\RoutingSkill | Skill

try {
    $result = $api_instance->postRoutingSkills($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->postRoutingSkills: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\RoutingSkill**](../Model/\PureCloudSDK\RoutingSkill.md)| Skill |

### Return type

[**\PureCloudSDK\RoutingSkill**](../Model/RoutingSkill.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postRoutingWrapupcodes**
> \PureCloudSDK\WrapupCode postRoutingWrapupcodes($body)

Create a wrap-up code



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$body = new \PureCloudSDK\WrapupCode(); // \PureCloudSDK\WrapupCode | WrapupCode

try {
    $result = $api_instance->postRoutingWrapupcodes($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->postRoutingWrapupcodes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\WrapupCode**](../Model/\PureCloudSDK\WrapupCode.md)| WrapupCode |

### Return type

[**\PureCloudSDK\WrapupCode**](../Model/WrapupCode.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postUsersUserIdRoutingskills**
> \PureCloudSDK\UserRoutingSkill postUsersUserIdRoutingskills($userId, $body)

Add routing skill to user



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$userId = "userId_example"; // string | User ID
$body = new \PureCloudSDK\UserRoutingSkillPost(); // \PureCloudSDK\UserRoutingSkillPost | Skill

try {
    $result = $api_instance->postUsersUserIdRoutingskills($userId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->postUsersUserIdRoutingskills: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |
 **body** | [**\PureCloudSDK\UserRoutingSkillPost**](../Model/\PureCloudSDK\UserRoutingSkillPost.md)| Skill |

### Return type

[**\PureCloudSDK\UserRoutingSkill**](../Model/UserRoutingSkill.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putRoutingEmailDomainsDomainnameRoutesRouteId**
> \PureCloudSDK\InboundRoute putRoutingEmailDomainsDomainnameRoutesRouteId($domainName, $routeId, $body)

Update a route



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$domainName = "domainName_example"; // string | email domain
$routeId = "routeId_example"; // string | route ID
$body = new \PureCloudSDK\InboundRoute(); // \PureCloudSDK\InboundRoute | Route

try {
    $result = $api_instance->putRoutingEmailDomainsDomainnameRoutesRouteId($domainName, $routeId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->putRoutingEmailDomainsDomainnameRoutesRouteId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **domainName** | **string**| email domain |
 **routeId** | **string**| route ID |
 **body** | [**\PureCloudSDK\InboundRoute**](../Model/\PureCloudSDK\InboundRoute.md)| Route |

### Return type

[**\PureCloudSDK\InboundRoute**](../Model/InboundRoute.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putRoutingQueuesQueueId**
> \PureCloudSDK\Queue putRoutingQueuesQueueId($queueId, $body)

Update a queue



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$queueId = "queueId_example"; // string | Queue ID
$body = new \PureCloudSDK\Queue(); // \PureCloudSDK\Queue | Queue

try {
    $result = $api_instance->putRoutingQueuesQueueId($queueId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->putRoutingQueuesQueueId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **queueId** | **string**| Queue ID |
 **body** | [**\PureCloudSDK\Queue**](../Model/\PureCloudSDK\Queue.md)| Queue |

### Return type

[**\PureCloudSDK\Queue**](../Model/Queue.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putRoutingUtilization**
> \PureCloudSDK\Utilization putRoutingUtilization($body)

Update the utilization settings.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$body = new \PureCloudSDK\Utilization(); // \PureCloudSDK\Utilization | utilization

try {
    $result = $api_instance->putRoutingUtilization($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->putRoutingUtilization: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Utilization**](../Model/\PureCloudSDK\Utilization.md)| utilization |

### Return type

[**\PureCloudSDK\Utilization**](../Model/Utilization.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putRoutingWrapupcodesCodeId**
> \PureCloudSDK\WrapupCode putRoutingWrapupcodesCodeId($codeId, $body)

Update wrap-up code



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$codeId = "codeId_example"; // string | Wrapup Code ID
$body = new \PureCloudSDK\WrapupCode(); // \PureCloudSDK\WrapupCode | WrapupCode

try {
    $result = $api_instance->putRoutingWrapupcodesCodeId($codeId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->putRoutingWrapupcodesCodeId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **codeId** | **string**| Wrapup Code ID |
 **body** | [**\PureCloudSDK\WrapupCode**](../Model/\PureCloudSDK\WrapupCode.md)| WrapupCode |

### Return type

[**\PureCloudSDK\WrapupCode**](../Model/WrapupCode.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putUsersUserIdRoutingskillsSkillId**
> \PureCloudSDK\UserRoutingSkill putUsersUserIdRoutingskillsSkillId($userId, $skillId, $body)

Update routing skill proficiency or state.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$userId = "userId_example"; // string | User ID
$skillId = "skillId_example"; // string | skillId
$body = new \PureCloudSDK\UserRoutingSkill(); // \PureCloudSDK\UserRoutingSkill | Skill

try {
    $result = $api_instance->putUsersUserIdRoutingskillsSkillId($userId, $skillId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->putUsersUserIdRoutingskillsSkillId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |
 **skillId** | **string**| skillId |
 **body** | [**\PureCloudSDK\UserRoutingSkill**](../Model/\PureCloudSDK\UserRoutingSkill.md)| Skill |

### Return type

[**\PureCloudSDK\UserRoutingSkill**](../Model/UserRoutingSkill.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

