<?php

/**
 * Annotation
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * Annotation Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Annotation implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Annotation';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'type' => 'string',
        'location' => 'int',
        'durationMs' => 'int',
        'absoluteLocation' => 'int',
        'absoluteDurationMs' => 'int',
        'recordingLocation' => 'int',
        'recordingDurationMs' => 'int',
        'user' => '\PureCloudSDK\User',
        'description' => 'string',
        'keywordName' => 'string',
        'confidence' => 'float',
        'keywordSetId' => 'string',
        'keywordSetName' => 'string',
        'utterance' => 'string',
        'timeBegin' => 'string',
        'timeEnd' => 'string',
        'keywordConfidenceThreshold' => 'string',
        'agentScoreModifier' => 'string',
        'customerScoreModifier' => 'string',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'type' => 'type',
        'location' => 'location',
        'durationMs' => 'durationMs',
        'absoluteLocation' => 'absoluteLocation',
        'absoluteDurationMs' => 'absoluteDurationMs',
        'recordingLocation' => 'recordingLocation',
        'recordingDurationMs' => 'recordingDurationMs',
        'user' => 'user',
        'description' => 'description',
        'keywordName' => 'keywordName',
        'confidence' => 'confidence',
        'keywordSetId' => 'keywordSetId',
        'keywordSetName' => 'keywordSetName',
        'utterance' => 'utterance',
        'timeBegin' => 'timeBegin',
        'timeEnd' => 'timeEnd',
        'keywordConfidenceThreshold' => 'keywordConfidenceThreshold',
        'agentScoreModifier' => 'agentScoreModifier',
        'customerScoreModifier' => 'customerScoreModifier',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'type' => 'setType',
        'location' => 'setLocation',
        'durationMs' => 'setDurationMs',
        'absoluteLocation' => 'setAbsoluteLocation',
        'absoluteDurationMs' => 'setAbsoluteDurationMs',
        'recordingLocation' => 'setRecordingLocation',
        'recordingDurationMs' => 'setRecordingDurationMs',
        'user' => 'setUser',
        'description' => 'setDescription',
        'keywordName' => 'setKeywordName',
        'confidence' => 'setConfidence',
        'keywordSetId' => 'setKeywordSetId',
        'keywordSetName' => 'setKeywordSetName',
        'utterance' => 'setUtterance',
        'timeBegin' => 'setTimeBegin',
        'timeEnd' => 'setTimeEnd',
        'keywordConfidenceThreshold' => 'setKeywordConfidenceThreshold',
        'agentScoreModifier' => 'setAgentScoreModifier',
        'customerScoreModifier' => 'setCustomerScoreModifier',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'type' => 'getType',
        'location' => 'getLocation',
        'durationMs' => 'getDurationMs',
        'absoluteLocation' => 'getAbsoluteLocation',
        'absoluteDurationMs' => 'getAbsoluteDurationMs',
        'recordingLocation' => 'getRecordingLocation',
        'recordingDurationMs' => 'getRecordingDurationMs',
        'user' => 'getUser',
        'description' => 'getDescription',
        'keywordName' => 'getKeywordName',
        'confidence' => 'getConfidence',
        'keywordSetId' => 'getKeywordSetId',
        'keywordSetName' => 'getKeywordSetName',
        'utterance' => 'getUtterance',
        'timeBegin' => 'getTimeBegin',
        'timeEnd' => 'getTimeEnd',
        'keywordConfidenceThreshold' => 'getKeywordConfidenceThreshold',
        'agentScoreModifier' => 'getAgentScoreModifier',
        'customerScoreModifier' => 'getCustomerScoreModifier',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['location'] = isset($data['location']) ? $data['location'] : null;
        $this->container['durationMs'] = isset($data['durationMs']) ? $data['durationMs'] : null;
        $this->container['absoluteLocation'] = isset($data['absoluteLocation']) ? $data['absoluteLocation'] : null;
        $this->container['absoluteDurationMs'] = isset($data['absoluteDurationMs']) ? $data['absoluteDurationMs'] : null;
        $this->container['recordingLocation'] = isset($data['recordingLocation']) ? $data['recordingLocation'] : null;
        $this->container['recordingDurationMs'] = isset($data['recordingDurationMs']) ? $data['recordingDurationMs'] : null;
        $this->container['user'] = isset($data['user']) ? $data['user'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['keywordName'] = isset($data['keywordName']) ? $data['keywordName'] : null;
        $this->container['confidence'] = isset($data['confidence']) ? $data['confidence'] : null;
        $this->container['keywordSetId'] = isset($data['keywordSetId']) ? $data['keywordSetId'] : null;
        $this->container['keywordSetName'] = isset($data['keywordSetName']) ? $data['keywordSetName'] : null;
        $this->container['utterance'] = isset($data['utterance']) ? $data['utterance'] : null;
        $this->container['timeBegin'] = isset($data['timeBegin']) ? $data['timeBegin'] : null;
        $this->container['timeEnd'] = isset($data['timeEnd']) ? $data['timeEnd'] : null;
        $this->container['keywordConfidenceThreshold'] = isset($data['keywordConfidenceThreshold']) ? $data['keywordConfidenceThreshold'] : null;
        $this->container['agentScoreModifier'] = isset($data['agentScoreModifier']) ? $data['agentScoreModifier'] : null;
        $this->container['customerScoreModifier'] = isset($data['customerScoreModifier']) ? $data['customerScoreModifier'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['agentScoreModifier'] === null) {
            $invalid_properties[] = "'agentScoreModifier' can't be null";
        }
        if ($this->container['customerScoreModifier'] === null) {
            $invalid_properties[] = "'customerScoreModifier' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['agentScoreModifier'] === null) {
            return false;
        }
        if ($this->container['customerScoreModifier'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     * @param string $type
     * @return $this
     */
    public function setType($type)
    {
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets location
     * @return int
     */
    public function getLocation()
    {
        return $this->container['location'];
    }

    /**
     * Sets location
     * @param int $location Offset of annotation in milliseconds.
     * @return $this
     */
    public function setLocation($location)
    {
        $this->container['location'] = $location;

        return $this;
    }

    /**
     * Gets durationMs
     * @return int
     */
    public function getDurationMs()
    {
        return $this->container['durationMs'];
    }

    /**
     * Sets durationMs
     * @param int $durationMs Duration of annotation in milliseconds.
     * @return $this
     */
    public function setDurationMs($durationMs)
    {
        $this->container['durationMs'] = $durationMs;

        return $this;
    }

    /**
     * Gets absoluteLocation
     * @return int
     */
    public function getAbsoluteLocation()
    {
        return $this->container['absoluteLocation'];
    }

    /**
     * Sets absoluteLocation
     * @param int $absoluteLocation Offset of annotation (milliseconds) from start of recording.
     * @return $this
     */
    public function setAbsoluteLocation($absoluteLocation)
    {
        $this->container['absoluteLocation'] = $absoluteLocation;

        return $this;
    }

    /**
     * Gets absoluteDurationMs
     * @return int
     */
    public function getAbsoluteDurationMs()
    {
        return $this->container['absoluteDurationMs'];
    }

    /**
     * Sets absoluteDurationMs
     * @param int $absoluteDurationMs Duration of annotation (milliseconds).
     * @return $this
     */
    public function setAbsoluteDurationMs($absoluteDurationMs)
    {
        $this->container['absoluteDurationMs'] = $absoluteDurationMs;

        return $this;
    }

    /**
     * Gets recordingLocation
     * @return int
     */
    public function getRecordingLocation()
    {
        return $this->container['recordingLocation'];
    }

    /**
     * Sets recordingLocation
     * @param int $recordingLocation Offset of annotation (milliseconds) from start of recording, adjusted for any recording cuts
     * @return $this
     */
    public function setRecordingLocation($recordingLocation)
    {
        $this->container['recordingLocation'] = $recordingLocation;

        return $this;
    }

    /**
     * Gets recordingDurationMs
     * @return int
     */
    public function getRecordingDurationMs()
    {
        return $this->container['recordingDurationMs'];
    }

    /**
     * Sets recordingDurationMs
     * @param int $recordingDurationMs Duration of annotation (milliseconds), adjusted for any recording cuts.
     * @return $this
     */
    public function setRecordingDurationMs($recordingDurationMs)
    {
        $this->container['recordingDurationMs'] = $recordingDurationMs;

        return $this;
    }

    /**
     * Gets user
     * @return \PureCloudSDK\User
     */
    public function getUser()
    {
        return $this->container['user'];
    }

    /**
     * Sets user
     * @param \PureCloudSDK\User $user User that created this annotation (if any).
     * @return $this
     */
    public function setUser($user)
    {
        $this->container['user'] = $user;

        return $this;
    }

    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description Text of annotation.
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets keywordName
     * @return string
     */
    public function getKeywordName()
    {
        return $this->container['keywordName'];
    }

    /**
     * Sets keywordName
     * @param string $keywordName The word or phrase which is being looked for with speech recognition.
     * @return $this
     */
    public function setKeywordName($keywordName)
    {
        $this->container['keywordName'] = $keywordName;

        return $this;
    }

    /**
     * Gets confidence
     * @return float
     */
    public function getConfidence()
    {
        return $this->container['confidence'];
    }

    /**
     * Sets confidence
     * @param float $confidence Actual confidence that this is an accurate match.
     * @return $this
     */
    public function setConfidence($confidence)
    {
        $this->container['confidence'] = $confidence;

        return $this;
    }

    /**
     * Gets keywordSetId
     * @return string
     */
    public function getKeywordSetId()
    {
        return $this->container['keywordSetId'];
    }

    /**
     * Sets keywordSetId
     * @param string $keywordSetId A unique identifier for the keyword set to which this spotted keyword belongs.
     * @return $this
     */
    public function setKeywordSetId($keywordSetId)
    {
        $this->container['keywordSetId'] = $keywordSetId;

        return $this;
    }

    /**
     * Gets keywordSetName
     * @return string
     */
    public function getKeywordSetName()
    {
        return $this->container['keywordSetName'];
    }

    /**
     * Sets keywordSetName
     * @param string $keywordSetName The keyword set to which this spotted keyword belongs.
     * @return $this
     */
    public function setKeywordSetName($keywordSetName)
    {
        $this->container['keywordSetName'] = $keywordSetName;

        return $this;
    }

    /**
     * Gets utterance
     * @return string
     */
    public function getUtterance()
    {
        return $this->container['utterance'];
    }

    /**
     * Sets utterance
     * @param string $utterance The phonetic spellings for the phrase and alternate spellings.
     * @return $this
     */
    public function setUtterance($utterance)
    {
        $this->container['utterance'] = $utterance;

        return $this;
    }

    /**
     * Gets timeBegin
     * @return string
     */
    public function getTimeBegin()
    {
        return $this->container['timeBegin'];
    }

    /**
     * Sets timeBegin
     * @param string $timeBegin Beginning time offset of the keyword spot match.
     * @return $this
     */
    public function setTimeBegin($timeBegin)
    {
        $this->container['timeBegin'] = $timeBegin;

        return $this;
    }

    /**
     * Gets timeEnd
     * @return string
     */
    public function getTimeEnd()
    {
        return $this->container['timeEnd'];
    }

    /**
     * Sets timeEnd
     * @param string $timeEnd Ending time offset of the keyword spot match.
     * @return $this
     */
    public function setTimeEnd($timeEnd)
    {
        $this->container['timeEnd'] = $timeEnd;

        return $this;
    }

    /**
     * Gets keywordConfidenceThreshold
     * @return string
     */
    public function getKeywordConfidenceThreshold()
    {
        return $this->container['keywordConfidenceThreshold'];
    }

    /**
     * Sets keywordConfidenceThreshold
     * @param string $keywordConfidenceThreshold Configured sensitivity threshold that can be increased to lower false positives or decreased to reduce false negatives.
     * @return $this
     */
    public function setKeywordConfidenceThreshold($keywordConfidenceThreshold)
    {
        $this->container['keywordConfidenceThreshold'] = $keywordConfidenceThreshold;

        return $this;
    }

    /**
     * Gets agentScoreModifier
     * @return string
     */
    public function getAgentScoreModifier()
    {
        return $this->container['agentScoreModifier'];
    }

    /**
     * Sets agentScoreModifier
     * @param string $agentScoreModifier A modifier to the evaluation score when the phrase is spotted in the agent channel.
     * @return $this
     */
    public function setAgentScoreModifier($agentScoreModifier)
    {
        $this->container['agentScoreModifier'] = $agentScoreModifier;

        return $this;
    }

    /**
     * Gets customerScoreModifier
     * @return string
     */
    public function getCustomerScoreModifier()
    {
        return $this->container['customerScoreModifier'];
    }

    /**
     * Sets customerScoreModifier
     * @param string $customerScoreModifier A modifier to the evaluation score when the phrase is spotted in the customer channel.
     * @return $this
     */
    public function setCustomerScoreModifier($customerScoreModifier)
    {
        $this->container['customerScoreModifier'] = $customerScoreModifier;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


