<?php

/**
 * CreateSecureSession
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * CreateSecureSession Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CreateSecureSession implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CreateSecureSession';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'sourceParticipantId' => 'string',
        'flowId' => 'string',
        'userData' => 'string',
        'disconnect' => 'bool'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'sourceParticipantId' => 'sourceParticipantId',
        'flowId' => 'flowId',
        'userData' => 'userData',
        'disconnect' => 'disconnect'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'sourceParticipantId' => 'setSourceParticipantId',
        'flowId' => 'setFlowId',
        'userData' => 'setUserData',
        'disconnect' => 'setDisconnect'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'sourceParticipantId' => 'getSourceParticipantId',
        'flowId' => 'getFlowId',
        'userData' => 'getUserData',
        'disconnect' => 'getDisconnect'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['sourceParticipantId'] = isset($data['sourceParticipantId']) ? $data['sourceParticipantId'] : null;
        $this->container['flowId'] = isset($data['flowId']) ? $data['flowId'] : null;
        $this->container['userData'] = isset($data['userData']) ? $data['userData'] : null;
        $this->container['disconnect'] = isset($data['disconnect']) ? $data['disconnect'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['flowId'] === null) {
            $invalid_properties[] = "'flowId' can't be null";
        }
        if ($this->container['userData'] === null) {
            $invalid_properties[] = "'userData' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['flowId'] === null) {
            return false;
        }
        if ($this->container['userData'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets sourceParticipantId
     * @return string
     */
    public function getSourceParticipantId()
    {
        return $this->container['sourceParticipantId'];
    }

    /**
     * Sets sourceParticipantId
     * @param string $sourceParticipantId requesting participant
     * @return $this
     */
    public function setSourceParticipantId($sourceParticipantId)
    {
        $this->container['sourceParticipantId'] = $sourceParticipantId;

        return $this;
    }

    /**
     * Gets flowId
     * @return string
     */
    public function getFlowId()
    {
        return $this->container['flowId'];
    }

    /**
     * Sets flowId
     * @param string $flowId the flow id to execute in the secure session
     * @return $this
     */
    public function setFlowId($flowId)
    {
        $this->container['flowId'] = $flowId;

        return $this;
    }

    /**
     * Gets userData
     * @return string
     */
    public function getUserData()
    {
        return $this->container['userData'];
    }

    /**
     * Sets userData
     * @param string $userData user data for the secure session
     * @return $this
     */
    public function setUserData($userData)
    {
        $this->container['userData'] = $userData;

        return $this;
    }

    /**
     * Gets disconnect
     * @return bool
     */
    public function getDisconnect()
    {
        return $this->container['disconnect'];
    }

    /**
     * Sets disconnect
     * @param bool $disconnect if true, disconnect the agent after creating the session
     * @return $this
     */
    public function setDisconnect($disconnect)
    {
        $this->container['disconnect'] = $disconnect;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


