<?php

/**
 * DocumentationResult
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * DocumentationResult Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class DocumentationResult implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'DocumentationResult';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'int',
        'categories' => 'int[]',
        'description' => 'string',
        'content' => 'string',
        'excerpt' => 'string',
        'link' => 'string',
        'modified' => '\DateTime',
        'name' => 'string',
        'service' => 'int[]',
        'slug' => 'string',
        'title' => 'string',
        'getType' => 'string',
        'facetFeature' => 'int[]',
        'facetRole' => 'int[]',
        'facetService' => 'int[]',
        'faqCategories' => 'int[]',
        'releasenoteCategory' => 'int[]',
        'releasenoteTag' => 'int[]',
        'serviceArea' => 'int[]',
        'videoCategories' => 'int[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'categories' => 'categories',
        'description' => 'description',
        'content' => 'content',
        'excerpt' => 'excerpt',
        'link' => 'link',
        'modified' => 'modified',
        'name' => 'name',
        'service' => 'service',
        'slug' => 'slug',
        'title' => 'title',
        'getType' => 'get_type',
        'facetFeature' => 'facet_feature',
        'facetRole' => 'facet_role',
        'facetService' => 'facet_service',
        'faqCategories' => 'faq_categories',
        'releasenoteCategory' => 'releasenote_category',
        'releasenoteTag' => 'releasenote_tag',
        'serviceArea' => 'service-area',
        'videoCategories' => 'video_categories'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'categories' => 'setCategories',
        'description' => 'setDescription',
        'content' => 'setContent',
        'excerpt' => 'setExcerpt',
        'link' => 'setLink',
        'modified' => 'setModified',
        'name' => 'setName',
        'service' => 'setService',
        'slug' => 'setSlug',
        'title' => 'setTitle',
        'getType' => 'setGetType',
        'facetFeature' => 'setFacetFeature',
        'facetRole' => 'setFacetRole',
        'facetService' => 'setFacetService',
        'faqCategories' => 'setFaqCategories',
        'releasenoteCategory' => 'setReleasenoteCategory',
        'releasenoteTag' => 'setReleasenoteTag',
        'serviceArea' => 'setServiceArea',
        'videoCategories' => 'setVideoCategories'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'categories' => 'getCategories',
        'description' => 'getDescription',
        'content' => 'getContent',
        'excerpt' => 'getExcerpt',
        'link' => 'getLink',
        'modified' => 'getModified',
        'name' => 'getName',
        'service' => 'getService',
        'slug' => 'getSlug',
        'title' => 'getTitle',
        'getType' => 'getGetType',
        'facetFeature' => 'getFacetFeature',
        'facetRole' => 'getFacetRole',
        'facetService' => 'getFacetService',
        'faqCategories' => 'getFaqCategories',
        'releasenoteCategory' => 'getReleasenoteCategory',
        'releasenoteTag' => 'getReleasenoteTag',
        'serviceArea' => 'getServiceArea',
        'videoCategories' => 'getVideoCategories'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['categories'] = isset($data['categories']) ? $data['categories'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['content'] = isset($data['content']) ? $data['content'] : null;
        $this->container['excerpt'] = isset($data['excerpt']) ? $data['excerpt'] : null;
        $this->container['link'] = isset($data['link']) ? $data['link'] : null;
        $this->container['modified'] = isset($data['modified']) ? $data['modified'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['service'] = isset($data['service']) ? $data['service'] : null;
        $this->container['slug'] = isset($data['slug']) ? $data['slug'] : null;
        $this->container['title'] = isset($data['title']) ? $data['title'] : null;
        $this->container['getType'] = isset($data['getType']) ? $data['getType'] : null;
        $this->container['facetFeature'] = isset($data['facetFeature']) ? $data['facetFeature'] : null;
        $this->container['facetRole'] = isset($data['facetRole']) ? $data['facetRole'] : null;
        $this->container['facetService'] = isset($data['facetService']) ? $data['facetService'] : null;
        $this->container['faqCategories'] = isset($data['faqCategories']) ? $data['faqCategories'] : null;
        $this->container['releasenoteCategory'] = isset($data['releasenoteCategory']) ? $data['releasenoteCategory'] : null;
        $this->container['releasenoteTag'] = isset($data['releasenoteTag']) ? $data['releasenoteTag'] : null;
        $this->container['serviceArea'] = isset($data['serviceArea']) ? $data['serviceArea'] : null;
        $this->container['videoCategories'] = isset($data['videoCategories']) ? $data['videoCategories'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['id'] === null) {
            $invalid_properties[] = "'id' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['id'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return int
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param int $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets categories
     * @return int[]
     */
    public function getCategories()
    {
        return $this->container['categories'];
    }

    /**
     * Sets categories
     * @param int[] $categories The category of the documentation entity. Will be returned in responses for certain entities.
     * @return $this
     */
    public function setCategories($categories)
    {
        $this->container['categories'] = $categories;

        return $this;
    }

    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description The description of the documentation entity. Will be returned in responses for certain entities.
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets content
     * @return string
     */
    public function getContent()
    {
        return $this->container['content'];
    }

    /**
     * Sets content
     * @param string $content The text or html content for the documentation entity. Will be returned in responses for certain entities.
     * @return $this
     */
    public function setContent($content)
    {
        $this->container['content'] = $content;

        return $this;
    }

    /**
     * Gets excerpt
     * @return string
     */
    public function getExcerpt()
    {
        return $this->container['excerpt'];
    }

    /**
     * Sets excerpt
     * @param string $excerpt The excerpt of the documentation entity. Will be returned in responses for certain entities.
     * @return $this
     */
    public function setExcerpt($excerpt)
    {
        $this->container['excerpt'] = $excerpt;

        return $this;
    }

    /**
     * Gets link
     * @return string
     */
    public function getLink()
    {
        return $this->container['link'];
    }

    /**
     * Sets link
     * @param string $link URL link for the documentation entity. Will be returned in responses for certain entities.
     * @return $this
     */
    public function setLink($link)
    {
        $this->container['link'] = $link;

        return $this;
    }

    /**
     * Gets modified
     * @return \DateTime
     */
    public function getModified()
    {
        return $this->container['modified'];
    }

    /**
     * Sets modified
     * @param \DateTime $modified The modified date for the documentation entity. Will be returned in responses for certain entities. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setModified($modified)
    {
        $this->container['modified'] = $modified;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The name of the documentation entity. Will be returned in responses for certain entities.
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets service
     * @return int[]
     */
    public function getService()
    {
        return $this->container['service'];
    }

    /**
     * Sets service
     * @param int[] $service The service of the documentation entity. Will be returned in responses for certain entities.
     * @return $this
     */
    public function setService($service)
    {
        $this->container['service'] = $service;

        return $this;
    }

    /**
     * Gets slug
     * @return string
     */
    public function getSlug()
    {
        return $this->container['slug'];
    }

    /**
     * Sets slug
     * @param string $slug The slug of the documentation entity. Will be returned in responses for certain entities.
     * @return $this
     */
    public function setSlug($slug)
    {
        $this->container['slug'] = $slug;

        return $this;
    }

    /**
     * Gets title
     * @return string
     */
    public function getTitle()
    {
        return $this->container['title'];
    }

    /**
     * Sets title
     * @param string $title The title of the documentation entity. Will be returned in responses for certain entities.
     * @return $this
     */
    public function setTitle($title)
    {
        $this->container['title'] = $title;

        return $this;
    }

    /**
     * Gets getType
     * @return string
     */
    public function getGetType()
    {
        return $this->container['getType'];
    }

    /**
     * Sets getType
     * @param string $getType The search type. Will be returned in responses for certain entities.
     * @return $this
     */
    public function setGetType($getType)
    {
        $this->container['getType'] = $getType;

        return $this;
    }

    /**
     * Gets facetFeature
     * @return int[]
     */
    public function getFacetFeature()
    {
        return $this->container['facetFeature'];
    }

    /**
     * Sets facetFeature
     * @param int[] $facetFeature The facet feature of the documentation entity. Will be returned in responses for certain entities.
     * @return $this
     */
    public function setFacetFeature($facetFeature)
    {
        $this->container['facetFeature'] = $facetFeature;

        return $this;
    }

    /**
     * Gets facetRole
     * @return int[]
     */
    public function getFacetRole()
    {
        return $this->container['facetRole'];
    }

    /**
     * Sets facetRole
     * @param int[] $facetRole The facet role of the documentation entity. Will be returned in responses for certain entities.
     * @return $this
     */
    public function setFacetRole($facetRole)
    {
        $this->container['facetRole'] = $facetRole;

        return $this;
    }

    /**
     * Gets facetService
     * @return int[]
     */
    public function getFacetService()
    {
        return $this->container['facetService'];
    }

    /**
     * Sets facetService
     * @param int[] $facetService The facet service of the documentation entity. Will be returned in responses for certain entities.
     * @return $this
     */
    public function setFacetService($facetService)
    {
        $this->container['facetService'] = $facetService;

        return $this;
    }

    /**
     * Gets faqCategories
     * @return int[]
     */
    public function getFaqCategories()
    {
        return $this->container['faqCategories'];
    }

    /**
     * Sets faqCategories
     * @param int[] $faqCategories The faq categories of the documentation entity. Will be returned in responses for certain entities.
     * @return $this
     */
    public function setFaqCategories($faqCategories)
    {
        $this->container['faqCategories'] = $faqCategories;

        return $this;
    }

    /**
     * Gets releasenoteCategory
     * @return int[]
     */
    public function getReleasenoteCategory()
    {
        return $this->container['releasenoteCategory'];
    }

    /**
     * Sets releasenoteCategory
     * @param int[] $releasenoteCategory The releasenote category of the documentation entity. Will be returned in responses for certain entities.
     * @return $this
     */
    public function setReleasenoteCategory($releasenoteCategory)
    {
        $this->container['releasenoteCategory'] = $releasenoteCategory;

        return $this;
    }

    /**
     * Gets releasenoteTag
     * @return int[]
     */
    public function getReleasenoteTag()
    {
        return $this->container['releasenoteTag'];
    }

    /**
     * Sets releasenoteTag
     * @param int[] $releasenoteTag The releasenote tag of the documentation entity. Will be returned in responses for certain entities.
     * @return $this
     */
    public function setReleasenoteTag($releasenoteTag)
    {
        $this->container['releasenoteTag'] = $releasenoteTag;

        return $this;
    }

    /**
     * Gets serviceArea
     * @return int[]
     */
    public function getServiceArea()
    {
        return $this->container['serviceArea'];
    }

    /**
     * Sets serviceArea
     * @param int[] $serviceArea The service area of the documentation entity. Will be returned in responses for certain entities.
     * @return $this
     */
    public function setServiceArea($serviceArea)
    {
        $this->container['serviceArea'] = $serviceArea;

        return $this;
    }

    /**
     * Gets videoCategories
     * @return int[]
     */
    public function getVideoCategories()
    {
        return $this->container['videoCategories'];
    }

    /**
     * Sets videoCategories
     * @param int[] $videoCategories The video categories of the documentation entity. Will be returned in responses for certain entities.
     * @return $this
     */
    public function setVideoCategories($videoCategories)
    {
        $this->container['videoCategories'] = $videoCategories;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


