<?php

/**
 * HistoryEntry
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * HistoryEntry Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class HistoryEntry implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'HistoryEntry';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'action' => 'string',
        'resource' => 'string',
        'timestamp' => '\DateTime',
        'user' => '\PureCloudSDK\User',
        'version' => 'string',
        'secure' => 'bool'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'action' => 'action',
        'resource' => 'resource',
        'timestamp' => 'timestamp',
        'user' => 'user',
        'version' => 'version',
        'secure' => 'secure'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'action' => 'setAction',
        'resource' => 'setResource',
        'timestamp' => 'setTimestamp',
        'user' => 'setUser',
        'version' => 'setVersion',
        'secure' => 'setSecure'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'action' => 'getAction',
        'resource' => 'getResource',
        'timestamp' => 'getTimestamp',
        'user' => 'getUser',
        'version' => 'getVersion',
        'secure' => 'getSecure'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const ACTION_CHECKIN = 'CHECKIN';
    public const ACTION_CHECKOUT = 'CHECKOUT';
    public const ACTION_CREATE = 'CREATE';
    public const ACTION_DEACTIVATE = 'DEACTIVATE';
    public const ACTION_DEBUG = 'DEBUG';
    public const ACTION_DELETE = 'DELETE';
    public const ACTION_PUBLISH = 'PUBLISH';
    public const ACTION_REVERT = 'REVERT';
    public const ACTION_SAVE = 'SAVE';
    public const ACTION_TRANSCODE = 'TRANSCODE';
    public const ACTION_UPDATE = 'UPDATE';
    public const ACTION_UPLOAD = 'UPLOAD';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getActionAllowableValues()
    {
        return [
            self::ACTION_CHECKIN,
            self::ACTION_CHECKOUT,
            self::ACTION_CREATE,
            self::ACTION_DEACTIVATE,
            self::ACTION_DEBUG,
            self::ACTION_DELETE,
            self::ACTION_PUBLISH,
            self::ACTION_REVERT,
            self::ACTION_SAVE,
            self::ACTION_TRANSCODE,
            self::ACTION_UPDATE,
            self::ACTION_UPLOAD,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['action'] = isset($data['action']) ? $data['action'] : null;
        $this->container['resource'] = isset($data['resource']) ? $data['resource'] : null;
        $this->container['timestamp'] = isset($data['timestamp']) ? $data['timestamp'] : null;
        $this->container['user'] = isset($data['user']) ? $data['user'] : null;
        $this->container['version'] = isset($data['version']) ? $data['version'] : null;
        $this->container['secure'] = isset($data['secure']) ? $data['secure'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("CHECKIN", "CHECKOUT", "CREATE", "DEACTIVATE", "DEBUG", "DELETE", "PUBLISH", "REVERT", "SAVE", "TRANSCODE", "UPDATE", "UPLOAD");
        if (!in_array($this->container['action'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'action', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("CHECKIN", "CHECKOUT", "CREATE", "DEACTIVATE", "DEBUG", "DELETE", "PUBLISH", "REVERT", "SAVE", "TRANSCODE", "UPDATE", "UPLOAD");
        if (!in_array($this->container['action'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets action
     * @return string
     */
    public function getAction()
    {
        return $this->container['action'];
    }

    /**
     * Sets action
     * @param string $action The action performed
     * @return $this
     */
    public function setAction($action)
    {
        $allowed_values = array('CHECKIN', 'CHECKOUT', 'CREATE', 'DEACTIVATE', 'DEBUG', 'DELETE', 'PUBLISH', 'REVERT', 'SAVE', 'TRANSCODE', 'UPDATE', 'UPLOAD');
        if (!in_array($action, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'action', must be one of 'CHECKIN', 'CHECKOUT', 'CREATE', 'DEACTIVATE', 'DEBUG', 'DELETE', 'PUBLISH', 'REVERT', 'SAVE', 'TRANSCODE', 'UPDATE', 'UPLOAD'");
        }
        $this->container['action'] = $action;

        return $this;
    }

    /**
     * Gets resource
     * @return string
     */
    public function getResource()
    {
        return $this->container['resource'];
    }

    /**
     * Sets resource
     * @param string $resource For actions performed not on the item itself, but on a sub-item, this field identifies the sub-item by name.  For example, for actions performed on prompt resources, this will be the prompt resource name.
     * @return $this
     */
    public function setResource($resource)
    {
        $this->container['resource'] = $resource;

        return $this;
    }

    /**
     * Gets timestamp
     * @return \DateTime
     */
    public function getTimestamp()
    {
        return $this->container['timestamp'];
    }

    /**
     * Sets timestamp
     * @param \DateTime $timestamp Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setTimestamp($timestamp)
    {
        $this->container['timestamp'] = $timestamp;

        return $this;
    }

    /**
     * Gets user
     * @return \PureCloudSDK\User
     */
    public function getUser()
    {
        return $this->container['user'];
    }

    /**
     * Sets user
     * @param \PureCloudSDK\User $user
     * @return $this
     */
    public function setUser($user)
    {
        $this->container['user'] = $user;

        return $this;
    }

    /**
     * Gets version
     * @return string
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     * @param string $version
     * @return $this
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets secure
     * @return bool
     */
    public function getSecure()
    {
        return $this->container['secure'];
    }

    /**
     * Sets secure
     * @param bool $secure
     * @return $this
     */
    public function setSecure($secure)
    {
        $this->container['secure'] = $secure;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


