<?php

/**
 * ApiUsageQuery
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * ApiUsageQuery Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ApiUsageQuery implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ApiUsageQuery';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'interval' => 'string',
        'granularity' => 'string',
        'groupBy' => 'string[]',
        'metrics' => 'string[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'interval' => 'interval',
        'granularity' => 'granularity',
        'groupBy' => 'groupBy',
        'metrics' => 'metrics'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'interval' => 'setInterval',
        'granularity' => 'setGranularity',
        'groupBy' => 'setGroupBy',
        'metrics' => 'setMetrics'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'interval' => 'getInterval',
        'granularity' => 'getGranularity',
        'groupBy' => 'getGroupBy',
        'metrics' => 'getMetrics'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const GRANULARITY_DAY = 'Day';
    public const GRANULARITY_WEEK = 'Week';
    public const GRANULARITY_MONTH = 'Month';
    public const GROUP_BY_O_AUTH_CLIENT_ID = 'OAuthClientId';
    public const GROUP_BY_ORGANIZATION_ID = 'OrganizationId';
    public const GROUP_BY_USER_ID = 'UserId';
    public const GROUP_BY_TEMPLATE_URI = 'TemplateUri';
    public const GROUP_BY_HTTP_METHOD = 'HttpMethod';
    public const METRICS_STATUS200 = 'Status200';
    public const METRICS_STATUS300 = 'Status300';
    public const METRICS_STATUS400 = 'Status400';
    public const METRICS_STATUS500 = 'Status500';
    public const METRICS_STATUS429 = 'Status429';
    public const METRICS_REQUESTS = 'Requests';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getGranularityAllowableValues()
    {
        return [
            self::GRANULARITY_DAY,
            self::GRANULARITY_WEEK,
            self::GRANULARITY_MONTH,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getGroupByAllowableValues()
    {
        return [
            self::GROUP_BY_O_AUTH_CLIENT_ID,
            self::GROUP_BY_ORGANIZATION_ID,
            self::GROUP_BY_USER_ID,
            self::GROUP_BY_TEMPLATE_URI,
            self::GROUP_BY_HTTP_METHOD,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMetricsAllowableValues()
    {
        return [
            self::METRICS_STATUS200,
            self::METRICS_STATUS300,
            self::METRICS_STATUS400,
            self::METRICS_STATUS500,
            self::METRICS_STATUS429,
            self::METRICS_REQUESTS,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['interval'] = isset($data['interval']) ? $data['interval'] : null;
        $this->container['granularity'] = isset($data['granularity']) ? $data['granularity'] : null;
        $this->container['groupBy'] = isset($data['groupBy']) ? $data['groupBy'] : null;
        $this->container['metrics'] = isset($data['metrics']) ? $data['metrics'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['interval'] === null) {
            $invalid_properties[] = "'interval' can't be null";
        }
        $allowed_values = array("Day", "Week", "Month");
        if (!in_array($this->container['granularity'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'granularity', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['interval'] === null) {
            return false;
        }
        $allowed_values = array("Day", "Week", "Month");
        if (!in_array($this->container['granularity'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets interval
     * @return string
     */
    public function getInterval()
    {
        return $this->container['interval'];
    }

    /**
     * Sets interval
     * @param string $interval Behaves like one clause in a SQL WHERE. Specifies the date and time range of data being queried. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss
     * @return $this
     */
    public function setInterval($interval)
    {
        $this->container['interval'] = $interval;

        return $this;
    }

    /**
     * Gets granularity
     * @return string
     */
    public function getGranularity()
    {
        return $this->container['granularity'];
    }

    /**
     * Sets granularity
     * @param string $granularity Date granularity of the results
     * @return $this
     */
    public function setGranularity($granularity)
    {
        $allowed_values = array('Day', 'Week', 'Month');
        if (!in_array($granularity, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'granularity', must be one of 'Day', 'Week', 'Month'");
        }
        $this->container['granularity'] = $granularity;

        return $this;
    }

    /**
     * Gets groupBy
     * @return string[]
     */
    public function getGroupBy()
    {
        return $this->container['groupBy'];
    }

    /**
     * Sets groupBy
     * @param string[] $groupBy Behaves like a SQL GROUPBY. Allows for multiple levels of grouping as a list of dimensions. Partitions resulting aggregate computations into distinct named subgroups rather than across the entire result set as if it were one group.
     * @return $this
     */
    public function setGroupBy($groupBy)
    {
        $allowed_values = array('OAuthClientId', 'OrganizationId', 'UserId', 'TemplateUri', 'HttpMethod');
        if (!in_array($groupBy, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'groupBy', must be one of 'OAuthClientId', 'OrganizationId', 'UserId', 'TemplateUri', 'HttpMethod'");
        }
        $this->container['groupBy'] = $groupBy;

        return $this;
    }

    /**
     * Gets metrics
     * @return string[]
     */
    public function getMetrics()
    {
        return $this->container['metrics'];
    }

    /**
     * Sets metrics
     * @param string[] $metrics Behaves like a SQL SELECT clause. Enables retrieving only named metrics. If omitted, all metrics that are available will be returned (like SELECT *).
     * @return $this
     */
    public function setMetrics($metrics)
    {
        $allowed_values = array('Status200', 'Status300', 'Status400', 'Status500', 'Status429', 'Requests');
        if (!in_array($metrics, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'metrics', must be one of 'Status200', 'Status300', 'Status400', 'Status500', 'Status429', 'Requests'");
        }
        $this->container['metrics'] = $metrics;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
