<?php

/**
 * BuForecastModification
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * BuForecastModification Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class BuForecastModification implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'BuForecastModification';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'type' => 'string',
        'startIntervalIndex' => 'int',
        'endIntervalIndex' => 'int',
        'metric' => 'string',
        'legacyMetric' => 'string',
        'value' => 'double',
        'values' => '\PureCloudSDK\WfmForecastModificationIntervalOffsetValue[]',
        'displayGranularity' => 'string',
        'granularity' => 'string',
        'enabled' => 'bool',
        'planningGroupIds' => 'string[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'type' => 'type',
        'startIntervalIndex' => 'startIntervalIndex',
        'endIntervalIndex' => 'endIntervalIndex',
        'metric' => 'metric',
        'legacyMetric' => 'legacyMetric',
        'value' => 'value',
        'values' => 'values',
        'displayGranularity' => 'displayGranularity',
        'granularity' => 'granularity',
        'enabled' => 'enabled',
        'planningGroupIds' => 'planningGroupIds'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'type' => 'setType',
        'startIntervalIndex' => 'setStartIntervalIndex',
        'endIntervalIndex' => 'setEndIntervalIndex',
        'metric' => 'setMetric',
        'legacyMetric' => 'setLegacyMetric',
        'value' => 'setValue',
        'values' => 'setValues',
        'displayGranularity' => 'setDisplayGranularity',
        'granularity' => 'setGranularity',
        'enabled' => 'setEnabled',
        'planningGroupIds' => 'setPlanningGroupIds'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'type' => 'getType',
        'startIntervalIndex' => 'getStartIntervalIndex',
        'endIntervalIndex' => 'getEndIntervalIndex',
        'metric' => 'getMetric',
        'legacyMetric' => 'getLegacyMetric',
        'value' => 'getValue',
        'values' => 'getValues',
        'displayGranularity' => 'getDisplayGranularity',
        'granularity' => 'getGranularity',
        'enabled' => 'getEnabled',
        'planningGroupIds' => 'getPlanningGroupIds'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const TYPE_MINIMUM_PER_INTERVAL = 'MinimumPerInterval';
    public const TYPE_MAXIMUM_PER_INTERVAL = 'MaximumPerInterval';
    public const TYPE_SET_VALUE_PER_INTERVAL = 'SetValuePerInterval';
    public const TYPE_CHANGE_VALUE_PER_INTERVAL = 'ChangeValuePerInterval';
    public const TYPE_CHANGE_PERCENT_PER_INTERVAL = 'ChangePercentPerInterval';
    public const TYPE_SET_VALUE_OVER_RANGE = 'SetValueOverRange';
    public const TYPE_CHANGE_VALUE_OVER_RANGE = 'ChangeValueOverRange';
    public const TYPE_SET_VALUES_FOR_INTERVAL_SET = 'SetValuesForIntervalSet';
    public const METRIC_OFFERED = 'Offered';
    public const METRIC_AVERAGE_HANDLE_TIME_SECONDS = 'AverageHandleTimeSeconds';
    public const LEGACY_METRIC_AVERAGE_AFTER_CALL_WORK_TIME_SECONDS = 'AverageAfterCallWorkTimeSeconds';
    public const LEGACY_METRIC_AVERAGE_HANDLE_TIME_SECONDS = 'AverageHandleTimeSeconds';
    public const LEGACY_METRIC_AVERAGE_TALK_TIME_SECONDS = 'AverageTalkTimeSeconds';
    public const LEGACY_METRIC_OFFERED = 'Offered';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_MINIMUM_PER_INTERVAL,
            self::TYPE_MAXIMUM_PER_INTERVAL,
            self::TYPE_SET_VALUE_PER_INTERVAL,
            self::TYPE_CHANGE_VALUE_PER_INTERVAL,
            self::TYPE_CHANGE_PERCENT_PER_INTERVAL,
            self::TYPE_SET_VALUE_OVER_RANGE,
            self::TYPE_CHANGE_VALUE_OVER_RANGE,
            self::TYPE_SET_VALUES_FOR_INTERVAL_SET,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMetricAllowableValues()
    {
        return [
            self::METRIC_OFFERED,
            self::METRIC_AVERAGE_HANDLE_TIME_SECONDS,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getLegacyMetricAllowableValues()
    {
        return [
            self::LEGACY_METRIC_AVERAGE_AFTER_CALL_WORK_TIME_SECONDS,
            self::LEGACY_METRIC_AVERAGE_HANDLE_TIME_SECONDS,
            self::LEGACY_METRIC_AVERAGE_TALK_TIME_SECONDS,
            self::LEGACY_METRIC_OFFERED,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['startIntervalIndex'] = isset($data['startIntervalIndex']) ? $data['startIntervalIndex'] : null;
        $this->container['endIntervalIndex'] = isset($data['endIntervalIndex']) ? $data['endIntervalIndex'] : null;
        $this->container['metric'] = isset($data['metric']) ? $data['metric'] : null;
        $this->container['legacyMetric'] = isset($data['legacyMetric']) ? $data['legacyMetric'] : null;
        $this->container['value'] = isset($data['value']) ? $data['value'] : null;
        $this->container['values'] = isset($data['values']) ? $data['values'] : null;
        $this->container['displayGranularity'] = isset($data['displayGranularity']) ? $data['displayGranularity'] : null;
        $this->container['granularity'] = isset($data['granularity']) ? $data['granularity'] : null;
        $this->container['enabled'] = isset($data['enabled']) ? $data['enabled'] : null;
        $this->container['planningGroupIds'] = isset($data['planningGroupIds']) ? $data['planningGroupIds'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['type'] === null) {
            $invalid_properties[] = "'type' can't be null";
        }
        $allowed_values = array("MinimumPerInterval", "MaximumPerInterval", "SetValuePerInterval", "ChangeValuePerInterval", "ChangePercentPerInterval", "SetValueOverRange", "ChangeValueOverRange", "SetValuesForIntervalSet");
        if (!in_array($this->container['type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'type', must be one of #{allowed_values}.";
        }

        if ($this->container['metric'] === null) {
            $invalid_properties[] = "'metric' can't be null";
        }
        $allowed_values = array("Offered", "AverageHandleTimeSeconds");
        if (!in_array($this->container['metric'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'metric', must be one of #{allowed_values}.";
        }

        $allowed_values = array("AverageAfterCallWorkTimeSeconds", "AverageHandleTimeSeconds", "AverageTalkTimeSeconds", "Offered");
        if (!in_array($this->container['legacyMetric'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'legacyMetric', must be one of #{allowed_values}.";
        }

        if ($this->container['displayGranularity'] === null) {
            $invalid_properties[] = "'displayGranularity' can't be null";
        }
        if ($this->container['enabled'] === null) {
            $invalid_properties[] = "'enabled' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['type'] === null) {
            return false;
        }
        $allowed_values = array("MinimumPerInterval", "MaximumPerInterval", "SetValuePerInterval", "ChangeValuePerInterval", "ChangePercentPerInterval", "SetValueOverRange", "ChangeValueOverRange", "SetValuesForIntervalSet");
        if (!in_array($this->container['type'], $allowed_values)) {
            return false;
        }
        if ($this->container['metric'] === null) {
            return false;
        }
        $allowed_values = array("Offered", "AverageHandleTimeSeconds");
        if (!in_array($this->container['metric'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("AverageAfterCallWorkTimeSeconds", "AverageHandleTimeSeconds", "AverageTalkTimeSeconds", "Offered");
        if (!in_array($this->container['legacyMetric'], $allowed_values)) {
            return false;
        }
        if ($this->container['displayGranularity'] === null) {
            return false;
        }
        if ($this->container['enabled'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     * @param string $type The type of the modification
     * @return $this
     */
    public function setType($type)
    {
        $allowed_values = array('MinimumPerInterval', 'MaximumPerInterval', 'SetValuePerInterval', 'ChangeValuePerInterval', 'ChangePercentPerInterval', 'SetValueOverRange', 'ChangeValueOverRange', 'SetValuesForIntervalSet');
        if (!in_array($type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'type', must be one of 'MinimumPerInterval', 'MaximumPerInterval', 'SetValuePerInterval', 'ChangeValuePerInterval', 'ChangePercentPerInterval', 'SetValueOverRange', 'ChangeValueOverRange', 'SetValuesForIntervalSet'");
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets startIntervalIndex
     * @return int
     */
    public function getStartIntervalIndex()
    {
        return $this->container['startIntervalIndex'];
    }

    /**
     * Sets startIntervalIndex
     * @param int $startIntervalIndex The number of 15 minute intervals past referenceStartDate representing the first interval to which to apply this modification. Must be null if values is populated
     * @return $this
     */
    public function setStartIntervalIndex($startIntervalIndex)
    {
        $this->container['startIntervalIndex'] = $startIntervalIndex;

        return $this;
    }

    /**
     * Gets endIntervalIndex
     * @return int
     */
    public function getEndIntervalIndex()
    {
        return $this->container['endIntervalIndex'];
    }

    /**
     * Sets endIntervalIndex
     * @param int $endIntervalIndex The number of 15 minute intervals past referenceStartDate representing the last interval to which to apply this modification.  Must be null if values is populated
     * @return $this
     */
    public function setEndIntervalIndex($endIntervalIndex)
    {
        $this->container['endIntervalIndex'] = $endIntervalIndex;

        return $this;
    }

    /**
     * Gets metric
     * @return string
     */
    public function getMetric()
    {
        return $this->container['metric'];
    }

    /**
     * Sets metric
     * @param string $metric The metric to which this modification applies
     * @return $this
     */
    public function setMetric($metric)
    {
        $allowed_values = array('Offered', 'AverageHandleTimeSeconds');
        if (!in_array($metric, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'metric', must be one of 'Offered', 'AverageHandleTimeSeconds'");
        }
        $this->container['metric'] = $metric;

        return $this;
    }

    /**
     * Gets legacyMetric
     * @return string
     */
    public function getLegacyMetric()
    {
        return $this->container['legacyMetric'];
    }

    /**
     * Sets legacyMetric
     * @param string $legacyMetric The legacy metric to which this modification applies if applicable
     * @return $this
     */
    public function setLegacyMetric($legacyMetric)
    {
        $allowed_values = array('AverageAfterCallWorkTimeSeconds', 'AverageHandleTimeSeconds', 'AverageTalkTimeSeconds', 'Offered');
        if (!in_array($legacyMetric, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'legacyMetric', must be one of 'AverageAfterCallWorkTimeSeconds', 'AverageHandleTimeSeconds', 'AverageTalkTimeSeconds', 'Offered'");
        }
        $this->container['legacyMetric'] = $legacyMetric;

        return $this;
    }

    /**
     * Gets value
     * @return double
     */
    public function getValue()
    {
        return $this->container['value'];
    }

    /**
     * Sets value
     * @param double $value The value of the modification.  Must be null if \"values\" is populated
     * @return $this
     */
    public function setValue($value)
    {
        $this->container['value'] = $value;

        return $this;
    }

    /**
     * Gets values
     * @return \PureCloudSDK\WfmForecastModificationIntervalOffsetValue[]
     */
    public function getValues()
    {
        return $this->container['values'];
    }

    /**
     * Sets values
     * @param \PureCloudSDK\WfmForecastModificationIntervalOffsetValue[] $values The list of values to update.  Only applicable for grid-type modifications. Must be null if \"value\" is populated
     * @return $this
     */
    public function setValues($values)
    {
        $this->container['values'] = $values;

        return $this;
    }

    /**
     * Gets displayGranularity
     * @return string
     */
    public function getDisplayGranularity()
    {
        return $this->container['displayGranularity'];
    }

    /**
     * Sets displayGranularity
     * @param string $displayGranularity The client side display granularity of the modification, expressed in the ISO-8601 duration format. Periods are represented as an ISO-8601 string. For example: P1D or P1DT12H
     * @return $this
     */
    public function setDisplayGranularity($displayGranularity)
    {
        $this->container['displayGranularity'] = $displayGranularity;

        return $this;
    }

    /**
     * Gets granularity
     * @return string
     */
    public function getGranularity()
    {
        return $this->container['granularity'];
    }

    /**
     * Sets granularity
     * @param string $granularity The actual granularity of the modification as stored behind the scenes, expressed in the ISO-8601 duration format. Periods are represented as an ISO-8601 string. For example: P1D or P1DT12H
     * @return $this
     */
    public function setGranularity($granularity)
    {
        $this->container['granularity'] = $granularity;

        return $this;
    }

    /**
     * Gets enabled
     * @return bool
     */
    public function getEnabled()
    {
        return $this->container['enabled'];
    }

    /**
     * Sets enabled
     * @param bool $enabled Whether the modification is enabled for the forecast
     * @return $this
     */
    public function setEnabled($enabled)
    {
        $this->container['enabled'] = $enabled;

        return $this;
    }

    /**
     * Gets planningGroupIds
     * @return string[]
     */
    public function getPlanningGroupIds()
    {
        return $this->container['planningGroupIds'];
    }

    /**
     * Sets planningGroupIds
     * @param string[] $planningGroupIds The IDs of the planning groups to which this forecast modification applies.  Leave empty to apply to all
     * @return $this
     */
    public function setPlanningGroupIds($planningGroupIds)
    {
        $this->container['planningGroupIds'] = $planningGroupIds;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
