<?php

/**
 * DataTableImportJob
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * DataTableImportJob Class Doc Comment
 *
 * @category    Class */
 // @description State information for an import job of rows to a datatable
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class DataTableImportJob implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'DataTableImportJob';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'owner' => '\PureCloudSDK\AddressableEntityRef',
        'status' => 'string',
        'dateCreated' => '\DateTime',
        'dateCompleted' => '\DateTime',
        'uploadURI' => 'string',
        'importMode' => 'string',
        'errorInformation' => '\PureCloudSDK\ErrorBody',
        'countRecordsUpdated' => 'int',
        'countRecordsDeleted' => 'int',
        'countRecordsFailed' => 'int',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'owner' => 'owner',
        'status' => 'status',
        'dateCreated' => 'dateCreated',
        'dateCompleted' => 'dateCompleted',
        'uploadURI' => 'uploadURI',
        'importMode' => 'importMode',
        'errorInformation' => 'errorInformation',
        'countRecordsUpdated' => 'countRecordsUpdated',
        'countRecordsDeleted' => 'countRecordsDeleted',
        'countRecordsFailed' => 'countRecordsFailed',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'owner' => 'setOwner',
        'status' => 'setStatus',
        'dateCreated' => 'setDateCreated',
        'dateCompleted' => 'setDateCompleted',
        'uploadURI' => 'setUploadURI',
        'importMode' => 'setImportMode',
        'errorInformation' => 'setErrorInformation',
        'countRecordsUpdated' => 'setCountRecordsUpdated',
        'countRecordsDeleted' => 'setCountRecordsDeleted',
        'countRecordsFailed' => 'setCountRecordsFailed',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'owner' => 'getOwner',
        'status' => 'getStatus',
        'dateCreated' => 'getDateCreated',
        'dateCompleted' => 'getDateCompleted',
        'uploadURI' => 'getUploadURI',
        'importMode' => 'getImportMode',
        'errorInformation' => 'getErrorInformation',
        'countRecordsUpdated' => 'getCountRecordsUpdated',
        'countRecordsDeleted' => 'getCountRecordsDeleted',
        'countRecordsFailed' => 'getCountRecordsFailed',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const STATUS_WAITING_FOR_UPLOAD = 'WaitingForUpload';
    public const STATUS_PROCESSING = 'Processing';
    public const STATUS_FAILED = 'Failed';
    public const STATUS_SUCCEEDED = 'Succeeded';
    public const IMPORT_MODE_REPLACE_ALL = 'ReplaceAll';
    public const IMPORT_MODE_APPEND = 'Append';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_WAITING_FOR_UPLOAD,
            self::STATUS_PROCESSING,
            self::STATUS_FAILED,
            self::STATUS_SUCCEEDED,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getImportModeAllowableValues()
    {
        return [
            self::IMPORT_MODE_REPLACE_ALL,
            self::IMPORT_MODE_APPEND,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['owner'] = isset($data['owner']) ? $data['owner'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['dateCreated'] = isset($data['dateCreated']) ? $data['dateCreated'] : null;
        $this->container['dateCompleted'] = isset($data['dateCompleted']) ? $data['dateCompleted'] : null;
        $this->container['uploadURI'] = isset($data['uploadURI']) ? $data['uploadURI'] : null;
        $this->container['importMode'] = isset($data['importMode']) ? $data['importMode'] : null;
        $this->container['errorInformation'] = isset($data['errorInformation']) ? $data['errorInformation'] : null;
        $this->container['countRecordsUpdated'] = isset($data['countRecordsUpdated']) ? $data['countRecordsUpdated'] : null;
        $this->container['countRecordsDeleted'] = isset($data['countRecordsDeleted']) ? $data['countRecordsDeleted'] : null;
        $this->container['countRecordsFailed'] = isset($data['countRecordsFailed']) ? $data['countRecordsFailed'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['status'] === null) {
            $invalid_properties[] = "'status' can't be null";
        }
        $allowed_values = array("WaitingForUpload", "Processing", "Failed", "Succeeded");
        if (!in_array($this->container['status'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'status', must be one of #{allowed_values}.";
        }

        $allowed_values = array("ReplaceAll", "Append");
        if (!in_array($this->container['importMode'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'importMode', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['status'] === null) {
            return false;
        }
        $allowed_values = array("WaitingForUpload", "Processing", "Failed", "Succeeded");
        if (!in_array($this->container['status'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("ReplaceAll", "Append");
        if (!in_array($this->container['importMode'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets owner
     * @return \PureCloudSDK\AddressableEntityRef
     */
    public function getOwner()
    {
        return $this->container['owner'];
    }

    /**
     * Sets owner
     * @param \PureCloudSDK\AddressableEntityRef $owner The PureCloud user who started the import job
     * @return $this
     */
    public function setOwner($owner)
    {
        $this->container['owner'] = $owner;

        return $this;
    }

    /**
     * Gets status
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     * @param string $status The status of the import job
     * @return $this
     */
    public function setStatus($status)
    {
        $allowed_values = array('WaitingForUpload', 'Processing', 'Failed', 'Succeeded');
        if (!in_array($status, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'status', must be one of 'WaitingForUpload', 'Processing', 'Failed', 'Succeeded'");
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets dateCreated
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->container['dateCreated'];
    }

    /**
     * Sets dateCreated
     * @param \DateTime $dateCreated The timestamp of when the import began. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCreated($dateCreated)
    {
        $this->container['dateCreated'] = $dateCreated;

        return $this;
    }

    /**
     * Gets dateCompleted
     * @return \DateTime
     */
    public function getDateCompleted()
    {
        return $this->container['dateCompleted'];
    }

    /**
     * Sets dateCompleted
     * @param \DateTime $dateCompleted The timestamp of when the import stopped (either successfully or unsuccessfully). Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCompleted($dateCompleted)
    {
        $this->container['dateCompleted'] = $dateCompleted;

        return $this;
    }

    /**
     * Gets uploadURI
     * @return string
     */
    public function getUploadURI()
    {
        return $this->container['uploadURI'];
    }

    /**
     * Sets uploadURI
     * @param string $uploadURI The URL of the location at which the caller can upload the file to be imported
     * @return $this
     */
    public function setUploadURI($uploadURI)
    {
        $this->container['uploadURI'] = $uploadURI;

        return $this;
    }

    /**
     * Gets importMode
     * @return string
     */
    public function getImportMode()
    {
        return $this->container['importMode'];
    }

    /**
     * Sets importMode
     * @param string $importMode The indication of whether the processing should remove rows that don't appear in the import file
     * @return $this
     */
    public function setImportMode($importMode)
    {
        $allowed_values = array('ReplaceAll', 'Append');
        if (!in_array($importMode, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'importMode', must be one of 'ReplaceAll', 'Append'");
        }
        $this->container['importMode'] = $importMode;

        return $this;
    }

    /**
     * Gets errorInformation
     * @return \PureCloudSDK\ErrorBody
     */
    public function getErrorInformation()
    {
        return $this->container['errorInformation'];
    }

    /**
     * Sets errorInformation
     * @param \PureCloudSDK\ErrorBody $errorInformation Any error information, or null of the processing is not in an error state
     * @return $this
     */
    public function setErrorInformation($errorInformation)
    {
        $this->container['errorInformation'] = $errorInformation;

        return $this;
    }

    /**
     * Gets countRecordsUpdated
     * @return int
     */
    public function getCountRecordsUpdated()
    {
        return $this->container['countRecordsUpdated'];
    }

    /**
     * Sets countRecordsUpdated
     * @param int $countRecordsUpdated The current count of the number of records processed
     * @return $this
     */
    public function setCountRecordsUpdated($countRecordsUpdated)
    {
        $this->container['countRecordsUpdated'] = $countRecordsUpdated;

        return $this;
    }

    /**
     * Gets countRecordsDeleted
     * @return int
     */
    public function getCountRecordsDeleted()
    {
        return $this->container['countRecordsDeleted'];
    }

    /**
     * Sets countRecordsDeleted
     * @param int $countRecordsDeleted The current count of the number of records deleted
     * @return $this
     */
    public function setCountRecordsDeleted($countRecordsDeleted)
    {
        $this->container['countRecordsDeleted'] = $countRecordsDeleted;

        return $this;
    }

    /**
     * Gets countRecordsFailed
     * @return int
     */
    public function getCountRecordsFailed()
    {
        return $this->container['countRecordsFailed'];
    }

    /**
     * Sets countRecordsFailed
     * @param int $countRecordsFailed The current count of the number of records that failed to import
     * @return $this
     */
    public function setCountRecordsFailed($countRecordsFailed)
    {
        $this->container['countRecordsFailed'] = $countRecordsFailed;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
