<?php

/**
 * PostTextRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * PostTextRequest Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class PostTextRequest implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'PostTextRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'botId' => 'string',
        'botAlias' => 'string',
        'integrationId' => 'string',
        'botSessionId' => 'string',
        'postTextMessage' => '\PureCloudSDK\PostTextMessage',
        'languageCode' => 'string',
        'botSessionTimeoutMinutes' => 'int',
        'botChannels' => 'string[]',
        'botCorrelationId' => 'string',
        'amazonLexRequest' => '\PureCloudSDK\AmazonLexRequest',
        'googleDialogflow' => '\PureCloudSDK\GoogleDialogflowCustomSettings'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'botId' => 'botId',
        'botAlias' => 'botAlias',
        'integrationId' => 'integrationId',
        'botSessionId' => 'botSessionId',
        'postTextMessage' => 'postTextMessage',
        'languageCode' => 'languageCode',
        'botSessionTimeoutMinutes' => 'botSessionTimeoutMinutes',
        'botChannels' => 'botChannels',
        'botCorrelationId' => 'botCorrelationId',
        'amazonLexRequest' => 'amazonLexRequest',
        'googleDialogflow' => 'googleDialogflow'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'botId' => 'setBotId',
        'botAlias' => 'setBotAlias',
        'integrationId' => 'setIntegrationId',
        'botSessionId' => 'setBotSessionId',
        'postTextMessage' => 'setPostTextMessage',
        'languageCode' => 'setLanguageCode',
        'botSessionTimeoutMinutes' => 'setBotSessionTimeoutMinutes',
        'botChannels' => 'setBotChannels',
        'botCorrelationId' => 'setBotCorrelationId',
        'amazonLexRequest' => 'setAmazonLexRequest',
        'googleDialogflow' => 'setGoogleDialogflow'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'botId' => 'getBotId',
        'botAlias' => 'getBotAlias',
        'integrationId' => 'getIntegrationId',
        'botSessionId' => 'getBotSessionId',
        'postTextMessage' => 'getPostTextMessage',
        'languageCode' => 'getLanguageCode',
        'botSessionTimeoutMinutes' => 'getBotSessionTimeoutMinutes',
        'botChannels' => 'getBotChannels',
        'botCorrelationId' => 'getBotCorrelationId',
        'amazonLexRequest' => 'getAmazonLexRequest',
        'googleDialogflow' => 'getGoogleDialogflow'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const BOT_CHANNELS_CALL = 'Call';
    public const BOT_CHANNELS_CALLBACK = 'Callback';
    public const BOT_CHANNELS_MESSAGING = 'Messaging';
    public const BOT_CHANNELS_WEBCHAT = 'Webchat';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getBotChannelsAllowableValues()
    {
        return [
            self::BOT_CHANNELS_CALL,
            self::BOT_CHANNELS_CALLBACK,
            self::BOT_CHANNELS_MESSAGING,
            self::BOT_CHANNELS_WEBCHAT,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['botId'] = isset($data['botId']) ? $data['botId'] : null;
        $this->container['botAlias'] = isset($data['botAlias']) ? $data['botAlias'] : null;
        $this->container['integrationId'] = isset($data['integrationId']) ? $data['integrationId'] : null;
        $this->container['botSessionId'] = isset($data['botSessionId']) ? $data['botSessionId'] : null;
        $this->container['postTextMessage'] = isset($data['postTextMessage']) ? $data['postTextMessage'] : null;
        $this->container['languageCode'] = isset($data['languageCode']) ? $data['languageCode'] : null;
        $this->container['botSessionTimeoutMinutes'] = isset($data['botSessionTimeoutMinutes']) ? $data['botSessionTimeoutMinutes'] : null;
        $this->container['botChannels'] = isset($data['botChannels']) ? $data['botChannels'] : null;
        $this->container['botCorrelationId'] = isset($data['botCorrelationId']) ? $data['botCorrelationId'] : null;
        $this->container['amazonLexRequest'] = isset($data['amazonLexRequest']) ? $data['amazonLexRequest'] : null;
        $this->container['googleDialogflow'] = isset($data['googleDialogflow']) ? $data['googleDialogflow'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['botId'] === null) {
            $invalid_properties[] = "'botId' can't be null";
        }
        if ($this->container['integrationId'] === null) {
            $invalid_properties[] = "'integrationId' can't be null";
        }
        if ($this->container['botSessionId'] === null) {
            $invalid_properties[] = "'botSessionId' can't be null";
        }
        if ($this->container['postTextMessage'] === null) {
            $invalid_properties[] = "'postTextMessage' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['botId'] === null) {
            return false;
        }
        if ($this->container['integrationId'] === null) {
            return false;
        }
        if ($this->container['botSessionId'] === null) {
            return false;
        }
        if ($this->container['postTextMessage'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets botId
     * @return string
     */
    public function getBotId()
    {
        return $this->container['botId'];
    }

    /**
     * Sets botId
     * @param string $botId ID of the bot to send the text to.
     * @return $this
     */
    public function setBotId($botId)
    {
        $this->container['botId'] = $botId;

        return $this;
    }

    /**
     * Gets botAlias
     * @return string
     */
    public function getBotAlias()
    {
        return $this->container['botAlias'];
    }

    /**
     * Sets botAlias
     * @param string $botAlias Alias/Version of the bot
     * @return $this
     */
    public function setBotAlias($botAlias)
    {
        $this->container['botAlias'] = $botAlias;

        return $this;
    }

    /**
     * Gets integrationId
     * @return string
     */
    public function getIntegrationId()
    {
        return $this->container['integrationId'];
    }

    /**
     * Sets integrationId
     * @param string $integrationId the integration service id for the bot's credentials
     * @return $this
     */
    public function setIntegrationId($integrationId)
    {
        $this->container['integrationId'] = $integrationId;

        return $this;
    }

    /**
     * Gets botSessionId
     * @return string
     */
    public function getBotSessionId()
    {
        return $this->container['botSessionId'];
    }

    /**
     * Sets botSessionId
     * @param string $botSessionId GUID for this bot's session
     * @return $this
     */
    public function setBotSessionId($botSessionId)
    {
        $this->container['botSessionId'] = $botSessionId;

        return $this;
    }

    /**
     * Gets postTextMessage
     * @return \PureCloudSDK\PostTextMessage
     */
    public function getPostTextMessage()
    {
        return $this->container['postTextMessage'];
    }

    /**
     * Sets postTextMessage
     * @param \PureCloudSDK\PostTextMessage $postTextMessage Message to send to the bot
     * @return $this
     */
    public function setPostTextMessage($postTextMessage)
    {
        $this->container['postTextMessage'] = $postTextMessage;

        return $this;
    }

    /**
     * Gets languageCode
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->container['languageCode'];
    }

    /**
     * Sets languageCode
     * @param string $languageCode The launguage code the bot will run under
     * @return $this
     */
    public function setLanguageCode($languageCode)
    {
        $this->container['languageCode'] = $languageCode;

        return $this;
    }

    /**
     * Gets botSessionTimeoutMinutes
     * @return int
     */
    public function getBotSessionTimeoutMinutes()
    {
        return $this->container['botSessionTimeoutMinutes'];
    }

    /**
     * Sets botSessionTimeoutMinutes
     * @param int $botSessionTimeoutMinutes Override timeout for the bot session. This should be greater than 10 minutes.
     * @return $this
     */
    public function setBotSessionTimeoutMinutes($botSessionTimeoutMinutes)
    {
        $this->container['botSessionTimeoutMinutes'] = $botSessionTimeoutMinutes;

        return $this;
    }

    /**
     * Gets botChannels
     * @return string[]
     */
    public function getBotChannels()
    {
        return $this->container['botChannels'];
    }

    /**
     * Sets botChannels
     * @param string[] $botChannels The channels this bot is utilizing
     * @return $this
     */
    public function setBotChannels($botChannels)
    {
        $allowed_values = array('Call', 'Callback', 'Messaging', 'Webchat');
        if (!in_array($botChannels, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'botChannels', must be one of 'Call', 'Callback', 'Messaging', 'Webchat'");
        }
        $this->container['botChannels'] = $botChannels;

        return $this;
    }

    /**
     * Gets botCorrelationId
     * @return string
     */
    public function getBotCorrelationId()
    {
        return $this->container['botCorrelationId'];
    }

    /**
     * Sets botCorrelationId
     * @param string $botCorrelationId Id for tracking the activity - this will be returned in the response
     * @return $this
     */
    public function setBotCorrelationId($botCorrelationId)
    {
        $this->container['botCorrelationId'] = $botCorrelationId;

        return $this;
    }

    /**
     * Gets amazonLexRequest
     * @return \PureCloudSDK\AmazonLexRequest
     */
    public function getAmazonLexRequest()
    {
        return $this->container['amazonLexRequest'];
    }

    /**
     * Sets amazonLexRequest
     * @param \PureCloudSDK\AmazonLexRequest $amazonLexRequest
     * @return $this
     */
    public function setAmazonLexRequest($amazonLexRequest)
    {
        $this->container['amazonLexRequest'] = $amazonLexRequest;

        return $this;
    }

    /**
     * Gets googleDialogflow
     * @return \PureCloudSDK\GoogleDialogflowCustomSettings
     */
    public function getGoogleDialogflow()
    {
        return $this->container['googleDialogflow'];
    }

    /**
     * Sets googleDialogflow
     * @param \PureCloudSDK\GoogleDialogflowCustomSettings $googleDialogflow
     * @return $this
     */
    public function setGoogleDialogflow($googleDialogflow)
    {
        $this->container['googleDialogflow'] = $googleDialogflow;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
