<?php

/**
 * PostTextResponse
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * PostTextResponse Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class PostTextResponse implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'PostTextResponse';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'botState' => 'string',
        'replyMessages' => '\PureCloudSDK\PostTextMessage[]',
        'intentName' => 'string',
        'slots' => 'map[string,string]',
        'botCorrelationId' => 'string',
        'amazonLex' => 'map[string,object]',
        'googleDialogFlow' => 'map[string,object]',
        'genesysDialogEngine' => 'map[string,object]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'botState' => 'botState',
        'replyMessages' => 'replyMessages',
        'intentName' => 'intentName',
        'slots' => 'slots',
        'botCorrelationId' => 'botCorrelationId',
        'amazonLex' => 'amazonLex',
        'googleDialogFlow' => 'googleDialogFlow',
        'genesysDialogEngine' => 'genesysDialogEngine'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'botState' => 'setBotState',
        'replyMessages' => 'setReplyMessages',
        'intentName' => 'setIntentName',
        'slots' => 'setSlots',
        'botCorrelationId' => 'setBotCorrelationId',
        'amazonLex' => 'setAmazonLex',
        'googleDialogFlow' => 'setGoogleDialogFlow',
        'genesysDialogEngine' => 'setGenesysDialogEngine'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'botState' => 'getBotState',
        'replyMessages' => 'getReplyMessages',
        'intentName' => 'getIntentName',
        'slots' => 'getSlots',
        'botCorrelationId' => 'getBotCorrelationId',
        'amazonLex' => 'getAmazonLex',
        'googleDialogFlow' => 'getGoogleDialogFlow',
        'genesysDialogEngine' => 'getGenesysDialogEngine'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const BOT_STATE_COMPLETE = 'Complete';
    public const BOT_STATE_FAILED = 'Failed';
    public const BOT_STATE_MORE_DATA = 'MoreData';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getBotStateAllowableValues()
    {
        return [
            self::BOT_STATE_COMPLETE,
            self::BOT_STATE_FAILED,
            self::BOT_STATE_MORE_DATA,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['botState'] = isset($data['botState']) ? $data['botState'] : null;
        $this->container['replyMessages'] = isset($data['replyMessages']) ? $data['replyMessages'] : null;
        $this->container['intentName'] = isset($data['intentName']) ? $data['intentName'] : null;
        $this->container['slots'] = isset($data['slots']) ? $data['slots'] : null;
        $this->container['botCorrelationId'] = isset($data['botCorrelationId']) ? $data['botCorrelationId'] : null;
        $this->container['amazonLex'] = isset($data['amazonLex']) ? $data['amazonLex'] : null;
        $this->container['googleDialogFlow'] = isset($data['googleDialogFlow']) ? $data['googleDialogFlow'] : null;
        $this->container['genesysDialogEngine'] = isset($data['genesysDialogEngine']) ? $data['genesysDialogEngine'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['botState'] === null) {
            $invalid_properties[] = "'botState' can't be null";
        }
        $allowed_values = array("Complete", "Failed", "MoreData");
        if (!in_array($this->container['botState'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'botState', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['botState'] === null) {
            return false;
        }
        $allowed_values = array("Complete", "Failed", "MoreData");
        if (!in_array($this->container['botState'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets botState
     * @return string
     */
    public function getBotState()
    {
        return $this->container['botState'];
    }

    /**
     * Sets botState
     * @param string $botState The state of the bot after completion of the request
     * @return $this
     */
    public function setBotState($botState)
    {
        $allowed_values = array('Complete', 'Failed', 'MoreData');
        if (!in_array($botState, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'botState', must be one of 'Complete', 'Failed', 'MoreData'");
        }
        $this->container['botState'] = $botState;

        return $this;
    }

    /**
     * Gets replyMessages
     * @return \PureCloudSDK\PostTextMessage[]
     */
    public function getReplyMessages()
    {
        return $this->container['replyMessages'];
    }

    /**
     * Sets replyMessages
     * @param \PureCloudSDK\PostTextMessage[] $replyMessages The list of messages to respond with, if any
     * @return $this
     */
    public function setReplyMessages($replyMessages)
    {
        $this->container['replyMessages'] = $replyMessages;

        return $this;
    }

    /**
     * Gets intentName
     * @return string
     */
    public function getIntentName()
    {
        return $this->container['intentName'];
    }

    /**
     * Sets intentName
     * @param string $intentName The name of the intent the bot is either processing or has processed, this will be blank if no intent could be detected.
     * @return $this
     */
    public function setIntentName($intentName)
    {
        $this->container['intentName'] = $intentName;

        return $this;
    }

    /**
     * Gets slots
     * @return map[string,string]
     */
    public function getSlots()
    {
        return $this->container['slots'];
    }

    /**
     * Sets slots
     * @param map[string,string] $slots Data parameters detected and filled by the bot.
     * @return $this
     */
    public function setSlots($slots)
    {
        $this->container['slots'] = $slots;

        return $this;
    }

    /**
     * Gets botCorrelationId
     * @return string
     */
    public function getBotCorrelationId()
    {
        return $this->container['botCorrelationId'];
    }

    /**
     * Sets botCorrelationId
     * @param string $botCorrelationId The optional ID specified in the request
     * @return $this
     */
    public function setBotCorrelationId($botCorrelationId)
    {
        $this->container['botCorrelationId'] = $botCorrelationId;

        return $this;
    }

    /**
     * Gets amazonLex
     * @return map[string,object]
     */
    public function getAmazonLex()
    {
        return $this->container['amazonLex'];
    }

    /**
     * Sets amazonLex
     * @param map[string,object] $amazonLex Raw data response from AWS (if called)
     * @return $this
     */
    public function setAmazonLex($amazonLex)
    {
        $this->container['amazonLex'] = $amazonLex;

        return $this;
    }

    /**
     * Gets googleDialogFlow
     * @return map[string,object]
     */
    public function getGoogleDialogFlow()
    {
        return $this->container['googleDialogFlow'];
    }

    /**
     * Sets googleDialogFlow
     * @param map[string,object] $googleDialogFlow Raw data response from Google Dialogflow (if called)
     * @return $this
     */
    public function setGoogleDialogFlow($googleDialogFlow)
    {
        $this->container['googleDialogFlow'] = $googleDialogFlow;

        return $this;
    }

    /**
     * Gets genesysDialogEngine
     * @return map[string,object]
     */
    public function getGenesysDialogEngine()
    {
        return $this->container['genesysDialogEngine'];
    }

    /**
     * Sets genesysDialogEngine
     * @param map[string,object] $genesysDialogEngine Raw data response from Genesys' Dialogengine (if called)
     * @return $this
     */
    public function setGenesysDialogEngine($genesysDialogEngine)
    {
        $this->container['genesysDialogEngine'] = $genesysDialogEngine;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
