<?php

/**
 * RecordingJob
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * RecordingJob Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class RecordingJob implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'RecordingJob';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'state' => 'string',
        'recordingJobsQuery' => '\PureCloudSDK\RecordingJobsQuery',
        'dateCreated' => '\DateTime',
        'totalConversations' => 'int',
        'totalRecordings' => 'int',
        'totalProcessedRecordings' => 'int',
        'percentProgress' => 'int',
        'errorMessage' => 'string',
        'selfUri' => 'string',
        'user' => '\PureCloudSDK\AddressableEntityRef'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'state' => 'state',
        'recordingJobsQuery' => 'recordingJobsQuery',
        'dateCreated' => 'dateCreated',
        'totalConversations' => 'totalConversations',
        'totalRecordings' => 'totalRecordings',
        'totalProcessedRecordings' => 'totalProcessedRecordings',
        'percentProgress' => 'percentProgress',
        'errorMessage' => 'errorMessage',
        'selfUri' => 'selfUri',
        'user' => 'user'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'state' => 'setState',
        'recordingJobsQuery' => 'setRecordingJobsQuery',
        'dateCreated' => 'setDateCreated',
        'totalConversations' => 'setTotalConversations',
        'totalRecordings' => 'setTotalRecordings',
        'totalProcessedRecordings' => 'setTotalProcessedRecordings',
        'percentProgress' => 'setPercentProgress',
        'errorMessage' => 'setErrorMessage',
        'selfUri' => 'setSelfUri',
        'user' => 'setUser'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'state' => 'getState',
        'recordingJobsQuery' => 'getRecordingJobsQuery',
        'dateCreated' => 'getDateCreated',
        'totalConversations' => 'getTotalConversations',
        'totalRecordings' => 'getTotalRecordings',
        'totalProcessedRecordings' => 'getTotalProcessedRecordings',
        'percentProgress' => 'getPercentProgress',
        'errorMessage' => 'getErrorMessage',
        'selfUri' => 'getSelfUri',
        'user' => 'getUser'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const STATE_FULFILLED = 'FULFILLED';
    public const STATE_PENDING = 'PENDING';
    public const STATE_READY = 'READY';
    public const STATE_PROCESSING = 'PROCESSING';
    public const STATE_CANCELLED = 'CANCELLED';
    public const STATE_FAILED = 'FAILED';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_FULFILLED,
            self::STATE_PENDING,
            self::STATE_READY,
            self::STATE_PROCESSING,
            self::STATE_CANCELLED,
            self::STATE_FAILED,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['recordingJobsQuery'] = isset($data['recordingJobsQuery']) ? $data['recordingJobsQuery'] : null;
        $this->container['dateCreated'] = isset($data['dateCreated']) ? $data['dateCreated'] : null;
        $this->container['totalConversations'] = isset($data['totalConversations']) ? $data['totalConversations'] : null;
        $this->container['totalRecordings'] = isset($data['totalRecordings']) ? $data['totalRecordings'] : null;
        $this->container['totalProcessedRecordings'] = isset($data['totalProcessedRecordings']) ? $data['totalProcessedRecordings'] : null;
        $this->container['percentProgress'] = isset($data['percentProgress']) ? $data['percentProgress'] : null;
        $this->container['errorMessage'] = isset($data['errorMessage']) ? $data['errorMessage'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
        $this->container['user'] = isset($data['user']) ? $data['user'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['state'] === null) {
            $invalid_properties[] = "'state' can't be null";
        }
        $allowed_values = array("FULFILLED", "PENDING", "READY", "PROCESSING", "CANCELLED", "FAILED");
        if (!in_array($this->container['state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'state', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['state'] === null) {
            return false;
        }
        $allowed_values = array("FULFILLED", "PENDING", "READY", "PROCESSING", "CANCELLED", "FAILED");
        if (!in_array($this->container['state'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state The current state of the job.
     * @return $this
     */
    public function setState($state)
    {
        $allowed_values = array('FULFILLED', 'PENDING', 'READY', 'PROCESSING', 'CANCELLED', 'FAILED');
        if (!in_array($state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'state', must be one of 'FULFILLED', 'PENDING', 'READY', 'PROCESSING', 'CANCELLED', 'FAILED'");
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets recordingJobsQuery
     * @return \PureCloudSDK\RecordingJobsQuery
     */
    public function getRecordingJobsQuery()
    {
        return $this->container['recordingJobsQuery'];
    }

    /**
     * Sets recordingJobsQuery
     * @param \PureCloudSDK\RecordingJobsQuery $recordingJobsQuery Original query of the job.
     * @return $this
     */
    public function setRecordingJobsQuery($recordingJobsQuery)
    {
        $this->container['recordingJobsQuery'] = $recordingJobsQuery;

        return $this;
    }

    /**
     * Gets dateCreated
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->container['dateCreated'];
    }

    /**
     * Sets dateCreated
     * @param \DateTime $dateCreated Date when the job was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCreated($dateCreated)
    {
        $this->container['dateCreated'] = $dateCreated;

        return $this;
    }

    /**
     * Gets totalConversations
     * @return int
     */
    public function getTotalConversations()
    {
        return $this->container['totalConversations'];
    }

    /**
     * Sets totalConversations
     * @param int $totalConversations Total number of conversations affected.
     * @return $this
     */
    public function setTotalConversations($totalConversations)
    {
        $this->container['totalConversations'] = $totalConversations;

        return $this;
    }

    /**
     * Gets totalRecordings
     * @return int
     */
    public function getTotalRecordings()
    {
        return $this->container['totalRecordings'];
    }

    /**
     * Sets totalRecordings
     * @param int $totalRecordings Total number of recordings affected.
     * @return $this
     */
    public function setTotalRecordings($totalRecordings)
    {
        $this->container['totalRecordings'] = $totalRecordings;

        return $this;
    }

    /**
     * Gets totalProcessedRecordings
     * @return int
     */
    public function getTotalProcessedRecordings()
    {
        return $this->container['totalProcessedRecordings'];
    }

    /**
     * Sets totalProcessedRecordings
     * @param int $totalProcessedRecordings Total number of recordings have been processed.
     * @return $this
     */
    public function setTotalProcessedRecordings($totalProcessedRecordings)
    {
        $this->container['totalProcessedRecordings'] = $totalProcessedRecordings;

        return $this;
    }

    /**
     * Gets percentProgress
     * @return int
     */
    public function getPercentProgress()
    {
        return $this->container['percentProgress'];
    }

    /**
     * Sets percentProgress
     * @param int $percentProgress Progress in percentage based on the number of recordings
     * @return $this
     */
    public function setPercentProgress($percentProgress)
    {
        $this->container['percentProgress'] = $percentProgress;

        return $this;
    }

    /**
     * Gets errorMessage
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->container['errorMessage'];
    }

    /**
     * Sets errorMessage
     * @param string $errorMessage Error occurred during the job execution
     * @return $this
     */
    public function setErrorMessage($errorMessage)
    {
        $this->container['errorMessage'] = $errorMessage;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }

    /**
     * Gets user
     * @return \PureCloudSDK\AddressableEntityRef
     */
    public function getUser()
    {
        return $this->container['user'];
    }

    /**
     * Sets user
     * @param \PureCloudSDK\AddressableEntityRef $user Details of the user created the job
     * @return $this
     */
    public function setUser($user)
    {
        $this->container['user'] = $user;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
