<?php

/**
 * ReportingExportJobRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * ReportingExportJobRequest Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ReportingExportJobRequest implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ReportingExportJobRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'name' => 'string',
        'timeZone' => 'string',
        'exportFormat' => 'string',
        'interval' => 'string',
        'period' => 'string',
        'viewType' => 'string',
        'filter' => '\PureCloudSDK\ViewFilter',
        'read' => 'bool',
        'locale' => 'string',
        'hasFormatDurations' => 'bool',
        'hasSplitFilters' => 'bool',
        'excludeEmptyRows' => 'bool',
        'hasSplitByMedia' => 'bool',
        'selectedColumns' => '\PureCloudSDK\SelectedColumns[]',
        'hasCustomParticipantAttributes' => 'bool',
        'recipientEmails' => 'string[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'name' => 'name',
        'timeZone' => 'timeZone',
        'exportFormat' => 'exportFormat',
        'interval' => 'interval',
        'period' => 'period',
        'viewType' => 'viewType',
        'filter' => 'filter',
        'read' => 'read',
        'locale' => 'locale',
        'hasFormatDurations' => 'hasFormatDurations',
        'hasSplitFilters' => 'hasSplitFilters',
        'excludeEmptyRows' => 'excludeEmptyRows',
        'hasSplitByMedia' => 'hasSplitByMedia',
        'selectedColumns' => 'selectedColumns',
        'hasCustomParticipantAttributes' => 'hasCustomParticipantAttributes',
        'recipientEmails' => 'recipientEmails'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'name' => 'setName',
        'timeZone' => 'setTimeZone',
        'exportFormat' => 'setExportFormat',
        'interval' => 'setInterval',
        'period' => 'setPeriod',
        'viewType' => 'setViewType',
        'filter' => 'setFilter',
        'read' => 'setRead',
        'locale' => 'setLocale',
        'hasFormatDurations' => 'setHasFormatDurations',
        'hasSplitFilters' => 'setHasSplitFilters',
        'excludeEmptyRows' => 'setExcludeEmptyRows',
        'hasSplitByMedia' => 'setHasSplitByMedia',
        'selectedColumns' => 'setSelectedColumns',
        'hasCustomParticipantAttributes' => 'setHasCustomParticipantAttributes',
        'recipientEmails' => 'setRecipientEmails'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'name' => 'getName',
        'timeZone' => 'getTimeZone',
        'exportFormat' => 'getExportFormat',
        'interval' => 'getInterval',
        'period' => 'getPeriod',
        'viewType' => 'getViewType',
        'filter' => 'getFilter',
        'read' => 'getRead',
        'locale' => 'getLocale',
        'hasFormatDurations' => 'getHasFormatDurations',
        'hasSplitFilters' => 'getHasSplitFilters',
        'excludeEmptyRows' => 'getExcludeEmptyRows',
        'hasSplitByMedia' => 'getHasSplitByMedia',
        'selectedColumns' => 'getSelectedColumns',
        'hasCustomParticipantAttributes' => 'getHasCustomParticipantAttributes',
        'recipientEmails' => 'getRecipientEmails'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const EXPORT_FORMAT_CSV = 'CSV';
    public const EXPORT_FORMAT_PDF = 'PDF';
    public const VIEW_TYPE_QUEUE_PERFORMANCE_SUMMARY_VIEW = 'QUEUE_PERFORMANCE_SUMMARY_VIEW';
    public const VIEW_TYPE_QUEUE_PERFORMANCE_DETAIL_VIEW = 'QUEUE_PERFORMANCE_DETAIL_VIEW';
    public const VIEW_TYPE_INTERACTION_SEARCH_VIEW = 'INTERACTION_SEARCH_VIEW';
    public const VIEW_TYPE_AGENT_PERFORMANCE_SUMMARY_VIEW = 'AGENT_PERFORMANCE_SUMMARY_VIEW';
    public const VIEW_TYPE_AGENT_PERFORMANCE_DETAIL_VIEW = 'AGENT_PERFORMANCE_DETAIL_VIEW';
    public const VIEW_TYPE_AGENT_STATUS_SUMMARY_VIEW = 'AGENT_STATUS_SUMMARY_VIEW';
    public const VIEW_TYPE_AGENT_STATUS_DETAIL_VIEW = 'AGENT_STATUS_DETAIL_VIEW';
    public const VIEW_TYPE_AGENT_EVALUATION_SUMMARY_VIEW = 'AGENT_EVALUATION_SUMMARY_VIEW';
    public const VIEW_TYPE_AGENT_EVALUATION_DETAIL_VIEW = 'AGENT_EVALUATION_DETAIL_VIEW';
    public const VIEW_TYPE_AGENT_QUEUE_DETAIL_VIEW = 'AGENT_QUEUE_DETAIL_VIEW';
    public const VIEW_TYPE_AGENT_INTERACTION_DETAIL_VIEW = 'AGENT_INTERACTION_DETAIL_VIEW';
    public const VIEW_TYPE_ABANDON_INSIGHTS_VIEW = 'ABANDON_INSIGHTS_VIEW';
    public const VIEW_TYPE_SKILLS_PERFORMANCE_VIEW = 'SKILLS_PERFORMANCE_VIEW';
    public const VIEW_TYPE_SURVEY_FORM_PERFORMANCE_SUMMARY_VIEW = 'SURVEY_FORM_PERFORMANCE_SUMMARY_VIEW';
    public const VIEW_TYPE_SURVEY_FORM_PERFORMANCE_DETAIL_VIEW = 'SURVEY_FORM_PERFORMANCE_DETAIL_VIEW';
    public const VIEW_TYPE_DNIS_PERFORMANCE_SUMMARY_VIEW = 'DNIS_PERFORMANCE_SUMMARY_VIEW';
    public const VIEW_TYPE_DNIS_PERFORMANCE_DETAIL_VIEW = 'DNIS_PERFORMANCE_DETAIL_VIEW';
    public const VIEW_TYPE_WRAP_UP_PERFORMANCE_SUMMARY_VIEW = 'WRAP_UP_PERFORMANCE_SUMMARY_VIEW';
    public const VIEW_TYPE_AGENT_WRAP_UP_PERFORMANCE_DETAIL_VIEW = 'AGENT_WRAP_UP_PERFORMANCE_DETAIL_VIEW';
    public const VIEW_TYPE_QUEUE_ACTIVITY_SUMMARY_VIEW = 'QUEUE_ACTIVITY_SUMMARY_VIEW';
    public const VIEW_TYPE_QUEUE_ACTIVITY_DETAIL_VIEW = 'QUEUE_ACTIVITY_DETAIL_VIEW';
    public const VIEW_TYPE_AGENT_QUEUE_ACTIVITY_SUMMARY_VIEW = 'AGENT_QUEUE_ACTIVITY_SUMMARY_VIEW';
    public const VIEW_TYPE_QUEUE_AGENT_DETAIL_VIEW = 'QUEUE_AGENT_DETAIL_VIEW';
    public const VIEW_TYPE_QUEUE_INTERACTION_DETAIL_VIEW = 'QUEUE_INTERACTION_DETAIL_VIEW';
    public const VIEW_TYPE_AGENT_SCHEDULE_DETAIL_VIEW = 'AGENT_SCHEDULE_DETAIL_VIEW';
    public const VIEW_TYPE_IVR_PERFORMANCE_SUMMARY_VIEW = 'IVR_PERFORMANCE_SUMMARY_VIEW';
    public const VIEW_TYPE_IVR_PERFORMANCE_DETAIL_VIEW = 'IVR_PERFORMANCE_DETAIL_VIEW';
    public const VIEW_TYPE_ANSWER_INSIGHTS_VIEW = 'ANSWER_INSIGHTS_VIEW';
    public const VIEW_TYPE_HANDLE_INSIGHTS_VIEW = 'HANDLE_INSIGHTS_VIEW';
    public const VIEW_TYPE_TALK_INSIGHTS_VIEW = 'TALK_INSIGHTS_VIEW';
    public const VIEW_TYPE_HOLD_INSIGHTS_VIEW = 'HOLD_INSIGHTS_VIEW';
    public const VIEW_TYPE_ACW_INSIGHTS_VIEW = 'ACW_INSIGHTS_VIEW';
    public const VIEW_TYPE_WAIT_INSIGHTS_VIEW = 'WAIT_INSIGHTS_VIEW';
    public const VIEW_TYPE_AGENT_WRAP_UP_PERFORMANCE_INTERVAL_DETAIL_VIEW = 'AGENT_WRAP_UP_PERFORMANCE_INTERVAL_DETAIL_VIEW';
    public const VIEW_TYPE_FLOW_OUTCOME_SUMMARY_VIEW = 'FLOW_OUTCOME_SUMMARY_VIEW';
    public const VIEW_TYPE_FLOW_OUTCOME_PERFORMANCE_DETAIL_VIEW = 'FLOW_OUTCOME_PERFORMANCE_DETAIL_VIEW';
    public const VIEW_TYPE_FLOW_OUTCOME_PERFORMANCE_INTERVAL_DETAIL_VIEW = 'FLOW_OUTCOME_PERFORMANCE_INTERVAL_DETAIL_VIEW';
    public const VIEW_TYPE_FLOW_DESTINATION_SUMMARY_VIEW = 'FLOW_DESTINATION_SUMMARY_VIEW';
    public const VIEW_TYPE_FLOW_DESTINATION_DETAIL_VIEW = 'FLOW_DESTINATION_DETAIL_VIEW';
    public const VIEW_TYPE_API_USAGE_VIEW = 'API_USAGE_VIEW';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getExportFormatAllowableValues()
    {
        return [
            self::EXPORT_FORMAT_CSV,
            self::EXPORT_FORMAT_PDF,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getViewTypeAllowableValues()
    {
        return [
            self::VIEW_TYPE_QUEUE_PERFORMANCE_SUMMARY_VIEW,
            self::VIEW_TYPE_QUEUE_PERFORMANCE_DETAIL_VIEW,
            self::VIEW_TYPE_INTERACTION_SEARCH_VIEW,
            self::VIEW_TYPE_AGENT_PERFORMANCE_SUMMARY_VIEW,
            self::VIEW_TYPE_AGENT_PERFORMANCE_DETAIL_VIEW,
            self::VIEW_TYPE_AGENT_STATUS_SUMMARY_VIEW,
            self::VIEW_TYPE_AGENT_STATUS_DETAIL_VIEW,
            self::VIEW_TYPE_AGENT_EVALUATION_SUMMARY_VIEW,
            self::VIEW_TYPE_AGENT_EVALUATION_DETAIL_VIEW,
            self::VIEW_TYPE_AGENT_QUEUE_DETAIL_VIEW,
            self::VIEW_TYPE_AGENT_INTERACTION_DETAIL_VIEW,
            self::VIEW_TYPE_ABANDON_INSIGHTS_VIEW,
            self::VIEW_TYPE_SKILLS_PERFORMANCE_VIEW,
            self::VIEW_TYPE_SURVEY_FORM_PERFORMANCE_SUMMARY_VIEW,
            self::VIEW_TYPE_SURVEY_FORM_PERFORMANCE_DETAIL_VIEW,
            self::VIEW_TYPE_DNIS_PERFORMANCE_SUMMARY_VIEW,
            self::VIEW_TYPE_DNIS_PERFORMANCE_DETAIL_VIEW,
            self::VIEW_TYPE_WRAP_UP_PERFORMANCE_SUMMARY_VIEW,
            self::VIEW_TYPE_AGENT_WRAP_UP_PERFORMANCE_DETAIL_VIEW,
            self::VIEW_TYPE_QUEUE_ACTIVITY_SUMMARY_VIEW,
            self::VIEW_TYPE_QUEUE_ACTIVITY_DETAIL_VIEW,
            self::VIEW_TYPE_AGENT_QUEUE_ACTIVITY_SUMMARY_VIEW,
            self::VIEW_TYPE_QUEUE_AGENT_DETAIL_VIEW,
            self::VIEW_TYPE_QUEUE_INTERACTION_DETAIL_VIEW,
            self::VIEW_TYPE_AGENT_SCHEDULE_DETAIL_VIEW,
            self::VIEW_TYPE_IVR_PERFORMANCE_SUMMARY_VIEW,
            self::VIEW_TYPE_IVR_PERFORMANCE_DETAIL_VIEW,
            self::VIEW_TYPE_ANSWER_INSIGHTS_VIEW,
            self::VIEW_TYPE_HANDLE_INSIGHTS_VIEW,
            self::VIEW_TYPE_TALK_INSIGHTS_VIEW,
            self::VIEW_TYPE_HOLD_INSIGHTS_VIEW,
            self::VIEW_TYPE_ACW_INSIGHTS_VIEW,
            self::VIEW_TYPE_WAIT_INSIGHTS_VIEW,
            self::VIEW_TYPE_AGENT_WRAP_UP_PERFORMANCE_INTERVAL_DETAIL_VIEW,
            self::VIEW_TYPE_FLOW_OUTCOME_SUMMARY_VIEW,
            self::VIEW_TYPE_FLOW_OUTCOME_PERFORMANCE_DETAIL_VIEW,
            self::VIEW_TYPE_FLOW_OUTCOME_PERFORMANCE_INTERVAL_DETAIL_VIEW,
            self::VIEW_TYPE_FLOW_DESTINATION_SUMMARY_VIEW,
            self::VIEW_TYPE_FLOW_DESTINATION_DETAIL_VIEW,
            self::VIEW_TYPE_API_USAGE_VIEW,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['timeZone'] = isset($data['timeZone']) ? $data['timeZone'] : null;
        $this->container['exportFormat'] = isset($data['exportFormat']) ? $data['exportFormat'] : null;
        $this->container['interval'] = isset($data['interval']) ? $data['interval'] : null;
        $this->container['period'] = isset($data['period']) ? $data['period'] : null;
        $this->container['viewType'] = isset($data['viewType']) ? $data['viewType'] : null;
        $this->container['filter'] = isset($data['filter']) ? $data['filter'] : null;
        $this->container['read'] = isset($data['read']) ? $data['read'] : null;
        $this->container['locale'] = isset($data['locale']) ? $data['locale'] : null;
        $this->container['hasFormatDurations'] = isset($data['hasFormatDurations']) ? $data['hasFormatDurations'] : null;
        $this->container['hasSplitFilters'] = isset($data['hasSplitFilters']) ? $data['hasSplitFilters'] : null;
        $this->container['excludeEmptyRows'] = isset($data['excludeEmptyRows']) ? $data['excludeEmptyRows'] : null;
        $this->container['hasSplitByMedia'] = isset($data['hasSplitByMedia']) ? $data['hasSplitByMedia'] : null;
        $this->container['selectedColumns'] = isset($data['selectedColumns']) ? $data['selectedColumns'] : null;
        $this->container['hasCustomParticipantAttributes'] = isset($data['hasCustomParticipantAttributes']) ? $data['hasCustomParticipantAttributes'] : null;
        $this->container['recipientEmails'] = isset($data['recipientEmails']) ? $data['recipientEmails'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['name'] === null) {
            $invalid_properties[] = "'name' can't be null";
        }
        if ($this->container['timeZone'] === null) {
            $invalid_properties[] = "'timeZone' can't be null";
        }
        if ($this->container['exportFormat'] === null) {
            $invalid_properties[] = "'exportFormat' can't be null";
        }
        $allowed_values = array("CSV", "PDF");
        if (!in_array($this->container['exportFormat'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'exportFormat', must be one of #{allowed_values}.";
        }

        if ($this->container['interval'] === null) {
            $invalid_properties[] = "'interval' can't be null";
        }
        if ($this->container['period'] === null) {
            $invalid_properties[] = "'period' can't be null";
        }
        if ($this->container['viewType'] === null) {
            $invalid_properties[] = "'viewType' can't be null";
        }
        $allowed_values = array("QUEUE_PERFORMANCE_SUMMARY_VIEW", "QUEUE_PERFORMANCE_DETAIL_VIEW", "INTERACTION_SEARCH_VIEW", "AGENT_PERFORMANCE_SUMMARY_VIEW", "AGENT_PERFORMANCE_DETAIL_VIEW", "AGENT_STATUS_SUMMARY_VIEW", "AGENT_STATUS_DETAIL_VIEW", "AGENT_EVALUATION_SUMMARY_VIEW", "AGENT_EVALUATION_DETAIL_VIEW", "AGENT_QUEUE_DETAIL_VIEW", "AGENT_INTERACTION_DETAIL_VIEW", "ABANDON_INSIGHTS_VIEW", "SKILLS_PERFORMANCE_VIEW", "SURVEY_FORM_PERFORMANCE_SUMMARY_VIEW", "SURVEY_FORM_PERFORMANCE_DETAIL_VIEW", "DNIS_PERFORMANCE_SUMMARY_VIEW", "DNIS_PERFORMANCE_DETAIL_VIEW", "WRAP_UP_PERFORMANCE_SUMMARY_VIEW", "AGENT_WRAP_UP_PERFORMANCE_DETAIL_VIEW", "QUEUE_ACTIVITY_SUMMARY_VIEW", "QUEUE_ACTIVITY_DETAIL_VIEW", "AGENT_QUEUE_ACTIVITY_SUMMARY_VIEW", "QUEUE_AGENT_DETAIL_VIEW", "QUEUE_INTERACTION_DETAIL_VIEW", "AGENT_SCHEDULE_DETAIL_VIEW", "IVR_PERFORMANCE_SUMMARY_VIEW", "IVR_PERFORMANCE_DETAIL_VIEW", "ANSWER_INSIGHTS_VIEW", "HANDLE_INSIGHTS_VIEW", "TALK_INSIGHTS_VIEW", "HOLD_INSIGHTS_VIEW", "ACW_INSIGHTS_VIEW", "WAIT_INSIGHTS_VIEW", "AGENT_WRAP_UP_PERFORMANCE_INTERVAL_DETAIL_VIEW", "FLOW_OUTCOME_SUMMARY_VIEW", "FLOW_OUTCOME_PERFORMANCE_DETAIL_VIEW", "FLOW_OUTCOME_PERFORMANCE_INTERVAL_DETAIL_VIEW", "FLOW_DESTINATION_SUMMARY_VIEW", "FLOW_DESTINATION_DETAIL_VIEW", "API_USAGE_VIEW");
        if (!in_array($this->container['viewType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'viewType', must be one of #{allowed_values}.";
        }

        if ($this->container['filter'] === null) {
            $invalid_properties[] = "'filter' can't be null";
        }
        if ($this->container['locale'] === null) {
            $invalid_properties[] = "'locale' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['name'] === null) {
            return false;
        }
        if ($this->container['timeZone'] === null) {
            return false;
        }
        if ($this->container['exportFormat'] === null) {
            return false;
        }
        $allowed_values = array("CSV", "PDF");
        if (!in_array($this->container['exportFormat'], $allowed_values)) {
            return false;
        }
        if ($this->container['interval'] === null) {
            return false;
        }
        if ($this->container['period'] === null) {
            return false;
        }
        if ($this->container['viewType'] === null) {
            return false;
        }
        $allowed_values = array("QUEUE_PERFORMANCE_SUMMARY_VIEW", "QUEUE_PERFORMANCE_DETAIL_VIEW", "INTERACTION_SEARCH_VIEW", "AGENT_PERFORMANCE_SUMMARY_VIEW", "AGENT_PERFORMANCE_DETAIL_VIEW", "AGENT_STATUS_SUMMARY_VIEW", "AGENT_STATUS_DETAIL_VIEW", "AGENT_EVALUATION_SUMMARY_VIEW", "AGENT_EVALUATION_DETAIL_VIEW", "AGENT_QUEUE_DETAIL_VIEW", "AGENT_INTERACTION_DETAIL_VIEW", "ABANDON_INSIGHTS_VIEW", "SKILLS_PERFORMANCE_VIEW", "SURVEY_FORM_PERFORMANCE_SUMMARY_VIEW", "SURVEY_FORM_PERFORMANCE_DETAIL_VIEW", "DNIS_PERFORMANCE_SUMMARY_VIEW", "DNIS_PERFORMANCE_DETAIL_VIEW", "WRAP_UP_PERFORMANCE_SUMMARY_VIEW", "AGENT_WRAP_UP_PERFORMANCE_DETAIL_VIEW", "QUEUE_ACTIVITY_SUMMARY_VIEW", "QUEUE_ACTIVITY_DETAIL_VIEW", "AGENT_QUEUE_ACTIVITY_SUMMARY_VIEW", "QUEUE_AGENT_DETAIL_VIEW", "QUEUE_INTERACTION_DETAIL_VIEW", "AGENT_SCHEDULE_DETAIL_VIEW", "IVR_PERFORMANCE_SUMMARY_VIEW", "IVR_PERFORMANCE_DETAIL_VIEW", "ANSWER_INSIGHTS_VIEW", "HANDLE_INSIGHTS_VIEW", "TALK_INSIGHTS_VIEW", "HOLD_INSIGHTS_VIEW", "ACW_INSIGHTS_VIEW", "WAIT_INSIGHTS_VIEW", "AGENT_WRAP_UP_PERFORMANCE_INTERVAL_DETAIL_VIEW", "FLOW_OUTCOME_SUMMARY_VIEW", "FLOW_OUTCOME_PERFORMANCE_DETAIL_VIEW", "FLOW_OUTCOME_PERFORMANCE_INTERVAL_DETAIL_VIEW", "FLOW_DESTINATION_SUMMARY_VIEW", "FLOW_DESTINATION_DETAIL_VIEW", "API_USAGE_VIEW");
        if (!in_array($this->container['viewType'], $allowed_values)) {
            return false;
        }
        if ($this->container['filter'] === null) {
            return false;
        }
        if ($this->container['locale'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The user supplied name of the export request
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets timeZone
     * @return string
     */
    public function getTimeZone()
    {
        return $this->container['timeZone'];
    }

    /**
     * Sets timeZone
     * @param string $timeZone The requested timezone of the exported data. Time zones are represented as a string of the zone name as found in the IANA time zone database. For example: UTC, Etc/UTC, or Europe/London
     * @return $this
     */
    public function setTimeZone($timeZone)
    {
        $this->container['timeZone'] = $timeZone;

        return $this;
    }

    /**
     * Gets exportFormat
     * @return string
     */
    public function getExportFormat()
    {
        return $this->container['exportFormat'];
    }

    /**
     * Sets exportFormat
     * @param string $exportFormat The requested format of the exported data
     * @return $this
     */
    public function setExportFormat($exportFormat)
    {
        $allowed_values = array('CSV', 'PDF');
        if (!in_array($exportFormat, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'exportFormat', must be one of 'CSV', 'PDF'");
        }
        $this->container['exportFormat'] = $exportFormat;

        return $this;
    }

    /**
     * Gets interval
     * @return string
     */
    public function getInterval()
    {
        return $this->container['interval'];
    }

    /**
     * Sets interval
     * @param string $interval The time period used to limit the the exported data. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss
     * @return $this
     */
    public function setInterval($interval)
    {
        $this->container['interval'] = $interval;

        return $this;
    }

    /**
     * Gets period
     * @return string
     */
    public function getPeriod()
    {
        return $this->container['period'];
    }

    /**
     * Sets period
     * @param string $period The Period of the request in which to break down the intervals. Periods are represented as an ISO-8601 string. For example: P1D or P1DT12H
     * @return $this
     */
    public function setPeriod($period)
    {
        $this->container['period'] = $period;

        return $this;
    }

    /**
     * Gets viewType
     * @return string
     */
    public function getViewType()
    {
        return $this->container['viewType'];
    }

    /**
     * Sets viewType
     * @param string $viewType The type of view export job to be created
     * @return $this
     */
    public function setViewType($viewType)
    {
        $allowed_values = array('QUEUE_PERFORMANCE_SUMMARY_VIEW', 'QUEUE_PERFORMANCE_DETAIL_VIEW', 'INTERACTION_SEARCH_VIEW', 'AGENT_PERFORMANCE_SUMMARY_VIEW', 'AGENT_PERFORMANCE_DETAIL_VIEW', 'AGENT_STATUS_SUMMARY_VIEW', 'AGENT_STATUS_DETAIL_VIEW', 'AGENT_EVALUATION_SUMMARY_VIEW', 'AGENT_EVALUATION_DETAIL_VIEW', 'AGENT_QUEUE_DETAIL_VIEW', 'AGENT_INTERACTION_DETAIL_VIEW', 'ABANDON_INSIGHTS_VIEW', 'SKILLS_PERFORMANCE_VIEW', 'SURVEY_FORM_PERFORMANCE_SUMMARY_VIEW', 'SURVEY_FORM_PERFORMANCE_DETAIL_VIEW', 'DNIS_PERFORMANCE_SUMMARY_VIEW', 'DNIS_PERFORMANCE_DETAIL_VIEW', 'WRAP_UP_PERFORMANCE_SUMMARY_VIEW', 'AGENT_WRAP_UP_PERFORMANCE_DETAIL_VIEW', 'QUEUE_ACTIVITY_SUMMARY_VIEW', 'QUEUE_ACTIVITY_DETAIL_VIEW', 'AGENT_QUEUE_ACTIVITY_SUMMARY_VIEW', 'QUEUE_AGENT_DETAIL_VIEW', 'QUEUE_INTERACTION_DETAIL_VIEW', 'AGENT_SCHEDULE_DETAIL_VIEW', 'IVR_PERFORMANCE_SUMMARY_VIEW', 'IVR_PERFORMANCE_DETAIL_VIEW', 'ANSWER_INSIGHTS_VIEW', 'HANDLE_INSIGHTS_VIEW', 'TALK_INSIGHTS_VIEW', 'HOLD_INSIGHTS_VIEW', 'ACW_INSIGHTS_VIEW', 'WAIT_INSIGHTS_VIEW', 'AGENT_WRAP_UP_PERFORMANCE_INTERVAL_DETAIL_VIEW', 'FLOW_OUTCOME_SUMMARY_VIEW', 'FLOW_OUTCOME_PERFORMANCE_DETAIL_VIEW', 'FLOW_OUTCOME_PERFORMANCE_INTERVAL_DETAIL_VIEW', 'FLOW_DESTINATION_SUMMARY_VIEW', 'FLOW_DESTINATION_DETAIL_VIEW', 'API_USAGE_VIEW');
        if (!in_array($viewType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'viewType', must be one of 'QUEUE_PERFORMANCE_SUMMARY_VIEW', 'QUEUE_PERFORMANCE_DETAIL_VIEW', 'INTERACTION_SEARCH_VIEW', 'AGENT_PERFORMANCE_SUMMARY_VIEW', 'AGENT_PERFORMANCE_DETAIL_VIEW', 'AGENT_STATUS_SUMMARY_VIEW', 'AGENT_STATUS_DETAIL_VIEW', 'AGENT_EVALUATION_SUMMARY_VIEW', 'AGENT_EVALUATION_DETAIL_VIEW', 'AGENT_QUEUE_DETAIL_VIEW', 'AGENT_INTERACTION_DETAIL_VIEW', 'ABANDON_INSIGHTS_VIEW', 'SKILLS_PERFORMANCE_VIEW', 'SURVEY_FORM_PERFORMANCE_SUMMARY_VIEW', 'SURVEY_FORM_PERFORMANCE_DETAIL_VIEW', 'DNIS_PERFORMANCE_SUMMARY_VIEW', 'DNIS_PERFORMANCE_DETAIL_VIEW', 'WRAP_UP_PERFORMANCE_SUMMARY_VIEW', 'AGENT_WRAP_UP_PERFORMANCE_DETAIL_VIEW', 'QUEUE_ACTIVITY_SUMMARY_VIEW', 'QUEUE_ACTIVITY_DETAIL_VIEW', 'AGENT_QUEUE_ACTIVITY_SUMMARY_VIEW', 'QUEUE_AGENT_DETAIL_VIEW', 'QUEUE_INTERACTION_DETAIL_VIEW', 'AGENT_SCHEDULE_DETAIL_VIEW', 'IVR_PERFORMANCE_SUMMARY_VIEW', 'IVR_PERFORMANCE_DETAIL_VIEW', 'ANSWER_INSIGHTS_VIEW', 'HANDLE_INSIGHTS_VIEW', 'TALK_INSIGHTS_VIEW', 'HOLD_INSIGHTS_VIEW', 'ACW_INSIGHTS_VIEW', 'WAIT_INSIGHTS_VIEW', 'AGENT_WRAP_UP_PERFORMANCE_INTERVAL_DETAIL_VIEW', 'FLOW_OUTCOME_SUMMARY_VIEW', 'FLOW_OUTCOME_PERFORMANCE_DETAIL_VIEW', 'FLOW_OUTCOME_PERFORMANCE_INTERVAL_DETAIL_VIEW', 'FLOW_DESTINATION_SUMMARY_VIEW', 'FLOW_DESTINATION_DETAIL_VIEW', 'API_USAGE_VIEW'");
        }
        $this->container['viewType'] = $viewType;

        return $this;
    }

    /**
     * Gets filter
     * @return \PureCloudSDK\ViewFilter
     */
    public function getFilter()
    {
        return $this->container['filter'];
    }

    /**
     * Sets filter
     * @param \PureCloudSDK\ViewFilter $filter Filters to apply to create the view
     * @return $this
     */
    public function setFilter($filter)
    {
        $this->container['filter'] = $filter;

        return $this;
    }

    /**
     * Gets read
     * @return bool
     */
    public function getRead()
    {
        return $this->container['read'];
    }

    /**
     * Sets read
     * @param bool $read Indicates if the request has been marked as read
     * @return $this
     */
    public function setRead($read)
    {
        $this->container['read'] = $read;

        return $this;
    }

    /**
     * Gets locale
     * @return string
     */
    public function getLocale()
    {
        return $this->container['locale'];
    }

    /**
     * Sets locale
     * @param string $locale The locale use for localization of the exported data, i.e. en-us, es-mx
     * @return $this
     */
    public function setLocale($locale)
    {
        $this->container['locale'] = $locale;

        return $this;
    }

    /**
     * Gets hasFormatDurations
     * @return bool
     */
    public function getHasFormatDurations()
    {
        return $this->container['hasFormatDurations'];
    }

    /**
     * Sets hasFormatDurations
     * @param bool $hasFormatDurations Indicates if durations are formatted in hh:mm:ss format instead of ms
     * @return $this
     */
    public function setHasFormatDurations($hasFormatDurations)
    {
        $this->container['hasFormatDurations'] = $hasFormatDurations;

        return $this;
    }

    /**
     * Gets hasSplitFilters
     * @return bool
     */
    public function getHasSplitFilters()
    {
        return $this->container['hasSplitFilters'];
    }

    /**
     * Sets hasSplitFilters
     * @param bool $hasSplitFilters Indicates if filters will be split in aggregate detail exports
     * @return $this
     */
    public function setHasSplitFilters($hasSplitFilters)
    {
        $this->container['hasSplitFilters'] = $hasSplitFilters;

        return $this;
    }

    /**
     * Gets excludeEmptyRows
     * @return bool
     */
    public function getExcludeEmptyRows()
    {
        return $this->container['excludeEmptyRows'];
    }

    /**
     * Sets excludeEmptyRows
     * @param bool $excludeEmptyRows Excludes empty rows from the exports
     * @return $this
     */
    public function setExcludeEmptyRows($excludeEmptyRows)
    {
        $this->container['excludeEmptyRows'] = $excludeEmptyRows;

        return $this;
    }

    /**
     * Gets hasSplitByMedia
     * @return bool
     */
    public function getHasSplitByMedia()
    {
        return $this->container['hasSplitByMedia'];
    }

    /**
     * Sets hasSplitByMedia
     * @param bool $hasSplitByMedia Indicates if media type will be split in aggregate detail exports
     * @return $this
     */
    public function setHasSplitByMedia($hasSplitByMedia)
    {
        $this->container['hasSplitByMedia'] = $hasSplitByMedia;

        return $this;
    }

    /**
     * Gets selectedColumns
     * @return \PureCloudSDK\SelectedColumns[]
     */
    public function getSelectedColumns()
    {
        return $this->container['selectedColumns'];
    }

    /**
     * Sets selectedColumns
     * @param \PureCloudSDK\SelectedColumns[] $selectedColumns The list of ordered selected columns from the export view by the user
     * @return $this
     */
    public function setSelectedColumns($selectedColumns)
    {
        $this->container['selectedColumns'] = $selectedColumns;

        return $this;
    }

    /**
     * Gets hasCustomParticipantAttributes
     * @return bool
     */
    public function getHasCustomParticipantAttributes()
    {
        return $this->container['hasCustomParticipantAttributes'];
    }

    /**
     * Sets hasCustomParticipantAttributes
     * @param bool $hasCustomParticipantAttributes Indicates if custom participant attributes will be exported
     * @return $this
     */
    public function setHasCustomParticipantAttributes($hasCustomParticipantAttributes)
    {
        $this->container['hasCustomParticipantAttributes'] = $hasCustomParticipantAttributes;

        return $this;
    }

    /**
     * Gets recipientEmails
     * @return string[]
     */
    public function getRecipientEmails()
    {
        return $this->container['recipientEmails'];
    }

    /**
     * Sets recipientEmails
     * @param string[] $recipientEmails The list of email recipients for the exports
     * @return $this
     */
    public function setRecipientEmails($recipientEmails)
    {
        $this->container['recipientEmails'] = $recipientEmails;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
