<?php

/**
 * ScimV2SchemaAttribute
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * ScimV2SchemaAttribute Class Doc Comment
 *
 * @category    Class */
 // @description A complex type that defines service provider attributes or subattributes and their qualities.
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ScimV2SchemaAttribute implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ScimV2SchemaAttribute';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'name' => 'string',
        'type' => 'string',
        'subAttributes' => '\PureCloudSDK\ScimV2SchemaAttribute[]',
        'multiValued' => 'bool',
        'description' => 'string',
        'required' => 'bool',
        'canonicalValues' => 'string[]',
        'caseExact' => 'bool',
        'mutability' => 'string',
        'returned' => 'string',
        'uniqueness' => 'string',
        'referenceTypes' => 'string[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'name' => 'name',
        'type' => 'type',
        'subAttributes' => 'subAttributes',
        'multiValued' => 'multiValued',
        'description' => 'description',
        'required' => 'required',
        'canonicalValues' => 'canonicalValues',
        'caseExact' => 'caseExact',
        'mutability' => 'mutability',
        'returned' => 'returned',
        'uniqueness' => 'uniqueness',
        'referenceTypes' => 'referenceTypes'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'name' => 'setName',
        'type' => 'setType',
        'subAttributes' => 'setSubAttributes',
        'multiValued' => 'setMultiValued',
        'description' => 'setDescription',
        'required' => 'setRequired',
        'canonicalValues' => 'setCanonicalValues',
        'caseExact' => 'setCaseExact',
        'mutability' => 'setMutability',
        'returned' => 'setReturned',
        'uniqueness' => 'setUniqueness',
        'referenceTypes' => 'setReferenceTypes'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'name' => 'getName',
        'type' => 'getType',
        'subAttributes' => 'getSubAttributes',
        'multiValued' => 'getMultiValued',
        'description' => 'getDescription',
        'required' => 'getRequired',
        'canonicalValues' => 'getCanonicalValues',
        'caseExact' => 'getCaseExact',
        'mutability' => 'getMutability',
        'returned' => 'getReturned',
        'uniqueness' => 'getUniqueness',
        'referenceTypes' => 'getReferenceTypes'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const TYPE_STRING = 'STRING';
    public const TYPE_BOOLEAN = 'BOOLEAN';
    public const TYPE_DECIMAL = 'DECIMAL';
    public const TYPE_INTEGER = 'INTEGER';
    public const TYPE_DATE_TIME = 'DATE_TIME';
    public const TYPE_REFERENCE = 'REFERENCE';
    public const TYPE_COMPLEX = 'COMPLEX';
    public const MUTABILITY_READ_WRITE = 'readWrite';
    public const MUTABILITY_READ_ONLY = 'readOnly';
    public const MUTABILITY_IMMUTABLE = 'immutable';
    public const MUTABILITY_WRITE_ONLY = 'writeOnly';
    public const RETURNED_ALWAYS = 'ALWAYS';
    public const RETURNED_NEVER = 'NEVER';
    public const RETURNED_DEFAULT = 'DEFAULT';
    public const RETURNED_REQUEST = 'REQUEST';
    public const UNIQUENESS_NONE = 'NONE';
    public const UNIQUENESS_SERVER = 'SERVER';
    public const UNIQUENESS_GLOBAL = 'GLOBAL';
    public const REFERENCE_TYPES_USER = 'USER';
    public const REFERENCE_TYPES_GROUP = 'GROUP';
    public const REFERENCE_TYPES_EXTERNAL = 'EXTERNAL';
    public const REFERENCE_TYPES_URI = 'URI';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_STRING,
            self::TYPE_BOOLEAN,
            self::TYPE_DECIMAL,
            self::TYPE_INTEGER,
            self::TYPE_DATE_TIME,
            self::TYPE_REFERENCE,
            self::TYPE_COMPLEX,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMutabilityAllowableValues()
    {
        return [
            self::MUTABILITY_READ_WRITE,
            self::MUTABILITY_READ_ONLY,
            self::MUTABILITY_IMMUTABLE,
            self::MUTABILITY_WRITE_ONLY,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getReturnedAllowableValues()
    {
        return [
            self::RETURNED_ALWAYS,
            self::RETURNED_NEVER,
            self::RETURNED_DEFAULT,
            self::RETURNED_REQUEST,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getUniquenessAllowableValues()
    {
        return [
            self::UNIQUENESS_NONE,
            self::UNIQUENESS_SERVER,
            self::UNIQUENESS_GLOBAL,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getReferenceTypesAllowableValues()
    {
        return [
            self::REFERENCE_TYPES_USER,
            self::REFERENCE_TYPES_GROUP,
            self::REFERENCE_TYPES_EXTERNAL,
            self::REFERENCE_TYPES_URI,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['subAttributes'] = isset($data['subAttributes']) ? $data['subAttributes'] : null;
        $this->container['multiValued'] = isset($data['multiValued']) ? $data['multiValued'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['required'] = isset($data['required']) ? $data['required'] : null;
        $this->container['canonicalValues'] = isset($data['canonicalValues']) ? $data['canonicalValues'] : null;
        $this->container['caseExact'] = isset($data['caseExact']) ? $data['caseExact'] : null;
        $this->container['mutability'] = isset($data['mutability']) ? $data['mutability'] : null;
        $this->container['returned'] = isset($data['returned']) ? $data['returned'] : null;
        $this->container['uniqueness'] = isset($data['uniqueness']) ? $data['uniqueness'] : null;
        $this->container['referenceTypes'] = isset($data['referenceTypes']) ? $data['referenceTypes'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("STRING", "BOOLEAN", "DECIMAL", "INTEGER", "DATE_TIME", "REFERENCE", "COMPLEX");
        if (!in_array($this->container['type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'type', must be one of #{allowed_values}.";
        }

        $allowed_values = array("readWrite", "readOnly", "immutable", "writeOnly");
        if (!in_array($this->container['mutability'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'mutability', must be one of #{allowed_values}.";
        }

        $allowed_values = array("ALWAYS", "NEVER", "DEFAULT", "REQUEST");
        if (!in_array($this->container['returned'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'returned', must be one of #{allowed_values}.";
        }

        $allowed_values = array("NONE", "SERVER", "GLOBAL");
        if (!in_array($this->container['uniqueness'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'uniqueness', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("STRING", "BOOLEAN", "DECIMAL", "INTEGER", "DATE_TIME", "REFERENCE", "COMPLEX");
        if (!in_array($this->container['type'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("readWrite", "readOnly", "immutable", "writeOnly");
        if (!in_array($this->container['mutability'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("ALWAYS", "NEVER", "DEFAULT", "REQUEST");
        if (!in_array($this->container['returned'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("NONE", "SERVER", "GLOBAL");
        if (!in_array($this->container['uniqueness'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The attribute's name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     * @param string $type The data type of the attribute.
     * @return $this
     */
    public function setType($type)
    {
        $allowed_values = array('STRING', 'BOOLEAN', 'DECIMAL', 'INTEGER', 'DATE_TIME', 'REFERENCE', 'COMPLEX');
        if (!in_array($type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'type', must be one of 'STRING', 'BOOLEAN', 'DECIMAL', 'INTEGER', 'DATE_TIME', 'REFERENCE', 'COMPLEX'");
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets subAttributes
     * @return \PureCloudSDK\ScimV2SchemaAttribute[]
     */
    public function getSubAttributes()
    {
        return $this->container['subAttributes'];
    }

    /**
     * Sets subAttributes
     * @param \PureCloudSDK\ScimV2SchemaAttribute[] $subAttributes The list of subattributes for an attribute of the type \"complex\". Uses the same schema as \"attributes\".
     * @return $this
     */
    public function setSubAttributes($subAttributes)
    {
        $this->container['subAttributes'] = $subAttributes;

        return $this;
    }

    /**
     * Gets multiValued
     * @return bool
     */
    public function getMultiValued()
    {
        return $this->container['multiValued'];
    }

    /**
     * Sets multiValued
     * @param bool $multiValued Indicates whether an attribute contains multiple values.
     * @return $this
     */
    public function setMultiValued($multiValued)
    {
        $this->container['multiValued'] = $multiValued;

        return $this;
    }

    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description The description of the attribute.
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets required
     * @return bool
     */
    public function getRequired()
    {
        return $this->container['required'];
    }

    /**
     * Sets required
     * @param bool $required Indicates whether an attribute is required.
     * @return $this
     */
    public function setRequired($required)
    {
        $this->container['required'] = $required;

        return $this;
    }

    /**
     * Gets canonicalValues
     * @return string[]
     */
    public function getCanonicalValues()
    {
        return $this->container['canonicalValues'];
    }

    /**
     * Sets canonicalValues
     * @param string[] $canonicalValues The list of standard values that service providers may use. Service providers may ignore unsupported values.
     * @return $this
     */
    public function setCanonicalValues($canonicalValues)
    {
        $this->container['canonicalValues'] = $canonicalValues;

        return $this;
    }

    /**
     * Gets caseExact
     * @return bool
     */
    public function getCaseExact()
    {
        return $this->container['caseExact'];
    }

    /**
     * Sets caseExact
     * @param bool $caseExact Indicates whether a string attribute is case-sensitive. If set to \"true\", the server preserves case sensitivity. If set to \"false\", the server may change the case. The server also uses case sensitivity when evaluating filters. See section 3.4.2.2 \"Filtering\" in RFC 7644 for details.
     * @return $this
     */
    public function setCaseExact($caseExact)
    {
        $this->container['caseExact'] = $caseExact;

        return $this;
    }

    /**
     * Gets mutability
     * @return string
     */
    public function getMutability()
    {
        return $this->container['mutability'];
    }

    /**
     * Sets mutability
     * @param string $mutability The circumstances under which an attribute can be defined or redefined. The default is \"readWrite\".
     * @return $this
     */
    public function setMutability($mutability)
    {
        $allowed_values = array('readWrite', 'readOnly', 'immutable', 'writeOnly');
        if (!in_array($mutability, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'mutability', must be one of 'readWrite', 'readOnly', 'immutable', 'writeOnly'");
        }
        $this->container['mutability'] = $mutability;

        return $this;
    }

    /**
     * Gets returned
     * @return string
     */
    public function getReturned()
    {
        return $this->container['returned'];
    }

    /**
     * Sets returned
     * @param string $returned The circumstances under which an attribute and its values are returned in response to a GET, PUT, POST, or PATCH request.
     * @return $this
     */
    public function setReturned($returned)
    {
        $allowed_values = array('ALWAYS', 'NEVER', 'DEFAULT', 'REQUEST');
        if (!in_array($returned, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'returned', must be one of 'ALWAYS', 'NEVER', 'DEFAULT', 'REQUEST'");
        }
        $this->container['returned'] = $returned;

        return $this;
    }

    /**
     * Gets uniqueness
     * @return string
     */
    public function getUniqueness()
    {
        return $this->container['uniqueness'];
    }

    /**
     * Sets uniqueness
     * @param string $uniqueness The method by which the service provider enforces the uniqueness of an attribute value. A server can reject a value by returning the HTTP response code 400 (Bad Request). A client can enforce uniqueness to a greater degree than the server provider enforces. For example, a client could make a value unique even though the server has \"uniqueness\" set to \"none\".
     * @return $this
     */
    public function setUniqueness($uniqueness)
    {
        $allowed_values = array('NONE', 'SERVER', 'GLOBAL');
        if (!in_array($uniqueness, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'uniqueness', must be one of 'NONE', 'SERVER', 'GLOBAL'");
        }
        $this->container['uniqueness'] = $uniqueness;

        return $this;
    }

    /**
     * Gets referenceTypes
     * @return string[]
     */
    public function getReferenceTypes()
    {
        return $this->container['referenceTypes'];
    }

    /**
     * Sets referenceTypes
     * @param string[] $referenceTypes The list of SCIM resource types that may be referenced. Only applies when \"type\" is set to \"reference\".
     * @return $this
     */
    public function setReferenceTypes($referenceTypes)
    {
        $allowed_values = array('USER', 'GROUP', 'EXTERNAL', 'URI');
        if (!in_array($referenceTypes, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'referenceTypes', must be one of 'USER', 'GROUP', 'EXTERNAL', 'URI'");
        }
        $this->container['referenceTypes'] = $referenceTypes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
