<?php

/**
 * SurveyAggregationQuery
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * SurveyAggregationQuery Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class SurveyAggregationQuery implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'SurveyAggregationQuery';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'interval' => 'string',
        'granularity' => 'string',
        'timeZone' => 'string',
        'groupBy' => 'string[]',
        'filter' => '\PureCloudSDK\SurveyAggregateQueryFilter',
        'metrics' => 'string[]',
        'flattenMultivaluedDimensions' => 'bool',
        'views' => '\PureCloudSDK\SurveyAggregationView[]',
        'alternateTimeDimension' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'interval' => 'interval',
        'granularity' => 'granularity',
        'timeZone' => 'timeZone',
        'groupBy' => 'groupBy',
        'filter' => 'filter',
        'metrics' => 'metrics',
        'flattenMultivaluedDimensions' => 'flattenMultivaluedDimensions',
        'views' => 'views',
        'alternateTimeDimension' => 'alternateTimeDimension'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'interval' => 'setInterval',
        'granularity' => 'setGranularity',
        'timeZone' => 'setTimeZone',
        'groupBy' => 'setGroupBy',
        'filter' => 'setFilter',
        'metrics' => 'setMetrics',
        'flattenMultivaluedDimensions' => 'setFlattenMultivaluedDimensions',
        'views' => 'setViews',
        'alternateTimeDimension' => 'setAlternateTimeDimension'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'interval' => 'getInterval',
        'granularity' => 'getGranularity',
        'timeZone' => 'getTimeZone',
        'groupBy' => 'getGroupBy',
        'filter' => 'getFilter',
        'metrics' => 'getMetrics',
        'flattenMultivaluedDimensions' => 'getFlattenMultivaluedDimensions',
        'views' => 'getViews',
        'alternateTimeDimension' => 'getAlternateTimeDimension'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const GROUP_BY_CONVERSATION_ID = 'conversationId';
    public const GROUP_BY_DIVISION_ID = 'divisionId';
    public const GROUP_BY_EXTERNAL_CONTACT_ID = 'externalContactId';
    public const GROUP_BY_MEDIA_TYPE = 'mediaType';
    public const GROUP_BY_QUEUE_ID = 'queueId';
    public const GROUP_BY_REQUESTED_LANGUAGE_ID = 'requestedLanguageId';
    public const GROUP_BY_REQUESTED_ROUTING_SKILL_ID = 'requestedRoutingSkillId';
    public const GROUP_BY_SURVEY_ANSWER_ID = 'surveyAnswerId';
    public const GROUP_BY_SURVEY_CREATED_DATE = 'surveyCreatedDate';
    public const GROUP_BY_SURVEY_ERROR_REASON = 'surveyErrorReason';
    public const GROUP_BY_SURVEY_FORM_CONTEXT_ID = 'surveyFormContextId';
    public const GROUP_BY_SURVEY_FORM_ID = 'surveyFormId';
    public const GROUP_BY_SURVEY_FORM_NAME = 'surveyFormName';
    public const GROUP_BY_SURVEY_ID = 'surveyId';
    public const GROUP_BY_SURVEY_PREVIOUS_STATUS = 'surveyPreviousStatus';
    public const GROUP_BY_SURVEY_PROMOTER_SCORE = 'surveyPromoterScore';
    public const GROUP_BY_SURVEY_QUESTION_GROUP_ID = 'surveyQuestionGroupId';
    public const GROUP_BY_SURVEY_QUESTION_ID = 'surveyQuestionId';
    public const GROUP_BY_SURVEY_STATUS = 'surveyStatus';
    public const GROUP_BY_USER_ID = 'userId';
    public const GROUP_BY_WRAP_UP_CODE = 'wrapUpCode';
    public const METRICS_N_SURVEY_ERRORS = 'nSurveyErrors';
    public const METRICS_N_SURVEY_NPS_DETRACTORS = 'nSurveyNpsDetractors';
    public const METRICS_N_SURVEY_NPS_PROMOTERS = 'nSurveyNpsPromoters';
    public const METRICS_N_SURVEY_NPS_RESPONSES = 'nSurveyNpsResponses';
    public const METRICS_N_SURVEY_QUESTION_GROUP_RESPONSES = 'nSurveyQuestionGroupResponses';
    public const METRICS_N_SURVEY_QUESTION_RESPONSES = 'nSurveyQuestionResponses';
    public const METRICS_N_SURVEY_RESPONSES = 'nSurveyResponses';
    public const METRICS_N_SURVEYS_ABANDONED = 'nSurveysAbandoned';
    public const METRICS_N_SURVEYS_DELETED = 'nSurveysDeleted';
    public const METRICS_N_SURVEYS_EXPIRED = 'nSurveysExpired';
    public const METRICS_N_SURVEYS_SENT = 'nSurveysSent';
    public const METRICS_N_SURVEYS_STARTED = 'nSurveysStarted';
    public const METRICS_O_SURVEY_QUESTION_GROUP_SCORE = 'oSurveyQuestionGroupScore';
    public const METRICS_O_SURVEY_QUESTION_SCORE = 'oSurveyQuestionScore';
    public const METRICS_O_SURVEY_TOTAL_SCORE = 'oSurveyTotalScore';
    public const ALTERNATE_TIME_DIMENSION_EVENT_TIME = 'eventTime';
    public const ALTERNATE_TIME_DIMENSION_SURVEY_CREATED_DATE = 'surveyCreatedDate';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getGroupByAllowableValues()
    {
        return [
            self::GROUP_BY_CONVERSATION_ID,
            self::GROUP_BY_DIVISION_ID,
            self::GROUP_BY_EXTERNAL_CONTACT_ID,
            self::GROUP_BY_MEDIA_TYPE,
            self::GROUP_BY_QUEUE_ID,
            self::GROUP_BY_REQUESTED_LANGUAGE_ID,
            self::GROUP_BY_REQUESTED_ROUTING_SKILL_ID,
            self::GROUP_BY_SURVEY_ANSWER_ID,
            self::GROUP_BY_SURVEY_CREATED_DATE,
            self::GROUP_BY_SURVEY_ERROR_REASON,
            self::GROUP_BY_SURVEY_FORM_CONTEXT_ID,
            self::GROUP_BY_SURVEY_FORM_ID,
            self::GROUP_BY_SURVEY_FORM_NAME,
            self::GROUP_BY_SURVEY_ID,
            self::GROUP_BY_SURVEY_PREVIOUS_STATUS,
            self::GROUP_BY_SURVEY_PROMOTER_SCORE,
            self::GROUP_BY_SURVEY_QUESTION_GROUP_ID,
            self::GROUP_BY_SURVEY_QUESTION_ID,
            self::GROUP_BY_SURVEY_STATUS,
            self::GROUP_BY_USER_ID,
            self::GROUP_BY_WRAP_UP_CODE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMetricsAllowableValues()
    {
        return [
            self::METRICS_N_SURVEY_ERRORS,
            self::METRICS_N_SURVEY_NPS_DETRACTORS,
            self::METRICS_N_SURVEY_NPS_PROMOTERS,
            self::METRICS_N_SURVEY_NPS_RESPONSES,
            self::METRICS_N_SURVEY_QUESTION_GROUP_RESPONSES,
            self::METRICS_N_SURVEY_QUESTION_RESPONSES,
            self::METRICS_N_SURVEY_RESPONSES,
            self::METRICS_N_SURVEYS_ABANDONED,
            self::METRICS_N_SURVEYS_DELETED,
            self::METRICS_N_SURVEYS_EXPIRED,
            self::METRICS_N_SURVEYS_SENT,
            self::METRICS_N_SURVEYS_STARTED,
            self::METRICS_O_SURVEY_QUESTION_GROUP_SCORE,
            self::METRICS_O_SURVEY_QUESTION_SCORE,
            self::METRICS_O_SURVEY_TOTAL_SCORE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getAlternateTimeDimensionAllowableValues()
    {
        return [
            self::ALTERNATE_TIME_DIMENSION_EVENT_TIME,
            self::ALTERNATE_TIME_DIMENSION_SURVEY_CREATED_DATE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['interval'] = isset($data['interval']) ? $data['interval'] : null;
        $this->container['granularity'] = isset($data['granularity']) ? $data['granularity'] : null;
        $this->container['timeZone'] = isset($data['timeZone']) ? $data['timeZone'] : null;
        $this->container['groupBy'] = isset($data['groupBy']) ? $data['groupBy'] : null;
        $this->container['filter'] = isset($data['filter']) ? $data['filter'] : null;
        $this->container['metrics'] = isset($data['metrics']) ? $data['metrics'] : null;
        $this->container['flattenMultivaluedDimensions'] = isset($data['flattenMultivaluedDimensions']) ? $data['flattenMultivaluedDimensions'] : null;
        $this->container['views'] = isset($data['views']) ? $data['views'] : null;
        $this->container['alternateTimeDimension'] = isset($data['alternateTimeDimension']) ? $data['alternateTimeDimension'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['interval'] === null) {
            $invalid_properties[] = "'interval' can't be null";
        }
        $allowed_values = array("eventTime", "surveyCreatedDate");
        if (!in_array($this->container['alternateTimeDimension'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'alternateTimeDimension', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['interval'] === null) {
            return false;
        }
        $allowed_values = array("eventTime", "surveyCreatedDate");
        if (!in_array($this->container['alternateTimeDimension'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets interval
     * @return string
     */
    public function getInterval()
    {
        return $this->container['interval'];
    }

    /**
     * Sets interval
     * @param string $interval Behaves like one clause in a SQL WHERE. Specifies the date and time range of data being queried. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss
     * @return $this
     */
    public function setInterval($interval)
    {
        $this->container['interval'] = $interval;

        return $this;
    }

    /**
     * Gets granularity
     * @return string
     */
    public function getGranularity()
    {
        return $this->container['granularity'];
    }

    /**
     * Sets granularity
     * @param string $granularity Granularity aggregates metrics into subpartitions within the time interval specified. The default granularity is the same duration as the interval. Periods are represented as an ISO-8601 string. For example: P1D or P1DT12H
     * @return $this
     */
    public function setGranularity($granularity)
    {
        $this->container['granularity'] = $granularity;

        return $this;
    }

    /**
     * Gets timeZone
     * @return string
     */
    public function getTimeZone()
    {
        return $this->container['timeZone'];
    }

    /**
     * Sets timeZone
     * @param string $timeZone Time zone context used to calculate response intervals (this allows resolving DST changes). The interval offset is used even when timeZone is specified. Default is UTC. Time zones are represented as a string of the zone name as found in the IANA time zone database. For example: UTC, Etc/UTC, or Europe/London
     * @return $this
     */
    public function setTimeZone($timeZone)
    {
        $this->container['timeZone'] = $timeZone;

        return $this;
    }

    /**
     * Gets groupBy
     * @return string[]
     */
    public function getGroupBy()
    {
        return $this->container['groupBy'];
    }

    /**
     * Sets groupBy
     * @param string[] $groupBy Behaves like a SQL GROUPBY. Allows for multiple levels of grouping as a list of dimensions. Partitions resulting aggregate computations into distinct named subgroups rather than across the entire result set as if it were one group.
     * @return $this
     */
    public function setGroupBy($groupBy)
    {
        $allowed_values = array('conversationId', 'divisionId', 'externalContactId', 'mediaType', 'queueId', 'requestedLanguageId', 'requestedRoutingSkillId', 'surveyAnswerId', 'surveyCreatedDate', 'surveyErrorReason', 'surveyFormContextId', 'surveyFormId', 'surveyFormName', 'surveyId', 'surveyPreviousStatus', 'surveyPromoterScore', 'surveyQuestionGroupId', 'surveyQuestionId', 'surveyStatus', 'userId', 'wrapUpCode');
        if (!in_array($groupBy, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'groupBy', must be one of 'conversationId', 'divisionId', 'externalContactId', 'mediaType', 'queueId', 'requestedLanguageId', 'requestedRoutingSkillId', 'surveyAnswerId', 'surveyCreatedDate', 'surveyErrorReason', 'surveyFormContextId', 'surveyFormId', 'surveyFormName', 'surveyId', 'surveyPreviousStatus', 'surveyPromoterScore', 'surveyQuestionGroupId', 'surveyQuestionId', 'surveyStatus', 'userId', 'wrapUpCode'");
        }
        $this->container['groupBy'] = $groupBy;

        return $this;
    }

    /**
     * Gets filter
     * @return \PureCloudSDK\SurveyAggregateQueryFilter
     */
    public function getFilter()
    {
        return $this->container['filter'];
    }

    /**
     * Sets filter
     * @param \PureCloudSDK\SurveyAggregateQueryFilter $filter Behaves like a SQL WHERE clause. This is ANDed with the interval parameter. Expresses boolean logical predicates as well as dimensional filters
     * @return $this
     */
    public function setFilter($filter)
    {
        $this->container['filter'] = $filter;

        return $this;
    }

    /**
     * Gets metrics
     * @return string[]
     */
    public function getMetrics()
    {
        return $this->container['metrics'];
    }

    /**
     * Sets metrics
     * @param string[] $metrics Behaves like a SQL SELECT clause. Enables retrieving only named metrics. If omitted, all metrics that are available will be returned (like SELECT *).
     * @return $this
     */
    public function setMetrics($metrics)
    {
        $allowed_values = array('nSurveyErrors', 'nSurveyNpsDetractors', 'nSurveyNpsPromoters', 'nSurveyNpsResponses', 'nSurveyQuestionGroupResponses', 'nSurveyQuestionResponses', 'nSurveyResponses', 'nSurveysAbandoned', 'nSurveysDeleted', 'nSurveysExpired', 'nSurveysSent', 'nSurveysStarted', 'oSurveyQuestionGroupScore', 'oSurveyQuestionScore', 'oSurveyTotalScore');
        if (!in_array($metrics, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'metrics', must be one of 'nSurveyErrors', 'nSurveyNpsDetractors', 'nSurveyNpsPromoters', 'nSurveyNpsResponses', 'nSurveyQuestionGroupResponses', 'nSurveyQuestionResponses', 'nSurveyResponses', 'nSurveysAbandoned', 'nSurveysDeleted', 'nSurveysExpired', 'nSurveysSent', 'nSurveysStarted', 'oSurveyQuestionGroupScore', 'oSurveyQuestionScore', 'oSurveyTotalScore'");
        }
        $this->container['metrics'] = $metrics;

        return $this;
    }

    /**
     * Gets flattenMultivaluedDimensions
     * @return bool
     */
    public function getFlattenMultivaluedDimensions()
    {
        return $this->container['flattenMultivaluedDimensions'];
    }

    /**
     * Sets flattenMultivaluedDimensions
     * @param bool $flattenMultivaluedDimensions Flattens any multivalued dimensions used in response groups (e.g. ['a','b','c']->'a,b,c')
     * @return $this
     */
    public function setFlattenMultivaluedDimensions($flattenMultivaluedDimensions)
    {
        $this->container['flattenMultivaluedDimensions'] = $flattenMultivaluedDimensions;

        return $this;
    }

    /**
     * Gets views
     * @return \PureCloudSDK\SurveyAggregationView[]
     */
    public function getViews()
    {
        return $this->container['views'];
    }

    /**
     * Sets views
     * @param \PureCloudSDK\SurveyAggregationView[] $views Custom derived metric views
     * @return $this
     */
    public function setViews($views)
    {
        $this->container['views'] = $views;

        return $this;
    }

    /**
     * Gets alternateTimeDimension
     * @return string
     */
    public function getAlternateTimeDimension()
    {
        return $this->container['alternateTimeDimension'];
    }

    /**
     * Sets alternateTimeDimension
     * @param string $alternateTimeDimension Dimension to use as the alternative timestamp for data in the aggregate.  Choosing \"eventTime\" uses the actual time of the data event.
     * @return $this
     */
    public function setAlternateTimeDimension($alternateTimeDimension)
    {
        $allowed_values = array('eventTime', 'surveyCreatedDate');
        if (!in_array($alternateTimeDimension, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'alternateTimeDimension', must be one of 'eventTime', 'surveyCreatedDate'");
        }
        $this->container['alternateTimeDimension'] = $alternateTimeDimension;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
