<?php

namespace DealerDirect\Example\Sdk;

use DealerDirect\Generic\Category\EmailType;
use DealerDirect\Generic\Category\Locale;
use DealerDirect\Generic\Category\VehicleType;
use DealerDirect\Sdk\Config;
use DealerDirect\Sdk\Exception\HttpException;
use Dealerdirect\Sdk\Model\Email\Attachment;
use Dealerdirect\Sdk\Model\Email\Email;
use Dealerdirect\Sdk\Model\Email\Recipient;
use Dealerdirect\Sdk\Model\Email\Substitution\UserMakeModelSubstitution;
use DealerDirect\Sdk\Sdk;

require dirname(__DIR__) . '/vendor/autoload.php';

// =============================================================================
// Values used to send an email
// =============================================================================
$name = 'Ike Bot';
$address = 'devops@dealerdirect.nl';

$locale = Locale::NL_NL;
$vehicleType = VehicleType::SCOOTER;
$emailType = EmailType::CONFIRMATION_EMAIL;
$substitutions = new UserMakeModelSubstitution('Carl', 'Benz', 'Benz Patent Motor Car', 'No.1');

// -----------------------------------------------------------------------------
// Get the Client
// -----------------------------------------------------------------------------

$config = new Config([
    /* @NOTE: The EMAIL_SERVICE_URL would normally be read from a `.env` file */
    Config::EMAIL_SERVICE_URL => 'https://email-service.email-service.dev/api/v1',
]);

$sdk = new Sdk($config);

$client = $sdk->getEmail();

// =============================================================================
// Send an Email
// =============================================================================
$attachments = [
    new Attachment(
        file_get_contents(__DIR__.'/example.jpg'),
        'image/jpeg',
        'test.jpeg'
    ),
];

$email = new Email($locale, $vehicleType, $emailType, $substitutions, $attachments);

$to = [
    new Recipient($address, $name)
];

try {
    $client->sendEmail($email, $to);
    $content = 'Success';
} catch (HttpException $exception) {
    $content = '!!! FAILURE !!!' . $exception->getMessage();
}
// =============================================================================

echo $content.PHP_EOL;

/*EOF*/
