<?php

namespace Dealerdirect\Sdk\Model\Email;

use DealerDirect\Sdk\Exception\HttpException;
use Dealerdirect\Sdk\Model\Email\Substitution\AbstractSubstitution;

final class Email
{
    /** @var Attachment[] */
    private $attachments;
    /** @return string */
    private $emailType;
    /** @return string */
    private $locale;
    /** @return array */
    private $substitution;
    /** @return string */
    private $vehicleType;

    /** @return Attachment[] */
    public function getAttachments()
    {
        return $this->attachments;
    }

    /** @return string */
    public function getEmailType()
    {
        return $this->emailType;
    }

    /** @return string */
    public function getLocale()
    {
        return $this->locale;
    }

    /** @return array*/
    public function getSubstitution()
    {
        return $this->substitution;
    }

    /** @return string */
    public function getVehicleType()
    {
        return $this->vehicleType;
    }

    /**
     * @param string $locale
     * @param string $vehicleType
     * @param string $emailType
     * @param AbstractSubstitution $substitution
     * @param array $attachments
     *
     * @throws \InvalidArgumentException
     */
    public function __construct($locale, $vehicleType, $emailType, AbstractSubstitution $substitution, array $attachments = [])
    {
        $this->validateAttachments($attachments);

        $this->emailType = $emailType;
        $this->locale = $locale;
        $this->vehicleType = $vehicleType;
        $this->substitution = $substitution->toArray();
        $this->attachments = $attachments;
    }

    /**
     * @param array $attachments
     *
     * @throws \InvalidArgumentException
     */
    private function validateAttachments(array $attachments)
    {
        array_walk($attachments, function ($attachment) {
            if (! $attachment instanceof Attachment) {

                $type = gettype($attachment);
                if (is_object($attachment)) {
                    $type = get_class($attachment);
                }

                $message = sprintf(
                    'Attachments must be of class %s, %s given',
                    '\\Dealerdirect\\Sdk\\Model\\Email\\Attachment',
                    $type
                );

                throw new \InvalidArgumentException($message);
            }
        });
    }
}
