<?php

namespace Dealerdirect\Sdk\Model\Email\Substitution;

class UserMakeModelSubstitution extends AbstractSubstitution
{
    /** @var string */
    private $first_name;
    /** @var string */
    private $last_name;
    /** @var string */
    private $make;
    /** @var string */
    private $model;

    /**
     * @return string
     */
    public function getFirstName()
    {
        return $this->first_name;
    }

    /**
     * @return string
     */
    public function getLastName()
    {
        return $this->last_name;
    }

    /**
     * @return string
     */
    public function getMake()
    {
        return $this->make;
    }

    /**
     * @return string
     */
    public function getModel()
    {
        return $this->model;
    }

    /**
     * ConfirmEmail constructor.
     *
     * @param string $first_name
     * @param string $last_name
     * @param string $make
     * @param string $model
     */
    final public function __construct($first_name, $last_name, $make, $model)
    {
        $this->first_name = $first_name;
        $this->last_name = $last_name;
        $this->make = $make;
        $this->model = $model;
    }
}
