<?php

namespace Dealerdirect\Sdk\Model\Email;

class Attachment
{
    const DISPOSITION_ATTACHMENT = 'attachment';

    /** @var string */
    private $content;
    /** @var string */
    private $fileName;
    /** @var string */
    private $mimeType;
    /** @var string */
    private $disposition;

    /** @return string */
    public function getContent()
    {
        return $this->content;
    }

    /** @return string */
    public function getFileName()
    {
        return $this->fileName;
    }

    /** @return string */
    public function getMimeType()
    {
        return $this->mimeType;
    }

    /** @return string */
    public function getDisposition()
    {
        return $this->disposition;
    }

    /**
     * @param string $content
     * @param string $mimeType
     * @param string $fileName
     * @param string $disposition
     */
    public function __construct($content, $mimeType, $fileName, $disposition = self::DISPOSITION_ATTACHMENT)
    {
        $this->content = $content;
        $this->fileName = $fileName;
        $this->mimeType = $mimeType;
        $this->disposition = $disposition;
    }
}

/*EOF*/
