<?php

namespace Dealerdirect\Sdk\Model\Email;

use DealerDirect\Generic\Category\AbstractEnum;

class SubstitutionKeys extends AbstractEnum
{
    /*/ Agent details /*/
    const AGENT_NAME = 'agent_name';
    const AGENT_PHONE = 'agent_phone';

    /*/ Consumer details /*/
    const CONSUMER_ADDRESS = 'consumer_address';
    const CONSUMER_COUNTRY = 'consumer_country';
    const CONSUMER_EMAIL = 'consumer_email';
    const CONSUMER_NAME = 'consumer_name';
    const CONSUMER_PHONE = 'consumer_phone';

    /*/ Dealer details /*/
    const DEALER_ADDRESS = 'dealer_address';
    const DEALER_EMAIL = 'dealer_email';
    const DEALER_NAME = 'dealer_name';
    const DEALER_PHONE = 'dealer_phone';
    const DEALER_PREVIOUS_BID = 'old_bid';

    /*/ Generic details for email addressee /*/
    const FIRST_NAME = 'first_name';
    const FULL_NAME = 'name';
    const LAST_NAME = 'last_name';
    const SALUTATION = 'salutation';
    const LOT_NUMBER = 'lot_id';
    const URL = 'url';

    /*/ Credentials /*/
    const LOGIN = 'login';
    const PASSWORD = 'password';

    /*/ Vehicle details /*/
    const VEHICLE_BODYWORK = 'bodywork'; // Carrosserie
    const VEHICLE_COLOR = 'color'; // Carrosseriekleur
    const VEHICLE_CONSTRUCTION_YEAR = 'construction_year';
    const VEHICLE_CONSUMER_PRICE = 'consumer_price';
    const VEHICLE_DEALER_FEE = 'dealer_fee';
    const VEHICLE_DEALER_PICK_UP = 'dealer_will_pick_up';
    const VEHICLE_DRIVABLE = 'drivable';
    const VEHICLE_ENGINE_CAPACITY = 'engine_capacity'; // motorinhoud
    const VEHICLE_ENGINE_POWER = 'engine_power'; // vermogen
    const VEHICLE_FIRST_ADMISSION = 'first_admission'; // datum eerste toelating
    const VEHICLE_FIRST_DELIVERY = 'first_delivery'; // datum eerste afgifte
    const VEHICLE_FUEL_TYPE = 'fuel_type';
    const VEHICLE_GROSS_PRICE = 'gross_price';
    const VEHICLE_MAKE = 'make';
    const VEHICLE_MODEL = 'model';
    const VEHICLE_MILEAGE = 'mileage';
    const VEHICLE_PAINTWORK_TYPE = 'paintwork_type';
    const VEHICLE_REGISTRATION_PLATE = 'registration_plate';
    const VEHICLE_TRANSMISSION = 'transmission';
    const VEHICLE_TRIM_LEVEL = 'trim_level'; // Uitvoering
    const VEHICLE_UPHOLSTERY = 'upholstery'; // Bekleding
    const VEHICLE_VAT = 'vat'; // btw/marge
}
