<?php

namespace DealerDirect\Sdk;

use Dealerdirect\EmailServiceSdk;
use DealerDirect\Sdk\Client\HttpClient;
use DealerDirect\Sdk\Facade\Email;
use GuzzleHttp\Client;

class Sdk
{
    /** @var Config */
    private $config;
    /** @var Email */
    private $email;

    /**
     * @return Email
     */
    public function getEmail()
    {
        if ($this->email === null) {
            // @TODO: The logic to create an Email Facade should be moved to a factory  2017/06/13/BMP

            $config = new EmailServiceSdk\Configuration();

            $config->setHost($this->config->get(Config::EMAIL_SERVICE_URL));

            $apiClient =new EmailServiceSdk\ApiClient($config);

            $sendEmailApi = new EmailServiceSdk\Api\SendEmailApi($apiClient);

            $this->email = new Email($sendEmailApi);
        }

        return $this->email;
    }

    public function __construct(Config $config)
    {
        $this->config = $config;
    }
}
