<?php

namespace DealerDirect\Sdk\Facade;

use DealerDirect\SoapApi\ConsumerSites\ConsumerAPI;
use DealerDirect\SoapApi\ConsumerSites\BrokerageAgreementEntity;

class BrokerageAgreement
{
    /** @var ConsumerAPI */
    private $consumerAPI;

    final public function __construct(ConsumerAPI $consumerAPI)
    {
        $this->consumerAPI = $consumerAPI;
    }

    /**
     *
     * @param BrokerageAgreementEntity $entity
     *
     * @return BrokerageAgreementEntity
     */
    final public function create(BrokerageAgreementEntity $entity)
    {
        return $this->callSoapApi('BrokerageAgreement.create', $entity);
    }

    /**
     *
     * @param string $id
     *
     * @return BrokerageAgreementEntity
     */
    final public function read($id)
    {
        return $this->callSoapApi('BrokerageAgreement.read', $id);
    }

    /**
     *
     * @param string $id
     *
     * @return bool
     */
    final public function sendConfirmationEmail($id)
    {
        return $this->callSoapApi('BrokerageAgreement.sendConfirmationEmail', $id);
    }

    /**
     *
     * @param string $id
     *
     * @return bool
     */
    final public function sendSignEmail($id)
    {
        return $this->callSoapApi('BrokerageAgreement.sendSignEmail', $id);
    }

    /**
     *
     * @param BrokerageAgreementEntity $entity
     *
     * @return BrokerageAgreementEntity
     */
    final public function update(BrokerageAgreementEntity $entity)
    {
        return $this->callSoapApi('BrokerageAgreement.update', $entity);
    }

    /**
     * @param string $method
     * @param mixed $entity
     *
     * @return mixed
     */
    private function callSoapApi($method, $entity)
    {
        return $this->consumerAPI->__soapCall($method, [$entity]);
    }


}

/*EOF*/
