<?php

namespace Dealerdirect\Sdk\Model\Email;

use DealerDirect\Generic\Category\AbstractEnum;

class SubstitutionKeys extends AbstractEnum
{
    /*/ Agent details /*/
    public const AGENT_NAME = 'agent_name';
    public const AGENT_PHONE = 'agent_phone';
    public const AGENT_WHATSAPP = 'agent_whatsapp';

    /*/ Customer Service details /*/
    public const CUSTOMER_SERVICE_PHONE = 'customer_service_phone';

    /*/ Consumer details /*/
    public const CONSUMER_ADDRESS = 'consumer_address';
    public const CONSUMER_CITY = 'consumer_city';
    public const CONSUMER_COUNTRY = 'consumer_country';
    public const CONSUMER_EMAIL = 'consumer_email';
    public const CONSUMER_NAME = 'consumer_name';
    public const CONSUMER_PHONE = 'consumer_phone';

    /*/ Dealer details /*/
    public const DEALER_ADDRESS = 'dealer_address';
    public const DEALER_EMAIL = 'dealer_email';
    public const DEALER_NAME = 'dealer_name';
    public const DEALER_PHONE = 'dealer_phone';
    public const DEALER_PREVIOUS_BID = 'old_bid';

    /*/ Generic details for email addressee /*/
    public const FIRST_NAME = 'first_name';
    public const FULL_NAME = 'name';
    public const LAST_NAME = 'last_name';
    public const SALUTATION = 'salutation';
    public const LOT_NUMBER = 'lot_id';
    public const URL = 'url';
    public const URL_SECONDARY = 'url_secondary'; // Generic optional secondary URL
    public const URL_UNSUBSCRIBE = 'url_unsubscribe';

    /*/ Credentials /*/
    public const LOGIN = 'login';
    public const PASSWORD = 'password';

    /*/ Vehicle details /*/
    public const VEHICLE_BODYWORK = 'bodywork'; // Carrosserie
    public const VEHICLE_COLOR = 'color'; // Carrosseriekleur
    public const VEHICLE_CONSTRUCTION_YEAR = 'construction_year';
    public const VEHICLE_CONSUMER_PRICE = 'consumer_price';
    public const VEHICLE_DEALER_FEE = 'dealer_fee';
    public const VEHICLE_DEALER_PICK_UP = 'dealer_will_pick_up';
    public const VEHICLE_DRIVABLE = 'drivable';
    public const VEHICLE_ENGINE_CAPACITY = 'engine_capacity'; // motorinhoud
    public const VEHICLE_ENGINE_POWER = 'engine_power'; // vermogen
    public const VEHICLE_FIRST_ADMISSION = 'first_admission'; // datum eerste toelating
    public const VEHICLE_FIRST_DELIVERY = 'first_delivery'; // datum eerste afgifte
    public const VEHICLE_FUEL_TYPE = 'fuel_type';
    public const VEHICLE_GROSS_PRICE = 'gross_price';
    public const VEHICLE_MAKE = 'make';
    public const VEHICLE_MODEL = 'model';
    public const VEHICLE_MILEAGE = 'mileage';
    public const VEHICLE_PAINTWORK_TYPE = 'paintwork_type';
    public const VEHICLE_REGISTRATION_PLATE = 'registration_plate';
    public const VEHICLE_TRANSMISSION = 'transmission';
    public const VEHICLE_TRIM_LEVEL = 'trim_level'; // Uitvoering
    public const VEHICLE_UPHOLSTERY = 'upholstery'; // Bekleding
    public const VEHICLE_VAT = 'vat'; // btw/marge
    public const VEHICLE_DELIVERY_DATE = 'date_delivery';

    /*/ Rating values /*/
    public const RATING_DEALER = 'rating_dealer';
    public const RATING_CONSUMER = 'rating_consumer';

    /*/ Vehicle inspections /*/
    public const INSPECTION_DATE = 'inspection_date';
    public const INSPECTION_TIME = 'inspection_time';
    public const INSPECTION_LOCATION = 'inspection_location';

    /*/ Vehicle valuation /*/
    public const VALUE_MIN = 'value_min';
    public const VALUE_AVG = 'value_avg';
    public const VALUE_MAX = 'value_max';
    public const VALUE_URL = 'value_url';
    public const VALUE_DATE = 'value_date';

    /*/ Auction details /*/
    public const AUCTION_MIN_OFFER = 'bid_min';

    /*/ Auction actions /*/
    public const EXTEND_AUCTION_URL = 'extend_auction_url';

    /*/ Lead details /*/
    public const LEAD_CONSUMER_LABEL_NAME = 'lead_consumer_label_name';

    public const SERVICE_COST = 'service_cost';
}
