<?php

namespace DealerDirect\Sdk;

use DealerDirect\Sdk\Client\HttpClient;
use DealerDirect\Sdk\Facade\BrokerageAgreement;
use DealerDirect\SoapApi\ConsumerSites\ConsumerAPI;
use GuzzleHttp\Client;

class Sdk
{
    /** @var BrokerageAgreement */
    private $brokerageAgreement;

    public function getBrokerageAgreement()
    {
        // @TODO: Read URL from ENV. 2016/12/23/BMP
        $url = 'https://api-develop.dealerdirect.de';

        if ($this->brokerageAgreement === null) {

            $config = [
                'base_url' => $url
            ];

            $client = new Client($config);

            /*/ Disable SSL until local dev boxes have proper certificates /*/
            // @FIXME: This needs to be wrapped in a is-dev-environment-check
            $client->setDefaultOption('verify', false);
            $client->setDefaultOption('exceptions', false);

            $consumerAPI = new HttpClient($client);

            $this->brokerageAgreement = new BrokerageAgreement($consumerAPI);
        }

        return $this->brokerageAgreement;
    }
}
/*EOF*/
