<?php

namespace Dealerdirect\Sdk\Model\Email;

use DealerDirect\Generic\Category\AbstractEnum;

class SubstitutionKeys extends AbstractEnum
{
    /*/ Agent details /*/
    const AGENT_NAME = 'agent_name';
    const AGENT_PHONE = 'agent_phone';

    /*/ Consumer details /*/
    const CONSUMER_ADDRESS = 'consumer_address';
    const CONSUMER_CITY = 'consumer_city';
    const CONSUMER_COUNTRY = 'consumer_country';
    const CONSUMER_EMAIL = 'consumer_email';
    const CONSUMER_NAME = 'consumer_name';
    const CONSUMER_PHONE = 'consumer_phone';

    /*/ Dealer details /*/
    const DEALER_ADDRESS = 'dealer_address';
    const DEALER_EMAIL = 'dealer_email';
    const DEALER_NAME = 'dealer_name';
    const DEALER_PHONE = 'dealer_phone';
    const DEALER_PREVIOUS_BID = 'old_bid';

    /*/ Generic details for email addressee /*/
    const FIRST_NAME = 'first_name';
    const FULL_NAME = 'name';
    const LAST_NAME = 'last_name';
    const SALUTATION = 'salutation';
    const LOT_NUMBER = 'lot_id';
    const URL = 'url';
    const URL_SECONDARY = 'url_secondary'; // Generic optional secondary URL

    /*/ Credentials /*/
    const LOGIN = 'login';
    const PASSWORD = 'password';

    /*/ Vehicle details /*/
    const VEHICLE_BODYWORK = 'bodywork'; // Carrosserie
    const VEHICLE_COLOR = 'color'; // Carrosseriekleur
    const VEHICLE_CONSTRUCTION_YEAR = 'construction_year';
    const VEHICLE_CONSUMER_PRICE = 'consumer_price';
    const VEHICLE_DEALER_FEE = 'dealer_fee';
    const VEHICLE_DEALER_PICK_UP = 'dealer_will_pick_up';
    const VEHICLE_DRIVABLE = 'drivable';
    const VEHICLE_ENGINE_CAPACITY = 'engine_capacity'; // motorinhoud
    const VEHICLE_ENGINE_POWER = 'engine_power'; // vermogen
    const VEHICLE_FIRST_ADMISSION = 'first_admission'; // datum eerste toelating
    const VEHICLE_FIRST_DELIVERY = 'first_delivery'; // datum eerste afgifte
    const VEHICLE_FUEL_TYPE = 'fuel_type';
    const VEHICLE_GROSS_PRICE = 'gross_price';
    const VEHICLE_MAKE = 'make';
    const VEHICLE_MODEL = 'model';
    const VEHICLE_MILEAGE = 'mileage';
    const VEHICLE_PAINTWORK_TYPE = 'paintwork_type';
    const VEHICLE_REGISTRATION_PLATE = 'registration_plate';
    const VEHICLE_TRANSMISSION = 'transmission';
    const VEHICLE_TRIM_LEVEL = 'trim_level'; // Uitvoering
    const VEHICLE_UPHOLSTERY = 'upholstery'; // Bekleding
    const VEHICLE_VAT = 'vat'; // btw/marge
    const VEHICLE_DELIVERY_DATE = 'date_delivery';

    /*/ Rating values /*/
    const RATING_DEALER = 'rating_dealer';
    const RATING_CONSUMER = 'rating_consumer';

    /*/ Vehicle inspections /*/
    const INSPECTION_DATE = 'inspection_date';
    const INSPECTION_TIME = 'inspection_time';
    const INSPECTION_LOCATION = 'inspection_location';

    /*/ Vehicle valuation /*/
    const VALUE_MIN = 'value_min';
    const VALUE_AVG = 'value_avg';
    const VALUE_MAX = 'value_max';
    const VALUE_URL = 'value_url';

    /*/ Auction details /*/
    const AUCTION_MIN_OFFER = 'bid_min';

    /*/ Auction actions /*/
    const EXTEND_AUCTION_URL = 'extend_auction_url';
}
