<?php

namespace DealerDirect\Example\Sdk;

use DealerDirect\Sdk\Sdk;
use DealerDirect\SoapApi\ConsumerSites\BrokerageAgreementEntity;
use DealerDirect\SoapApi\ConsumerSites\BrokerageAgreementStatus;

require dirname(__DIR__) . '/vendor/autoload.php';

$sdk = new Sdk();

// -----------------------------------------------------------------------------
$newEntity = new BrokerageAgreementEntity(
    null,
    'abc',
    100,
    'ben.peachey@dealerdirect.nl',
    '212.178.76.6',
    null,
    null,
    new \DateInterval('PT72H'),
    new \DateInterval('P3D'),
    '12345ABC',
    0,
    BrokerageAgreementStatus::BROKERAGE_AGREEMENT_STATUS_000_NONE
);

$savedEntity = $sdk->getBrokerageAgreement()->create($newEntity);
/** @noinspection ForgottenDebugOutputInspection */
var_dump($savedEntity);
// -----------------------------------------------------------------------------


// -----------------------------------------------------------------------------
$uuid = $savedEntity->getUuid();
$sdk->getBrokerageAgreement()->read($uuid);
/** @noinspection ForgottenDebugOutputInspection */
var_dump($savedEntity);
// -----------------------------------------------------------------------------

/*EOF*/
