<?php

namespace DealerDirect\Sdk;

use DealerDirect\Sdk\Facade\BrokerageAgreement;
use DealerDirect\SoapApi\ConsumerSites\ConsumerAPI;

class Sdk
{
    /** @var BrokerageAgreement */
    private $brokerageAgreement;

    public function getBrokerageAgreement()
    {
        // @TODO: Read URL from ENV. 2016/12/23/BMP
        $wsdl = null;
        // @NOTE: For local development use the URL below
        // $wsdl = 'https://api-develop.dealerdirect.de/consumerSites.php?wsdl';

        if ($this->brokerageAgreement === null) {

            $options = [
                'cache_wsdl' => WSDL_CACHE_NONE,
                'exceptions' => true,
                'soap_version' => SOAP_1_1,
                'trace' => true,
                'stream_context' => stream_context_create(
                    [
                        'ssl' => [
                            'verify_peer' => false,
                            'verify_peer_name' => false,
                        ]
                    ]
                ),
            ];

            $consumerAPI = new ConsumerAPI($options, $wsdl);

            // @NOTE: Setting the cookies allows for remote debugging
            // $consumerAPI->__setCookie('XDEBUG_SESSION','PHPSTORM');

            $this->brokerageAgreement = new BrokerageAgreement($consumerAPI);
        }

        return $this->brokerageAgreement;
    }
}
/*EOF*/
