<?php

namespace DealerDirect\Sdk\Facade;

use Dealerdirect\EmailServiceSdk\Api;
use Dealerdirect\EmailServiceSdk\ApiException;
use Dealerdirect\EmailServiceSdk\Model;
use DealerDirect\Sdk\Exception\HttpException;
use Dealerdirect\Sdk\Model\Email\Email as EmailModel;
use Dealerdirect\Sdk\Model\Email\Recipient;

class Email
{
    /** @var Api\SendEmailApi */
    private $sendEmailApi;

    final public function __construct(Api\SendEmailApi $sendEmailApi)
    {
        $this->sendEmailApi = $sendEmailApi;
    }

    /**
     * @param $email
     * @param Recipient[] $recipients
     */
    final public function sendEmail(EmailModel $email, array $recipients)
    {
        $to = [];

        array_walk($recipients, function (Recipient $recipient) use (&$to){
            $to[] = new Model\To([
                'address' => $recipient->getEmailAddress(),
                'name' => $recipient->getName(),
            ]);
        });

        $payload = new Model\EmailPayload([
            'email' => new Model\Email([
                'locale' => $email->getLocale(),
                'emailType' => $email->getEmailType(),
                'lotType' => $email->getVehicleType(),
                'substitutions' => $email->getSubstitution(),
                'to' => $to,
            ])
        ]);

        try {
            $this->sendEmailApi->emailsPost($payload);
        } catch (ApiException $apiException) {
            // @FIXME: Add error handling for when ApiException is thrown    2017/06/13/BMP
            throw new HttpException('Could not send email', $apiException->getCode(), $apiException);
        }
    }
}
