<?php

namespace Dealerdirect\Sdk\Model\Email\Substitution;

abstract class AbstractSubstitution
{
    /** @var \ReflectionObject */
    private $reflectionObject;

    private function getReflectionObject()
    {
        if ($this->reflectionObject === null) {
            $this->reflectionObject = new \ReflectionObject($this);
        }

        return $this->reflectionObject;
    }

    /**
     * @return array
     */
    final public function toArray()
    {
        $self = [];

        $reflectionObject = $this->getReflectionObject();
        $reflectionProperties = $reflectionObject->getProperties();

        array_walk($reflectionProperties, function (\ReflectionProperty $reflectionProperty) use (&$self) {
            $name = $reflectionProperty->getName();
            if ($name !== 'reflectionObject') {
                $reflectionProperty->setAccessible(true);
                $value = $reflectionProperty->getValue($this);
                $reflectionProperty->setAccessible(false);

                if (is_object($value) === true) {
                    if (is_callable([$value, 'toArray'])) {
                        $value = $value->toArray();
                    } elseif (is_callable([$value, '__toString'])) {
                        $value = (string) $value;
                    } elseif ($value instanceof \DateTime) {
                        $value = $value->format(\DateTime::ATOM);
                    } elseif ($value instanceof \DateInterval) {
                        $value = $value->format('P%DD');
                    }
                }

                $self[$name] = $value;
            }
        });

        return $self;
    }
}
