<?php

namespace DealerDirect\Example\Sdk;

use DealerDirect\BrokerageAgreement\Entity\BrokerageAgreement;
use DealerDirect\BrokerageAgreement\Entity\LotData;
use DealerDirect\Generic\Category\VehicleType;
use DealerDirect\Sdk\Sdk;

use DealerDirect\BrokerageAgreement\Entity\BrokerageAgreement as Entity;
use DealerDirect\BrokerageAgreement\BrokerageAgreementStatus;

require dirname(__DIR__) . '/vendor/autoload.php';

function printResult($createdAgreement, $action, $code)
{
    $action = strtoupper($action);
    if ($createdAgreement instanceof BrokerageAgreement) {
        //echo var_export($createdAgreement->toArray(), true).PHP_EOL;
        echo $action.' SUCCESS!'/* . $createdAgreement->getUuid() */.PHP_EOL;
        echo '=============================================================================' . PHP_EOL;
    } else {
        echo $action .' ERROR!';
        exit($code);
    }
}

// -----------------------------------------------------------------------------
// Get the Client
// -----------------------------------------------------------------------------
$sdk = new Sdk();
$client = $sdk->getBrokerageAgreement();

// =============================================================================
// Create a Brokerage Agreement
// =============================================================================
// Create an Entity
$newEntity = Entity::fromArray([
    /* The UUID is created by the API. If an entity is to be created it must be
     * empty, otherwise an error is returned
     */
    Entity::UUID => null,

    Entity::AGENT_ID => 12345,
    Entity::AGREED_UPON_PRICE => 1000,
    Entity::CONSUMER_EMAIL_ADDRESS => 'ben.peachey@dealerdirect.nl',
    Entity::CONSUMER_IP_ADDRESS => '212.178.76.6',
    Entity::CREATED_AT => new \DateTime(),
    Entity::DATE_LAST_REMINDER_SENT => null,
    Entity::DATE_SIGNED => null,
    Entity::DURATION_AGREEMENT => new \DateInterval('P3D'),
    Entity::DURATION_SIGNABLE => new \DateInterval('P7D'),
    Entity::LOT_DATA => LotData::fromArray([
        LotData::CITY => 'city',
        LotData::HOUSE_NUMBER => 'house_number',
        LotData::MAKE => 'make',
        LotData::MODEL => 'model',
        LotData::NAME => 'name',
        LotData::SALUTATION => 'salutation',
        LotData::SURNAME => 'surname',
        LotData::STREET_NAME => 'street_name',
        LotData::ZIP_CODE => 'zip_code',
    ]),
    Entity::LOTNUMBER => 54321, // the Honda CBR 600 owned by Roelof Kooiker from Staphorst. Yes. That was supposed to be a random number. It is not. IT ACTUALLY EXISTS!
    Entity::REMINDERS_SENT_COUNT => 'reminders_sent_count',
    Entity::STATUS => BrokerageAgreementStatus::NONE,
    Entity::VEHICLE_TYPE => VehicleType::SCOOTER,
]);

// Post the entity to the remote API
/* Creating an agreement  also triggers the "confirmation" email to be sent*/
$createdAgreement = $client->create($newEntity);

printResult($createdAgreement, 'create', 201);
// =============================================================================



// =============================================================================
// Read the created Brokerage Agreement
// =============================================================================
$uuid = $createdAgreement->getUuid();

$readEntity = $client->read($uuid);

printResult($readEntity, 'read', 202);
// =============================================================================


// =============================================================================
// Update the created Brokerage Agreement
// =============================================================================
$entityArray = $readEntity->toArray();

/* Setting the status to "signed" also triggers the "signed" email to be sent
 * The signed date will automatically be updated by the server so there is no
 * need to call
 *
 *     $entityArray[Entity::DATE_SIGNED] = new \DateTime();
 */
$entityArray[Entity::STATUS] = BrokerageAgreementStatus::SIGNED;

$entity = BrokerageAgreement::fromArray($entityArray);
$updateEntity = $client->update($entity);

printResult($updateEntity, 'update', 203);

// =============================================================================

/*EOF*/

