<?php

namespace DealerDirect\Example\Sdk;

use DealerDirect\Generic\Category\EmailType;
use DealerDirect\Generic\Category\Locale;
use DealerDirect\Generic\Category\VehicleType;
use DealerDirect\Sdk\Config;
use DealerDirect\Sdk\Exception\HttpException;
use Dealerdirect\Sdk\Model\Email\Email;
use Dealerdirect\Sdk\Model\Email\Recipient;
use Dealerdirect\Sdk\Model\Email\Substitution\UserModelMakeSubstitution;
use DealerDirect\Sdk\Sdk;

require dirname(__DIR__) . '/vendor/autoload.php';

// =============================================================================
// Values used to send an email
// =============================================================================
$name = 'Ike Bot';
$address = 'devops@dealerdirect.nl';

$locale = Locale::NL_NL;
$vehicleType = VehicleType::SCOOTER;
$emailType = EmailType::CONFIRMATION_EMAIL;
$substitutions = new UserModelMakeSubstitution('Carl', 'Benz', 'Benz Patent Motor Car', 'No.1');

// -----------------------------------------------------------------------------
// Get the Client
// -----------------------------------------------------------------------------

$config = new Config([
    Config::EMAIL_SERVICE_URL => 'https://email-service.email-service.dev/api/v1',
]);

$sdk = new Sdk($config);

$client = $sdk->getEmail();

// =============================================================================
// Send an Email
// =============================================================================

$email = new Email($locale, $vehicleType, $emailType, $substitutions);

$to = [
    new Recipient($name, $address)
];

try {
    $client->sendEmail($email, $to);
    $content = 'Success';
} catch (HttpException $exception) {
    $content = '!!! FAILURE !!!' . $exception->getMessage();
}
// =============================================================================

echo $content;

/*EOF*/
